/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.controllers.systemsettings;

import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.support.RequestContextUtils;
import si.nevensrok.common.dl.query.DataFilter;
import si.nevensrok.common.dl.query.FieldFilter;
import si.nevensrok.common.dl.query.Filter;
import si.nevensrok.common.dl.query.GroupFilter;
import si.nevensrok.common.dl.query.PageDataResult;
import si.nevensrok.common.dl.query.SimpleDataFilter;
import si.nevensrok.common.dl.query.Sort;
import si.nevensrok.common.utils.ObjectUtil;
import si.nevensrok.common.web.filter.SearchFilter;
import si.nevensrok.jtekma.common.category.AgeCategoryOption;
import si.nevensrok.jtekma.server.web.controllers.CoreController;
import si.nevensrok.jtekma.server.web.controllers.systemsettings.AgeCategoryOptionModel;
import si.nevensrok.jtekma.server.web.tools.FilterGeneratorTool;

@Controller
@RequestMapping(value={"/system-settings/age-categories"})
public class AgeCategoryController
extends CoreController {
    public Map<String, String> getStatuses(Locale locale) {
        LinkedHashMap<String, String> categoryTypes = new LinkedHashMap<String, String>();
        categoryTypes.put(AgeCategoryOption.Status.ACTIVE.name(), this.getLanguageText(locale, "ageCategories.status." + AgeCategoryOption.Status.ACTIVE.name()));
        categoryTypes.put(AgeCategoryOption.Status.INACTIVE.name(), this.getLanguageText(locale, "ageCategories.status." + AgeCategoryOption.Status.INACTIVE.name()));
        return categoryTypes;
    }

    private void addFormOptions(Model model, Locale locale) {
        model.addAttribute("statuses", this.getStatuses(locale));
    }

    @ModelAttribute(value="ageCategoriesActive")
    public Boolean getAgeCategoriesActive() {
        return Boolean.TRUE;
    }

    @ModelAttribute(value="ageCategoryFilter")
    public SearchFilter getSearchFilter() {
        return FilterGeneratorTool.generateDefaultSearchFilter();
    }

    @RequestMapping
    public String list(HttpServletRequest request, Model model, @ModelAttribute(value="ageCategoryFilter") SearchFilter searchFilter, @RequestParam(value="messageCode", required=false, defaultValue="0") Integer messageCode) {
        SimpleDataFilter dataFilter = new SimpleDataFilter();
        GroupFilter rootFilter = new GroupFilter(GroupFilter.Combine.AND);
        dataFilter.setFilter((Filter)rootFilter);
        GroupFilter nameFilter = new GroupFilter(GroupFilter.Combine.OR);
        rootFilter.addFilter((Filter)nameFilter);
        nameFilter.addFilter((Filter)new FieldFilter("name", FieldFilter.Comparator.LIKECASEISENSITIVE, (Object)("%" + searchFilter.getSearch().trim() + "%")));
        GroupFilter statusFilter = new GroupFilter(GroupFilter.Combine.OR);
        rootFilter.addFilter((Filter)statusFilter);
        statusFilter.addFilter((Filter)new FieldFilter("status", FieldFilter.Comparator.EQUAL, (Object)AgeCategoryOption.Status.ACTIVE));
        statusFilter.addFilter((Filter)new FieldFilter("status", FieldFilter.Comparator.EQUAL, (Object)AgeCategoryOption.Status.INACTIVE));
        dataFilter.setSort(new Sort());
        dataFilter.getSort().addField(new Sort.Field("name", Sort.Field.Direction.ASC, false));
        dataFilter.setItemCountPerPage(searchFilter.getShowPerPage().intValue());
        dataFilter.setPage(searchFilter.getPage().intValue());
        PageDataResult dataResult = this.getManagersList().getAgeCategoryOptionManager().find((DataFilter)dataFilter);
        model.addAttribute("ageCategories", (Object)dataResult.getData());
        model.addAttribute("totalPages", (Object)dataResult.getPageCount(true));
        if (messageCode == 1) {
            model.addAttribute("message", (Object)this.getLanguageText(RequestContextUtils.getLocale((HttpServletRequest)request), "ageCategories.text.added"));
        } else if (messageCode == 2) {
            model.addAttribute("message", (Object)this.getLanguageText(RequestContextUtils.getLocale((HttpServletRequest)request), "ageCategories.text.updated"));
        } else if (messageCode == 3) {
            model.addAttribute("message", (Object)this.getLanguageText(RequestContextUtils.getLocale((HttpServletRequest)request), "ageCategories.text.deleted"));
        }
        return "system-settings/age-category-list";
    }

    @RequestMapping(value={"/add"}, method={RequestMethod.GET})
    public String add(HttpServletRequest request, Model model, @ModelAttribute(value="ageCategoryOption") AgeCategoryOptionModel ageCategoryOptionModel, BindingResult bindingResult) {
        model.addAttribute("adding", (Object)true);
        if (!bindingResult.hasErrors()) {
            ageCategoryOptionModel.setAge(18);
            ageCategoryOptionModel.setName("");
            ageCategoryOptionModel.setStatus(AgeCategoryOption.Status.ACTIVE);
            ageCategoryOptionModel.setFightTime(180);
            ageCategoryOptionModel.setHosekomiTime(15);
            ageCategoryOptionModel.setNewazaPenaltyHansokumake(4);
        }
        this.addFormOptions(model, RequestContextUtils.getLocale((HttpServletRequest)request));
        return "system-settings/age-category-edit";
    }

    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public String addPost(HttpServletRequest request, Model model, @ModelAttribute(value="ageCategoryOption") @Valid AgeCategoryOptionModel ageCategoryOptionModel, BindingResult bindingResult) {
        AgeCategoryOption ageCategoryOption = this.getManagersList().getAgeCategoryOptionManager().getAgeCategoryOptionByName(ageCategoryOptionModel.getName());
        if (ageCategoryOption != null && ageCategoryOption.getStatus() != AgeCategoryOption.Status.DELETED) {
            bindingResult.rejectValue("name", "ageCategories.text.nameAlreadyInUse");
        }
        if (bindingResult.hasErrors()) {
            return this.add(request, model, ageCategoryOptionModel, bindingResult);
        }
        if (ageCategoryOption == null) {
            ageCategoryOption = new AgeCategoryOption();
        }
        ObjectUtil.copyProperties((Object)ageCategoryOptionModel, (Object)ageCategoryOption);
        ageCategoryOption = ageCategoryOption.getAgeCategoryId() == null ? this.getManagersList().getAgeCategoryOptionManager().createAgeCategoryOption(ageCategoryOption) : this.getManagersList().getAgeCategoryOptionManager().updateAgeCategoryOption(ageCategoryOption);
        return "redirect:/system-settings/age-categories?messageCode=1";
    }

    @RequestMapping(value={"/edit/{ageCategoryId}"}, method={RequestMethod.GET})
    public String edit(HttpServletRequest request, Model model, @PathVariable(value="ageCategoryId") Long ageCategoryId, @ModelAttribute(value="ageCategoryOption") AgeCategoryOptionModel ageCategoryOptionModel, BindingResult bindingResult) {
        if (!bindingResult.hasErrors()) {
            AgeCategoryOption ageCategoryOption = this.getManagersList().getAgeCategoryOptionManager().getById(ageCategoryId);
            ObjectUtil.copyProperties((Object)ageCategoryOption, (Object)ageCategoryOptionModel);
        }
        this.addFormOptions(model, RequestContextUtils.getLocale((HttpServletRequest)request));
        return "system-settings/age-category-edit";
    }

    @RequestMapping(value={"/edit/{ageCategoryId}"}, method={RequestMethod.POST})
    public String editPost(HttpServletRequest request, Model model, @PathVariable(value="ageCategoryId") Long ageCategoryId, @ModelAttribute(value="ageCategoryOption") @Valid AgeCategoryOptionModel ageCategoryOptionModel, BindingResult bindingResult) {
        AgeCategoryOption existingByName = this.getManagersList().getAgeCategoryOptionManager().getAgeCategoryOptionByName(ageCategoryOptionModel.getName());
        if (existingByName != null && !existingByName.getAgeCategoryId().equals(ageCategoryId)) {
            bindingResult.rejectValue("name", "ageCategories.text.nameAlreadyInUse");
        }
        if (bindingResult.hasErrors()) {
            return this.edit(request, model, ageCategoryId, ageCategoryOptionModel, bindingResult);
        }
        AgeCategoryOption ageCategoryOption = this.getManagersList().getAgeCategoryOptionManager().getById(ageCategoryId);
        ObjectUtil.copyProperties((Object)ageCategoryOptionModel, (Object)ageCategoryOption);
        ageCategoryOption = this.getManagersList().getAgeCategoryOptionManager().updateAgeCategoryOption(ageCategoryOption);
        return "redirect:/system-settings/age-categories?messageCode=2";
    }

    @RequestMapping(value={"/delete/{ageCategoryId}"})
    public String delete(HttpServletRequest request, Model model, @PathVariable(value="ageCategoryId") Long ageCategoryId) {
        AgeCategoryOption ageCategoryOption = this.getManagersList().getAgeCategoryOptionManager().getById(ageCategoryId);
        ageCategoryOption.setStatus(AgeCategoryOption.Status.DELETED);
        ageCategoryOption = this.getManagersList().getAgeCategoryOptionManager().updateAgeCategoryOption(ageCategoryOption);
        return "redirect:/system-settings/age-categories?messageCode=3";
    }
}

