/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.controllers.competition;

import java.util.HashMap;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.category.Duo2023Category;
import si.nevensrok.jtekma.common.category.TreeCategory;
import si.nevensrok.jtekma.common.competitors.Competitor;
import si.nevensrok.jtekma.common.competitors.GroupDraw;
import si.nevensrok.jtekma.common.system.Right;
import si.nevensrok.jtekma.server.web.common.CommonResponse;
import si.nevensrok.jtekma.server.web.common.competition.SaveDrawRequest;
import si.nevensrok.jtekma.server.web.controllers.CoreController;
import si.nevensrok.jtekma.server.web.security.ForbiddenException;
import si.nevensrok.jtekma.server.web.security.MethodRight;

@Controller
@RequestMapping(value={"/competition/data"})
public class CompetitionDataDrawController
extends CoreController {
    @MethodRight(value={Right.LEADCOMPETITION})
    @RequestMapping(value={"/save-draw"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse saveDraw(HttpServletResponse response, @RequestBody SaveDrawRequest saveDrawRequest) {
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        Category category = this.getManagersList().getCategoryManager().getById(saveDrawRequest.getCategoryId());
        if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForCategory(category).getCompetitionId())) {
            throw new ForbiddenException("Invalid competition for category");
        }
        HashMap<Competitor, GroupDraw> draw = new HashMap<Competitor, GroupDraw>();
        for (SaveDrawRequest.DrawedCompetitor drawedCompetitor : saveDrawRequest.getDraw()) {
            Competitor competitor = new Competitor();
            competitor.setCompetitorId(drawedCompetitor.getCompetitorId());
            draw.put(competitor, new GroupDraw(drawedCompetitor.getDrawNumber(), drawedCompetitor.getDrawGroup()));
        }
        if (category instanceof TreeCategory && saveDrawRequest.getTreeCategoryOptions() != null) {
            TreeCategory treeCategory = (TreeCategory)category;
            if (saveDrawRequest.getTreeCategoryOptions().getTreeType() != null) {
                this.getManagersList().getCategoryManager().setCategoryTreeType(treeCategory, saveDrawRequest.getTreeCategoryOptions().getTreeType());
            }
            if (saveDrawRequest.getTreeCategoryOptions().getRepassageType() != null) {
                this.getManagersList().getCategoryManager().setRepassageType(treeCategory, saveDrawRequest.getTreeCategoryOptions().getRepassageType());
            }
            if (saveDrawRequest.getTreeCategoryOptions().getDouble3rdPlace() != null) {
                this.getManagersList().getCategoryManager().setDouble3rdPlace(treeCategory, saveDrawRequest.getTreeCategoryOptions().getDouble3rdPlace());
            }
            if (saveDrawRequest.getTreeCategoryOptions().getRepassageFromRound() != null) {
                this.getManagersList().getCategoryManager().setRepassageFromRound(treeCategory, saveDrawRequest.getTreeCategoryOptions().getRepassageFromRound());
            }
        }
        if (category instanceof Duo2023Category && saveDrawRequest.getDraw2023Options() != null) {
            Duo2023Category duo2023Category = (Duo2023Category)category;
            if (saveDrawRequest.getDraw2023Options().getAdvancedLevel() != null) {
                this.getManagersList().getCategoryManager().setAdvancedLevel(duo2023Category, saveDrawRequest.getDraw2023Options().getAdvancedLevel());
            }
            if (saveDrawRequest.getDraw2023Options().getNoviceLevel() != null) {
                this.getManagersList().getCategoryManager().setNoviceLevel(duo2023Category, saveDrawRequest.getDraw2023Options().getNoviceLevel());
            }
            if (saveDrawRequest.getDraw2023Options().getKnockoutStage() != null) {
                this.getManagersList().getCategoryManager().setKnockoutStage(duo2023Category, saveDrawRequest.getDraw2023Options().getKnockoutStage());
            }
            if (saveDrawRequest.getDraw2023Options().getDouble3rdPlace() != null) {
                this.getManagersList().getCategoryManager().setDouble3rdPlace(duo2023Category, saveDrawRequest.getDraw2023Options().getDouble3rdPlace());
            }
        }
        this.getManagersList().getCategoryManager().setGroupDraw(category, draw);
        return new CommonResponse(true);
    }
}

