/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.impl.packrect;

import com.sun.javafx.geom.Rectangle;
import com.sun.prism.Texture;
import com.sun.prism.impl.packrect.Level;
import java.util.ArrayList;
import java.util.List;

public class RectanglePacker {
    private Texture backingStore;
    private List<Level> levels = new ArrayList<Level>(150);
    private static final int MIN_SIZE = 8;
    private static final int ROUND_UP = 4;
    private int recentUsedLevelIndex = 0;
    private int length;
    private int size;
    private int sizeOffset;
    private int x;
    private int y;
    private boolean vertical;

    public RectanglePacker(Texture backingStore, int x, int y, int width, int height, boolean vertical) {
        this.backingStore = backingStore;
        if (vertical) {
            this.length = height;
            this.size = width;
        } else {
            this.length = width;
            this.size = height;
        }
        this.x = x;
        this.y = y;
        this.vertical = vertical;
    }

    public RectanglePacker(Texture backingStore, int width, int height) {
        this(backingStore, 0, 0, width, height, false);
    }

    public final Texture getBackingStore() {
        return this.backingStore;
    }

    public final boolean add(Rectangle rect) {
        int requestedSize;
        int requestedLength = this.vertical ? rect.height : rect.width;
        int n = requestedSize = this.vertical ? rect.width : rect.height;
        if (requestedLength > this.length) {
            return false;
        }
        if (requestedSize > this.size) {
            return false;
        }
        int newSize = 8 > requestedSize ? 8 : requestedSize;
        newSize = newSize + 4 - 1 - (newSize - 1) % 4;
        int newIndex = this.recentUsedLevelIndex < this.levels.size() && this.levels.get((int)this.recentUsedLevelIndex).size != newSize ? RectanglePacker.binarySearch(this.levels, newSize) : this.recentUsedLevelIndex;
        boolean newLevelFlag = this.sizeOffset + newSize <= this.size;
        int max = this.levels.size();
        for (int i = newIndex; i < max; ++i) {
            Level level = this.levels.get(i);
            if (level.size > newSize + 8 && newLevelFlag) break;
            if (!level.add(rect, this.x, this.y, requestedLength, requestedSize, this.vertical)) continue;
            this.recentUsedLevelIndex = i;
            return true;
        }
        if (!newLevelFlag) {
            return false;
        }
        Level newLevel = new Level(this.length, newSize, this.sizeOffset);
        this.sizeOffset += newSize;
        if (newIndex < this.levels.size() && this.levels.get((int)newIndex).size <= newSize) {
            this.levels.add(newIndex + 1, newLevel);
            this.recentUsedLevelIndex = newIndex + 1;
        } else {
            this.levels.add(newIndex, newLevel);
            this.recentUsedLevelIndex = newIndex;
        }
        return newLevel.add(rect, this.x, this.y, requestedLength, requestedSize, this.vertical);
    }

    public void clear() {
        this.levels.clear();
        this.sizeOffset = 0;
        this.recentUsedLevelIndex = 0;
    }

    public void dispose() {
        if (this.backingStore != null) {
            this.backingStore.dispose();
        }
        this.backingStore = null;
        this.levels = null;
    }

    private static int binarySearch(List<Level> levels, int k) {
        int key = k + 1;
        int from = 0;
        int to = levels.size() - 1;
        int mid = 0;
        int midSize = 0;
        if (to < 0) {
            return 0;
        }
        while (from <= to) {
            mid = (from + to) / 2;
            midSize = levels.get((int)mid).size;
            if (key < midSize) {
                to = mid - 1;
                continue;
            }
            from = mid + 1;
        }
        if (midSize < k) {
            return mid + 1;
        }
        if (midSize > k) {
            return mid > 0 ? mid - 1 : 0;
        }
        return mid;
    }
}

