/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.dl.dto.competitors;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import si.nevensrok.common.objects.ObjectToString;
import si.nevensrok.jtekma.common.matches.Rank;
import si.nevensrok.jtekma.server.dl.dto.category.CategoryDTO;
import si.nevensrok.jtekma.server.dl.dto.competitors.CompetitorDTO;

@Entity
@Table(name="competesincategory")
public class CompetesInCategoryDTO {
    @Id
    private CompetesInCategoryKey competesInCategoryKey;
    @Column(name="drawnumber", nullable=true)
    private Integer drawNumber;
    @Column(name="competitorplacing", nullable=true)
    private Integer competitorPlacing;
    @Column(name="draw_group", nullable=true)
    private Integer drawGroup;
    @Enumerated(value=EnumType.STRING)
    @Column(length=32, name="placing_rank", nullable=true)
    private Rank placingRank;

    public CompetesInCategoryDTO() {
    }

    public CompetesInCategoryDTO(CategoryDTO category, CompetitorDTO competitor) {
        this.competesInCategoryKey = new CompetesInCategoryKey(category, competitor);
    }

    public CompetesInCategoryKey getCompetesInCategoryKey() {
        return this.competesInCategoryKey;
    }

    public void setCompetesInCategoryKey(CompetesInCategoryKey competesInCategoryKey) {
        this.competesInCategoryKey = competesInCategoryKey;
    }

    public Integer getDrawNumber() {
        return this.drawNumber;
    }

    public void setDrawNumber(Integer drawNumber) {
        this.drawNumber = drawNumber;
    }

    public Integer getCompetitorPlacing() {
        return this.competitorPlacing;
    }

    public void setCompetitorPlacing(Integer competitorPlacing) {
        this.competitorPlacing = competitorPlacing;
    }

    public Integer getDrawGroup() {
        return this.drawGroup;
    }

    public void setDrawGroup(Integer drawGroup) {
        this.drawGroup = drawGroup;
    }

    public Rank getPlacingRank() {
        return this.placingRank;
    }

    public void setPlacingRank(Rank placingRank) {
        this.placingRank = placingRank;
    }

    public String toString() {
        return new ObjectToString(CompetesInCategoryDTO.class).addProperty("competesInCategoryKey", (Object)this.competesInCategoryKey).addProperty("drawNumber", (Object)this.drawNumber).addProperty("competitorPlacing", (Object)this.competitorPlacing).addProperty("drawGroup", (Object)this.drawGroup).addProperty("placingRank", (Object)this.placingRank).generateString();
    }

    @Embeddable
    public static class CompetesInCategoryKey
    implements Serializable {
        private static final long serialVersionUID = -7401161047610340079L;
        @ManyToOne(fetch=FetchType.EAGER)
        @JoinColumn(name="categoryid", nullable=false, updatable=false)
        private CategoryDTO category;
        @ManyToOne(fetch=FetchType.EAGER)
        @JoinColumn(name="competitorid", nullable=false, updatable=false)
        private CompetitorDTO competitor;

        public CompetesInCategoryKey() {
        }

        public CompetesInCategoryKey(CategoryDTO category, CompetitorDTO competitor) {
            this.category = category;
            this.competitor = competitor;
        }

        public CategoryDTO getCategory() {
            return this.category;
        }

        public void setCategory(CategoryDTO category) {
            this.category = category;
        }

        public CompetitorDTO getCompetitor() {
            return this.competitor;
        }

        public void setCompetitor(CompetitorDTO competitor) {
            this.competitor = competitor;
        }

        public String toString() {
            return new ObjectToString(CompetesInCategoryKey.class).addProperty("category", (Object)this.category).addProperty("competitor", (Object)this.competitor).generateString();
        }
    }
}

