/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.dl.alter;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.regex.Pattern;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.query.NativeQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.io.ClassPathResource;
import si.nevensrok.common.threads.ThreadUtil;

public class DatabaseAlter
implements ApplicationListener<ApplicationEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseAlter.class);
    private boolean databaseChanged = false;
    private Map<String, String> placeholders;
    private SessionFactory sessionFactory;
    private String driverClassName;

    public void setPlaceholders(Map<String, String> placeholders) {
        this.placeholders = placeholders;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    public synchronized void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            if (this.databaseChanged) {
                return;
            }
            this.databaseChanged = true;
            ThreadUtil.runInBackground((Runnable)new Runnable(){

                @Override
                public void run() {
                    LOGGER.info("Making database changes");
                    try {
                        DatabaseAlter.this.makeDatabaseChanges();
                        LOGGER.info("Database changes made");
                    }
                    catch (Exception e) {
                        LOGGER.error("Error while making database changes", (Throwable)e);
                    }
                }
            }, (boolean)true);
        }
    }

    private void makeDatabaseChanges() throws Exception {
        String path = null;
        if (this.driverClassName.equalsIgnoreCase("org.apache.derby.jdbc.EmbeddedDriver")) {
            path = "/si/nevensrok/jtekma/server/dl/alter/derby";
        }
        if (path != null) {
            this.executeLineFile(path + "/drop-tables.sql");
            this.executeLineFile(path + "/drop-views.sql");
            this.executeFile(path + "/create-view-categorymatchcount.sql");
            this.executeFile(path + "/create-view-competitorcategorycount.sql");
            this.executeFile(path + "/create-view-competitorclubcount.sql");
        }
    }

    private void executeLineFile(String path) {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new ClassPathResource(path).getInputStream(), "UTF-8"));
            String line = reader.readLine();
            while (line != null) {
                if (!(line = line.trim()).isEmpty()) {
                    this.execute(line);
                }
                line = reader.readLine();
            }
        }
        catch (Exception e) {
            LOGGER.debug("Error executing line sql file", (Throwable)e);
        }
    }

    private void executeFile(String path) {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new ClassPathResource(path).getInputStream(), "UTF-8"));
            StringBuilder sql = new StringBuilder();
            int n = reader.read();
            while (n >= 0) {
                sql.append((char)n);
                n = reader.read();
            }
            if (sql.length() > 0) {
                this.execute(sql.toString().trim());
            }
        }
        catch (Exception e) {
            LOGGER.debug("Error executing sql file", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(String sql) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.sessionFactory.openSession();
            transaction = session.beginTransaction();
            if (this.placeholders != null) {
                for (Map.Entry<String, String> entry : this.placeholders.entrySet()) {
                    sql = sql.replaceAll("\\x24\\x7B" + Pattern.quote(entry.getKey()) + "\\x7D", entry.getValue());
                }
            }
            if (sql.endsWith(";")) {
                sql = sql.substring(0, sql.length() - 1);
            }
            LOGGER.debug("Executing query: {}", (Object)sql);
            NativeQuery sqlQuery = session.createNativeQuery(sql);
            sqlQuery.executeUpdate();
            transaction.commit();
        }
        catch (Exception e) {
            try {
                transaction.rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            LOGGER.debug("Error executing sql", (Throwable)e);
        }
        finally {
            try {
                session.close();
            }
            catch (Exception exception) {}
        }
    }
}

