/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.dl.adapters;

import java.util.HashMap;
import java.util.Map;
import si.nevensrok.common.dl.adapters.AdapterPool;
import si.nevensrok.common.dl.adapters.AdapterPoolAware;
import si.nevensrok.common.dl.adapters.AdapterProvider;

public class AdapterPoolImpl
implements AdapterPool {
    protected Map<AdapterPoolKey, AdapterProvider<?, ?>> pool = new HashMap();
    protected Map<AdapterPoolKey, AdapterProvider<?, ?>> subClassCache = new HashMap();

    public void setAdapters(AdapterProvider<?, ?>[] adapters) {
        for (AdapterProvider<?, ?> adapterProvider : adapters) {
            if (adapterProvider instanceof AdapterPoolAware) {
                ((AdapterPoolAware)((Object)adapterProvider)).setAdapterPool(this);
            }
            this.pool.put(new AdapterPoolKey(adapterProvider.getFromClass(), adapterProvider.getToClass()), adapterProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <FROM, TO> AdapterProvider<FROM, TO> getAdapter(Class<FROM> from, Class<TO> to) {
        AdapterProvider result = this.pool.get(new AdapterPoolKey(from, to));
        if (result == null) {
            Map<AdapterPoolKey, AdapterProvider<?, ?>> map = this.subClassCache;
            synchronized (map) {
                result = this.subClassCache.get(new AdapterPoolKey(from, to));
            }
        }
        if (result == null) {
            for (Map.Entry entry : this.pool.entrySet()) {
                if (!((AdapterPoolKey)entry.getKey()).getFrom().isAssignableFrom(from) || !((AdapterPoolKey)entry.getKey()).getTo().equals(to)) continue;
                result = (AdapterProvider)entry.getValue();
                Map<AdapterPoolKey, AdapterProvider<?, ?>> map = this.subClassCache;
                synchronized (map) {
                    this.subClassCache.put(new AdapterPoolKey(from, to), result);
                    break;
                }
            }
        }
        return result;
    }

    @Override
    public <FROM, TO> TO create(Class<TO> toClass, FROM from) {
        if (from == null) {
            return null;
        }
        Class<?> fromClass = from.getClass();
        AdapterProvider<?, TO> adapter = this.getAdapter(fromClass, toClass);
        if (adapter == null) {
            throw new RuntimeException("Adapter not found for " + from.getClass().getName() + " -> " + toClass.getName());
        }
        return adapter.create(from);
    }

    public static class AdapterPoolKey {
        private Class<?> from;
        private Class<?> to;

        public AdapterPoolKey(Class<?> from, Class<?> to) {
            this.from = from;
            this.to = to;
        }

        public Class<?> getFrom() {
            return this.from;
        }

        public Class<?> getTo() {
            return this.to;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.from == null ? 0 : this.from.hashCode());
            result = 31 * result + (this.to == null ? 0 : this.to.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            AdapterPoolKey other = (AdapterPoolKey)obj;
            if (this.from == null ? other.from != null : !this.from.equals(other.from)) {
                return false;
            }
            return !(this.to == null ? other.to != null : !this.to.equals(other.to));
        }
    }
}

