/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.dl;

import java.io.Serializable;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.springframework.beans.factory.InitializingBean;
import si.nevensrok.common.dl.ParamsBinder;

public abstract class CoreDao
implements InitializingBean {
    private SessionFactory sessionFactory;

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    protected Session getCurrentSession() throws HibernateException {
        return this.getSessionFactory().getCurrentSession();
    }

    protected Session openSession() throws HibernateException {
        return this.getSessionFactory().openSession();
    }

    protected <T> T createInstance(T inst) {
        this.getCurrentSession().save(inst);
        return inst;
    }

    protected <T> T saveInstance(T inst) {
        this.getCurrentSession().saveOrUpdate(inst);
        return inst;
    }

    protected <T> T updateInstance(T inst) {
        this.getCurrentSession().update(inst);
        return inst;
    }

    protected void deleteInstance(Object inst) {
        this.getCurrentSession().delete(inst);
    }

    protected <T> T getInstance(Class<T> clazz, Serializable id) {
        return (T)this.getCurrentSession().get(clazz, id);
    }

    protected Query<?> createQuery(String sql) {
        return this.getCurrentSession().createQuery(sql);
    }

    protected Query<?> createQuery(String sql, ParamsBinder paramsBinder) {
        Query query = this.getCurrentSession().createQuery(sql);
        paramsBinder.bindParams(query);
        return query;
    }

    protected NativeQuery<?> createSQLQuery(String sql) {
        return this.getCurrentSession().createNativeQuery(sql);
    }

    protected NativeQuery<?> createSQLQuery(String sql, ParamsBinder paramsBinder) {
        NativeQuery nativeQuery = this.getCurrentSession().createNativeQuery(sql);
        paramsBinder.bindParams((Query<?>)nativeQuery);
        return nativeQuery;
    }

    protected void flush() {
        this.getCurrentSession().flush();
        this.getCurrentSession().clear();
    }

    public static <T> T getSingleResult(Query<T> query) {
        List list = query.getResultList();
        if (list.isEmpty()) {
            return null;
        }
        return (T)list.get(0);
    }

    public void afterPropertiesSet() throws Exception {
        if (this.sessionFactory == null) {
            throw new IllegalArgumentException("Property 'sessionFactory' is requied");
        }
    }
}

