/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.yubikey;

import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import si.nevensrok.common.utils.ArrayUtil;
import si.nevensrok.common.yubikey.Crc16;
import si.nevensrok.common.yubikey.ModHexUtil;
import si.nevensrok.common.yubikey.OtpChecker;
import si.nevensrok.common.yubikey.OtpCodeCheckException;
import si.nevensrok.common.yubikey.OtpCodeData;
import si.nevensrok.common.yubikey.SecretKeyFetcher;

public class YubicoOtpChecker
implements OtpChecker {
    private SecretKeyFetcher secretKeyFetcher;

    public void setSecretKeyFetcher(SecretKeyFetcher secretKeyFetcher) {
        this.secretKeyFetcher = secretKeyFetcher;
    }

    @Override
    public OtpCodeData checkCode(String otpCode) {
        try {
            OtpCodeData otpCodeData = new OtpCodeData();
            String publicId = otpCode.substring(0, otpCode.length() - 32);
            otpCodeData.setPublicId(publicId);
            String encryptedOtp = otpCode.substring(otpCode.length() - 32);
            byte[] encryptedOtpBytes = ModHexUtil.fromModhexString(encryptedOtp);
            byte[] secretKeyBytes = this.secretKeyFetcher.fetchSecretKey(publicId);
            if (secretKeyBytes == null) {
                throw new RuntimeException("Secret key not found");
            }
            if (secretKeyBytes.length != 16) {
                throw new RuntimeException("Secret key bytes length is invalid");
            }
            SecretKeySpec secretKey = new SecretKeySpec(secretKeyBytes, "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding");
            cipher.init(2, secretKey);
            byte[] decryptedOtpBytes = cipher.doFinal(encryptedOtpBytes);
            otpCodeData.setPrivateId(ArrayUtil.subArray((byte[])decryptedOtpBytes, (int)0, (int)6));
            int usageCounter = (decryptedOtpBytes[7] << 8 & 0xFF00) + (decryptedOtpBytes[6] & 0xFF);
            otpCodeData.setUsageCounter(usageCounter);
            int timeStamp = (decryptedOtpBytes[10] << 16 & 0xFF0000) + (decryptedOtpBytes[9] << 8 & 0xFF00) + (decryptedOtpBytes[8] & 0xFF);
            otpCodeData.setTimeStamp(timeStamp);
            int sessionUsageCounter = decryptedOtpBytes[11] & 0xFF;
            otpCodeData.setSessionUsageCounter(sessionUsageCounter);
            int crc16 = (decryptedOtpBytes[15] << 8 & 0xFF00) + (decryptedOtpBytes[14] & 0xFF);
            byte[] bytesToCheck = ArrayUtil.subArray((byte[])decryptedOtpBytes, (int)0, (int)14);
            int calculatedCrc16 = Crc16.calculateCrc16(bytesToCheck);
            if (crc16 != calculatedCrc16) {
                throw new OtpCodeCheckException("CRC16 check failed");
            }
            return otpCodeData;
        }
        catch (Throwable e) {
            throw new OtpCodeCheckException("Error checking OTP code", e);
        }
    }
}

