/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.streams;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import si.nevensrok.common.buffer.WriteByteBuffer;
import si.nevensrok.common.streams.DataInputStream;

public class SplitterInputStream
extends DataInputStream {
    private static final int DATA_FULL = 0;
    private static final int DATA_INFO = 1;
    private static final int DATA_CONTENT = 2;
    private int maxMessageSize;
    private long lastActivityAt = Long.MIN_VALUE;
    private final Map<Integer, WriteByteBuffer> dataMap = new HashMap<Integer, WriteByteBuffer>();

    public SplitterInputStream(InputStream inputStream, int maxMessageSize) {
        super(inputStream);
        this.maxMessageSize = maxMessageSize;
    }

    public synchronized byte[] readData() throws IOException {
        int c;
        block11: {
            WriteByteBuffer byteBuffer;
            int dataId;
            while (true) {
                int n;
                if ((c = this.readUnsignedByte()) == 0) {
                    int n2;
                    int dataLength = this.readInt();
                    if (dataLength > this.maxMessageSize) {
                        throw new IOException("Received data length " + dataLength + " is too big");
                    }
                    byte[] data = new byte[dataLength];
                    for (int dataRead = 0; dataRead < dataLength; dataRead += n2) {
                        n2 = this.read(data, dataRead, dataLength - dataRead);
                        if (n2 < 0) {
                            throw new IOException("End of stream reached");
                        }
                        this.lastActivityAt = System.currentTimeMillis();
                    }
                    return data;
                }
                if (c == 1) {
                    dataId = this.readInt();
                    int dataLength = this.readInt();
                    if (dataLength > this.maxMessageSize) {
                        throw new IOException("Received data length " + dataLength + " is too big");
                    }
                    this.dataMap.put(dataId, new WriteByteBuffer(dataLength, dataLength));
                    this.lastActivityAt = System.currentTimeMillis();
                    continue;
                }
                if (c != 2) break block11;
                dataId = this.readInt();
                int chunkLength = this.readInt();
                if (chunkLength > this.maxMessageSize) {
                    throw new IOException("Received chunk length " + chunkLength + " is too big");
                }
                byteBuffer = this.dataMap.get(dataId);
                this.lastActivityAt = System.currentTimeMillis();
                if (byteBuffer == null) {
                    throw new IOException("Invalid data id received '" + dataId + "'");
                }
                byte[] data = new byte[chunkLength];
                for (int dataRead = 0; dataRead < chunkLength; dataRead += n) {
                    n = this.read(data, dataRead, chunkLength - dataRead);
                    if (n < 0) {
                        throw new IOException("End of stream reached");
                    }
                    this.lastActivityAt = System.currentTimeMillis();
                }
                byteBuffer.add(data);
                if (byteBuffer.isBufferFull()) break;
            }
            this.dataMap.remove(dataId);
            return byteBuffer.getBuffer();
        }
        throw new IOException("Unexpected data received '" + c + "'");
    }

    public long getLastActivityAt() {
        return this.lastActivityAt;
    }
}

