/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.network.udp;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.concurrent.Executor;
import si.nevensrok.common.encryption.AesEncryptorDecryptor;
import si.nevensrok.common.network.NetworkMessageHandler;
import si.nevensrok.common.network.udp.AesMessageReceiver;
import si.nevensrok.common.network.udp.MessageReceiver;
import si.nevensrok.common.network.udp.UdpBroadcastMessageSenderAndReceiver;

public class AesUdpBroadcastMessageSenderAndReceiver
extends UdpBroadcastMessageSenderAndReceiver {
    private AesEncryptorDecryptor aesEncryptorDecryptor = new AesEncryptorDecryptor();

    public void setKeyAsString(String keyAsString) {
        this.aesEncryptorDecryptor.setKeyAsString(keyAsString);
    }

    public void setKey(byte[] key) {
        this.aesEncryptorDecryptor.setKey(key);
    }

    public void setKeySize(int keySize) {
        this.aesEncryptorDecryptor.setKeySize(keySize);
    }

    public void setChipperInstance(String chipperInstance) {
        this.aesEncryptorDecryptor.setChipperInstance(chipperInstance);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        this.aesEncryptorDecryptor.afterPropertiesSet();
        super.afterPropertiesSet();
    }

    @Override
    protected DatagramPacket generateDatagramPacket(String address, int port, byte[] data) throws Exception {
        byte[] encryptedData = this.aesEncryptorDecryptor.encrypt(data);
        return new DatagramPacket(encryptedData, encryptedData.length, InetAddress.getByName(address), port);
    }

    @Override
    protected MessageReceiver generateMessageReceiver(DatagramSocket socket, int bufferSize, Executor executor, NetworkMessageHandler nmh) throws Exception {
        return new AesMessageReceiver(socket, bufferSize, executor, nmh, this.aesEncryptorDecryptor);
    }
}

