/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.jms;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.TaskExecutor;
import si.nevensrok.common.jms.MessageHandler;
import si.nevensrok.common.jms.MessageProcessorChecker;
import si.nevensrok.common.jms.SourceType;
import si.nevensrok.common.utils.StringUtil;

public class JmsProcessorInstance
implements MessageListener {
    private static final Logger log = LoggerFactory.getLogger(JmsProcessorInstance.class);
    private TaskExecutor taskExecutor;
    private MessageHandler messageHandler;
    private MessageProcessorChecker messageProcessorChecker;
    private Session session;
    private MessageProducer messageProducer;
    private MessageConsumer messageConsumer;

    public JmsProcessorInstance(Connection connection, int deliveryMode, int priority, int timeToLive, boolean transacted, int acknowledgeMode, TaskExecutor taskExecutor, String source, SourceType sourceType, MessageHandler messageHandler, MessageProcessorChecker messageProcessorChecker) throws Exception {
        Queue jmsSource;
        this.taskExecutor = taskExecutor;
        this.messageHandler = messageHandler;
        this.messageProcessorChecker = messageProcessorChecker;
        this.session = connection.createSession(transacted, acknowledgeMode);
        if (sourceType == SourceType.QUEUE) {
            jmsSource = this.session.createQueue(source);
        } else if (sourceType == SourceType.TOPIC) {
            jmsSource = this.session.createTopic(source);
        } else {
            throw new IllegalArgumentException("Unsupported source type " + (Object)((Object)sourceType));
        }
        this.messageProducer = this.session.createProducer(null);
        this.messageProducer.setDeliveryMode(deliveryMode);
        if (priority > 0) {
            this.messageProducer.setPriority(priority);
        }
        if (timeToLive > 0) {
            this.messageProducer.setTimeToLive((long)timeToLive);
        }
        this.messageConsumer = this.session.createConsumer((Destination)jmsSource);
        this.messageConsumer.setMessageListener((MessageListener)this);
    }

    public void close() {
        try {
            this.messageConsumer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.messageProducer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.session.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void onMessage(final Message message) {
        try {
            log.trace("JMS message received: {}", (Object)message);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        if (JmsProcessorInstance.this.messageProcessorChecker != null && JmsProcessorInstance.this.messageProcessorChecker.wasMessageAlreadyProcessed(message)) {
                            return;
                        }
                        String correlationId = message.getJMSCorrelationID();
                        Destination replyTo = message.getJMSReplyTo();
                        Message responseMessage = JmsProcessorInstance.this.messageHandler.handleMessage(JmsProcessorInstance.this.session, message);
                        if (responseMessage != null && replyTo != null) {
                            if (!StringUtil.isEmpty((String)correlationId)) {
                                responseMessage.setJMSCorrelationID(correlationId);
                            }
                            JmsProcessorInstance.this.messageProducer.send(replyTo, responseMessage);
                        }
                    }
                    catch (Throwable e) {
                        log.debug("Error handling message", e);
                        throw new RuntimeException("Error handling message");
                    }
                }
            };
            if (this.taskExecutor != null) {
                this.taskExecutor.execute(runnable);
            } else {
                runnable.run();
            }
        }
        catch (Exception e) {
            log.debug("Error handling message", (Throwable)e);
            throw new RuntimeException("Error handling message");
        }
    }
}

