/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.lock;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import javax.sql.DataSource;
import si.nevensrok.common.lock.AbstractExternalLockService;
import si.nevensrok.common.lock.DatabaseLock;

public class DatabaseLockService
extends AbstractExternalLockService {
    private DataSource dataSource;
    private String locksTableName;
    private String membersTableName;

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public String getLocksTableName() {
        return this.locksTableName;
    }

    public void setLocksTableName(String locksTableName) {
        this.locksTableName = locksTableName;
    }

    public String getMembersTableName() {
        return this.membersTableName;
    }

    public void setMembersTableName(String membersTableName) {
        this.membersTableName = membersTableName;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        if (this.dataSource == null) {
            throw new IllegalArgumentException("Property 'dataSource' is requied");
        }
        if (this.locksTableName == null) {
            throw new IllegalArgumentException("Property 'locksTableName' is requied");
        }
        if (this.dataSource == null) {
            throw new IllegalArgumentException("Property 'membersTableName' is requied");
        }
        super.afterPropertiesSet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean announceMember() {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = this.dataSource.getConnection();
            connection.setAutoCommit(false);
            preparedStatement = connection.prepareStatement("insert into " + this.membersTableName + " (memberid,lastcheckin) values (?,?)");
            preparedStatement.setString(1, this.getMemberId());
            preparedStatement.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
            preparedStatement.execute();
            preparedStatement.close();
            connection.commit();
            boolean bl = true;
            return bl;
        }
        catch (Throwable e) {
            if (connection != null) {
                try {
                    connection.rollback();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Throwable throwable) {}
            }
        }
        return false;
    }

    @Override
    protected void departMember() {
        this.removeDataForMember(this.getMemberId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void checkInMember() {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = this.dataSource.getConnection();
            connection.setAutoCommit(false);
            preparedStatement = connection.prepareStatement("update " + this.membersTableName + " set lastcheckin=? where memberid=?");
            preparedStatement.setTimestamp(1, new Timestamp(System.currentTimeMillis()));
            preparedStatement.setString(2, this.getMemberId());
            preparedStatement.execute();
            preparedStatement.close();
            connection.commit();
        }
        catch (Throwable e) {
            if (connection != null) {
                try {
                    connection.rollback();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    @Override
    protected void cleanupExpiredData() {
        for (String expiredmemberId : this.getExpiredMembers()) {
            this.removeDataForMember(expiredmemberId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDataForMember(String memberId) {
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            connection = this.dataSource.getConnection();
            connection.setAutoCommit(false);
            preparedStatement = connection.prepareStatement("delete from " + this.locksTableName + " where memberid=?");
            preparedStatement.setString(1, memberId);
            preparedStatement.execute();
            preparedStatement.close();
            preparedStatement = connection.prepareStatement("delete from " + this.membersTableName + " where memberid=?");
            preparedStatement.setString(1, memberId);
            preparedStatement.execute();
            preparedStatement.close();
            connection.commit();
        }
        catch (Throwable e) {
            if (connection != null) {
                try {
                    connection.rollback();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> getExpiredMembers() {
        LinkedList<String> linkedList;
        Connection connection = null;
        PreparedStatement preparedStatement = null;
        try {
            LinkedList<String> expiredMembers = new LinkedList<String>();
            connection = this.dataSource.getConnection();
            connection.setAutoCommit(false);
            preparedStatement = connection.prepareStatement("select memberid from " + this.membersTableName + " where lastcheckin<?");
            preparedStatement.setTimestamp(1, new Timestamp(System.currentTimeMillis() - 60000L));
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                expiredMembers.add(resultSet.getString(1));
            }
            resultSet.close();
            preparedStatement.close();
            connection.commit();
            linkedList = expiredMembers;
            if (connection == null) return linkedList;
        }
        catch (Throwable e) {
            try {
                if (connection != null) {
                    try {
                        connection.rollback();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                LinkedList<String> linkedList2 = new LinkedList<String>();
                return linkedList2;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        try {
            connection.close();
            return linkedList;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return linkedList;
    }

    @Override
    protected Lock generateLock(String name) {
        return new DatabaseLock(this.dataSource, this.getMemberId(), name, this.getLocksTableName(), this.getMembersTableName());
    }
}

