/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.gui.horizontal.duo;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import si.nevensrok.jtekma.common.rules.CompetitorType;
import si.nevensrok.jtekma.tabla.common.Constants;
import si.nevensrok.jtekma.tabla.common.DuoPoints;
import si.nevensrok.jtekma.tabla.common.MatchData;
import si.nevensrok.jtekma.tabla.fw.TablaManager;
import si.nevensrok.jtekma.tabla.gui.WindowKeyListener;
import si.nevensrok.jtekma.tabla.gui.duo.DuoPointsDocument;
import si.nevensrok.jtekma.tabla.gui.duo.DuoTextFieldKeyListener;
import si.nevensrok.jtekma.tabla.gui.horizontal.duo.DuoFieldSelector;
import si.nevensrok.jtekma.tabla.util.FontSizeUtil;

public class DuoPointsRow
extends JPanel {
    private JLabel numberLabel = new JLabel();
    private JTextField[] points = new JTextField[5];
    private JLabel pointsSum = new JLabel("0.0");
    private int round;
    private MatchData matchData;
    private DuoPoints duoPoints;
    private TablaManager tablaManager;
    private CompetitorType competitorType;
    private boolean documentForFieldsSet = false;
    private DuoTextFieldKeyListener duoTextFieldKeyListener;

    public DuoPointsRow(CompetitorType competitorType, int round) {
        this.competitorType = competitorType;
        this.round = round;
        this.setLayout(new GridLayout(1, 7));
        this.numberLabel.setHorizontalAlignment(0);
        if (round <= 4) {
            this.numberLabel.setText(String.valueOf(round));
        } else {
            this.numberLabel.setText("E");
        }
        this.add(this.numberLabel);
        for (int i = 0; i < this.points.length; ++i) {
            this.points[i] = new JTextField("0.0");
            this.points[i].setHorizontalAlignment(0);
            this.add(this.points[i]);
        }
        this.pointsSum.setHorizontalAlignment(0);
        this.add(this.pointsSum);
        this.duoTextFieldKeyListener = new DuoTextFieldKeyListener();
    }

    public void setWindowKeyListener(WindowKeyListener windowKeyListener) {
        for (JTextField pointField : this.points) {
            pointField.addKeyListener(windowKeyListener);
        }
    }

    public void setMatchData(MatchData matchData) {
        this.matchData = matchData;
        this.setDocumentForFields();
    }

    public void setDuoPoints(DuoPoints duoPoints) {
        this.duoPoints = duoPoints;
        this.setDocumentForFields();
    }

    public void setTablaManager(TablaManager tablaManager) {
        this.tablaManager = tablaManager;
        this.setDocumentForFields();
    }

    public void setDuoFieldSelector(DuoFieldSelector duoFieldSelector) {
        for (JTextField pointField : this.points) {
            this.duoTextFieldKeyListener.setDuoPointsPanel(duoFieldSelector);
            pointField.addKeyListener(this.duoTextFieldKeyListener);
        }
    }

    private void setDocumentForFields() {
        if (this.duoPoints == null || this.tablaManager == null || this.matchData == null) {
            return;
        }
        if (this.documentForFieldsSet) {
            return;
        }
        this.documentForFieldsSet = true;
        for (int i = 0; i < this.points.length; ++i) {
            this.points[i].setDocument(new DuoPointsDocument(this.competitorType, this.round, i + 1, this.duoPoints, this.matchData, this.tablaManager));
        }
    }

    public void selectField(final int index) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DuoPointsRow.this.points[index - 1].requestFocus();
                DuoPointsRow.this.points[index - 1].setSelectionStart(0);
                DuoPointsRow.this.points[index - 1].setSelectionEnd(DuoPointsRow.this.points[index - 1].getText().length());
            }
        });
    }

    public int getSelectedField() {
        for (int judge = 1; judge <= 5; ++judge) {
            if (!this.points[judge - 1].hasFocus()) continue;
            return judge;
        }
        return 0;
    }

    public void resetPoints() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (int judge = 1; judge <= 5; ++judge) {
                    if (DuoPointsRow.this.competitorType == CompetitorType.COMPETITOR1) {
                        DuoPointsRow.this.points[judge - 1].setText(Constants.DUO_POINTS_FORMAT.format(DuoPointsRow.this.duoPoints.getPoints1(DuoPointsRow.this.round, judge)));
                    } else if (DuoPointsRow.this.competitorType == CompetitorType.COMPETITOR2) {
                        DuoPointsRow.this.points[judge - 1].setText(Constants.DUO_POINTS_FORMAT.format(DuoPointsRow.this.duoPoints.getPoints2(DuoPointsRow.this.round, judge)));
                    }
                    FontSizeUtil.refitFontSize(Constants.FONT, DuoPointsRow.this.points[judge - 1]);
                }
                DuoPointsRow.this.recalculateRoundPoints();
            }
        });
    }

    public void recalculateRoundPoints() {
        float total = 0.0f;
        float min = 2.1474836E9f;
        float max = -2.1474836E9f;
        for (int judge = 1; judge <= 5; ++judge) {
            float point = 0.0f;
            if (this.competitorType == CompetitorType.COMPETITOR1) {
                point = this.duoPoints.getPoints1(this.round, judge);
            } else if (this.competitorType == CompetitorType.COMPETITOR2) {
                point = this.duoPoints.getPoints2(this.round, judge);
            }
            total += point;
            min = Math.min(min, point);
            max = Math.max(max, point);
        }
        total -= min + max;
        final float t = total = (float)Math.round(total * 10.0f) / 10.0f;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DuoPointsRow.this.pointsSum.setText(Constants.DUO_POINTS_FORMAT.format(t));
                FontSizeUtil.refitFontSize(Constants.FONT, DuoPointsRow.this.pointsSum);
            }
        });
    }

    public void redrawElements() {
        final int judges = this.matchData.getDuoJudges();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (judges == 3) {
                    if (!DuoPointsRow.this.points[3].getText().equals("0")) {
                        DuoPointsRow.this.points[3].setText("0");
                    }
                    DuoPointsRow.this.points[3].setEnabled(false);
                    if (!DuoPointsRow.this.points[4].getText().equals("10")) {
                        DuoPointsRow.this.points[4].setText("10");
                    }
                    DuoPointsRow.this.points[4].setEnabled(false);
                } else {
                    DuoPointsRow.this.points[3].setEnabled(true);
                    DuoPointsRow.this.points[4].setEnabled(true);
                }
                FontSizeUtil.refitFontSize(Constants.FONT, DuoPointsRow.this.numberLabel, "E");
                for (JTextField pointField : DuoPointsRow.this.points) {
                    FontSizeUtil.refitFontSize(Constants.FONT, pointField);
                }
                FontSizeUtil.refitFontSize(Constants.FONT, DuoPointsRow.this.pointsSum);
            }
        });
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.numberLabel != null) {
            this.numberLabel.setBackground(bg);
        }
        if (this.pointsSum != null) {
            this.pointsSum.setBackground(bg);
        }
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.numberLabel != null) {
            this.numberLabel.setForeground(fg);
        }
        if (this.pointsSum != null) {
            this.pointsSum.setForeground(fg);
        }
    }
}

