/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.fw;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import si.nevensrok.jtekma.tabla.common.MatchData;
import si.nevensrok.jtekma.tabla.fw.TablaManager;
import si.nevensrok.jtekma.tabla.gui.MatchPanel;
import si.nevensrok.jtekma.tabla.gui.TablaWindow;

public class TimeTracker
implements DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeTracker.class);
    private MatchData matchData;
    private TablaManager tablaManager;
    private TablaWindow tablaWindow;
    private MatchPanel matchPanel;
    private final Object timeMonitor = new Object();
    private Thread timeThread = null;
    private Thread hosekomiThread = null;

    public void setMatchData(MatchData matchData) {
        this.matchData = matchData;
    }

    public void setTablaManager(TablaManager tablaManager) {
        this.tablaManager = tablaManager;
    }

    public void setTablaWindow(TablaWindow tablaWindow) {
        this.tablaWindow = tablaWindow;
    }

    public void setMatchPanel(MatchPanel matchPanel) {
        this.matchPanel = matchPanel;
    }

    public void destroy() throws Exception {
        this.timeThread = null;
        this.hosekomiThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startStopTime() {
        Object object = this.timeMonitor;
        synchronized (object) {
            if (this.timeThread == null) {
                this.timeThread = new Thread("Time thread"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        LOGGER.debug("Starting time thread");
                        long startTime = System.currentTimeMillis();
                        while (TimeTracker.this.timeThread == this) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            long endTime = System.currentTimeMillis();
                            long timeDiff = endTime - startTime;
                            Object object = TimeTracker.this.timeMonitor;
                            synchronized (object) {
                                if (TimeTracker.this.timeThread == this) {
                                    long time = TimeTracker.this.matchData.getTimeLeft() - timeDiff;
                                    if (time <= 0L) {
                                        time = 0L;
                                        TimeTracker.this.timeThread = null;
                                        if (TimeTracker.this.hosekomiThread == null) {
                                            TimeTracker.this.tablaManager.selectWinner();
                                        }
                                    }
                                    TimeTracker.this.matchData.setTimeLeft(time);
                                    TimeTracker.this.matchData.setTimeFromStart(TimeTracker.this.matchData.getTimeFromStart() + timeDiff);
                                    TimeTracker.this.matchPanel.redrawElements();
                                }
                            }
                            startTime = endTime;
                        }
                        LOGGER.debug("Stopping time thread");
                    }
                };
                this.timeThread.setDaemon(true);
                this.timeThread.start();
                this.matchPanel.redrawElements();
            } else {
                this.timeThread = null;
                this.hosekomiThread = null;
                this.matchPanel.redrawElements();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopTime() {
        Object object = this.timeMonitor;
        synchronized (object) {
            this.timeThread = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startStopHosekomiTime() {
        Object object = this.timeMonitor;
        synchronized (object) {
            if (this.hosekomiThread == null) {
                this.hosekomiThread = new Thread("Hosekomi time thread"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        LOGGER.debug("Starting hosekomi time thread");
                        long startTime = System.currentTimeMillis();
                        while (TimeTracker.this.hosekomiThread == this) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            long endTime = System.currentTimeMillis();
                            Object object = TimeTracker.this.timeMonitor;
                            synchronized (object) {
                                if (TimeTracker.this.hosekomiThread == this) {
                                    long time = TimeTracker.this.matchData.getHosekomiTime() + (endTime - startTime);
                                    if (time >= TimeTracker.this.matchData.getMaximumHosekomiTime()) {
                                        time = TimeTracker.this.matchData.getMaximumHosekomiTime();
                                        TimeTracker.this.hosekomiThread = null;
                                        TimeTracker.this.timeThread = null;
                                        TimeTracker.this.tablaWindow.showHosekomiEndedMessage();
                                    }
                                    TimeTracker.this.matchData.setHosekomiTime(time);
                                    TimeTracker.this.matchPanel.redrawElements();
                                }
                            }
                            startTime = endTime;
                        }
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Stopping hosekomi time thread");
                        }
                    }
                };
                this.hosekomiThread.setDaemon(true);
                this.hosekomiThread.start();
                this.matchPanel.redrawElements();
            } else {
                this.hosekomiThread = null;
                this.matchPanel.redrawElements();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopHosekomiTime() {
        Object object = this.timeMonitor;
        synchronized (object) {
            this.hosekomiThread = null;
        }
    }

    public boolean isTimeRunning() {
        return this.timeThread != null;
    }

    public boolean isHosekomiRunning() {
        return this.hosekomiThread != null;
    }
}

