/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.utils;

import java.util.LinkedHashMap;
import java.util.Map;

public final class MimeTypeUtil {
    private static final Map<String, String> KNOWN_MIME_TYPES = new LinkedHashMap<String, String>();
    private static final String DEFAULT_MIME_TYPE = "application/octet-stream";

    private MimeTypeUtil() {
    }

    public static String getMimeTypeByFileName(String fileName) {
        int n = (fileName = fileName.toLowerCase()).lastIndexOf(46);
        if (n < 0) {
            return DEFAULT_MIME_TYPE;
        }
        String fileSuffix = fileName.substring(n + 1, fileName.length());
        String mimeType = KNOWN_MIME_TYPES.get(fileSuffix);
        if (mimeType != null) {
            return mimeType;
        }
        return DEFAULT_MIME_TYPE;
    }

    static {
        KNOWN_MIME_TYPES.put("123", "application/vnd.lotus-1-2-3");
        KNOWN_MIME_TYPES.put("3dm", "x-world/x-3dmf");
        KNOWN_MIME_TYPES.put("3dmf", "x-world/x-3dmf");
        KNOWN_MIME_TYPES.put("3dml", "text/vnd.in3d.3dml");
        KNOWN_MIME_TYPES.put("3g2", "video/3gpp2");
        KNOWN_MIME_TYPES.put("3gp", "video/3gpp");
        KNOWN_MIME_TYPES.put("7z", "application/x-7z-compressed");
        KNOWN_MIME_TYPES.put("a", DEFAULT_MIME_TYPE);
        KNOWN_MIME_TYPES.put("aab", "application/x-authorware-bin");
        KNOWN_MIME_TYPES.put("aac", "audio/x-aac");
        KNOWN_MIME_TYPES.put("aam", "application/x-authorware-map");
        KNOWN_MIME_TYPES.put("aas", "application/x-authorware-seg");
        KNOWN_MIME_TYPES.put("abc", "text/vnd.abc");
        KNOWN_MIME_TYPES.put("abw", "application/x-abiword");
        KNOWN_MIME_TYPES.put("ac", "application/pkix-attr-cert");
        KNOWN_MIME_TYPES.put("acc", "application/vnd.americandynamics.acc");
        KNOWN_MIME_TYPES.put("ace", "application/x-ace-compressed");
        KNOWN_MIME_TYPES.put("acgi", "text/html");
        KNOWN_MIME_TYPES.put("acu", "application/vnd.acucobol");
        KNOWN_MIME_TYPES.put("adp", "audio/adpcm");
        KNOWN_MIME_TYPES.put("aep", "application/vnd.audiograph");
        KNOWN_MIME_TYPES.put("afl", "video/animaflex");
        KNOWN_MIME_TYPES.put("afp", "application/vnd.ibm.modcap");
        KNOWN_MIME_TYPES.put("ahead", "application/vnd.ahead.space");
        KNOWN_MIME_TYPES.put("ai", "application/postscript");
        KNOWN_MIME_TYPES.put("aif", "audio/x-aiff");
        KNOWN_MIME_TYPES.put("aifc", "audio/aiff");
        KNOWN_MIME_TYPES.put("aiff", "audio/aiff");
        KNOWN_MIME_TYPES.put("aim", "application/x-aim");
        KNOWN_MIME_TYPES.put("aip", "text/x-audiosoft-intra");
        KNOWN_MIME_TYPES.put("air", "application/vnd.adobe.air-application-installer-package+zip");
        KNOWN_MIME_TYPES.put("ait", "application/vnd.dvb.ait");
        KNOWN_MIME_TYPES.put("ami", "application/vnd.amiga.ami");
        KNOWN_MIME_TYPES.put("ani", "application/x-navi-animation");
        KNOWN_MIME_TYPES.put("aos", "application/x-nokia-9000-communicator-add-on-software");
        KNOWN_MIME_TYPES.put("apk", "application/vnd.android.package-archive");
        KNOWN_MIME_TYPES.put("application", "application/x-ms-application");
        KNOWN_MIME_TYPES.put("apr", "application/vnd.lotus-approach");
        KNOWN_MIME_TYPES.put("aps", "application/mime");
        KNOWN_MIME_TYPES.put("arc", DEFAULT_MIME_TYPE);
        KNOWN_MIME_TYPES.put("arj", "application/arj");
        KNOWN_MIME_TYPES.put("art", "image/x-jg");
        KNOWN_MIME_TYPES.put("asf", "video/x-ms-asf");
        KNOWN_MIME_TYPES.put("asm", "text/x-asm");
        KNOWN_MIME_TYPES.put("aso", "application/vnd.accpac.simply.aso");
        KNOWN_MIME_TYPES.put("asp", "text/asp");
        KNOWN_MIME_TYPES.put("asx", "application/x-mplayer2");
        KNOWN_MIME_TYPES.put("atc", "application/vnd.acucorp");
        KNOWN_MIME_TYPES.put("atom", "application/atom+xml");
        KNOWN_MIME_TYPES.put("atomcat", "application/atomcat+xml");
        KNOWN_MIME_TYPES.put("atomsvc", "application/atomsvc+xml");
        KNOWN_MIME_TYPES.put("atx", "application/vnd.antix.game-component");
        KNOWN_MIME_TYPES.put("au", "audio/basic");
        KNOWN_MIME_TYPES.put("avi", "video/avi");
        KNOWN_MIME_TYPES.put("avs", "video/avs-video");
        KNOWN_MIME_TYPES.put("aw", "application/applixware");
        KNOWN_MIME_TYPES.put("azf", "application/vnd.airzip.filesecure.azf");
        KNOWN_MIME_TYPES.put("azs", "application/vnd.airzip.filesecure.azs");
        KNOWN_MIME_TYPES.put("azw", "application/vnd.amazon.ebook");
        KNOWN_MIME_TYPES.put("bcpio", "application/x-bcpio");
        KNOWN_MIME_TYPES.put("bdf", "application/x-font-bdf");
        KNOWN_MIME_TYPES.put("bdm", "application/vnd.syncml.dm+wbxml");
        KNOWN_MIME_TYPES.put("bed", "application/vnd.realvnc.bed");
        KNOWN_MIME_TYPES.put("bh2", "application/vnd.fujitsu.oasysprs");
        KNOWN_MIME_TYPES.put("bin", DEFAULT_MIME_TYPE);
        KNOWN_MIME_TYPES.put("bm", "image/bmp");
        KNOWN_MIME_TYPES.put("bmi", "application/vnd.bmi");
        KNOWN_MIME_TYPES.put("bmp", "image/bmp");
        KNOWN_MIME_TYPES.put("boo", "application/book");
        KNOWN_MIME_TYPES.put("book", "application/book");
        KNOWN_MIME_TYPES.put("box", "application/vnd.previewsystems.box");
        KNOWN_MIME_TYPES.put("boz", "application/x-bzip2");
        KNOWN_MIME_TYPES.put("bsh", "application/x-bsh");
        KNOWN_MIME_TYPES.put("btif", "image/prs.btif");
        KNOWN_MIME_TYPES.put("bz", "application/x-bzip");
        KNOWN_MIME_TYPES.put("bz2", "application/x-bzip2");
        KNOWN_MIME_TYPES.put("c", "text/x-c");
        KNOWN_MIME_TYPES.put("c++", "text/plain");
        KNOWN_MIME_TYPES.put("c11amc", "application/vnd.cluetrust.cartomobile-config");
        KNOWN_MIME_TYPES.put("c11amz", "application/vnd.cluetrust.cartomobile-config-pkg");
        KNOWN_MIME_TYPES.put("c4g", "application/vnd.clonk.c4group");
        KNOWN_MIME_TYPES.put("cab", "application/vnd.ms-cab-compressed");
        KNOWN_MIME_TYPES.put("car", "application/vnd.curl.car");
        KNOWN_MIME_TYPES.put("cat", "application/vnd.ms-pki.seccat");
        KNOWN_MIME_TYPES.put("cc", "text/x-c");
        KNOWN_MIME_TYPES.put("ccad", "application/clariscad");
        KNOWN_MIME_TYPES.put("cco", "application/x-cocoa");
        KNOWN_MIME_TYPES.put("ccxml", "application/ccxml+xml,");
        KNOWN_MIME_TYPES.put("cdbcmsg", "application/vnd.contact.cmsg");
        KNOWN_MIME_TYPES.put("cdf", "application/cdf");
        KNOWN_MIME_TYPES.put("cdkey", "application/vnd.mediastation.cdkey");
        KNOWN_MIME_TYPES.put("cdmia", "application/cdmi-capability");
        KNOWN_MIME_TYPES.put("cdmic", "application/cdmi-container");
        KNOWN_MIME_TYPES.put("cdmid", "application/cdmi-domain");
        KNOWN_MIME_TYPES.put("cdmio", "application/cdmi-object");
        KNOWN_MIME_TYPES.put("cdmiq", "application/cdmi-queue");
        KNOWN_MIME_TYPES.put("cdx", "chemical/x-cdx");
        KNOWN_MIME_TYPES.put("cdxml", "application/vnd.chemdraw+xml");
        KNOWN_MIME_TYPES.put("cdy", "application/vnd.cinderella");
        KNOWN_MIME_TYPES.put("cer", "application/x-x509-ca-cert");
        KNOWN_MIME_TYPES.put("cgm", "image/cgm");
        KNOWN_MIME_TYPES.put("cha", "application/x-chat");
        KNOWN_MIME_TYPES.put("chat", "application/x-chat");
        KNOWN_MIME_TYPES.put("chm", "application/vnd.ms-htmlhelp");
        KNOWN_MIME_TYPES.put("chrt", "application/vnd.kde.kchart");
        KNOWN_MIME_TYPES.put("cif", "chemical/x-cif");
        KNOWN_MIME_TYPES.put("cii", "application/vnd.anser-web-certificate-issue-initiation");
        KNOWN_MIME_TYPES.put("cil", "application/vnd.ms-artgalry");
        KNOWN_MIME_TYPES.put("cla", "application/vnd.claymore");
        KNOWN_MIME_TYPES.put("class", "application/java-byte-code");
        KNOWN_MIME_TYPES.put("clkk", "application/vnd.crick.clicker.keyboard");
        KNOWN_MIME_TYPES.put("clkp", "application/vnd.crick.clicker.palette");
        KNOWN_MIME_TYPES.put("clkt", "application/vnd.crick.clicker.template");
        KNOWN_MIME_TYPES.put("clkw", "application/vnd.crick.clicker.wordbank");
        KNOWN_MIME_TYPES.put("clkx", "application/vnd.crick.clicker");
        KNOWN_MIME_TYPES.put("clp", "application/x-msclip");
        KNOWN_MIME_TYPES.put("cmc", "application/vnd.cosmocaller");
        KNOWN_MIME_TYPES.put("cmdf", "chemical/x-cmdf");
        KNOWN_MIME_TYPES.put("cml", "chemical/x-cml");
        KNOWN_MIME_TYPES.put("cmp", "application/vnd.yellowriver-custom-menu");
        KNOWN_MIME_TYPES.put("cmx", "image/x-cmx");
        KNOWN_MIME_TYPES.put("cod", "application/vnd.rim.cod");
        KNOWN_MIME_TYPES.put("com", DEFAULT_MIME_TYPE);
        KNOWN_MIME_TYPES.put("conf", "text/plain");
        KNOWN_MIME_TYPES.put("cpio", "application/x-cpio");
        KNOWN_MIME_TYPES.put("cpp", "text/x-c");
        KNOWN_MIME_TYPES.put("cpt", "application/x-cpt");
        KNOWN_MIME_TYPES.put("crd", "application/x-mscardfile");
        KNOWN_MIME_TYPES.put("crl", "application/pkix-crl");
        KNOWN_MIME_TYPES.put("crt", "application/pkix-cert");
        KNOWN_MIME_TYPES.put("cryptonote", "application/vnd.rig.cryptonote");
        KNOWN_MIME_TYPES.put("csh", "application/x-csh");
        KNOWN_MIME_TYPES.put("csml", "chemical/x-csml");
        KNOWN_MIME_TYPES.put("csp", "application/vnd.commonspace");
        KNOWN_MIME_TYPES.put("css", "text/css");
        KNOWN_MIME_TYPES.put("csv", "text/csv");
        KNOWN_MIME_TYPES.put("cu", "application/cu-seeme");
        KNOWN_MIME_TYPES.put("curl", "text/vnd.curl");
        KNOWN_MIME_TYPES.put("cww", "application/prs.cww");
        KNOWN_MIME_TYPES.put("cxx", "text/plain");
        KNOWN_MIME_TYPES.put("dae", "model/vnd.collada+xml");
        KNOWN_MIME_TYPES.put("daf", "application/vnd.mobius.daf");
        KNOWN_MIME_TYPES.put("davmount", "application/davmount+xml");
        KNOWN_MIME_TYPES.put("dcr", "application/x-director");
        KNOWN_MIME_TYPES.put("dcurl", "text/vnd.curl.dcurl");
        KNOWN_MIME_TYPES.put("dd2", "application/vnd.oma.dd2+xml");
        KNOWN_MIME_TYPES.put("ddd", "application/vnd.fujixerox.ddd");
        KNOWN_MIME_TYPES.put("deb", "application/x-debian-package");
        KNOWN_MIME_TYPES.put("deepv", "application/x-deepv");
        KNOWN_MIME_TYPES.put("def", "text/plain");
        KNOWN_MIME_TYPES.put("der", "application/x-x509-ca-cert");
        KNOWN_MIME_TYPES.put("dfac", "application/vnd.dreamfactory");
        KNOWN_MIME_TYPES.put("dif", "video/x-dv");
        KNOWN_MIME_TYPES.put("dir", "application/x-director");
        KNOWN_MIME_TYPES.put("dis", "application/vnd.mobius.dis");
        KNOWN_MIME_TYPES.put("djvu", "image/vnd.djvu");
        KNOWN_MIME_TYPES.put("dl", "video/dl");
        KNOWN_MIME_TYPES.put("dna", "application/vnd.dna");
        KNOWN_MIME_TYPES.put("doc", "application/msword");
        KNOWN_MIME_TYPES.put("docm", "application/vnd.ms-word.document.macroenabled.12");
        KNOWN_MIME_TYPES.put("docx", "application/vnd.openxmlformats-officedocument.wordprocessingml.document");
        KNOWN_MIME_TYPES.put("dot", "application/msword");
        KNOWN_MIME_TYPES.put("dotm", "application/vnd.ms-word.template.macroenabled.12");
        KNOWN_MIME_TYPES.put("dotx", "application/vnd.openxmlformats-officedocument.wordprocessingml.template");
        KNOWN_MIME_TYPES.put("dp", "application/vnd.osgi.dp");
        KNOWN_MIME_TYPES.put("dpg", "application/vnd.dpgraph");
        KNOWN_MIME_TYPES.put("dra", "audio/vnd.dra");
        KNOWN_MIME_TYPES.put("drw", "application/drafting");
        KNOWN_MIME_TYPES.put("dsc", "text/prs.lines.tag");
        KNOWN_MIME_TYPES.put("dssc", "application/dssc+der");
        KNOWN_MIME_TYPES.put("dtb", "application/x-dtbook+xml");
        KNOWN_MIME_TYPES.put("dtd", "application/xml-dtd");
        KNOWN_MIME_TYPES.put("dts", "audio/vnd.dts");
        KNOWN_MIME_TYPES.put("dtshd", "audio/vnd.dts.hd");
        KNOWN_MIME_TYPES.put("dump", DEFAULT_MIME_TYPE);
        KNOWN_MIME_TYPES.put("dv", "video/x-dv");
        KNOWN_MIME_TYPES.put("dvi", "application/x-dvi");
        KNOWN_MIME_TYPES.put("dwf", "model/vnd.dwf");
        KNOWN_MIME_TYPES.put("dwg", "image/vnd.dwg");
        KNOWN_MIME_TYPES.put("dxf", "image/vnd.dxf");
        KNOWN_MIME_TYPES.put("dxp", "application/vnd.spotfire.dxp");
        KNOWN_MIME_TYPES.put("dxr", "application/x-director");
        KNOWN_MIME_TYPES.put("ecelp4800", "audio/vnd.nuera.ecelp4800");
        KNOWN_MIME_TYPES.put("ecelp7470", "audio/vnd.nuera.ecelp7470");
        KNOWN_MIME_TYPES.put("ecelp9600", "audio/vnd.nuera.ecelp9600");
        KNOWN_MIME_TYPES.put("edm", "application/vnd.novadigm.edm");
        KNOWN_MIME_TYPES.put("edx", "application/vnd.novadigm.edx");
        KNOWN_MIME_TYPES.put("efif", "application/vnd.picsel");
        KNOWN_MIME_TYPES.put("ei6", "application/vnd.pg.osasli");
        KNOWN_MIME_TYPES.put("el", "text/x-script.elisp");
        KNOWN_MIME_TYPES.put("elc", "application/x-elc");
        KNOWN_MIME_TYPES.put("eml", "message/rfc822");
        KNOWN_MIME_TYPES.put("emma", "application/emma+xml");
        KNOWN_MIME_TYPES.put("env", "application/x-envoy");
        KNOWN_MIME_TYPES.put("eol", "audio/vnd.digital-winds");
        KNOWN_MIME_TYPES.put("eot", "application/vnd.ms-fontobject");
        KNOWN_MIME_TYPES.put("eps", "application/postscript");
        KNOWN_MIME_TYPES.put("epub", "application/epub+zip");
        KNOWN_MIME_TYPES.put("es", "application/ecmascript");
        KNOWN_MIME_TYPES.put("es3", "application/vnd.eszigno3+xml");
        KNOWN_MIME_TYPES.put("esf", "application/vnd.epson.esf");
        KNOWN_MIME_TYPES.put("etx", "text/x-setext");
        KNOWN_MIME_TYPES.put("evy", "application/envoy");
        KNOWN_MIME_TYPES.put("exe", DEFAULT_MIME_TYPE);
        KNOWN_MIME_TYPES.put("exi", "application/exi");
        KNOWN_MIME_TYPES.put("ext", "application/vnd.novadigm.ext");
        KNOWN_MIME_TYPES.put("ez2", "application/vnd.ezpix-album");
        KNOWN_MIME_TYPES.put("ez3", "application/vnd.ezpix-package");
        KNOWN_MIME_TYPES.put("f", "text/x-fortran");
        KNOWN_MIME_TYPES.put("f4v", "video/x-f4v");
        KNOWN_MIME_TYPES.put("f77", "text/x-fortran");
        KNOWN_MIME_TYPES.put("f90", "text/x-fortran");
        KNOWN_MIME_TYPES.put("fbs", "image/vnd.fastbidsheet");
        KNOWN_MIME_TYPES.put("fcs", "application/vnd.isac.fcs");
        KNOWN_MIME_TYPES.put("fdf", "application/vnd.fdf");
        KNOWN_MIME_TYPES.put("fe_launch", "application/vnd.denovo.fcselayout-link");
        KNOWN_MIME_TYPES.put("fg5", "application/vnd.fujitsu.oasysgp");
        KNOWN_MIME_TYPES.put("fh", "image/x-freehand");
        KNOWN_MIME_TYPES.put("fif", "image/fif");
        KNOWN_MIME_TYPES.put("fig", "application/x-xfig");
        KNOWN_MIME_TYPES.put("fli", "video/fli");
        KNOWN_MIME_TYPES.put("flo", "image/florian");
        KNOWN_MIME_TYPES.put("flv", "video/x-flv");
        KNOWN_MIME_TYPES.put("flw", "application/vnd.kde.kivio");
        KNOWN_MIME_TYPES.put("flx", "text/vnd.fmi.flexstor");
        KNOWN_MIME_TYPES.put("fly", "text/vnd.fly");
        KNOWN_MIME_TYPES.put("fm", "application/vnd.framemaker");
        KNOWN_MIME_TYPES.put("fmf", "video/x-atomic3d-feature");
        KNOWN_MIME_TYPES.put("fnc", "application/vnd.frogans.fnc");
        KNOWN_MIME_TYPES.put("for", "text/x-fortran");
        KNOWN_MIME_TYPES.put("fpx", "image/vnd.fpx");
        KNOWN_MIME_TYPES.put("frl", "application/freeloader");
        KNOWN_MIME_TYPES.put("fsc", "application/vnd.fsc.weblaunch");
        KNOWN_MIME_TYPES.put("fst", "image/vnd.fst");
        KNOWN_MIME_TYPES.put("ftc", "application/vnd.fluxtime.clip");
        KNOWN_MIME_TYPES.put("fti", "application/vnd.anser-web-funds-transfer-initiation");
        KNOWN_MIME_TYPES.put("funk", "audio/make");
        KNOWN_MIME_TYPES.put("fvt", "video/vnd.fvt");
        KNOWN_MIME_TYPES.put("fxp", "application/vnd.adobe.fxp");
        KNOWN_MIME_TYPES.put("fzs", "application/vnd.fuzzysheet");
        KNOWN_MIME_TYPES.put("g", "text/plain");
        KNOWN_MIME_TYPES.put("g2w", "application/vnd.geoplan");
        KNOWN_MIME_TYPES.put("g3", "image/g3fax");
        KNOWN_MIME_TYPES.put("g3w", "application/vnd.geospace");
        KNOWN_MIME_TYPES.put("gac", "application/vnd.groove-account");
        KNOWN_MIME_TYPES.put("gdl", "model/vnd.gdl");
        KNOWN_MIME_TYPES.put("geo", "application/vnd.dynageo");
        KNOWN_MIME_TYPES.put("gex", "application/vnd.geometry-explorer");
        KNOWN_MIME_TYPES.put("ggb", "application/vnd.geogebra.file");
        KNOWN_MIME_TYPES.put("ggt", "application/vnd.geogebra.tool");
        KNOWN_MIME_TYPES.put("ghf", "application/vnd.groove-help");
        KNOWN_MIME_TYPES.put("gif", "image/gif");
        KNOWN_MIME_TYPES.put("gim", "application/vnd.groove-identity-message");
        KNOWN_MIME_TYPES.put("gl", "video/gl");
        KNOWN_MIME_TYPES.put("gmx", "application/vnd.gmx");
        KNOWN_MIME_TYPES.put("gnumeric", "application/x-gnumeric");
        KNOWN_MIME_TYPES.put("gph", "application/vnd.flographit");
        KNOWN_MIME_TYPES.put("gqf", "application/vnd.grafeq");
        KNOWN_MIME_TYPES.put("gram", "application/srgs");
        KNOWN_MIME_TYPES.put("grv", "application/vnd.groove-injector");
        KNOWN_MIME_TYPES.put("grxml", "application/srgs+xml");
        KNOWN_MIME_TYPES.put("gsd", "audio/x-gsm");
        KNOWN_MIME_TYPES.put("gsf", "application/x-font-ghostscript");
        KNOWN_MIME_TYPES.put("gsm", "audio/x-gsm");
        KNOWN_MIME_TYPES.put("gsp", "application/x-gsp");
        KNOWN_MIME_TYPES.put("gss", "application/x-gss");
        KNOWN_MIME_TYPES.put("gtar", "application/x-gtar");
        KNOWN_MIME_TYPES.put("gtm", "application/vnd.groove-tool-message");
        KNOWN_MIME_TYPES.put("gtw", "model/vnd.gtw");
        KNOWN_MIME_TYPES.put("gv", "text/vnd.graphviz");
        KNOWN_MIME_TYPES.put("gxt", "application/vnd.geonext");
        KNOWN_MIME_TYPES.put("gz", "application/x-gzip");
        KNOWN_MIME_TYPES.put("gzip", "application/x-gzip");
        KNOWN_MIME_TYPES.put("h", "text/x-h");
        KNOWN_MIME_TYPES.put("h261", "video/h261");
        KNOWN_MIME_TYPES.put("h263", "video/h263");
        KNOWN_MIME_TYPES.put("h264", "video/h264");
        KNOWN_MIME_TYPES.put("hal", "application/vnd.hal+xml");
        KNOWN_MIME_TYPES.put("hbci", "application/vnd.hbci");
        KNOWN_MIME_TYPES.put("hdf", "application/x-hdf");
        KNOWN_MIME_TYPES.put("help", "application/x-helpfile");
        KNOWN_MIME_TYPES.put("hgl", "application/vnd.hp-hpgl");
        KNOWN_MIME_TYPES.put("hh", "text/x-h");
        KNOWN_MIME_TYPES.put("hlb", "text/x-script");
        KNOWN_MIME_TYPES.put("hlp", "application/hlp");
        KNOWN_MIME_TYPES.put("hpg", "application/vnd.hp-hpgl");
        KNOWN_MIME_TYPES.put("hpgl", "application/vnd.hp-hpgl");
        KNOWN_MIME_TYPES.put("hpid", "application/vnd.hp-hpid");
        KNOWN_MIME_TYPES.put("hps", "application/vnd.hp-hps");
        KNOWN_MIME_TYPES.put("hqx", "application/binhex");
        KNOWN_MIME_TYPES.put("hta", "application/hta");
        KNOWN_MIME_TYPES.put("htc", "text/x-component");
        KNOWN_MIME_TYPES.put("htke", "application/vnd.kenameaapp");
        KNOWN_MIME_TYPES.put("htm", "text/html");
        KNOWN_MIME_TYPES.put("html", "text/html");
        KNOWN_MIME_TYPES.put("htmls", "text/html");
        KNOWN_MIME_TYPES.put("htt", "text/webviewhtml");
        KNOWN_MIME_TYPES.put("htx", "text/html");
        KNOWN_MIME_TYPES.put("hvd", "application/vnd.yamaha.hv-dic");
        KNOWN_MIME_TYPES.put("hvp", "application/vnd.yamaha.hv-voice");
        KNOWN_MIME_TYPES.put("hvs", "application/vnd.yamaha.hv-script");
        KNOWN_MIME_TYPES.put("i2g", "application/vnd.intergeo");
        KNOWN_MIME_TYPES.put("icc", "application/vnd.iccprofile");
        KNOWN_MIME_TYPES.put("ice", "x-conference/x-cooltalk");
        KNOWN_MIME_TYPES.put("ico", "image/x-icon");
        KNOWN_MIME_TYPES.put("ics", "text/calendar");
        KNOWN_MIME_TYPES.put("idc", "text/plain");
        KNOWN_MIME_TYPES.put("ief", "image/ief");
        KNOWN_MIME_TYPES.put("iefs", "image/ief");
        KNOWN_MIME_TYPES.put("ifm", "application/vnd.shana.informed.formdata");
        KNOWN_MIME_TYPES.put("iges", "application/iges");
        KNOWN_MIME_TYPES.put("igl", "application/vnd.igloader");
        KNOWN_MIME_TYPES.put("igm", "application/vnd.insors.igm");
        KNOWN_MIME_TYPES.put("igs", "application/iges");
        KNOWN_MIME_TYPES.put("igx", "application/vnd.micrografx.igx");
        KNOWN_MIME_TYPES.put("iif", "application/vnd.shana.informed.interchange");
        KNOWN_MIME_TYPES.put("ima", "application/x-ima");
        KNOWN_MIME_TYPES.put("imap", "application/x-httpd-imap");
        KNOWN_MIME_TYPES.put("imp", "application/vnd.accpac.simply.imp");
        KNOWN_MIME_TYPES.put("ims", "application/vnd.ms-ims");
        KNOWN_MIME_TYPES.put("inf", "application/inf");
        KNOWN_MIME_TYPES.put("ins", "application/x-internett-signup");
        KNOWN_MIME_TYPES.put("ip", "application/x-ip2");
        KNOWN_MIME_TYPES.put("ipfix", "application/ipfix");
        KNOWN_MIME_TYPES.put("ipk", "application/vnd.shana.informed.package");
        KNOWN_MIME_TYPES.put("irm", "application/vnd.ibm.rights-management");
        KNOWN_MIME_TYPES.put("irp", "application/vnd.irepository.package+xml");
        KNOWN_MIME_TYPES.put("isu", "video/x-isvideo");
        KNOWN_MIME_TYPES.put("it", "audio/it");
        KNOWN_MIME_TYPES.put("itp", "application/vnd.shana.informed.formtemplate");
        KNOWN_MIME_TYPES.put("iv", "application/x-inventor");
        KNOWN_MIME_TYPES.put("ivp", "application/vnd.immervision-ivp");
        KNOWN_MIME_TYPES.put("ivr", "i-world/i-vrml");
        KNOWN_MIME_TYPES.put("ivu", "application/vnd.immervision-ivu");
        KNOWN_MIME_TYPES.put("ivy", "application/x-livescreen");
        KNOWN_MIME_TYPES.put("jad", "text/vnd.sun.j2me.app-descriptor");
        KNOWN_MIME_TYPES.put("jam", "audio/x-jam");
        KNOWN_MIME_TYPES.put("jar", "application/java-archive");
        KNOWN_MIME_TYPES.put("jav", "text/x-java-source");
        KNOWN_MIME_TYPES.put("java", "text/x-java-source");
        KNOWN_MIME_TYPES.put("jcm", "application/x-java-commerce");
        KNOWN_MIME_TYPES.put("jfif", "image/jpeg");
        KNOWN_MIME_TYPES.put("jfif-tbnl", "image/jpeg");
        KNOWN_MIME_TYPES.put("jisp", "application/vnd.jisp");
        KNOWN_MIME_TYPES.put("jlt", "application/vnd.hp-jlyt");
        KNOWN_MIME_TYPES.put("jnlp", "application/x-java-jnlp-file");
        KNOWN_MIME_TYPES.put("joda", "application/vnd.joost.joda-archive");
        KNOWN_MIME_TYPES.put("jpe", "image/jpeg");
        KNOWN_MIME_TYPES.put("jpeg", "image/jpeg");
        KNOWN_MIME_TYPES.put("jpg", "image/jpeg");
        KNOWN_MIME_TYPES.put("jpgv", "video/jpeg");
        KNOWN_MIME_TYPES.put("jpm", "video/jpm");
        KNOWN_MIME_TYPES.put("jps", "image/x-jps");
        KNOWN_MIME_TYPES.put("js", "text/javascript");
        KNOWN_MIME_TYPES.put("json", "application/json");
        KNOWN_MIME_TYPES.put("jut", "image/jutvision");
        KNOWN_MIME_TYPES.put("kar", "audio/midi");
        KNOWN_MIME_TYPES.put("karbon", "application/vnd.kde.karbon");
        KNOWN_MIME_TYPES.put("kfo", "application/vnd.kde.kformula");
        KNOWN_MIME_TYPES.put("kia", "application/vnd.kidspiration");
        KNOWN_MIME_TYPES.put("kml", "application/vnd.google-earth.kml+xml");
        KNOWN_MIME_TYPES.put("kmz", "application/vnd.google-earth.kmz");
        KNOWN_MIME_TYPES.put("kne", "application/vnd.kinar");
        KNOWN_MIME_TYPES.put("kon", "application/vnd.kde.kontour");
        KNOWN_MIME_TYPES.put("kpr", "application/vnd.kde.kpresenter");
        KNOWN_MIME_TYPES.put("ksh", "text/x-script.ksh");
        KNOWN_MIME_TYPES.put("ksp", "application/vnd.kde.kspread");
        KNOWN_MIME_TYPES.put("ktx", "image/ktx");
        KNOWN_MIME_TYPES.put("ktz", "application/vnd.kahootz");
        KNOWN_MIME_TYPES.put("kwd", "application/vnd.kde.kword");
        KNOWN_MIME_TYPES.put("la", "audio/nspaudio");
        KNOWN_MIME_TYPES.put("lam", "audio/x-liveaudio");
        KNOWN_MIME_TYPES.put("lasxml", "application/vnd.las.las+xml");
        KNOWN_MIME_TYPES.put("latex", "application/x-latex");
        KNOWN_MIME_TYPES.put("lbd", "application/vnd.llamagraphics.life-balance.desktop");
        KNOWN_MIME_TYPES.put("lbe", "application/vnd.llamagraphics.life-balance.exchange+xml");
        KNOWN_MIME_TYPES.put("les", "application/vnd.hhe.lesson-player");
        KNOWN_MIME_TYPES.put("lha", "application/lha");
        KNOWN_MIME_TYPES.put("lhx", DEFAULT_MIME_TYPE);
        KNOWN_MIME_TYPES.put("link66", "application/vnd.route66.link66+xml");
        KNOWN_MIME_TYPES.put("list", "text/plain");
        KNOWN_MIME_TYPES.put("lma", "audio/nspaudio");
        KNOWN_MIME_TYPES.put("log", "text/plain");
        KNOWN_MIME_TYPES.put("lrm", "application/vnd.ms-lrm");
        KNOWN_MIME_TYPES.put("lsp", "text/x-script.lisp");
        KNOWN_MIME_TYPES.put("lst", "text/plain");
        KNOWN_MIME_TYPES.put("lsx", "text/x-la-asf");
        KNOWN_MIME_TYPES.put("ltf", "application/vnd.frogans.ltf");
        KNOWN_MIME_TYPES.put("ltx", "application/x-latex");
        KNOWN_MIME_TYPES.put("lvp", "audio/vnd.lucent.voice");
        KNOWN_MIME_TYPES.put("lwp", "application/vnd.lotus-wordpro");
        KNOWN_MIME_TYPES.put("lzh", "application/x-lzh");
        KNOWN_MIME_TYPES.put("lzx", "application/lzx");
        KNOWN_MIME_TYPES.put("m", "text/x-m");
        KNOWN_MIME_TYPES.put("m1v", "video/mpeg");
        KNOWN_MIME_TYPES.put("m21", "application/mp21");
        KNOWN_MIME_TYPES.put("m2a", "audio/mpeg");
        KNOWN_MIME_TYPES.put("m2v", "video/mpeg");
        KNOWN_MIME_TYPES.put("m3u", "audio/x-mpegurl");
        KNOWN_MIME_TYPES.put("m3u8", "application/vnd.apple.mpegurl");
        KNOWN_MIME_TYPES.put("m4v", "video/x-m4v");
        KNOWN_MIME_TYPES.put("ma", "application/mathematica");
        KNOWN_MIME_TYPES.put("mads", "application/mads+xml");
        KNOWN_MIME_TYPES.put("mag", "application/vnd.ecowin.chart");
        KNOWN_MIME_TYPES.put("man", "application/x-troff-man");
        KNOWN_MIME_TYPES.put("map", "application/x-navimap");
        KNOWN_MIME_TYPES.put("mar", "text/plain");
        KNOWN_MIME_TYPES.put("mathml", "application/mathml+xml");
        KNOWN_MIME_TYPES.put("mbd", "application/mbedlet");
        KNOWN_MIME_TYPES.put("mbk", "application/vnd.mobius.mbk");
        KNOWN_MIME_TYPES.put("mbox", "application/mbox");
        KNOWN_MIME_TYPES.put("mc$", "application/x-magic-cap-package-1.0");
        KNOWN_MIME_TYPES.put("mc1", "application/vnd.medcalcdata");
        KNOWN_MIME_TYPES.put("mcd", "application/mcad");
        KNOWN_MIME_TYPES.put("mcf", "image/vasa");
        KNOWN_MIME_TYPES.put("mcp", "application/netmc");
        KNOWN_MIME_TYPES.put("mcurl", "text/vnd.curl.mcurl");
        KNOWN_MIME_TYPES.put("mdb", "application/x-msaccess");
        KNOWN_MIME_TYPES.put("mdi", "image/vnd.ms-modi");
        KNOWN_MIME_TYPES.put("me", "application/x-troff-me");
        KNOWN_MIME_TYPES.put("meta4", "application/metalink4+xml");
        KNOWN_MIME_TYPES.put("mets", "application/mets+xml");
        KNOWN_MIME_TYPES.put("mfm", "application/vnd.mfmp");
        KNOWN_MIME_TYPES.put("mgp", "application/vnd.osgeo.mapguide.package");
        KNOWN_MIME_TYPES.put("mgz", "application/vnd.proteus.magazine");
        KNOWN_MIME_TYPES.put("mht", "message/rfc822");
        KNOWN_MIME_TYPES.put("mhtml", "message/rfc822");
        KNOWN_MIME_TYPES.put("mid", "audio/midi");
        KNOWN_MIME_TYPES.put("midi", "audio/midi");
        KNOWN_MIME_TYPES.put("mif", "application/x-mif");
        KNOWN_MIME_TYPES.put("mime", "message/rfc822");
        KNOWN_MIME_TYPES.put("mj2", "video/mj2");
        KNOWN_MIME_TYPES.put("mjf", "audio/x-vnd.audioexplosion.mjuicemediafile");
        KNOWN_MIME_TYPES.put("mjpg", "video/x-motion-jpeg");
        KNOWN_MIME_TYPES.put("mlp", "application/vnd.dolby.mlp");
        KNOWN_MIME_TYPES.put("mm", "application/x-meme");
        KNOWN_MIME_TYPES.put("mmd", "application/vnd.chipnuts.karaoke-mmd");
        KNOWN_MIME_TYPES.put("mme", "application/base64");
        KNOWN_MIME_TYPES.put("mmf", "application/vnd.smaf");
        KNOWN_MIME_TYPES.put("mmr", "image/vnd.fujixerox.edmics-mmr");
        KNOWN_MIME_TYPES.put("mny", "application/x-msmoney");
        KNOWN_MIME_TYPES.put("mod", "audio/mod");
        KNOWN_MIME_TYPES.put("mods", "application/mods+xml");
        KNOWN_MIME_TYPES.put("moov", "video/quicktime");
        KNOWN_MIME_TYPES.put("mov", "video/quicktime");
        KNOWN_MIME_TYPES.put("movie", "video/x-sgi-movie");
        KNOWN_MIME_TYPES.put("mp2", "audio/mpeg");
        KNOWN_MIME_TYPES.put("mp3", "audio/mpeg3");
        KNOWN_MIME_TYPES.put("mp4", "video/mp4");
        KNOWN_MIME_TYPES.put("mp4a", "audio/mp4");
        KNOWN_MIME_TYPES.put("mpa", "audio/mpeg");
        KNOWN_MIME_TYPES.put("mpc", "application/vnd.mophun.certificate");
        KNOWN_MIME_TYPES.put("mpc", "application/x-project");
        KNOWN_MIME_TYPES.put("mpe", "video/mpeg");
        KNOWN_MIME_TYPES.put("mpeg", "video/mpeg");
        KNOWN_MIME_TYPES.put("mpg", "video/mpeg");
        KNOWN_MIME_TYPES.put("mpga", "audio/mpeg");
        KNOWN_MIME_TYPES.put("mpkg", "application/vnd.apple.installer+xml");
        KNOWN_MIME_TYPES.put("mpm", "application/vnd.blueice.multipass");
        KNOWN_MIME_TYPES.put("mpn", "application/vnd.mophun.application");
        KNOWN_MIME_TYPES.put("mpp", "application/vnd.ms-project");
        KNOWN_MIME_TYPES.put("mpt", "application/x-project");
        KNOWN_MIME_TYPES.put("mpv", "application/x-project");
        KNOWN_MIME_TYPES.put("mpx", "application/x-project");
        KNOWN_MIME_TYPES.put("mpy", "application/vnd.ibm.minipay");
        KNOWN_MIME_TYPES.put("mqy", "application/vnd.mobius.mqy");
        KNOWN_MIME_TYPES.put("mrc", "application/marc");
        KNOWN_MIME_TYPES.put("mrcx", "application/marcxml+xml");
        KNOWN_MIME_TYPES.put("ms", "application/x-troff-ms");
        KNOWN_MIME_TYPES.put("mscml", "application/mediaservercontrol+xml");
        KNOWN_MIME_TYPES.put("mseq", "application/vnd.mseq");
        KNOWN_MIME_TYPES.put("msf", "application/vnd.epson.msf");
        KNOWN_MIME_TYPES.put("msh", "model/mesh");
        KNOWN_MIME_TYPES.put("msl", "application/vnd.mobius.msl");
        KNOWN_MIME_TYPES.put("msty", "application/vnd.muvee.style");
        KNOWN_MIME_TYPES.put("mts", "model/vnd.mts");
        KNOWN_MIME_TYPES.put("mus", "application/vnd.musician");
        KNOWN_MIME_TYPES.put("musicxml", "application/vnd.recordare.musicxml+xml");
        KNOWN_MIME_TYPES.put("mv", "video/x-sgi-movie");
        KNOWN_MIME_TYPES.put("mvb", "application/x-msmediaview");
        KNOWN_MIME_TYPES.put("mwf", "application/vnd.mfer");
        KNOWN_MIME_TYPES.put("mxf", "application/mxf");
        KNOWN_MIME_TYPES.put("mxl", "application/vnd.recordare.musicxml");
        KNOWN_MIME_TYPES.put("mxml", "application/xv+xml");
        KNOWN_MIME_TYPES.put("mxs", "application/vnd.triscape.mxs");
        KNOWN_MIME_TYPES.put("mxu", "video/vnd.mpegurl");
        KNOWN_MIME_TYPES.put("my", "audio/make");
        KNOWN_MIME_TYPES.put("mzz", "application/x-vnd.audioexplosion.mzz");
        KNOWN_MIME_TYPES.put("n-gage", "application/vnd.nokia.n-gage.symbian.install");
        KNOWN_MIME_TYPES.put("n3", "text/n3");
        KNOWN_MIME_TYPES.put("nap", "image/naplps");
        KNOWN_MIME_TYPES.put("naplps", "image/naplps");
        KNOWN_MIME_TYPES.put("nbp", "application/vnd.wolfram.player");
        KNOWN_MIME_TYPES.put("nc", "application/x-netcdf");
        KNOWN_MIME_TYPES.put("ncm", "application/vnd.nokia.configuration-message");
        KNOWN_MIME_TYPES.put("ncx", "application/x-dtbncx+xml");
        KNOWN_MIME_TYPES.put("ngdat", "application/vnd.nokia.n-gage.data");
        KNOWN_MIME_TYPES.put("nif", "image/x-niff");
        KNOWN_MIME_TYPES.put("niff", "image/x-niff");
        KNOWN_MIME_TYPES.put("nix", "application/x-mix-transfer");
        KNOWN_MIME_TYPES.put("nlu", "application/vnd.neurolanguage.nlu");
        KNOWN_MIME_TYPES.put("nml", "application/vnd.enliven");
        KNOWN_MIME_TYPES.put("nnd", "application/vnd.noblenet-directory");
        KNOWN_MIME_TYPES.put("nns", "application/vnd.noblenet-sealer");
        KNOWN_MIME_TYPES.put("nnw", "application/vnd.noblenet-web");
        KNOWN_MIME_TYPES.put("npx", "image/vnd.net-fpx");
        KNOWN_MIME_TYPES.put("nsc", "application/x-conference");
        KNOWN_MIME_TYPES.put("nsf", "application/vnd.lotus-notes");
        KNOWN_MIME_TYPES.put("nvd", "application/x-navidoc");
        KNOWN_MIME_TYPES.put("o", DEFAULT_MIME_TYPE);
        KNOWN_MIME_TYPES.put("oa2", "application/vnd.fujitsu.oasys2");
        KNOWN_MIME_TYPES.put("oa3", "application/vnd.fujitsu.oasys3");
        KNOWN_MIME_TYPES.put("oas", "application/vnd.fujitsu.oasys");
        KNOWN_MIME_TYPES.put("obd", "application/x-msbinder");
        KNOWN_MIME_TYPES.put("oda", "application/oda");
        KNOWN_MIME_TYPES.put("odb", "application/vnd.oasis.opendocument.database");
        KNOWN_MIME_TYPES.put("odc", "application/vnd.oasis.opendocument.chart");
        KNOWN_MIME_TYPES.put("odf", "application/vnd.oasis.opendocument.formula");
        KNOWN_MIME_TYPES.put("odft", "application/vnd.oasis.opendocument.formula-template");
        KNOWN_MIME_TYPES.put("odg", "application/vnd.oasis.opendocument.graphics");
        KNOWN_MIME_TYPES.put("odi", "application/vnd.oasis.opendocument.image");
        KNOWN_MIME_TYPES.put("odm", "application/vnd.oasis.opendocument.text-master");
        KNOWN_MIME_TYPES.put("odp", "application/vnd.oasis.opendocument.presentation");
        KNOWN_MIME_TYPES.put("ods", "application/vnd.oasis.opendocument.spreadsheet");
        KNOWN_MIME_TYPES.put("odt", "application/vnd.oasis.opendocument.text");
        KNOWN_MIME_TYPES.put("oga", "audio/ogg");
        KNOWN_MIME_TYPES.put("ogv", "video/ogg");
        KNOWN_MIME_TYPES.put("ogx", "application/ogg");
        KNOWN_MIME_TYPES.put("omc", "application/x-omc");
        KNOWN_MIME_TYPES.put("omcd", "application/x-omcdatamaker");
        KNOWN_MIME_TYPES.put("omcr", "application/x-omcregerator");
        KNOWN_MIME_TYPES.put("onetoc", "application/onenote");
        KNOWN_MIME_TYPES.put("opf", "application/oebps-package+xml");
        KNOWN_MIME_TYPES.put("org", "application/vnd.lotus-organizer");
        KNOWN_MIME_TYPES.put("osf", "application/vnd.yamaha.openscoreformat");
        KNOWN_MIME_TYPES.put("osfpvg", "application/vnd.yamaha.openscoreformat.osfpvg+xml");
        KNOWN_MIME_TYPES.put("otc", "application/vnd.oasis.opendocument.chart-template");
        KNOWN_MIME_TYPES.put("otf", "application/x-font-otf");
        KNOWN_MIME_TYPES.put("otg", "application/vnd.oasis.opendocument.graphics-template");
        KNOWN_MIME_TYPES.put("oth", "application/vnd.oasis.opendocument.text-web");
        KNOWN_MIME_TYPES.put("oti", "application/vnd.oasis.opendocument.image-template");
        KNOWN_MIME_TYPES.put("otp", "application/vnd.oasis.opendocument.presentation-template");
        KNOWN_MIME_TYPES.put("ots", "application/vnd.oasis.opendocument.spreadsheet-template");
        KNOWN_MIME_TYPES.put("ott", "application/vnd.oasis.opendocument.text-template");
        KNOWN_MIME_TYPES.put("oxt", "application/vnd.openofficeorg.extension");
        KNOWN_MIME_TYPES.put("p", "text/x-pascal");
        KNOWN_MIME_TYPES.put("p10", "application/pkcs10");
        KNOWN_MIME_TYPES.put("p12", "application/pkcs-12");
        KNOWN_MIME_TYPES.put("p7a", "application/x-pkcs7-signature");
        KNOWN_MIME_TYPES.put("p7b", "application/x-pkcs7-certificates");
        KNOWN_MIME_TYPES.put("p7c", "application/pkcs7-mime");
        KNOWN_MIME_TYPES.put("p7m", "application/pkcs7-mime");
        KNOWN_MIME_TYPES.put("p7r", "application/x-pkcs7-certreqresp");
        KNOWN_MIME_TYPES.put("p7s", "application/pkcs7-signature");
        KNOWN_MIME_TYPES.put("p8", "application/pkcs8");
        KNOWN_MIME_TYPES.put("par", "text/plain-bas");
        KNOWN_MIME_TYPES.put("part", "application/pro_eng");
        KNOWN_MIME_TYPES.put("pas", "text/pascal");
        KNOWN_MIME_TYPES.put("paw", "application/vnd.pawaafile");
        KNOWN_MIME_TYPES.put("pbd", "application/vnd.powerbuilder6");
        KNOWN_MIME_TYPES.put("pbm", "image/x-portable-bitmap");
        KNOWN_MIME_TYPES.put("pcf", "application/x-font-pcf");
        KNOWN_MIME_TYPES.put("pcl", "application/x-pcl");
        KNOWN_MIME_TYPES.put("pclxl", "application/vnd.hp-pclxl");
        KNOWN_MIME_TYPES.put("pct", "image/x-pict");
        KNOWN_MIME_TYPES.put("pcurl", "application/vnd.curl.pcurl");
        KNOWN_MIME_TYPES.put("pcx", "image/x-pcx");
        KNOWN_MIME_TYPES.put("pdb", "application/vnd.palm");
        KNOWN_MIME_TYPES.put("pdf", "application/pdf");
        KNOWN_MIME_TYPES.put("pfa", "application/x-font-type1");
        KNOWN_MIME_TYPES.put("pfr", "application/font-tdpfr");
        KNOWN_MIME_TYPES.put("pfunk", "audio/make");
        KNOWN_MIME_TYPES.put("pgm", "image/x-portable-greymap");
        KNOWN_MIME_TYPES.put("pgn", "application/x-chess-pgn");
        KNOWN_MIME_TYPES.put("pgp", "application/pgp-signature");
        KNOWN_MIME_TYPES.put("pic", "image/pict");
        KNOWN_MIME_TYPES.put("pict", "image/pict");
        KNOWN_MIME_TYPES.put("pkg", "application/x-newton-compatible-pkg");
        KNOWN_MIME_TYPES.put("pki", "application/pkixcmp");
        KNOWN_MIME_TYPES.put("pkipath", "application/pkix-pkipath");
        KNOWN_MIME_TYPES.put("pko", "application/vnd.ms-pki.pko");
        KNOWN_MIME_TYPES.put("pl", "text/x-script.perl");
        KNOWN_MIME_TYPES.put("plb", "application/vnd.3gpp.pic-bw-large");
        KNOWN_MIME_TYPES.put("plc", "application/vnd.mobius.plc");
        KNOWN_MIME_TYPES.put("plf", "application/vnd.pocketlearn");
        KNOWN_MIME_TYPES.put("pls", "application/pls+xml");
        KNOWN_MIME_TYPES.put("plx", "application/x-pixclscript");
        KNOWN_MIME_TYPES.put("pm", "text/x-script.perl-module");
        KNOWN_MIME_TYPES.put("pm4", "application/x-pagemaker");
        KNOWN_MIME_TYPES.put("pm5", "application/x-pagemaker");
        KNOWN_MIME_TYPES.put("pml", "application/vnd.ctc-posml");
        KNOWN_MIME_TYPES.put("png", "image/png");
        KNOWN_MIME_TYPES.put("pnm", "image/x-portable-anymap");
        KNOWN_MIME_TYPES.put("portpkg", "application/vnd.macports.portpkg");
        KNOWN_MIME_TYPES.put("pot", "application/vnd.ms-powerpoint");
        KNOWN_MIME_TYPES.put("potm", "application/vnd.ms-powerpoint.template.macroenabled.12");
        KNOWN_MIME_TYPES.put("potx", "application/vnd.openxmlformats-officedocument.presentationml.template");
        KNOWN_MIME_TYPES.put("pov", "model/x-pov");
        KNOWN_MIME_TYPES.put("ppa", "application/vnd.ms-powerpoint");
        KNOWN_MIME_TYPES.put("ppam", "application/vnd.ms-powerpoint.addin.macroenabled.12");
        KNOWN_MIME_TYPES.put("ppd", "application/vnd.cups-ppd");
        KNOWN_MIME_TYPES.put("ppm", "image/x-portable-pixmap");
        KNOWN_MIME_TYPES.put("pps", "application/vnd.ms-powerpoint");
        KNOWN_MIME_TYPES.put("ppsm", "application/vnd.ms-powerpoint.slideshow.macroenabled.12");
        KNOWN_MIME_TYPES.put("ppsx", "application/vnd.openxmlformats-officedocument.presentationml.slideshow");
        KNOWN_MIME_TYPES.put("ppt", "application/vnd.ms-powerpoint");
        KNOWN_MIME_TYPES.put("pptm", "application/vnd.ms-powerpoint.presentation.macroenabled.12");
        KNOWN_MIME_TYPES.put("pptx", "application/vnd.openxmlformats-officedocument.presentationml.presentation");
        KNOWN_MIME_TYPES.put("ppz", "application/mspowerpoint");
        KNOWN_MIME_TYPES.put("prc", "application/x-mobipocket-ebook");
        KNOWN_MIME_TYPES.put("pre", "application/vnd.lotus-freelance");
        KNOWN_MIME_TYPES.put("prf", "application/pics-rules");
        KNOWN_MIME_TYPES.put("prt", "application/pro_eng");
        KNOWN_MIME_TYPES.put("ps", "application/postscript");
        KNOWN_MIME_TYPES.put("psb", "application/vnd.3gpp.pic-bw-small");
        KNOWN_MIME_TYPES.put("psd", "image/vnd.adobe.photoshop");
        KNOWN_MIME_TYPES.put("psf", "application/x-font-linux-psf");
        KNOWN_MIME_TYPES.put("pskcxml", "application/pskc+xml");
        KNOWN_MIME_TYPES.put("ptid", "application/vnd.pvi.ptid1");
        KNOWN_MIME_TYPES.put("pub", "application/x-mspublisher");
        KNOWN_MIME_TYPES.put("pvb", "application/vnd.3gpp.pic-bw-var");
        KNOWN_MIME_TYPES.put("pvu", "paleovu/x-pv");
        KNOWN_MIME_TYPES.put("pwn", "application/vnd.3m.post-it-notes");
        KNOWN_MIME_TYPES.put("pwz", "application/vnd.ms-powerpoint");
        KNOWN_MIME_TYPES.put("py", "text/x-script.phyton");
        KNOWN_MIME_TYPES.put("pya", "audio/vnd.ms-playready.media.pya");
        KNOWN_MIME_TYPES.put("pyc", "application/x-bytecode.python");
        KNOWN_MIME_TYPES.put("pyv", "video/vnd.ms-playready.media.pyv");
        KNOWN_MIME_TYPES.put("qam", "application/vnd.epson.quickanime");
        KNOWN_MIME_TYPES.put("qbo", "application/vnd.intu.qbo");
        KNOWN_MIME_TYPES.put("qcp", "audio/vnd.qcelp");
        KNOWN_MIME_TYPES.put("qd3", "x-world/x-3dmf");
        KNOWN_MIME_TYPES.put("qd3d", "x-world/x-3dmf");
        KNOWN_MIME_TYPES.put("qfx", "application/vnd.intu.qfx");
        KNOWN_MIME_TYPES.put("qif", "image/x-quicktime");
        KNOWN_MIME_TYPES.put("qps", "application/vnd.publishare-delta-tree");
        KNOWN_MIME_TYPES.put("qt", "video/quicktime");
        KNOWN_MIME_TYPES.put("qtc", "video/x-qtc");
        KNOWN_MIME_TYPES.put("qti", "image/x-quicktime");
        KNOWN_MIME_TYPES.put("qtif", "image/x-quicktime");
        KNOWN_MIME_TYPES.put("qxd", "application/vnd.quark.quarkxpress");
        KNOWN_MIME_TYPES.put("ra", "audio/x-realaudio");
        KNOWN_MIME_TYPES.put("ram", "audio/x-pn-realaudio");
        KNOWN_MIME_TYPES.put("rar", "application/x-rar-compressed");
        KNOWN_MIME_TYPES.put("ras", "image/x-cmu-raster");
        KNOWN_MIME_TYPES.put("rast", "image/cmu-raster");
        KNOWN_MIME_TYPES.put("rcprofile", "application/vnd.ipunplugged.rcprofile");
        KNOWN_MIME_TYPES.put("rdf", "application/rdf+xml");
        KNOWN_MIME_TYPES.put("rdz", "application/vnd.data-vision.rdz");
        KNOWN_MIME_TYPES.put("rep", "application/vnd.businessobjects");
        KNOWN_MIME_TYPES.put("res", "application/x-dtbresource+xml");
        KNOWN_MIME_TYPES.put("rexx", "text/x-script.rexx");
        KNOWN_MIME_TYPES.put("rf", "image/vnd.rn-realflash");
        KNOWN_MIME_TYPES.put("rgb", "image/x-rgb");
        KNOWN_MIME_TYPES.put("rif", "application/reginfo+xml");
        KNOWN_MIME_TYPES.put("rip", "audio/vnd.rip");
        KNOWN_MIME_TYPES.put("rl", "application/resource-lists+xml");
        KNOWN_MIME_TYPES.put("rlc", "image/vnd.fujixerox.edmics-rlc");
        KNOWN_MIME_TYPES.put("rld", "application/resource-lists-diff+xml");
        KNOWN_MIME_TYPES.put("rm", "audio/x-pn-realaudio");
        KNOWN_MIME_TYPES.put("rmi", "audio/mid");
        KNOWN_MIME_TYPES.put("rmm", "audio/x-pn-realaudio");
        KNOWN_MIME_TYPES.put("rmp", "audio/x-pn-realaudio-plugin");
        KNOWN_MIME_TYPES.put("rms", "application/vnd.jcp.javame.midlet-rms");
        KNOWN_MIME_TYPES.put("rnc", "application/relax-ng-compact-syntax");
        KNOWN_MIME_TYPES.put("rng", "application/ringing-tones");
        KNOWN_MIME_TYPES.put("rnx", "application/vnd.rn-realplayer");
        KNOWN_MIME_TYPES.put("roff", "application/x-troff");
        KNOWN_MIME_TYPES.put("rp", "image/vnd.rn-realpix");
        KNOWN_MIME_TYPES.put("rp9", "application/vnd.cloanto.rp9");
        KNOWN_MIME_TYPES.put("rpm", "audio/x-pn-realaudio-plugin");
        KNOWN_MIME_TYPES.put("rpss", "application/vnd.nokia.radio-presets");
        KNOWN_MIME_TYPES.put("rpst", "application/vnd.nokia.radio-preset");
        KNOWN_MIME_TYPES.put("rq", "application/sparql-query");
        KNOWN_MIME_TYPES.put("rs", "application/rls-services+xml");
        KNOWN_MIME_TYPES.put("rsd", "application/rsd+xml");
        KNOWN_MIME_TYPES.put("rss", "application/rss+xml");
        KNOWN_MIME_TYPES.put("rt", "text/richtext");
        KNOWN_MIME_TYPES.put("rtf", "application/rtf");
        KNOWN_MIME_TYPES.put("rtx", "text/richtext");
        KNOWN_MIME_TYPES.put("rv", "video/vnd.rn-realvideo");
        KNOWN_MIME_TYPES.put("s", "text/x-asm");
        KNOWN_MIME_TYPES.put("s3m", "audio/s3m");
        KNOWN_MIME_TYPES.put("saf", "application/vnd.yamaha.smaf-audio");
        KNOWN_MIME_TYPES.put("saveme", DEFAULT_MIME_TYPE);
        KNOWN_MIME_TYPES.put("sbk", "application/x-tbook");
        KNOWN_MIME_TYPES.put("sbml", "application/sbml+xml");
        KNOWN_MIME_TYPES.put("sc", "application/vnd.ibm.secure-container");
        KNOWN_MIME_TYPES.put("scd", "application/x-msschedule");
        KNOWN_MIME_TYPES.put("scm", "application/x-lotusscreencam");
        KNOWN_MIME_TYPES.put("scq", "application/scvp-cv-request");
        KNOWN_MIME_TYPES.put("scs", "application/scvp-cv-response");
        KNOWN_MIME_TYPES.put("scurl", "text/vnd.curl.scurl");
        KNOWN_MIME_TYPES.put("sda", "application/vnd.stardivision.draw");
        KNOWN_MIME_TYPES.put("sdc", "application/vnd.stardivision.calc");
        KNOWN_MIME_TYPES.put("sdd", "application/vnd.stardivision.impress");
        KNOWN_MIME_TYPES.put("sdkm", "application/vnd.solent.sdkm+xml");
        KNOWN_MIME_TYPES.put("sdml", "text/plain");
        KNOWN_MIME_TYPES.put("sdp", "application/sdp");
        KNOWN_MIME_TYPES.put("sdr", "application/sounder");
        KNOWN_MIME_TYPES.put("sdw", "application/vnd.stardivision.writer");
        KNOWN_MIME_TYPES.put("sea", "application/sea");
        KNOWN_MIME_TYPES.put("see", "application/vnd.seemail");
        KNOWN_MIME_TYPES.put("seed", "application/vnd.fdsn.seed");
        KNOWN_MIME_TYPES.put("sema", "application/vnd.sema");
        KNOWN_MIME_TYPES.put("semd", "application/vnd.semd");
        KNOWN_MIME_TYPES.put("semf", "application/vnd.semf");
        KNOWN_MIME_TYPES.put("ser", "application/java-serialized-object");
        KNOWN_MIME_TYPES.put("set", "application/set");
        KNOWN_MIME_TYPES.put("setpay", "application/set-payment-initiation");
        KNOWN_MIME_TYPES.put("setreg", "application/set-registration-initiation");
        KNOWN_MIME_TYPES.put("sfd-hdstx", "application/vnd.hydrostatix.sof-data");
        KNOWN_MIME_TYPES.put("sfs", "application/vnd.spotfire.sfs");
        KNOWN_MIME_TYPES.put("sgl", "application/vnd.stardivision.writer-global");
        KNOWN_MIME_TYPES.put("sgm", "text/sgml");
        KNOWN_MIME_TYPES.put("sgml", "text/sgml");
        KNOWN_MIME_TYPES.put("sh", "text/x-script.sh");
        KNOWN_MIME_TYPES.put("shar", "application/x-shar");
        KNOWN_MIME_TYPES.put("shf", "application/shf+xml");
        KNOWN_MIME_TYPES.put("shtml", "text/html");
        KNOWN_MIME_TYPES.put("sid", "audio/x-psid");
        KNOWN_MIME_TYPES.put("sis", "application/vnd.symbian.install");
        KNOWN_MIME_TYPES.put("sit", "application/x-stuffit");
        KNOWN_MIME_TYPES.put("sitx", "application/x-stuffitx");
        KNOWN_MIME_TYPES.put("skd", "application/x-koan");
        KNOWN_MIME_TYPES.put("skm", "application/x-koan");
        KNOWN_MIME_TYPES.put("skp", "application/x-koan");
        KNOWN_MIME_TYPES.put("skt", "application/x-koan");
        KNOWN_MIME_TYPES.put("sl", "application/x-seelogo");
        KNOWN_MIME_TYPES.put("sldm", "application/vnd.ms-powerpoint.slide.macroenabled.12");
        KNOWN_MIME_TYPES.put("sldx", "application/vnd.openxmlformats-officedocument.presentationml.slide");
        KNOWN_MIME_TYPES.put("slt", "application/vnd.epson.salt");
        KNOWN_MIME_TYPES.put("sm", "application/vnd.stepmania.stepchart");
        KNOWN_MIME_TYPES.put("smi", "application/smil+xml");
        KNOWN_MIME_TYPES.put("smil", "application/smil");
        KNOWN_MIME_TYPES.put("snd", "audio/basic");
        KNOWN_MIME_TYPES.put("snf", "application/x-font-snf");
        KNOWN_MIME_TYPES.put("sol", "application/solids");
        KNOWN_MIME_TYPES.put("spc", "text/x-speech");
        KNOWN_MIME_TYPES.put("spf", "application/vnd.yamaha.smaf-phrase");
        KNOWN_MIME_TYPES.put("spl", "application/futuresplash");
        KNOWN_MIME_TYPES.put("spot", "text/vnd.in3d.spot");
        KNOWN_MIME_TYPES.put("spp", "application/scvp-vp-response");
        KNOWN_MIME_TYPES.put("spq", "application/scvp-vp-request");
        KNOWN_MIME_TYPES.put("spr", "application/x-sprite");
        KNOWN_MIME_TYPES.put("sprite", "application/x-sprite");
        KNOWN_MIME_TYPES.put("src", "application/x-wais-source");
        KNOWN_MIME_TYPES.put("sru", "application/sru+xml");
        KNOWN_MIME_TYPES.put("srx", "application/sparql-results+xml");
        KNOWN_MIME_TYPES.put("sse", "application/vnd.kodak-descriptor");
        KNOWN_MIME_TYPES.put("ssf", "application/vnd.epson.ssf");
        KNOWN_MIME_TYPES.put("ssi", "text/x-server-parsed-html");
        KNOWN_MIME_TYPES.put("ssm", "application/streamingmedia");
        KNOWN_MIME_TYPES.put("ssml", "application/ssml+xml");
        KNOWN_MIME_TYPES.put("sst", "application/vnd.ms-pki.certstore");
        KNOWN_MIME_TYPES.put("st", "application/vnd.sailingtracker.track");
        KNOWN_MIME_TYPES.put("stc", "application/vnd.sun.xml.calc.template");
        KNOWN_MIME_TYPES.put("std", "application/vnd.sun.xml.draw.template");
        KNOWN_MIME_TYPES.put("step", "application/step");
        KNOWN_MIME_TYPES.put("stf", "application/vnd.wt.stf");
        KNOWN_MIME_TYPES.put("sti", "application/vnd.sun.xml.impress.template");
        KNOWN_MIME_TYPES.put("stk", "application/hyperstudio");
        KNOWN_MIME_TYPES.put("stl", "application/sla");
        KNOWN_MIME_TYPES.put("stp", "application/step");
        KNOWN_MIME_TYPES.put("str", "application/vnd.pg.format");
        KNOWN_MIME_TYPES.put("stw", "application/vnd.sun.xml.writer.template");
        KNOWN_MIME_TYPES.put("sub", "image/vnd.dvb.subtitle");
        KNOWN_MIME_TYPES.put("sus", "application/vnd.sus-calendar");
        KNOWN_MIME_TYPES.put("sv4cpio", "application/x-sv4cpio");
        KNOWN_MIME_TYPES.put("sv4crc", "application/x-sv4crc");
        KNOWN_MIME_TYPES.put("svc", "application/vnd.dvb.service");
        KNOWN_MIME_TYPES.put("svd", "application/vnd.svd");
        KNOWN_MIME_TYPES.put("svf", "image/x-dwg");
        KNOWN_MIME_TYPES.put("svg", "image/svg+xml");
        KNOWN_MIME_TYPES.put("svr", "application/x-world");
        KNOWN_MIME_TYPES.put("swf", "application/x-shockwave-flash");
        KNOWN_MIME_TYPES.put("swi", "application/vnd.aristanetworks.swi");
        KNOWN_MIME_TYPES.put("sxc", "application/vnd.sun.xml.calc");
        KNOWN_MIME_TYPES.put("sxd", "application/vnd.sun.xml.draw");
        KNOWN_MIME_TYPES.put("sxg", "application/vnd.sun.xml.writer.global");
        KNOWN_MIME_TYPES.put("sxi", "application/vnd.sun.xml.impress");
        KNOWN_MIME_TYPES.put("sxm", "application/vnd.sun.xml.math");
        KNOWN_MIME_TYPES.put("sxw", "application/vnd.sun.xml.writer");
        KNOWN_MIME_TYPES.put("t", "text/troff");
        KNOWN_MIME_TYPES.put("talk", "text/x-speech");
        KNOWN_MIME_TYPES.put("tao", "application/vnd.tao.intent-module-archive");
        KNOWN_MIME_TYPES.put("tar", "application/x-tar");
        KNOWN_MIME_TYPES.put("tbk", "application/toolbook");
        KNOWN_MIME_TYPES.put("tcap", "application/vnd.3gpp2.tcap");
        KNOWN_MIME_TYPES.put("tcl", "text/x-script.tcl");
        KNOWN_MIME_TYPES.put("tcsh", "text/x-script.tcsh");
        KNOWN_MIME_TYPES.put("teacher", "application/vnd.smart.teacher");
        KNOWN_MIME_TYPES.put("tei", "application/tei+xml");
        KNOWN_MIME_TYPES.put("tex", "application/x-tex");
        KNOWN_MIME_TYPES.put("texi", "application/x-texinfo");
        KNOWN_MIME_TYPES.put("texinfo", "application/x-texinfo");
        KNOWN_MIME_TYPES.put("text", "text/plain");
        KNOWN_MIME_TYPES.put("tfi", "application/thraud+xml");
        KNOWN_MIME_TYPES.put("tfm", "application/x-tex-tfm");
        KNOWN_MIME_TYPES.put("tgz", "application/x-compressed");
        KNOWN_MIME_TYPES.put("thmx", "application/vnd.ms-officetheme");
        KNOWN_MIME_TYPES.put("tif", "image/tiff");
        KNOWN_MIME_TYPES.put("tiff", "image/tiff");
        KNOWN_MIME_TYPES.put("tmo", "application/vnd.tmobile-livetv");
        KNOWN_MIME_TYPES.put("torrent", "application/x-bittorrent");
        KNOWN_MIME_TYPES.put("tpl", "application/vnd.groove-tool-template");
        KNOWN_MIME_TYPES.put("tpt", "application/vnd.trid.tpt");
        KNOWN_MIME_TYPES.put("tr", "application/x-troff");
        KNOWN_MIME_TYPES.put("tra", "application/vnd.trueapp");
        KNOWN_MIME_TYPES.put("trm", "application/x-msterminal");
        KNOWN_MIME_TYPES.put("tsd", "application/timestamped-data");
        KNOWN_MIME_TYPES.put("tsi", "audio/tsp-audio");
        KNOWN_MIME_TYPES.put("tsp", "audio/tsplayer");
        KNOWN_MIME_TYPES.put("tsv", "text/tab-separated-values");
        KNOWN_MIME_TYPES.put("ttf", "application/x-font-ttf");
        KNOWN_MIME_TYPES.put("ttl", "text/turtle");
        KNOWN_MIME_TYPES.put("turbot", "image/florian");
        KNOWN_MIME_TYPES.put("twd", "application/vnd.simtech-mindmapper");
        KNOWN_MIME_TYPES.put("txd", "application/vnd.genomatix.tuxedo");
        KNOWN_MIME_TYPES.put("txf", "application/vnd.mobius.txf");
        KNOWN_MIME_TYPES.put("txt", "text/plain");
        KNOWN_MIME_TYPES.put("ufd", "application/vnd.ufdl");
        KNOWN_MIME_TYPES.put("uil", "text/x-uil");
        KNOWN_MIME_TYPES.put("umj", "application/vnd.umajin");
        KNOWN_MIME_TYPES.put("uni", "text/uri-list");
        KNOWN_MIME_TYPES.put("unis", "text/uri-list");
        KNOWN_MIME_TYPES.put("unityweb", "application/vnd.unity");
        KNOWN_MIME_TYPES.put("unv", "application/i-deas");
        KNOWN_MIME_TYPES.put("uoml", "application/vnd.uoml+xml");
        KNOWN_MIME_TYPES.put("uri", "text/uri-list");
        KNOWN_MIME_TYPES.put("uris", "text/uri-list");
        KNOWN_MIME_TYPES.put("ustar", "application/x-ustar");
        KNOWN_MIME_TYPES.put("utz", "application/vnd.uiq.theme");
        KNOWN_MIME_TYPES.put("uu", "text/x-uuencode");
        KNOWN_MIME_TYPES.put("uue", "text/x-uuencode");
        KNOWN_MIME_TYPES.put("uva", "audio/vnd.dece.audio");
        KNOWN_MIME_TYPES.put("uvh", "video/vnd.dece.hd");
        KNOWN_MIME_TYPES.put("uvi", "image/vnd.dece.graphic");
        KNOWN_MIME_TYPES.put("uvm", "video/vnd.dece.mobile");
        KNOWN_MIME_TYPES.put("uvp", "video/vnd.dece.pd");
        KNOWN_MIME_TYPES.put("uvs", "video/vnd.dece.sd");
        KNOWN_MIME_TYPES.put("uvu", "video/vnd.uvvu.mp4");
        KNOWN_MIME_TYPES.put("uvv", "video/vnd.dece.video");
        KNOWN_MIME_TYPES.put("vcd", "application/x-cdlink");
        KNOWN_MIME_TYPES.put("vcf", "text/x-vcard");
        KNOWN_MIME_TYPES.put("vcg", "application/vnd.groove-vcard");
        KNOWN_MIME_TYPES.put("vcs", "text/x-vcalendar");
        KNOWN_MIME_TYPES.put("vcx", "application/vnd.vcx");
        KNOWN_MIME_TYPES.put("vda", "application/vda");
        KNOWN_MIME_TYPES.put("vdo", "video/vdo");
        KNOWN_MIME_TYPES.put("vew", "application/groupwise");
        KNOWN_MIME_TYPES.put("vis", "application/vnd.visionary");
        KNOWN_MIME_TYPES.put("viv", "video/vivo");
        KNOWN_MIME_TYPES.put("vivo", "video/vivo");
        KNOWN_MIME_TYPES.put("vmd", "application/vocaltec-media-desc");
        KNOWN_MIME_TYPES.put("vmf", "application/vocaltec-media-file");
        KNOWN_MIME_TYPES.put("voc", "audio/voc");
        KNOWN_MIME_TYPES.put("vos", "video/vosaic");
        KNOWN_MIME_TYPES.put("vox", "audio/voxware");
        KNOWN_MIME_TYPES.put("vqe", "audio/x-twinvq-plugin");
        KNOWN_MIME_TYPES.put("vqf", "audio/x-twinvq");
        KNOWN_MIME_TYPES.put("vql", "audio/x-twinvq-plugin");
        KNOWN_MIME_TYPES.put("vrml", "application/x-vrml");
        KNOWN_MIME_TYPES.put("vrt", "x-world/x-vrt");
        KNOWN_MIME_TYPES.put("vsd", "application/x-visio");
        KNOWN_MIME_TYPES.put("vsf", "application/vnd.vsf");
        KNOWN_MIME_TYPES.put("vst", "application/x-visio");
        KNOWN_MIME_TYPES.put("vsw", "application/x-visio");
        KNOWN_MIME_TYPES.put("vtu", "model/vnd.vtu");
        KNOWN_MIME_TYPES.put("vxml", "application/voicexml+xml");
        KNOWN_MIME_TYPES.put("w60", "application/wordperfect6.0");
        KNOWN_MIME_TYPES.put("w61", "application/wordperfect6.1");
        KNOWN_MIME_TYPES.put("w6w", "application/msword");
        KNOWN_MIME_TYPES.put("wad", "application/x-doom");
        KNOWN_MIME_TYPES.put("wav", "audio/wav");
        KNOWN_MIME_TYPES.put("wax", "audio/x-ms-wax");
        KNOWN_MIME_TYPES.put("wb1", "application/x-qpro");
        KNOWN_MIME_TYPES.put("wbmp", "image/vnd.wap.wbmp");
        KNOWN_MIME_TYPES.put("wbs", "application/vnd.criticaltools.wbs+xml");
        KNOWN_MIME_TYPES.put("wbxml", "application/vnd.wap.wbxml");
        KNOWN_MIME_TYPES.put("web", "application/vnd.xara");
        KNOWN_MIME_TYPES.put("weba", "audio/webm");
        KNOWN_MIME_TYPES.put("webm", "video/webm");
        KNOWN_MIME_TYPES.put("webp", "image/webp");
        KNOWN_MIME_TYPES.put("wg", "application/vnd.pmi.widget");
        KNOWN_MIME_TYPES.put("wgt", "application/widget");
        KNOWN_MIME_TYPES.put("wiz", "application/msword");
        KNOWN_MIME_TYPES.put("wk1", "application/x-123");
        KNOWN_MIME_TYPES.put("wm", "video/x-ms-wm");
        KNOWN_MIME_TYPES.put("wma", "audio/x-ms-wma");
        KNOWN_MIME_TYPES.put("wmd", "application/x-ms-wmd");
        KNOWN_MIME_TYPES.put("wmf", "application/x-msmetafile");
        KNOWN_MIME_TYPES.put("wml", "text/vnd.wap.wml");
        KNOWN_MIME_TYPES.put("wmlc", "application/vnd.wap.wmlc");
        KNOWN_MIME_TYPES.put("wmls", "text/vnd.wap.wmlscript");
        KNOWN_MIME_TYPES.put("wmlsc", "application/vnd.wap.wmlscriptc");
        KNOWN_MIME_TYPES.put("wmv", "video/x-ms-wmv");
        KNOWN_MIME_TYPES.put("wmx", "video/x-ms-wmx");
        KNOWN_MIME_TYPES.put("wmz", "application/x-ms-wmz");
        KNOWN_MIME_TYPES.put("woff", "application/x-font-woff");
        KNOWN_MIME_TYPES.put("word", "application/msword");
        KNOWN_MIME_TYPES.put("wp", "application/wordperfect");
        KNOWN_MIME_TYPES.put("wp5", "application/wordperfect");
        KNOWN_MIME_TYPES.put("wp6", "application/wordperfect");
        KNOWN_MIME_TYPES.put("wpd", "application/wordperfect");
        KNOWN_MIME_TYPES.put("wpl", "application/vnd.ms-wpl");
        KNOWN_MIME_TYPES.put("wps", "application/vnd.ms-works");
        KNOWN_MIME_TYPES.put("wq1", "application/x-lotus");
        KNOWN_MIME_TYPES.put("wqd", "application/vnd.wqd");
        KNOWN_MIME_TYPES.put("wri", "application/mswrite");
        KNOWN_MIME_TYPES.put("wrl", "application/x-world");
        KNOWN_MIME_TYPES.put("wrz", "model/vrml");
        KNOWN_MIME_TYPES.put("wsc", "text/scriplet");
        KNOWN_MIME_TYPES.put("wsdl", "application/wsdl+xml");
        KNOWN_MIME_TYPES.put("wspolicy", "application/wspolicy+xml");
        KNOWN_MIME_TYPES.put("wsrc", "application/x-wais-source");
        KNOWN_MIME_TYPES.put("wtb", "application/vnd.webturbo");
        KNOWN_MIME_TYPES.put("wtk", "application/x-wintalk");
        KNOWN_MIME_TYPES.put("wvx", "video/x-ms-wvx");
        KNOWN_MIME_TYPES.put("x-png", "image/png");
        KNOWN_MIME_TYPES.put("x3d", "application/vnd.hzn-3d-crossword");
        KNOWN_MIME_TYPES.put("xap", "application/x-silverlight-app");
        KNOWN_MIME_TYPES.put("xar", "application/vnd.xara");
        KNOWN_MIME_TYPES.put("xbap", "application/x-ms-xbap");
        KNOWN_MIME_TYPES.put("xbd", "application/vnd.fujixerox.docuworks.binder");
        KNOWN_MIME_TYPES.put("xbm", "image/x-xbitmap");
        KNOWN_MIME_TYPES.put("xdf", "application/xcap-diff+xml");
        KNOWN_MIME_TYPES.put("xdm", "application/vnd.syncml.dm+xml");
        KNOWN_MIME_TYPES.put("xdp", "application/vnd.adobe.xdp+xml");
        KNOWN_MIME_TYPES.put("xdr", "video/x-amt-demorun");
        KNOWN_MIME_TYPES.put("xdssc", "application/dssc+xml");
        KNOWN_MIME_TYPES.put("xdw", "application/vnd.fujixerox.docuworks");
        KNOWN_MIME_TYPES.put("xenc", "application/xenc+xml");
        KNOWN_MIME_TYPES.put("xer", "application/patch-ops-error+xml");
        KNOWN_MIME_TYPES.put("xfdf", "application/vnd.adobe.xfdf");
        KNOWN_MIME_TYPES.put("xfdl", "application/vnd.xfdl");
        KNOWN_MIME_TYPES.put("xgz", "xgl/drawing");
        KNOWN_MIME_TYPES.put("xhtml", "application/xhtml+xml");
        KNOWN_MIME_TYPES.put("xif", "image/vnd.xiff");
        KNOWN_MIME_TYPES.put("xl", "application/excel");
        KNOWN_MIME_TYPES.put("xla", "application/excel");
        KNOWN_MIME_TYPES.put("xlam", "application/vnd.ms-excel.addin.macroenabled.12");
        KNOWN_MIME_TYPES.put("xlb", "application/excel");
        KNOWN_MIME_TYPES.put("xlc", "application/excel");
        KNOWN_MIME_TYPES.put("xld", "application/excel");
        KNOWN_MIME_TYPES.put("xlk", "application/excel");
        KNOWN_MIME_TYPES.put("xll", "application/excel");
        KNOWN_MIME_TYPES.put("xlm", "application/excel");
        KNOWN_MIME_TYPES.put("xls", "application/vnd.ms-excel");
        KNOWN_MIME_TYPES.put("xlsb", "application/vnd.ms-excel.sheet.binary.macroenabled.12");
        KNOWN_MIME_TYPES.put("xlsm", "application/vnd.ms-excel.sheet.macroenabled.12");
        KNOWN_MIME_TYPES.put("xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        KNOWN_MIME_TYPES.put("xlt", "application/excel");
        KNOWN_MIME_TYPES.put("xltm", "application/vnd.ms-excel.template.macroenabled.12");
        KNOWN_MIME_TYPES.put("xltx", "application/vnd.openxmlformats-officedocument.spreadsheetml.template");
        KNOWN_MIME_TYPES.put("xlv", "application/excel");
        KNOWN_MIME_TYPES.put("xlw", "application/excel");
        KNOWN_MIME_TYPES.put("xm", "audio/xm");
        KNOWN_MIME_TYPES.put("xml", "text/xml");
        KNOWN_MIME_TYPES.put("xmz", "xgl/movie");
        KNOWN_MIME_TYPES.put("xo", "application/vnd.olpc-sugar");
        KNOWN_MIME_TYPES.put("xop", "application/xop+xml");
        KNOWN_MIME_TYPES.put("xpi", "application/x-xpinstall");
        KNOWN_MIME_TYPES.put("xpix", "application/x-vnd.ls-xpix");
        KNOWN_MIME_TYPES.put("xpm", "image/xpm");
        KNOWN_MIME_TYPES.put("xpr", "application/vnd.is-xpr");
        KNOWN_MIME_TYPES.put("xps", "application/vnd.ms-xpsdocument");
        KNOWN_MIME_TYPES.put("xpw", "application/vnd.intercon.formnet");
        KNOWN_MIME_TYPES.put("xsd", "text/xml");
        KNOWN_MIME_TYPES.put("xslt", "application/xslt+xml");
        KNOWN_MIME_TYPES.put("xsm", "application/vnd.syncml+xml");
        KNOWN_MIME_TYPES.put("xspf", "application/xspf+xml");
        KNOWN_MIME_TYPES.put("xsr", "video/x-amt-showrun");
        KNOWN_MIME_TYPES.put("xul", "application/vnd.mozilla.xul+xml");
        KNOWN_MIME_TYPES.put("xwd", "image/x-xwd");
        KNOWN_MIME_TYPES.put("xyz", "chemical/x-xyz");
        KNOWN_MIME_TYPES.put("yaml", "text/yaml");
        KNOWN_MIME_TYPES.put("yang", "application/yang");
        KNOWN_MIME_TYPES.put("yin", "application/yin+xml");
        KNOWN_MIME_TYPES.put("z", "application/x-compress");
        KNOWN_MIME_TYPES.put("zaz", "application/vnd.zzazz.deck+xml");
        KNOWN_MIME_TYPES.put("zip", "application/zip");
        KNOWN_MIME_TYPES.put("zir", "application/vnd.zul");
        KNOWN_MIME_TYPES.put("zmm", "application/vnd.handheld-entertainment+xml");
        KNOWN_MIME_TYPES.put("zoo", DEFAULT_MIME_TYPE);
        KNOWN_MIME_TYPES.put("zsh", "text/x-script.zsh");
    }
}

