/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.utils;

import si.nevensrok.common.utils.StringUtil;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public final class ByteUtil {
    private ByteUtil() {
    }

    public static String toHexString(byte[] data) {
        if (data == null) {
            return null;
        }
        StringBuilder text = new StringBuilder();
        for (byte b : data) {
            int n = b & 0xFF;
            if (n < 16) {
                text.append("0");
            }
            text.append(Integer.toHexString(n).toUpperCase());
        }
        return text.toString();
    }

    public static byte[] fromHexString(String text) {
        if (text == null) {
            return null;
        }
        try {
            byte[] data = new byte[text.length() / 2];
            for (int i = 0; i < data.length; ++i) {
                byte b;
                String part = text.substring(i * 2, i * 2 + 2);
                data[i] = b = (byte)Integer.parseInt(part, 16);
            }
            return data;
        }
        catch (Exception e) {
            throw new RuntimeException("Error decoding HEX string", e);
        }
    }

    public static boolean isHexString(String text) {
        if (StringUtil.isEmpty(text)) {
            return false;
        }
        if (text.length() % 2 != 0) {
            return false;
        }
        return text.matches("[0-9a-fA-F]+");
    }

    public static String toBase64String(byte[] data) {
        BASE64Encoder encoder = new BASE64Encoder();
        String text = encoder.encodeBuffer(data);
        return text.trim();
    }

    public static byte[] fromBase64String(String text) {
        try {
            BASE64Decoder decoder = new BASE64Decoder();
            return decoder.decodeBuffer(text);
        }
        catch (Exception e) {
            throw new RuntimeException("Error decoding base64 string", e);
        }
    }

    public static boolean isBase64String(String text) {
        if (StringUtil.isEmpty(text)) {
            return false;
        }
        if (text.length() % 4 != 0) {
            return false;
        }
        if (!text.substring(0, text.length() - 4).matches("[0-9a-zA-Z+/]+")) {
            return false;
        }
        return text.substring(text.length() - 4).matches("[0-9a-zA-Z+/=]+");
    }
}

