function isNull(obj) {
	return (obj === undefined || obj === null);
};

function isNotNull(obj) {
	return (obj !== undefined && obj !== null);
};

function isFunction(obj) {
	if (isNull(obj)) {
		return false;
	}
	var getType = {};
	return obj && getType.toString.call(obj) === '[object Function]';
};

function isArray(obj) {
	if (isNull(obj)) {
		return false;
	}
	return Object.prototype.toString.call(obj) === '[object Array]';
};

function isObject(obj) {
	if (isNull(obj)) {
		return false;
	}
	return (typeof obj === 'object');
};

function isString(obj) {
    if (isNull(obj)) {
		return false;
	}
	return (typeof obj === 'string');
}

function isNumber(obj) {
    if (isNull(obj)) {
		return false;
	}
	return (typeof obj === 'number');
}

function isValidNumber(val) {
	if (isTextEmpty(val)) {
		return false;
	}
	return val == Number(val);
};

function cloneObject(obj) {
    if (isNull(obj)) {
        return null;
    }
    if (isObject(obj)) {
        var copy = {};
        for (var key in obj) {
            copy[key] = obj[key];
        }
        return copy;
    }
    else if (isArray(obj)) {
        var copy = [];
        for (var key in obj) {
            copy[key] = obj[key];
        }
        return copy;
    }
    else {
    throw Error("Given object is not valid object type");
    }
};

function escapeHtml(text) {
	if (isNull(text)) {
		return null;
	}
	text = text.replace(new RegExp("&", 'g'), "&amp;");
	text = text.replace(new RegExp("<", 'g'), "&lt;");
	text = text.replace(new RegExp(">", 'g'), "&gt;");
	text = text.replace(new RegExp("\"", 'g'), "&quot;");
	text = text.replace(new RegExp("'", 'g'), "&#39;");
	text = text.replace(new RegExp("/", 'g'), "&#x2F;");
	return text;
};

function escapeRegExp(string) {
  return string.replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
}


function isTextEmpty(text) {
	if (isNull(text)) {
		return true;
	}
	return text === "";
};

function trimText(text) {
	if (isTextEmpty(text)) {
		return "";
	}
	return String(text).trim();
};

function definePackage(packageName, target) {
    if (isTextEmpty(packageName)) {
        throw new Error("Package name is empty");
    }

    var packages = packageName.split(".");
    for (var subPackageName of packages) {
        if (isTextEmpty(subPackageName)) {
            throw new Error("Invalid package name: '" + packageName + "'");
        }
    }

    var currentPackage = target;
    if (isNull(currentPackage)) {
        currentPackage = window;
    }

    for (var subPackageName of packages) {
        if (isNull(currentPackage[subPackageName])) {
            currentPackage[subPackageName] = {};
            currentPackage[subPackageName].definePackage = function(name) {
                return definePackage(name, currentPackage[subPackageName]);
            };
        }
        currentPackage = currentPackage[subPackageName];
    }

    return currentPackage;
};

function defineModule(moduleName, module) {
    if (isTextEmpty(moduleName)) {
        throw new Error("Module name is empty");
    }
    if (isNull(module)) {
        throw new Error("Module not provided");
    }
    var packages = moduleName.split(".");
    if (packages.length == 1) {
        window[packages[0]] = module;
    }
    else {
        var pckg = definePackage(packages.slice(0, packages.length - 1).join("."));
        pckg[packages[packages.length - 1]] = module;
    }

    return module;
};

function loadModule(moduleName) {
    if (isTextEmpty(moduleName)) {
        throw new Error("Module name is empty");
    }

    var currentPackage = window;
    var packages = moduleName.split(".");
    for (var subPackageName of packages) {
        if (isTextEmpty(subPackageName)) {
            throw new Error("Invalid module name: '" + moduleName + "'");
        }
        if (isNull(currentPackage[subPackageName])) {
            throw new Error("Module '" + moduleName + "' not defined");
        }
        currentPackage = currentPackage[subPackageName];
    }

    if (isNull(currentPackage)) {
        throw new Error("Module '" + moduleName + "' not defined");
    }

    return currentPackage;
};
(function () {
    var restClient = definePackage("restClient");

    restClient.response = class RestResponse {

        constructor(status) {
            this.status = status;
        }

        isSuccessful() {
            if (isNull(this.status)) {
                return false;
            }
            return this.status >= 200 && this.status <= 299;
        }

        parseResponseHeaders(responseHeaders) {
            if (isTextEmpty(responseHeaders)) {
                return;
            }
            this.headers = {};
            for (var line of responseHeaders.split("\n")) {
                var separator = line.indexOf(":");
                if (separator < 0) {
                    continue;
                }
                var headerName = trimText(line.substring(0, separator));
                var headerValue = trimText(line.substring(separator + 1));
                this.headers[headerName] = headerValue;
            }
        }

    };

    restClient.request = class RestRequest {

        constructor(method) {
            if (!isTextEmpty(method)) {
                this.method = method;
            }
            else {
                this.method = "GET";
            }
        }

        withParameters(parameters) {
            if (isNull(this.parameters)) {
                this.parameters = {};
            }
            for (var parameterName in parameters) {
                this.parameters[parameterName] = parameters[parameterName];
            }
            return this;
        }

        withParameter(parameterName, parameterValue) {
            if (isTextEmpty(parameterName)) {
                throw new Error("Parameter name not provided");
            }
            if (isNull(this.parameters)) {
                this.parameters = {};
            }
            this.parameters[parameterName] = parameterValue;
            return this;
        }

        withHeaders(headers) {
            if (isNull(this.headers)) {
                this.headers = {};
            }
            for (var headerName in headers) {
                this.headers[headerName] = headers[headerName];
            }
            return this;
        }

        withHeader(headerName, headerValue) {
            if (isTextEmpty(headerName)) {
                throw new Error("Header name not provided");
            }
            if (isNull(this.headers)) {
                this.headers = {};
            }
            this.headers[headerName] = headerValue;
            return this;
        }

        withBody(body) {
            this.body = body;
            return this;
        }

        withEncType(enctype) {
            this.enctype = enctype;
            return this;
        }

        execute(url, callback) {
            if (!isNull(callback) && !isFunction(callback)) {
                throw new Error("Callback parameter needs to be a function");
            }

            var targetUrl = baseUrl + url;

            if (!isNull(this.parameters)) {
                for (var parameterName in this.parameters) {
                    if (targetUrl.indexOf("?") >= 0) {
                        targetUrl += "&";
                    }
                    else {
                        targetUrl += "?";
                    }
                    targetUrl += parameterName + "=" + encodeURIComponent(this.parameters[parameterName]);
                }
            }

            targetUrl = addCsrfToUrl(targetUrl);

            var request = {
                "url": targetUrl
            };
            request.type = this.method;

            if (!isNull(this.headers)) {
                request.headers = this.headers;
            }

            if (!isNull(this.enctype)) {
                request.enctype = this.enctype;
                if (request.enctype == "multipart/form-data") {
                    request.processData = false;
                    request.contentType = false;
                }
            }

            if (!isNull(this.body)) {
                request.data = this.body;
            }

            if (isNull(callback)) {
                request.async = false;
            }
            request.cache = false;

            var response = null;

            request.success = function(data, textStatus, jqXHR) {
                response = new restClient.response(jqXHR.status);
                response.parseResponseHeaders(jqXHR.getAllResponseHeaders());
                response.data = data;
                if (!isNull(callback)) {
                    callback(response.data, response);
                }
            }

            request.error = function(data) {
                response = new restClient.response(data.status);
                response.errorText = data.responseText;
                if (!isNull(callback)) {
                    callback(response.data, response);
                }
            }

            $.ajax(request);

            if (isNull(callback)) {
                return response;
            }
        }

    };

    restClient.get = function(url, parameters, headers, callback) {
        if (!isNull(callback) && !isFunction(callback)) {
            throw new Error("Callback parameter needs to be a function");
        }
        var request = new restClient.request("GET");
        if (!isNull(parameters)) {
            request.withParameters(parameters);
        }
        if (!isNull(headers)) {
            request.withHeaders(headers);
        }
        if (isNull(callback)) {
            var response = request.execute(url);
            if (response.isSuccessful()) {
                return response.data;
            }
            else {
                throw Error("Invalid response code: " + response.status);
            }
        }
        else {
            request.execute(url, callback);
        }
    }

    restClient.post = function(url, body, parameters, headers, callback) {
        if (!isNull(callback) && !isFunction(callback)) {
            throw new Error("Callback parameter needs to be a function");
        }
        var request = new restClient.request("POST");
        if (!isNull(parameters)) {
            request.withParameters(parameters);
        }
        if (!isNull(headers)) {
            request.withHeaders(headers);
        }
        if (!isNull(body)) {
            request.withBody(body);
        }
        if (isNull(callback)) {
            var response = request.execute(url);
            if (response.status >= 200 && response.status <= 299) {
                return response.data;
            }
            else {
                throw Error("Invalid response code: " + response.status);
            }
        }
        else {
            request.execute(url, callback);
        }
    }

    restClient.postFormData = function(url, body, parameters, headers, callback) {
        if (!isNull(callback) && !isFunction(callback)) {
            throw new Error("Callback parameter needs to be a function");
        }
        var request = new restClient.request("POST");
        if (!isNull(parameters)) {
            request.withParameters(parameters);
        }
        if (!isNull(headers)) {
            request.withHeaders(headers);
        }
        request.withEncType("multipart/form-data");
        if (!isNull(body)) {
            request.withBody(body);
        }
        if (isNull(callback)) {
            var response = request.execute(url);
            if (response.status >= 200 && response.status <= 299) {
                return response.data;
            }
            else {
                throw Error("Invalid response code: " + response.status);
            }
        }
        else {
            request.execute(url, callback);
        }
    }

    restClient.postJson = function(url, body, parameters, headers, callback) {
        if (!isNull(callback) && !isFunction(callback)) {
            throw new Error("Callback parameter needs to be a function");
        }
        var request = new restClient.request("POST");
        if (!isNull(parameters)) {
            request.withParameters(parameters);
        }
        var allHeaders = {
            "Accept": "application/json"
        };
        if (!isNull(body)) {
            allHeaders["Content-Type"] = "application/json; charset=utf8";
        }
        if (!isNull(headers)) {
            for (var headerName in headers) {
                allHeaders[headerName] = headers[headerName];
            }
        }
        request.withHeaders(allHeaders);
        if (!isNull(body)) {
            request.withBody(body);
        }
        if (isNull(callback)) {
            var response = request.execute(url);
            if (response.status >= 200 && response.status <= 299) {
                return response.data;
            }
            else {
                throw Error("Invalid response code: " + response.status);
            }
        }
        else {
            request.execute(url, callback);
        }
    }

    restClient.put = function(url, body, parameters, headers, callback) {
        if (!isNull(callback) && !isFunction(callback)) {
            throw new Error("Callback parameter needs to be a function");
        }
        var request = new restClient.request("PUT");
        if (!isNull(parameters)) {
            request.withParameters(parameters);
        }
        if (!isNull(headers)) {
            request.withHeaders(headers);
        }
        if (!isNull(body)) {
            request.withBody(body);
        }
        if (isNull(callback)) {
            var response = request.execute(url);
            if (response.status >= 200 && response.status <= 299) {
                return response.data;
            }
            else {
                throw Error("Invalid response code: " + response.status);
            }
        }
        else {
            request.execute(url, callback);
        }
    }

    restClient.putJson = function(url, body, parameters, headers, callback) {
        if (!isNull(callback) && !isFunction(callback)) {
            throw new Error("Callback parameter needs to be a function");
        }
        var request = new restClient.request("PUT");
        if (!isNull(parameters)) {
            request.withParameters(parameters);
        }
        var allHeaders = {
            "Accept": "application/json"
        };
        if (!isNull(body)) {
            allHeaders["Content-Type"] = "application/json; charset=utf8";
        }
        if (!isNull(headers)) {
            for (var headerName in headers) {
                allHeaders[headerName] = headers[headerName];
            }
        }
        request.withHeaders(allHeaders);
        if (!isNull(body)) {
            request.withBody(body);
        }
        if (isNull(callback)) {
            var response = request.execute(url);
            if (response.status >= 200 && response.status <= 299) {
                return response.data;
            }
            else {
                throw Error("Invalid response code: " + response.status);
            }
        }
        else {
            request.execute(url, callback);
        }
    }

    restClient.delete = function(url, parameters, headers, callback) {
        if (!isNull(callback) && !isFunction(callback)) {
            throw new Error("Callback parameter needs to be a function");
        }
        var request = new restClient.request("DELETE");
        if (!isNull(parameters)) {
            request.withParameters(parameters);
        }
        if (!isNull(headers)) {
            request.withHeaders(headers);
        }
        if (isNull(callback)) {
            var response = request.execute(url);
            if (response.status >= 200 && response.status <= 299) {
                return response.data;
            }
            else {
                throw Error("Invalid response code: " + response.status);
            }
        }
        else {
            request.execute(url, callback);
        }
    }

})();
var highchartsColors = [ '#4572A7', '#AA4643', '#89A54E', '#80699B', '#3D96AE', '#DB843D', '#92A8CD', '#A47D7C', '#B5CA92' ];

$(document).ready(function() {
	$("[rel='tooltip']").tooltip();
	
	$(".deleteConfirmationButton").on("click",function(event) {
		event.preventDefault();
		var href = $(this).attr("href");
		var dialogTitle = $(this).attr("dialog-title");
		var dialogMessage = $(this).attr("dialog-message");
		dialog.showConfirmationRedirect(dialogTitle,dialogMessage,href);
		return false;
	});
	
	$(".chosen-select").each(function(index) {
		var width = $(this).attr("width");
		var options = {
			"search_contains": true
		};
		if (width) {
			options.width = width;
		}
		$(this).chosen(options);
	});
	
	$(".color-picker").each(function(index) {
		var field = this;
		var color = "#FFFFFF";
		
		if ($(field).prop("tagName") == "INPUT") {
			if ($(field).val() != "") {
				color = $(field).val();
			}
			$(field).ColorPicker({
				"color": color,
				onChange: function(hsb, hex, rgb, el) {
					$(field).val(hex);
				}
			});
		}
		else {
			var rgb = $(field).css("background-color");
			if (rgb != "transparent") {
				rgb = rgb.substring(4, rgb.length - 1).replace(/\s/g, "").split(",");
				color = "#";
				for (var i = 0; i < 3; i++) {
					if (Number(rgb[i]) < 10) {
						color += "0";
					}
					color += Number(rgb[i]).toString(16);
				}
			}
			$(field).ColorPicker({
				"color": color,
				onChange: function(hsb, hex, rgb, el) {
					$(field).css('backgroundColor', '#' + hex);
				}
			});
		}
	});

	$("input.date").each(function(index) {
		var dateFormat = $(this).attr("date-format");
		if (!dateFormat) {
			dateFormat = defaultDateFormat;
		}
		$(this).datepicker({
			"dateFormat": dateFormat
		});
	});
	
	$("input.datetime").each(function(index) {
		var dateFormat = $(this).attr("date-format");
		var timeFormat = $(this).attr("time-format");
		if (!dateFormat) {
			dateFormat = defaultDateFormat;
		}
		if (!timeFormat) {
			timeFormat = defaultTimeFormat;
		}
		$(this).datetimepicker({
			"dateFormat": dateFormat,
			"timeFormat": timeFormat
		});
	});
	
	$("input.time").each(function(index) {
		var timeFormat = $(this).attr("time-format");
		if (!timeFormat) {
			timeFormat = defaultTimeFormat;
		}
		$(this).timepicker({
			"timeFormat": timeFormat
		});
	});

	$("[slider-for]").each(function(index) {
		var sliderField = this;
		var forInputName = $(sliderField).attr("slider-for");
		var forInput = $(sliderField).parent().find("input[name='" + forInputName + "']");
		var min = Number($(sliderField).attr("min"));
		var max = Number($(sliderField).attr("max"));
		var step = Number($(sliderField).attr("step"));

		if (!isValidNumber(min)) {
			min = 0;
		}
		if (!isValidNumber(max)) {
			max = 100;
		}
		if (!isValidNumber(step)) {
			step = 1;
		}

		$(sliderField).slider({
			"min": min,
			"max": max,
			"step": step,
			"value": $(forInput).val(),
			"change": function(event,ui) {
				forInput.val(ui.value);
			},
			"slide": function(event,ui) {
				forInput.val(ui.value);
			}
		});

		forInput.on("change",function() {
			var value = Number($(this).val());
			if ($(this).val() == "" || !isValidNumber(value)) {
				$(this).val("0");
			}
			if (value < min) {
				value = min;
			}
			if (value > max) {
				value = max;
			}
			$(sliderField).slider("value", value);
		});
		forInput.on("keyup", function() {
			var value = Number($(this).val());
			if ($(this).val() != "" && isValidNumber(value)) {
				if (value >= min && value <= max) {
					$(sliderField).slider("value",value);
				}
			}
		});
	});

	$("input.spinner").each(function(index) {
		var min = Number($(this).attr("min"));
		var max = Number($(this).attr("max"));
		var step = Number($(this).attr("step"));
		var numberFormat = $(this).attr("number-format");

		if (!isValidNumber(min)) {
			min = 0;
		}
		if (!isValidNumber(max)) {
			max = 100;
		}
		if (!isValidNumber(step)) {
			step = 1;
		}
		if (!numberFormat) {
			numberFormat = "n";
		}

		$(this).spinner({
			"min": min,
			"max": max,
			"step": step,
			"numberFormat": numberFormat
		});
	});
	
	$("#search").change(function(e) {
		e.preventDefault();
		$("#page").val("1");
		$("#page").parent().submit();
		return false;
	});
	
	$("#showPerPage").change(function(e) {
		e.preventDefault();
		$("#page").val("1");
		$("#page").parent().submit();
		return false;
	});
	
	$("ul.pagination a").on("click",function(event) {
		var selectedPageNum = $(this).attr("href").substring(1);
		var currentPageNum = Number($("#page").val());
		if (selectedPageNum == "prev") {
			currentPageNum -= 1;
			if (currentPageNum < 1) {
				currentPageNum = 1;
			}
		}
		else if (selectedPageNum == "next") {
			currentPageNum += 1;
		}
		else {
			currentPageNum = Number(selectedPageNum);
		}
		$("#page").val(String(currentPageNum));
		
		$("#page").parent().submit();
		
		return false;
	});
});
var DialogButton = Backbone.Model.extend({
	defaults: {
		"text": "",
		"click": null,
		"class": "btn btn-primary",
		"close": false
	},
	initialize: function() {
		
	}
});

var DialogButtonList = Backbone.Collection.extend({
	model: DialogButton
});

var DialogData = Backbone.Model.extend({
	defaults: {
		"type": "info",
		"title": "",
		"content": ""
	},
	initialize:function() {
		this.set({ buttons: new DialogButtonList() }, { silent: true });
	}
});

var DialogButtonView = Backbone.View.extend({
	'tagName': "button",
	'initialize': function() {
		
		
	},
	'render': function() {
		var obj = this;
		this.$el.text(this.model.get("text"));
		this.$el.attr("type", "button");
		this.$el.attr("class", this.model.get("class"));
		
		if (this.model.get("close")) {
			this.$el.attr("data-dismiss", "modal");
		}
		
		this.$el.on("click",function() {
			var func = obj.model.get("click");
			if (func != null) {
				func();
			}
		});
		
		return this;
	}
});

var DialogView = Backbone.View.extend({
	'tagName':"div",
	'template': "",
	'initialize': function() {
		this.template = templates.getTemplate("/templates/dialog");
		this.$el.attr("class","modal fade");
	},
	show:function() {
		var obj = this;
		
		$("body").append(this.el);
		
		this.$el.modal({
	    	show: false
	    });
	    
		this.$el.on("hidden.bs.modal",function () {
			obj.$el.remove();
		});
		
		this.render();
		this.$el.modal("show");
	},
	hide: function() {
		
	},
	'render': function() {
		var obj = this;
		var data = {
			title: obj.model.get("title")
		};
		this.$el.html(Mustache.render(this.template,data));
		this.$el.find("div.dialogContent").html(this.model.get("content"));
		
		//add buttons
		for (var i = 0; i < this.model.get("buttons").length; i++) {
			var button = this.model.get("buttons").at(i);
			var dialogButtonView = new DialogButtonView({ model: button });
			this.$el.find(".modal-footer").append(dialogButtonView.render().el);
		}
		
		return this;
	}
});

var dialog = {
	showDialog: function(title,content,buttons,openFunction) {
		var dialogData=new DialogData({
			type:"info",
			title:title,
			content:content
		});
		for (var i=0;i<buttons.length;i++) {
			var button=buttons[i];
			dialogData.get("buttons").add(new DialogButton({
				"text":button.text,
				"class":button.class,
				"close":button.close,
				"click":button.click
			}));
		}
		
		var dialogView=new DialogView({
			model:dialogData
		});
		
		if (openFunction) {
			$(dialogView.el).on("show",function () {
				openFunction(dialogView.el);
			});
		}
		
		dialogView.show();
		
		return dialogView.el;
	},
	showInfoMessage: function(message,title) {
		var dialogTitle=getSpringMessage("common.title.info");
		if (title) {
			dialogTitle=title;
		}
		
		var dialogData=new DialogData({
			type:"info",
			title:dialogTitle,
			content:message
		});
		
		var dialogView=new DialogView({
			model:dialogData
		});
		
		dialogData.get("buttons").add(new DialogButton({
			"text":getSpringMessage("common.close"),
			"class":"btn btn-primary",
			"close":true
		}));
		
		dialogView.show();
	},
	showErrorMessage: function(message) {
		var dialogTitle=getSpringMessage("common.title.error");
		if (title) {
			dialogTitle=title;
		}
		
		var dialogData=new DialogData({
			type:"info",
			title:dialogTitle,
			content:message
		});
		
		var dialogView=new DialogView({
			model:dialogData
		});
		
		dialogData.get("buttons").add(new DialogButton({
			"text":getSpringMessage("common.close"),
			"class":"btn btn-primary",
			"close":true
		}));
		
		dialogView.show();
	},
	showPopup: function(item,title,content) {
		$(item).popover({
			trigger:"hover",
			title:title,
			content:content
		});
		$(item).popover('show');
	},
	showConfirmation: function(title,text,confirmationAction) {
		var dialogData=new DialogData({
			type:"info",
			title:title,
			content:text
		});
		
		var dialogView=new DialogView({
			model:dialogData
		});
		
		dialogData.get("buttons").add(new DialogButton({
			"text":getSpringMessage("common.confirm"),
			"class":"btn btn-primary",
			"close":false,
			"click":function() {
				$(dialogView.el).modal("hide");
				confirmationAction();
			}
		}));
		
		dialogData.get("buttons").add(new DialogButton({
			"text":getSpringMessage("common.cancel"),
			"class":"btn btn-danger",
			"close":true
		}));
		
		dialogView.show();
	},
	showConfirmationRedirect: function(title,text,url) {
		dialog.showConfirmation(title,text,function() {
			window.location=url;
		});
	}
};
$(document).ready(function() {
	$(".pagination a").on("click",function(event) {
		event.preventDefault();
		
		var formId=$(this).parent().parent().attr("formId");
		if ($(this).attr("href")!=undefined) {
			var page=$(this).attr("href").substring(1);
			
			var currentPage=Number($("#"+formId+" input[name='page']").val());
			
			if (page=="prev") {
				currentPage-=1;
			}
			else if (page=="next") {
				currentPage+=1;
			}
			else {
				currentPage=Number(page);
			}
			$("#"+formId+" input[name='page']").val(currentPage);
			$("#"+formId).submit();
		}
	});
	
	$(".pagination input").on("change",function(event) {
		var formId=$(this).parent().parent().attr("formId");
		$("#"+formId+" input[name='page']").val($(this).val());
		$("#"+formId).submit();
	});
});var templates = {
    cache: {},
    getTemplate: function(path) {
        if (isNotNull(this.cache[path])) {
            return this.cache[path];
        }
        var obj = this;
        $.ajax({
            async: false,
            url: contextPath + path,
            type: 'GET',
            success: function(responseData) {
                obj.cache[path] = responseData;
            }
        });
        return this.cache[path];
    }
};