/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.tools;

import java.util.Set;
import si.nevensrok.jtekma.common.matches.DuoPresentationPoint;
import si.nevensrok.jtekma.common.matches.MatchPoint;
import si.nevensrok.jtekma.common.matches.PointType;
import si.nevensrok.jtekma.common.matches.Series;
import si.nevensrok.jtekma.common.rules.CompetitorType;

public final class MatchPointsUtil {
    private MatchPointsUtil() {
    }

    public static MatchPoint getOrCreateMatchPoint(Set<MatchPoint> points, CompetitorType competitorType, PointType pointType) {
        for (MatchPoint matchPoint : points) {
            if (matchPoint.getCompetitor() != competitorType || matchPoint.getPointType() != pointType) continue;
            return matchPoint;
        }
        MatchPoint matchPoint = new MatchPoint();
        matchPoint.setCompetitor(competitorType);
        matchPoint.setPointType(pointType);
        points.add(matchPoint);
        return matchPoint;
    }

    public static MatchPoint getOrCreateMatchPoint(Set<MatchPoint> points, CompetitorType competitorType, int round, int judge) {
        for (MatchPoint matchPoint : points) {
            if (matchPoint.getCompetitor() != competitorType || matchPoint.getPointType() != PointType.JUDGE || matchPoint.getRound() != round || matchPoint.getJudge() != judge) continue;
            return matchPoint;
        }
        MatchPoint matchPoint = new MatchPoint();
        matchPoint.setCompetitor(competitorType);
        matchPoint.setPointType(PointType.JUDGE);
        matchPoint.setRound(Integer.valueOf(round));
        matchPoint.setJudge(Integer.valueOf(judge));
        points.add(matchPoint);
        return matchPoint;
    }

    public static MatchPoint getOrCreateMatchPoint(Set<MatchPoint> points, CompetitorType competitorType, int judge, Series series, int attack, int part) {
        for (MatchPoint matchPoint : points) {
            if (matchPoint.getCompetitor() != competitorType || matchPoint.getPointType() != PointType.JUDGE || matchPoint.getJudge() != judge || matchPoint.getSeries() != series || matchPoint.getAttack() != attack || matchPoint.getPart() != part) continue;
            return matchPoint;
        }
        MatchPoint matchPoint = new MatchPoint();
        matchPoint.setCompetitor(competitorType);
        matchPoint.setPointType(PointType.JUDGE);
        matchPoint.setJudge(Integer.valueOf(judge));
        matchPoint.setSeries(series);
        matchPoint.setAttack(Integer.valueOf(attack));
        matchPoint.setPart(Integer.valueOf(part));
        points.add(matchPoint);
        return matchPoint;
    }

    public static MatchPoint getOrCreateMatchPenaltyPoint(Set<MatchPoint> points, CompetitorType competitorType) {
        for (MatchPoint matchPoint : points) {
            if (matchPoint.getCompetitor() != competitorType || matchPoint.getPointType() != PointType.PENALTY) continue;
            return matchPoint;
        }
        MatchPoint matchPoint = new MatchPoint();
        matchPoint.setCompetitor(competitorType);
        matchPoint.setPointType(PointType.PENALTY);
        points.add(matchPoint);
        return matchPoint;
    }

    public static DuoPresentationPoint getOrCreateDuoPresentationPoint(Set<DuoPresentationPoint> points, int judge, Series series, int attack, int part) {
        for (DuoPresentationPoint duoPresentationPoint : points) {
            if (duoPresentationPoint.getType() != DuoPresentationPoint.Type.POINTS || duoPresentationPoint.getJudge() != judge || duoPresentationPoint.getSeries() != series || duoPresentationPoint.getAttack() != attack || duoPresentationPoint.getPart() != part) continue;
            return duoPresentationPoint;
        }
        DuoPresentationPoint duoPresentationPoint = new DuoPresentationPoint();
        duoPresentationPoint.setType(DuoPresentationPoint.Type.POINTS);
        duoPresentationPoint.setPoints(Float.valueOf(0.0f));
        duoPresentationPoint.setJudge(Integer.valueOf(judge));
        duoPresentationPoint.setSeries(series);
        duoPresentationPoint.setAttack(Integer.valueOf(attack));
        duoPresentationPoint.setPart(Integer.valueOf(part));
        points.add(duoPresentationPoint);
        return duoPresentationPoint;
    }

    public static DuoPresentationPoint getOrCreateDuoPresentationPenaltyPoint(Set<DuoPresentationPoint> points) {
        for (DuoPresentationPoint duoPresentationPoint : points) {
            if (duoPresentationPoint.getType() != DuoPresentationPoint.Type.PENALTY) continue;
            return duoPresentationPoint;
        }
        DuoPresentationPoint duoPresentationPoint = new DuoPresentationPoint();
        duoPresentationPoint.setType(DuoPresentationPoint.Type.PENALTY);
        duoPresentationPoint.setPoints(Float.valueOf(0.0f));
        points.add(duoPresentationPoint);
        return duoPresentationPoint;
    }
}

