/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.tools;

import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import si.nevensrok.common.dl.query.DataFilter;
import si.nevensrok.common.dl.query.FieldFilter;
import si.nevensrok.common.dl.query.Filter;
import si.nevensrok.common.dl.query.SimpleDataFilter;
import si.nevensrok.common.dl.query.Sort;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.server.web.ManagersList;
import si.nevensrok.jtekma.server.web.common.UserData;

public class DataTool
implements ApplicationContextAware {
    private ApplicationContext applicationContext;
    private UserData userData;
    private ManagersList managersList;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public String getLanguageText(Locale locale, String key) {
        return this.applicationContext.getMessage(key, null, key, locale);
    }

    public String getLanguageText(Locale locale, String key, Object[] args) {
        return this.applicationContext.getMessage(key, args, key, locale);
    }

    public void setUserData(UserData userData) {
        this.userData = userData;
    }

    public void setManagersList(ManagersList managersList) {
        this.managersList = managersList;
    }

    public List<Competition> getQuickCompetitions() {
        SimpleDataFilter dataFilter = new SimpleDataFilter();
        dataFilter.setItemLimit(Integer.valueOf(10));
        HashSet<Competition.Status> statuses = new HashSet<Competition.Status>();
        statuses.add(Competition.Status.ACTIVE);
        statuses.add(Competition.Status.FINISHED);
        FieldFilter fieldFilter = new FieldFilter("status", FieldFilter.Comparator.IN, statuses);
        dataFilter.setFilter((Filter)fieldFilter);
        dataFilter.setSort(new Sort());
        dataFilter.getSort().addField(new Sort.Field("competitonDate", Sort.Field.Direction.DESC));
        return this.managersList.getCompetitionManager().find((DataFilter)dataFilter).getData();
    }
}

