/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.services.impl;

import java.util.Calendar;
import java.util.LinkedHashSet;
import java.util.Set;
import si.nevensrok.jtekma.common.category.AgeCategoryOption;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.category.Duo2023Category;
import si.nevensrok.jtekma.common.category.FightingCategory;
import si.nevensrok.jtekma.common.category.NewazaCategory;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.matches.DuoPresentation;
import si.nevensrok.jtekma.common.matches.Match;
import si.nevensrok.jtekma.common.matches.MatchFinishData;
import si.nevensrok.jtekma.common.matches.MatchPartialData;
import si.nevensrok.jtekma.common.matches.NextMatchData;
import si.nevensrok.jtekma.common.matches.Rank;
import si.nevensrok.jtekma.common.matches.Round;
import si.nevensrok.jtekma.common.tatami.Tatami;
import si.nevensrok.jtekma.common.tatami.TatamiHistory;
import si.nevensrok.jtekma.server.management.AgeCategoryOptionManager;
import si.nevensrok.jtekma.server.management.CategoryManager;
import si.nevensrok.jtekma.server.management.CompetitionManager;
import si.nevensrok.jtekma.server.management.DuoPresentationManager;
import si.nevensrok.jtekma.server.management.MatchManager;
import si.nevensrok.jtekma.server.management.TatamiFightsManager;
import si.nevensrok.jtekma.server.management.TatamiHistoryManager;
import si.nevensrok.jtekma.server.management.TatamiManager;
import si.nevensrok.jtekma.services.TablaService;
import si.nevensrok.jtekma.services.common.Credentials;
import si.nevensrok.jtekma.services.common.ServiceException;

public class TablaServiceImpl
implements TablaService {
    private TatamiManager tatamiManager;
    private MatchManager matchManager;
    private TatamiFightsManager tatamiFightsManager;
    private CategoryManager categoryManager;
    private CompetitionManager competitionManager;
    private AgeCategoryOptionManager ageCategoryOptionManager;
    private TatamiHistoryManager tatamiHistoryManager;
    private DuoPresentationManager duoPresentationManager;

    public void setTatamiManager(TatamiManager tatamiManager) {
        this.tatamiManager = tatamiManager;
    }

    public void setMatchManager(MatchManager matchManager) {
        this.matchManager = matchManager;
    }

    public void setTatamiFightsManager(TatamiFightsManager tatamiFightsManager) {
        this.tatamiFightsManager = tatamiFightsManager;
    }

    public void setCategoryManager(CategoryManager categoryManager) {
        this.categoryManager = categoryManager;
    }

    public void setCompetitionManager(CompetitionManager competitionManager) {
        this.competitionManager = competitionManager;
    }

    public void setAgeCategoryOptionManager(AgeCategoryOptionManager ageCategoryOptionManager) {
        this.ageCategoryOptionManager = ageCategoryOptionManager;
    }

    public void setTatamiHistoryManager(TatamiHistoryManager tatamiHistoryManager) {
        this.tatamiHistoryManager = tatamiHistoryManager;
    }

    public void setDuoPresentationManager(DuoPresentationManager duoPresentationManager) {
        this.duoPresentationManager = duoPresentationManager;
    }

    public boolean checkLogin(Credentials credentials) throws ServiceException {
        Tatami tatami = this.tatamiManager.getTatamiByCredentials(credentials);
        return tatami != null;
    }

    public NextMatchData getNextMatch(Credentials credentials) throws ServiceException {
        NewazaCategory newazaCategory;
        AgeCategoryOption ageCategoryOption;
        DuoPresentation duoPresentation;
        Tatami tatami = this.tatamiManager.getTatamiByCredentials(credentials);
        if (tatami == null) {
            throw new ServiceException("Invalid credentials");
        }
        TatamiHistory tatamiHistory = new TatamiHistory();
        tatamiHistory.setTatami(tatami);
        tatamiHistory.setEventDate(Calendar.getInstance().getTime());
        tatamiHistory.setEventType(TatamiHistory.EventType.PULLMATCH);
        Category category = null;
        NextMatchData nextMatchData = null;
        Match match = this.tatamiFightsManager.getNextMatchForTatami(tatami);
        if (match != null) {
            tatamiHistory.setMatch(match);
            match = this.matchManager.getByIdWithCompetitors(match.getMatchId());
            match.setStartedAt(Calendar.getInstance().getTime());
            this.matchManager.setMatchStartedAt(match);
            category = this.categoryManager.getCategoryForMatch(match);
            match.setCategory(category);
            nextMatchData = new NextMatchData();
            nextMatchData.setMatch(match);
            nextMatchData.setMatchTime(match.getFightTimeLeft());
            nextMatchData.setHosekomiTime(match.getHosekomiTime());
            nextMatchData.setInjuryTime1(match.getInjuryTime1());
            nextMatchData.setInjuryTime2(match.getInjuryTime2());
            boolean challenge1 = this.matchManager.isChallengeAvailable(category, match, match.getCompetitor1());
            boolean challenge2 = this.matchManager.isChallengeAvailable(category, match, match.getCompetitor2());
            nextMatchData.setChallengeAvailable1(Boolean.valueOf(challenge1));
            nextMatchData.setChallengeAvailable2(Boolean.valueOf(challenge2));
            nextMatchData.setChallengesWon1(match.getChallengesWon1());
            nextMatchData.setChallengesWon2(match.getChallengesWon2());
            nextMatchData.setChallengesLost1(match.getChallengesLost1());
            nextMatchData.setChallengesLost2(match.getChallengesLost2());
            Set matchPoints = this.matchManager.getMatchPointsForMatch(match);
            nextMatchData.setMatchPoints(matchPoints);
            if (category instanceof Duo2023Category) {
                Round round = Round.ROUND_4;
                if (match.getFightNumber() == 7 || match.getFightNumber() == 8 || match.getFightNumber() == 15 || match.getFightNumber() == 16 || match.getFightNumber() == 23 || match.getFightNumber() == 24) {
                    round = Round.ROUND_5;
                }
                Rank rank = Rank.WORLD_LEVEL;
                if (match.getFightNumber() > 16) {
                    rank = Rank.NOVICE;
                } else if (match.getFightNumber() > 8) {
                    rank = Rank.ADVANCED;
                }
                nextMatchData.setRound(round);
                nextMatchData.setRank(rank);
            }
        }
        if ((duoPresentation = this.tatamiFightsManager.getNextDuoPresentationForTatami(tatami)) != null) {
            tatamiHistory.setDuoPresentation(duoPresentation);
            duoPresentation = this.duoPresentationManager.getByIdWithCompetitor(duoPresentation.getDuoPresentationId());
            duoPresentation.setStartedAt(Calendar.getInstance().getTime());
            this.duoPresentationManager.setDuoPresentationStartedAt(duoPresentation);
            category = this.categoryManager.getCategoryForDuoPresentation(duoPresentation);
            duoPresentation.setCategory(category);
            nextMatchData = new NextMatchData();
            nextMatchData.setDuoPresentation(duoPresentation);
            Set duoPresentationPoints = this.duoPresentationManager.getDuoPresentationPointsForDuoPresentation(duoPresentation);
            nextMatchData.setDuoPresentationPoints(duoPresentationPoints);
            nextMatchData.setRound(duoPresentation.getRound());
            nextMatchData.setRank(duoPresentation.getRank());
        }
        if (nextMatchData == null) {
            return null;
        }
        this.tatamiHistoryManager.createTatamiHistory(tatamiHistory);
        Competition competition = this.competitionManager.getCompetitionForCategory(category);
        nextMatchData.setRules(competition.getRules());
        if (category instanceof FightingCategory) {
            FightingCategory fightingCategory = (FightingCategory)category;
            ageCategoryOption = this.ageCategoryOptionManager.getForCategory(fightingCategory);
            if (ageCategoryOption != null) {
                if (ageCategoryOption.getFightTime() > 0 && nextMatchData.getMatchTime() == null) {
                    nextMatchData.setMatchTime(ageCategoryOption.getFightTime());
                }
                if (ageCategoryOption.getHosekomiTime() > 0 && nextMatchData.getHosekomiTime() == null) {
                    nextMatchData.setHosekomiTime(ageCategoryOption.getHosekomiTime());
                }
            }
        } else if (category instanceof NewazaCategory && (ageCategoryOption = this.ageCategoryOptionManager.getForCategory(newazaCategory = (NewazaCategory)category)) != null) {
            if (ageCategoryOption.getFightTime() > 0 && nextMatchData.getMatchTime() == null) {
                nextMatchData.setMatchTime(ageCategoryOption.getFightTime());
            }
            if (ageCategoryOption.getHosekomiTime() > 0 && nextMatchData.getHosekomiTime() == null) {
                nextMatchData.setHosekomiTime(ageCategoryOption.getHosekomiTime());
            }
            nextMatchData.setNewazaPenaltyHansokumake(ageCategoryOption.getNewazaPenaltyHansokumake());
        }
        if (nextMatchData.getMatchTime() == null) {
            nextMatchData.setMatchTime(Integer.valueOf(180));
        }
        if (nextMatchData.getHosekomiTime() == null) {
            nextMatchData.setHosekomiTime(Integer.valueOf(15));
        }
        return nextMatchData;
    }

    public void setPartialData(Credentials credentials, MatchPartialData matchPartialData) {
        DuoPresentation duoPresentation;
        Tatami tatami = this.tatamiManager.getTatamiByCredentials(credentials);
        if (tatami == null) {
            throw new ServiceException("Invalid credentials");
        }
        Match match = matchPartialData.getMatch();
        if (match != null) {
            Long matchId = match.getMatchId();
            if ((match = this.matchManager.getById(matchId)) == null) {
                throw new ServiceException("Match with id [" + matchId + "] not found");
            }
            if (match.getStatus() == Match.Status.FINISHED) {
                return;
            }
            Tatami matchTatami = this.tatamiManager.getTatamiForMatch(match);
            if (matchTatami == null) {
                throw new ServiceException("Match is not on tatami");
            }
            if (!matchTatami.getTatamiId().equals(tatami.getTatamiId())) {
                throw new ServiceException("Match is not on tatami");
            }
            match.setFightTimeLeft(matchPartialData.getFightTimeLeft());
            match.setInjuryTime1(matchPartialData.getInjuryTime1());
            match.setInjuryTime2(matchPartialData.getInjuryTime2());
            match.setChallengesWon1(matchPartialData.getChallengesWon1());
            match.setChallengesWon2(matchPartialData.getChallengesWon2());
            match.setChallengesLost1(matchPartialData.getChallengesLost1());
            match.setChallengesLost2(matchPartialData.getChallengesLost2());
            if (match.getStatus() == Match.Status.INPROGRESS || this.tatamiFightsManager.isNextMatchForTatami(matchTatami, match)) {
                this.matchManager.setMatchPointsForMatch(match, matchPartialData.getMatchPoints());
                this.matchManager.setFightTimeLeft(match);
                this.matchManager.setInjuryTime(match);
                this.matchManager.setChallenges(match);
            }
        }
        if ((duoPresentation = matchPartialData.getDuoPresentation()) != null) {
            Long duoPresentationId = duoPresentation.getDuoPresentationId();
            if ((duoPresentation = this.duoPresentationManager.getById(duoPresentationId)) == null) {
                throw new ServiceException("Duo presentation with id [" + duoPresentationId + "] not found");
            }
            if (duoPresentation.getStatus() == DuoPresentation.Status.FINISHED) {
                return;
            }
            Tatami duoPresentationTatami = this.tatamiManager.getTatamiForDuoPresentation(duoPresentation);
            if (duoPresentationTatami == null) {
                throw new ServiceException("Duo presentation is not on tatami");
            }
            if (!duoPresentationTatami.getTatamiId().equals(tatami.getTatamiId())) {
                throw new ServiceException("Duo presentation is not on tatami");
            }
            if (duoPresentation.getStatus() == DuoPresentation.Status.INPROGRESS || this.tatamiFightsManager.isNextDuoPresentationForTatami(duoPresentationTatami, duoPresentation)) {
                this.duoPresentationManager.setDuoPresentationPointsForDuoPresentation(duoPresentation, matchPartialData.getDuoPresentationPoints());
            }
        }
    }

    public void finishMatch(Credentials credentials, MatchFinishData matchFinishData) throws ServiceException {
        DuoPresentation duoPresentation;
        Tatami tatami = this.tatamiManager.getTatamiByCredentials(credentials);
        if (tatami == null) {
            throw new ServiceException("Invalid credentials");
        }
        Match match = matchFinishData.getMatch();
        if (match != null) {
            Long matchId = match.getMatchId();
            if ((match = this.matchManager.getById(matchId)) == null) {
                throw new ServiceException("Match with id [" + matchId + "] not found");
            }
            if (match.getStatus() == Match.Status.FINISHED) {
                return;
            }
            Tatami matchTatami = this.tatamiManager.getTatamiForMatch(match);
            if (matchTatami == null) {
                throw new ServiceException("Match is not on tatami");
            }
            if (!matchTatami.getTatamiId().equals(tatami.getTatamiId())) {
                throw new ServiceException("Match is not on tatami");
            }
            TatamiHistory tatamiHistory = new TatamiHistory();
            tatamiHistory.setTatami(tatami);
            tatamiHistory.setEventDate(Calendar.getInstance().getTime());
            tatamiHistory.setEventType(TatamiHistory.EventType.PUSHMATCH);
            tatamiHistory.setMatch(match);
            this.tatamiHistoryManager.createTatamiHistory(tatamiHistory);
            match.setFightTimeLeft(matchFinishData.getFightTimeLeft());
            match.setInjuryTime1(matchFinishData.getInjuryTime1());
            match.setInjuryTime2(matchFinishData.getInjuryTime2());
            match.setChallengesWon1(matchFinishData.getChallengesWon1());
            match.setChallengesWon2(matchFinishData.getChallengesWon2());
            match.setChallengesLost1(matchFinishData.getChallengesLost1());
            match.setChallengesLost2(matchFinishData.getChallengesLost2());
            if (match.getStatus() == Match.Status.INPROGRESS || this.tatamiFightsManager.isNextMatchForTatami(matchTatami, match)) {
                this.matchManager.setMatchPointsForMatch(match, matchFinishData.getMatchPoints());
                if (matchFinishData.getPointDetails() != null) {
                    this.matchManager.setMatchPointDetailsForMatch(match, matchFinishData.getPointDetails());
                } else {
                    this.matchManager.setMatchPointDetailsForMatch(match, new LinkedHashSet());
                }
                this.matchManager.setFightTimeLeft(match);
                this.matchManager.setInjuryTime(match);
                this.matchManager.setChallenges(match);
                this.matchManager.setMatchStatus(match, Match.Status.FINISHED);
                match.setFinishedAt(Calendar.getInstance().getTime());
                this.matchManager.setMatchFinishedAt(match);
            }
        }
        if ((duoPresentation = matchFinishData.getDuoPresentation()) != null) {
            Long duoPresentationId = duoPresentation.getDuoPresentationId();
            if ((duoPresentation = this.duoPresentationManager.getById(duoPresentationId)) == null) {
                throw new ServiceException("Duo presentation with id [" + duoPresentationId + "] not found");
            }
            if (duoPresentation.getStatus() == DuoPresentation.Status.FINISHED) {
                return;
            }
            Tatami duoPresentationTatami = this.tatamiManager.getTatamiForDuoPresentation(duoPresentation);
            if (duoPresentationTatami == null) {
                throw new ServiceException("Duo presentation is not on tatami");
            }
            if (!duoPresentationTatami.getTatamiId().equals(tatami.getTatamiId())) {
                throw new ServiceException("Duo presentation is not on tatami");
            }
            TatamiHistory tatamiHistory = new TatamiHistory();
            tatamiHistory.setTatami(tatami);
            tatamiHistory.setEventDate(Calendar.getInstance().getTime());
            tatamiHistory.setEventType(TatamiHistory.EventType.PUSHMATCH);
            tatamiHistory.setDuoPresentation(duoPresentation);
            this.tatamiHistoryManager.createTatamiHistory(tatamiHistory);
            if (duoPresentation.getStatus() == DuoPresentation.Status.INPROGRESS || this.tatamiFightsManager.isNextDuoPresentationForTatami(duoPresentationTatami, duoPresentation)) {
                this.duoPresentationManager.setDuoPresentationPointsForDuoPresentation(duoPresentation, matchFinishData.getDuoPresentationPoints());
                this.duoPresentationManager.setDuoPresentationStatus(duoPresentation, DuoPresentation.Status.FINISHED);
                duoPresentation.setFinishedAt(Calendar.getInstance().getTime());
                this.duoPresentationManager.setDuoPresentationFinishedAt(duoPresentation);
            }
        }
    }
}

