/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.controllers.data;

import java.text.Normalizer;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.support.RequestContextUtils;
import si.nevensrok.common.dl.query.DataFilter;
import si.nevensrok.common.dl.query.ExampleFilter;
import si.nevensrok.common.dl.query.Filter;
import si.nevensrok.common.dl.query.PageDataResult;
import si.nevensrok.common.dl.query.SimpleDataFilter;
import si.nevensrok.common.dl.query.Sort;
import si.nevensrok.common.utils.ObjectUtil;
import si.nevensrok.common.web.filter.SearchFilter;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.category.CategoryGroup;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.system.Right;
import si.nevensrok.jtekma.server.dataimport.DataImportException;
import si.nevensrok.jtekma.server.dataimport.FileType;
import si.nevensrok.jtekma.server.web.common.ImportDataModel;
import si.nevensrok.jtekma.server.web.controllers.CoreController;
import si.nevensrok.jtekma.server.web.controllers.data.CategoryGroupModel;
import si.nevensrok.jtekma.server.web.security.ForbiddenException;
import si.nevensrok.jtekma.server.web.security.MethodRight;
import si.nevensrok.jtekma.server.web.tools.FilterGeneratorTool;

@Controller
@RequestMapping(value={"/data/category-groups"})
@SessionAttributes(value={"categoryGroupListFilter", "importCategoryList"})
public class CategoryGroupsController
extends CoreController {
    private static final Logger LOGGER = LoggerFactory.getLogger(CategoryGroupsController.class);

    @ModelAttribute(value="categoryGroupsActive")
    public Boolean getCategoryGroupsActive() {
        return Boolean.TRUE;
    }

    @ModelAttribute(value="categoryGroupListFilter")
    public SearchFilter getSearchFilter() {
        return FilterGeneratorTool.generateDefaultSearchFilter();
    }

    @ModelAttribute(value="editRights")
    public Boolean getEditRights() {
        return this.hasRights(Right.CATEGORYEDIT);
    }

    @ModelAttribute(value="fileTypes")
    public Map<FileType, String> getFileTypes(HttpServletRequest request) {
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        LinkedHashMap<FileType, String> importType = new LinkedHashMap<FileType, String>();
        importType.put(FileType.CSV, this.getLanguageText(locale, "filetypes.csv"));
        importType.put(FileType.ODS, this.getLanguageText(locale, "filetypes.ods"));
        importType.put(FileType.XLS, this.getLanguageText(locale, "filetypes.xls"));
        importType.put(FileType.XLSX, this.getLanguageText(locale, "filetypes.xlsx"));
        return importType;
    }

    private Map<Long, String> getCategories() {
        LinkedHashMap<Long, String> categories = new LinkedHashMap<Long, String>();
        Category example = new Category();
        example.setStatus(Category.Status.ACTIVE);
        SimpleDataFilter dataFilter = new SimpleDataFilter();
        dataFilter.setFilter((Filter)new ExampleFilter((Object)example));
        dataFilter.setSort(new Sort());
        dataFilter.getSort().addField(new Sort.Field("name", Sort.Field.Direction.ASC, false));
        PageDataResult dataResult = this.getManagersList().getCategoryManager().find(this.getUserData().getCompetition(), (DataFilter)dataFilter);
        for (Category category : dataResult.getData()) {
            categories.put(category.getCategoryId(), category.getName());
        }
        return categories;
    }

    private void addFormOptions(Model model, Locale locale) {
        model.addAttribute("categoryOptions", this.getCategories());
    }

    @RequestMapping
    public String list(HttpServletRequest request, Model model, @ModelAttribute(value="categoryGroupListFilter") SearchFilter searchFilter, @RequestParam(value="messageCode", required=false, defaultValue="0") Integer messageCode) {
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        CategoryGroup example = new CategoryGroup();
        example.setName("%" + searchFilter.getSearch().trim() + "%");
        SimpleDataFilter dataFilter = new SimpleDataFilter();
        dataFilter.setFilter((Filter)new ExampleFilter((Object)example));
        dataFilter.setSort(new Sort());
        dataFilter.getSort().addField(new Sort.Field("name", Sort.Field.Direction.ASC, false));
        dataFilter.setItemCountPerPage(searchFilter.getShowPerPage().intValue());
        dataFilter.setPage(searchFilter.getPage().intValue());
        PageDataResult dataResult = this.getManagersList().getCategoryGroupManager().findCategoryGroups(this.getUserData().getCompetition(), (DataFilter)dataFilter);
        model.addAttribute("categoryGroups", (Object)dataResult.getData());
        model.addAttribute("totalPages", (Object)dataResult.getPageCount(true));
        if (messageCode.equals(1)) {
            model.addAttribute("message", (Object)this.getLanguageText(locale, "categoryGroups.text.added"));
        } else if (messageCode.equals(2)) {
            model.addAttribute("message", (Object)this.getLanguageText(locale, "categoryGroups.text.updated"));
        } else if (messageCode.equals(3)) {
            model.addAttribute("message", (Object)this.getLanguageText(locale, "categoryGroups.text.deleted"));
        } else if (messageCode.equals(4)) {
            model.addAttribute("message", (Object)this.getLanguageText(locale, "categoryGroups.text.imported"));
        }
        return "data/categorygroup-list";
    }

    @MethodRight(value={Right.CATEGORYEDIT})
    @RequestMapping(value={"/add"}, method={RequestMethod.GET})
    public String add(HttpServletRequest request, Model model, @ModelAttribute(value="categoryGroup") CategoryGroupModel categoryGroupModel, BindingResult bindingResult) {
        model.addAttribute("adding", (Object)true);
        this.addFormOptions(model, RequestContextUtils.getLocale((HttpServletRequest)request));
        return "data/categorygroup-edit";
    }

    @MethodRight(value={Right.CATEGORYEDIT})
    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public String addPost(HttpServletRequest request, Model model, @ModelAttribute(value="categoryGroup") @Valid CategoryGroupModel categoryGroupModel, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return this.add(request, model, categoryGroupModel, bindingResult);
        }
        CategoryGroup categoryGroup = new CategoryGroup();
        ObjectUtil.copyNotNullProperties((Object)categoryGroupModel, (Object)categoryGroup);
        categoryGroup.setCompetition(this.getUserData().getCompetition());
        categoryGroup = this.getManagersList().getCategoryGroupManager().createCategoryGroup(categoryGroup);
        LinkedList<Category> categories = new LinkedList<Category>();
        for (Long categoryId : categoryGroupModel.getCategoryIds()) {
            Category category = this.getManagersList().getCategoryManager().getById(categoryId);
            if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForCategory(category).getCompetitionId())) {
                throw new ForbiddenException("Invalid competition");
            }
            categories.add(category);
        }
        this.getManagersList().getCategoryGroupManager().setCategoriesForGroup(categoryGroup, categories);
        return "redirect:/data/category-groups?messageCode=1";
    }

    @MethodRight(value={Right.CATEGORYEDIT})
    @RequestMapping(value={"/edit/{categoryGroupId}"}, method={RequestMethod.GET})
    public String edit(HttpServletRequest request, Model model, @PathVariable(value="categoryGroupId") Long categoryGroupId, @ModelAttribute(value="categoryGroup") CategoryGroupModel categoryGroupModel, BindingResult bindingResult) {
        if (!bindingResult.hasErrors()) {
            CategoryGroup categoryGroup = this.getManagersList().getCategoryGroupManager().getCategoryGroupById(categoryGroupId);
            if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForCategoryGroup(categoryGroup).getCompetitionId())) {
                throw new ForbiddenException("Invalid competition");
            }
            ObjectUtil.copyNotNullProperties((Object)categoryGroup, (Object)categoryGroupModel);
            List categories = this.getManagersList().getCategoryGroupManager().getCategoriesForGroup(categoryGroup);
            for (Category category : categories) {
                categoryGroupModel.getCategoryIds().add(category.getCategoryId());
            }
        }
        this.addFormOptions(model, RequestContextUtils.getLocale((HttpServletRequest)request));
        return "data/categorygroup-edit";
    }

    @MethodRight(value={Right.CATEGORYEDIT})
    @RequestMapping(value={"/edit/{categoryGroupId}"}, method={RequestMethod.POST})
    public String editPost(HttpServletRequest request, Model model, @PathVariable(value="categoryGroupId") Long categoryGroupId, @ModelAttribute(value="categoryGroup") @Valid CategoryGroupModel categoryGroupModel, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return this.edit(request, model, categoryGroupId, categoryGroupModel, bindingResult);
        }
        CategoryGroup categoryGroup = this.getManagersList().getCategoryGroupManager().getCategoryGroupById(categoryGroupId);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForCategoryGroup(categoryGroup).getCompetitionId())) {
            throw new ForbiddenException("Invalid competition");
        }
        ObjectUtil.copyNotNullProperties((Object)categoryGroupModel, (Object)categoryGroup);
        categoryGroup = this.getManagersList().getCategoryGroupManager().updateCategoryGroup(categoryGroup);
        LinkedList<Category> categories = new LinkedList<Category>();
        for (Long categoryId : categoryGroupModel.getCategoryIds()) {
            Category category = this.getManagersList().getCategoryManager().getById(categoryId);
            if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForCategory(category).getCompetitionId())) {
                throw new ForbiddenException("Invalid competition");
            }
            categories.add(category);
        }
        this.getManagersList().getCategoryGroupManager().setCategoriesForGroup(categoryGroup, categories);
        return "redirect:/data/category-groups?messageCode=2";
    }

    @MethodRight(value={Right.CATEGORYEDIT})
    @RequestMapping(value={"/delete/{categoryGroupId}"})
    public String delete(HttpServletRequest request, Model model, @PathVariable(value="categoryGroupId") Long categoryGroupId) {
        CategoryGroup categoryGroup = this.getManagersList().getCategoryGroupManager().getCategoryGroupById(categoryGroupId);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForCategoryGroup(categoryGroup).getCompetitionId())) {
            throw new ForbiddenException("Invalid competition");
        }
        this.getManagersList().getCategoryGroupManager().deleteCategoryGroup(categoryGroup);
        return "redirect:/data/category-groups?messageCode=3";
    }

    @MethodRight(value={Right.CATEGORYEDIT})
    @RequestMapping(value={"/import"}, method={RequestMethod.GET})
    public String importData(HttpServletRequest request, Model model, @ModelAttribute(value="data") ImportDataModel importDataModel) {
        return "data/categorygroup-import";
    }

    @MethodRight(value={Right.CATEGORYEDIT})
    @RequestMapping(value={"/import"}, method={RequestMethod.POST})
    public String importDataPost(HttpServletRequest request, Model model, @ModelAttribute(value="data") ImportDataModel importDataModel) {
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        try {
            List categoryGroups = this.getManagersList().getCategoryGroupImporter().parseCategoryGroups(importDataModel.getFileType(), importDataModel.getFile().getBytes());
            this.getManagersList().getCategoryGroupImporter().importCategoryGroups(this.getUserData().getCompetition(), categoryGroups);
            return "redirect:/data/category-groups?messageCode=4";
        }
        catch (DataImportException e) {
            if (e.getErrorType() == DataImportException.ErrorType.NoCategoryGroupName) {
                model.addAttribute("errorText", (Object)this.getLanguageText(locale, "categoryGroups.error.noCategoryGroupName"));
                return this.importData(request, model, importDataModel);
            }
            LOGGER.error("Error while reading tatami data", (Throwable)e);
            model.addAttribute("errorText", (Object)this.getLanguageText(locale, "categoryGroups.error.importError"));
            return this.importData(request, model, importDataModel);
        }
        catch (Exception e) {
            LOGGER.error("Error while reading category group data", (Throwable)e);
            model.addAttribute("errorText", (Object)this.getLanguageText(locale, "categoryGroups.error.importError"));
            return this.importData(request, model, importDataModel);
        }
    }

    @RequestMapping(value={"/export/{fileType}"})
    public void exportData(HttpServletRequest request, HttpServletResponse response, Model model, @PathVariable(value="fileType") FileType fileType) {
        Locale locale = RequestContextUtils.getLocale((HttpServletRequest)request);
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        Competition competition = this.getUserData().getCompetition();
        String fileName = competition.getName() + "-" + this.getLanguageText(locale, "categoryGroups.export.fileName");
        if (fileType == FileType.CSV) {
            fileName = fileName + ".csv";
            response.setContentType("text/csv");
        } else if (fileType == FileType.ODS) {
            fileName = fileName + ".ods";
            response.setContentType("application/vnd.oasis.opendocument.spreadsheet");
        } else if (fileType == FileType.XLS) {
            fileName = fileName + ".xls";
            response.setContentType("application/vnd.ms-excel");
        } else if (fileType == FileType.XLSX) {
            fileName = fileName + ".xlsx";
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        }
        fileName = Normalizer.normalize(fileName, Normalizer.Form.NFD).replaceAll("[^\\p{Alnum}\\x20\\x2B\\x2D\\x2E\\x5F]", "");
        response.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
        List categoryGroups = this.getManagersList().getCategoryGroupManager().findCategoryGroups(competition, (DataFilter)new SimpleDataFilter()).getData();
        String[] header = new String[]{this.getLanguageText(locale, "categoryGroups.export.name")};
        try {
            byte[] data = this.getManagersList().getCategoryGroupImporter().exportCategoryGroups(fileType, categoryGroups, header);
            response.getOutputStream().write(data);
            response.getOutputStream().close();
        }
        catch (Exception e) {
            LOGGER.error("Error writeing to output stream", (Throwable)e);
        }
    }
}

