/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.web.controllers.competition;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import si.nevensrok.common.dl.query.DataFilter;
import si.nevensrok.common.dl.query.ExampleFilter;
import si.nevensrok.common.dl.query.Filter;
import si.nevensrok.common.dl.query.SimpleDataFilter;
import si.nevensrok.common.dl.query.Sort;
import si.nevensrok.common.objects.ObjectCompare;
import si.nevensrok.common.web.util.ControllerUtil;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.competitors.Competitor;
import si.nevensrok.jtekma.common.matches.Rank;
import si.nevensrok.jtekma.common.rules.CompetitionRules;
import si.nevensrok.jtekma.common.rules.DuoTable;
import si.nevensrok.jtekma.server.web.common.competition.Duo2023Placing;
import si.nevensrok.jtekma.server.web.common.competition.Duo2023Table;
import si.nevensrok.jtekma.server.web.common.competition.Placing;
import si.nevensrok.jtekma.server.web.common.competition.Table;
import si.nevensrok.jtekma.server.web.controllers.CoreController;
import si.nevensrok.jtekma.server.web.security.ForbiddenException;

@Controller
@RequestMapping(value={"/competition/data"})
public class CompetitionDataCategoryController
extends CoreController {
    @RequestMapping(value={"/category"}, method={RequestMethod.GET})
    @ResponseBody
    public List<si.nevensrok.jtekma.server.web.common.competition.Category> getCategoryList(HttpServletResponse response) {
        ControllerUtil.addNonCacheHeaders((HttpServletResponse)response);
        Category example = new Category();
        example.setStatus(Category.Status.ACTIVE);
        SimpleDataFilter dataFilter = new SimpleDataFilter();
        dataFilter.setFilter((Filter)new ExampleFilter((Object)example));
        dataFilter.setItemLimit(Integer.valueOf(1000));
        dataFilter.setSort(new Sort());
        dataFilter.getSort().addField(new Sort.Field("name", Sort.Field.Direction.ASC, false));
        LinkedList<si.nevensrok.jtekma.server.web.common.competition.Category> categories = new LinkedList<si.nevensrok.jtekma.server.web.common.competition.Category>();
        List categoryList = this.getManagersList().getCategoryManager().find(this.getUserData().getCompetition(), (DataFilter)dataFilter).getData();
        HashMap showCategoryById = new HashMap();
        for (Map.Entry entry : this.getManagersList().getCategoryManager().getShowCategoryForUser(this.getUserData().getLoginedUser(), new HashSet(categoryList)).entrySet()) {
            showCategoryById.put(((Category)entry.getKey()).getCategoryId(), entry.getValue());
        }
        for (Category category : categoryList) {
            si.nevensrok.jtekma.server.web.common.competition.Category c = new si.nevensrok.jtekma.server.web.common.competition.Category(category);
            c.setShow((Boolean)showCategoryById.get(category.getCategoryId()));
            categories.add(c);
        }
        return categories;
    }

    @RequestMapping(value={"/category/{categoryId}"}, method={RequestMethod.GET})
    @ResponseBody
    public si.nevensrok.jtekma.server.web.common.competition.Category getCategoryById(HttpServletResponse response, @PathVariable(value="categoryId") Long categoryId) {
        ControllerUtil.addNonCacheHeaders((HttpServletResponse)response);
        Category category = this.getManagersList().getCategoryManager().getById(categoryId);
        if (category != null) {
            if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForCategory(category).getCompetitionId())) {
                throw new ForbiddenException("Invalid competition for category");
            }
            return new si.nevensrok.jtekma.server.web.common.competition.Category(category);
        }
        return null;
    }

    @RequestMapping(value={"/show-category/{categoryId}/{show}"}, method={RequestMethod.GET})
    public void setCategoryById(HttpServletResponse response, @PathVariable(value="categoryId") Long categoryId, @PathVariable(value="show") Boolean show) {
        ControllerUtil.addNonCacheHeaders((HttpServletResponse)response);
        Category category = this.getManagersList().getCategoryManager().getById(categoryId);
        if (category != null) {
            if (!this.getUserData().getCompetition().getCompetitionId().equals(this.getManagersList().getCompetitionManager().getCompetitionForCategory(category).getCompetitionId())) {
                throw new ForbiddenException("Invalid competition for category");
            }
            HashMap<Category, Boolean> categories = new HashMap<Category, Boolean>();
            categories.put(category, show);
            this.getManagersList().getCategoryManager().setShowCategoryForUser(this.getUserData().getLoginedUser(), categories);
        }
    }

    @RequestMapping(value={"/table"}, method={RequestMethod.GET})
    @ResponseBody
    public Table getTable(HttpServletResponse response, @RequestParam(value="categoryId") Long categoryId) {
        ControllerUtil.addNonCacheHeaders((HttpServletResponse)response);
        Category category = new Category();
        category.setCategoryId(categoryId);
        Competition competition = this.getManagersList().getCompetitionManager().getCompetitionForCategory(category);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(competition.getCompetitionId())) {
            throw new ForbiddenException("Invalid competition for category");
        }
        CompetitionRules competitionRules = this.getManagersList().getRulesManager().getCompetitionRules(competition.getRules());
        if (competitionRules == null) {
            throw new RuntimeException("CompetitionRules for competition not found");
        }
        si.nevensrok.jtekma.common.rules.Table table = this.getManagersList().getCategoryTreeUpdateManager().getTable(category);
        competitionRules.setPlacingsInTable(table);
        return new Table(table);
    }

    @RequestMapping(value={"/duo-tables"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Duo2023Table> getDuoTables(HttpServletResponse response, @RequestParam(value="categoryId") Long categoryId) {
        ControllerUtil.addNonCacheHeaders((HttpServletResponse)response);
        Category category = new Category();
        category.setCategoryId(categoryId);
        Competition competition = this.getManagersList().getCompetitionManager().getCompetitionForCategory(category);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(competition.getCompetitionId())) {
            throw new ForbiddenException("Invalid competition for category");
        }
        CompetitionRules competitionRules = this.getManagersList().getRulesManager().getCompetitionRules(competition.getRules());
        if (competitionRules == null) {
            throw new RuntimeException("CompetitionRules for competition not found");
        }
        List duoTables = this.getManagersList().getCategoryTreeUpdateManager().getDuoTables(category);
        for (DuoTable duoTable : duoTables) {
            competitionRules.setPlacingsInDuoTable(duoTable);
        }
        LinkedList<Duo2023Table> list = new LinkedList<Duo2023Table>();
        for (DuoTable duoTable : duoTables) {
            list.add(new Duo2023Table(duoTable));
        }
        return list;
    }

    @RequestMapping(value={"/placings"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Placing> getPlacings(HttpServletResponse response, @RequestParam(value="categoryId") Long categoryId) {
        ControllerUtil.addNonCacheHeaders((HttpServletResponse)response);
        Category category = new Category();
        category.setCategoryId(categoryId);
        Competition competition = this.getManagersList().getCompetitionManager().getCompetitionForCategory(category);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(competition.getCompetitionId())) {
            throw new ForbiddenException("Invalid competition for category");
        }
        CompetitionRules competitionRules = this.getManagersList().getRulesManager().getCompetitionRules(competition.getRules());
        if (competitionRules == null) {
            throw new RuntimeException("CompetitionRules for competition not found");
        }
        ArrayList<Placing> placings = new ArrayList<Placing>();
        Map placingMap = this.getManagersList().getCategoryTreeUpdateManager().getPlacings(category);
        if (placingMap != null) {
            for (Map.Entry entry : placingMap.entrySet()) {
                placings.add(new Placing((Integer)entry.getValue(), new si.nevensrok.jtekma.server.web.common.competition.Competitor((Competitor)entry.getKey())));
            }
        }
        Collections.sort(placings, new Comparator<Placing>(){

            @Override
            public int compare(Placing o1, Placing o2) {
                return new ObjectCompare().addValue((Comparable)o1.getPlace(), (Object)o2.getPlace()).addValue((Comparable)((Object)o1.getCompetitor().getName()), (Object)o2.getCompetitor().getName()).calculateCompare();
            }
        });
        return placings;
    }

    @RequestMapping(value={"/duo-2023-placings"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Duo2023Placing> getDuo2023Placings(HttpServletResponse response, @RequestParam(value="categoryId") Long categoryId) {
        ControllerUtil.addNonCacheHeaders((HttpServletResponse)response);
        Category category = new Category();
        category.setCategoryId(categoryId);
        Competition competition = this.getManagersList().getCompetitionManager().getCompetitionForCategory(category);
        if (!this.getUserData().getCompetition().getCompetitionId().equals(competition.getCompetitionId())) {
            throw new ForbiddenException("Invalid competition for category");
        }
        CompetitionRules competitionRules = this.getManagersList().getRulesManager().getCompetitionRules(competition.getRules());
        if (competitionRules == null) {
            throw new RuntimeException("CompetitionRules for competition not found");
        }
        ArrayList<Duo2023Placing> placings = new ArrayList<Duo2023Placing>();
        for (Rank rank : Rank.values()) {
            Map placingMap = this.getManagersList().getCategoryTreeUpdateManager().getPlacings(category, rank);
            if (placingMap == null) continue;
            for (Map.Entry entry : placingMap.entrySet()) {
                placings.add(new Duo2023Placing(rank, (Integer)entry.getValue(), new si.nevensrok.jtekma.server.web.common.competition.Competitor((Competitor)entry.getKey())));
            }
        }
        Collections.sort(placings, new Comparator<Duo2023Placing>(){

            @Override
            public int compare(Duo2023Placing o1, Duo2023Placing o2) {
                return new ObjectCompare().addValue(o1.getRank().ordinal(), o2.getRank().ordinal()).addValue((Comparable)o1.getPlace(), (Object)o2.getPlace()).addValue((Comparable)((Object)o1.getCompetitor().getName()), (Object)o2.getCompetitor().getName()).calculateCompare();
            }
        });
        return placings;
    }
}

