/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.web.util;

import java.util.Collection;

public final class RequestMappingUtil {
    private RequestMappingUtil() {
    }

    public static boolean matchesMapping(String path, Collection<String> mappings) {
        for (String mapping : mappings) {
            if (!path.toLowerCase().matches(RequestMappingUtil.buildPathRegex(mapping.toLowerCase()))) continue;
            return true;
        }
        return false;
    }

    public static boolean matchesMapping(String path, String ... mappings) {
        for (String mapping : mappings) {
            if (!path.toLowerCase().matches(RequestMappingUtil.buildPathRegex(mapping.toLowerCase()))) continue;
            return true;
        }
        return false;
    }

    private static String buildPathRegex(String path) {
        StringBuilder regex = new StringBuilder();
        for (int i = 0; i < path.length(); ++i) {
            if (path.charAt(i) == '?') {
                regex.append("[^\\x2F]");
                continue;
            }
            if (path.charAt(i) == '*' && path.length() - 1 > i && path.charAt(i + 1) == '*') {
                regex.append("[^\\x2F]*(\\x2F[^\\x2F]+)*");
                continue;
            }
            if (path.charAt(i) == '*') {
                regex.append("[^\\x2F]*");
                continue;
            }
            regex.append("\\x");
            regex.append(Integer.toHexString(path.charAt(i)));
        }
        return regex.toString();
    }

    public static int comparePathsByBetterMatch(String path1, String path2) {
        int question2;
        int star2;
        int next2;
        int question1;
        int star1 = path1.indexOf(42);
        int next1 = Math.min(star1 >= 0 ? star1 : Integer.MAX_VALUE, (question1 = path1.indexOf(63)) >= 0 ? question1 : Integer.MAX_VALUE);
        if (next1 == Integer.MAX_VALUE) {
            next1 = -1;
        }
        if ((next2 = Math.min((star2 = path2.indexOf(42)) >= 0 ? star2 : Integer.MAX_VALUE, (question2 = path2.indexOf(63)) >= 0 ? question2 : Integer.MAX_VALUE)) == Integer.MAX_VALUE) {
            next2 = -1;
        }
        if (next1 < 0 && next2 < 0) {
            return 0;
        }
        if (next1 < 0 || next2 < 0) {
            if (next1 < 0) {
                return -1;
            }
            if (next2 < 0) {
                return 1;
            }
        } else {
            if (next1 < next2) {
                return 1;
            }
            if (next2 < next1) {
                return -1;
            }
            if (next1 == next2) {
                if (star1 == next1 && star2 != next2) {
                    return 1;
                }
                if (star1 != next1 && star2 == next2) {
                    return -1;
                }
            }
        }
        String subPath1 = path1.substring(next1 + 1, path1.length());
        String subPath2 = path2.substring(next2 + 1, path2.length());
        return RequestMappingUtil.comparePathsByBetterMatch(subPath1, subPath2);
    }
}

