/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.reports.impl;

import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.MessageSource;
import si.nevensrok.common.messagesource.ExternalMessageSource;
import si.nevensrok.common.messagesource.MessageLoader;
import si.nevensrok.common.textrenderer.TextRenderer;
import si.nevensrok.common.textrenderer.velocity.ContextData;
import si.nevensrok.jtekma.server.reports.impl.ResourceLoaderConfiguration;

public class VelocityTextRenderer
implements TextRenderer,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(VelocityTextRenderer.class);
    private ResourceLoaderConfiguration resourceLoaderConfiguration = null;
    private MessageLoader messageLoader;
    private String prefix = "";
    private String suffix = "";
    private Map<String, Object> toolbox;
    private VelocityEngine velocityEngine;
    private List<String> macroLibraries = new LinkedList<String>();

    public VelocityTextRenderer() {
        this.macroLibraries.add("/si/nevensrok/common/textrenderer/velocity/springMessage.vm");
    }

    public ResourceLoaderConfiguration getResourceLoaderConfiguration() {
        return this.resourceLoaderConfiguration;
    }

    public void setResourceLoaderConfiguration(ResourceLoaderConfiguration resourceLoaderConfiguration) {
        this.resourceLoaderConfiguration = resourceLoaderConfiguration;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public MessageLoader getMessageLoader() {
        return this.messageLoader;
    }

    public void setMessageLoader(MessageLoader messageLoader) {
        this.messageLoader = messageLoader;
    }

    public Map<String, Object> getToolbox() {
        return this.toolbox;
    }

    public void setToolbox(Map<String, Object> toolbox) {
        this.toolbox = toolbox;
    }

    public void afterPropertiesSet() throws Exception {
        LOGGER.debug("Initializing velocity engine");
        this.velocityEngine = new VelocityEngine();
        this.velocityEngine.setProperty("resource.loader", (Object)"classpath");
        this.velocityEngine.setProperty("classpath.resource.loader.class", (Object)this.resourceLoaderConfiguration.getResourceLoaderClassname());
        if (this.resourceLoaderConfiguration.getConfiguration() != null) {
            for (String key : this.resourceLoaderConfiguration.getConfiguration().keySet()) {
                String value = this.resourceLoaderConfiguration.getConfiguration().get(key);
                LOGGER.debug("Adding velocity property: {}={}", (Object)key, (Object)value);
                this.velocityEngine.setProperty("classpath.resource.loader." + key, (Object)value);
            }
        }
        this.velocityEngine.setProperty("runtime.log.logsystem.class", (Object)"si.nevensrok.jtekma.server.reports.impl.VelocityLogger");
        this.velocityEngine.init();
        LOGGER.debug("Velocity engine initialized");
    }

    public String renderText(String file, Map<String, Object> data) {
        return this.renderText(file, data, null);
    }

    public String renderText(String file, Map<String, Object> data, Locale locale) {
        String templateFilePath = this.prefix + file + this.suffix;
        LOGGER.debug("Using template: {}", (Object)templateFilePath);
        Template template = this.velocityEngine.getTemplate(templateFilePath);
        VelocityContext context = new VelocityContext();
        for (String key : data.keySet()) {
            context.put(key, data.get(key));
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        ContextData contextData = new ContextData();
        contextData.setLocale(locale);
        ExternalMessageSource messageSource = new ExternalMessageSource();
        messageSource.setMessageLoader(this.messageLoader);
        try {
            messageSource.afterPropertiesSet();
        }
        catch (Exception e) {
            LOGGER.error("Error initializing message source", (Throwable)e);
        }
        contextData.setMessageSource((MessageSource)messageSource);
        context.put("contextData", (Object)contextData);
        if (this.toolbox != null) {
            for (String key : this.toolbox.keySet()) {
                Object tool = this.toolbox.get(key);
                context.put(key, tool);
            }
        }
        StringWriter writer = new StringWriter();
        template.merge((Context)context, (Writer)writer, this.macroLibraries);
        return writer.toString();
    }
}

