/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.reports.impl;

import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.nevensrok.common.dl.query.DataFilter;
import si.nevensrok.common.dl.query.ExampleFilter;
import si.nevensrok.common.dl.query.Filter;
import si.nevensrok.common.dl.query.PageDataResult;
import si.nevensrok.common.dl.query.SimpleDataFilter;
import si.nevensrok.common.dl.query.Sort;
import si.nevensrok.common.documents.DocumentCreator;
import si.nevensrok.common.documents.common.Document;
import si.nevensrok.common.messagesource.MessageLoader;
import si.nevensrok.common.objects.ObjectCompare;
import si.nevensrok.common.utils.MapUtil;
import si.nevensrok.common.utils.ObjectUtil;
import si.nevensrok.common.utils.StringUtil;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.category.Duo2023Category;
import si.nevensrok.jtekma.common.category.TreeCategory;
import si.nevensrok.jtekma.common.club.Club;
import si.nevensrok.jtekma.common.club.ClubCompetitorPoints;
import si.nevensrok.jtekma.common.club.ClubPlacing;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.competitors.Competitor;
import si.nevensrok.jtekma.common.competitors.CompetitorRanking;
import si.nevensrok.jtekma.common.competitors.CoupleCompetitor;
import si.nevensrok.jtekma.common.competitors.PersonCompetitor;
import si.nevensrok.jtekma.common.management.RulesManager;
import si.nevensrok.jtekma.common.matches.Match;
import si.nevensrok.jtekma.common.matches.MatchPoint;
import si.nevensrok.jtekma.common.matches.Rank;
import si.nevensrok.jtekma.common.matches.Round;
import si.nevensrok.jtekma.common.rules.CompetitionRules;
import si.nevensrok.jtekma.common.rules.CompetitorType;
import si.nevensrok.jtekma.common.rules.DuoTable;
import si.nevensrok.jtekma.common.rules.SelectType;
import si.nevensrok.jtekma.common.rules.Table;
import si.nevensrok.jtekma.common.rules.TreeAdvancment;
import si.nevensrok.jtekma.common.rules.TreeAdvancmentItem;
import si.nevensrok.jtekma.common.rules.TreeType;
import si.nevensrok.jtekma.server.management.CategoryManager;
import si.nevensrok.jtekma.server.management.CategoryTreeUpdateManager;
import si.nevensrok.jtekma.server.management.ClubManager;
import si.nevensrok.jtekma.server.management.CompetitionManager;
import si.nevensrok.jtekma.server.management.MatchManager;
import si.nevensrok.jtekma.server.reports.DocumentType;
import si.nevensrok.jtekma.server.reports.ReportGenerator;
import si.nevensrok.jtekma.server.reports.impl.CategoryData;
import si.nevensrok.jtekma.server.reports.impl.CategoryPlacingData;
import si.nevensrok.jtekma.server.reports.impl.CompetitorPlacingData;
import si.nevensrok.jtekma.server.reports.impl.DocumentGenerator;
import si.nevensrok.jtekma.server.reports.impl.MatchData;
import si.nevensrok.jtekma.server.reports.impl.MedalsCount;
import si.nevensrok.jtekma.server.reports.impl.PlacingData;
import si.nevensrok.jtekma.server.tools.MatchNumberTool;

public class DocumentReportGenerator
implements ReportGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentReportGenerator.class);
    private static final DecimalFormat FIGHT_POINTS_FORMAT;
    private static final DecimalFormat DUO_POINTS_FORMAT;
    private static final DecimalFormat NEWAZZA_POINTS_FORMAT;
    private static final DecimalFormat DUO_PRESENTATION_POINTS_FORMAT;
    private MessageLoader messageLoader;
    private DocumentGenerator documentGenerator;
    private DocumentCreator pdfDocumentCreator;
    private DocumentCreator odfDocumentCreator;
    private CategoryManager categoryManager;
    private CategoryTreeUpdateManager categoryTreeUpdateManager;
    private RulesManager rulesManager;
    private CompetitionManager competitionManager;
    private MatchManager matchManager;
    private ClubManager clubManager;

    public void setMessageLoader(MessageLoader messageLoader) {
        this.messageLoader = messageLoader;
    }

    public void setDocumentGenerator(DocumentGenerator documentGenerator) {
        this.documentGenerator = documentGenerator;
    }

    public void setPdfDocumentCreator(DocumentCreator pdfDocumentCreator) {
        this.pdfDocumentCreator = pdfDocumentCreator;
    }

    public void setOdfDocumentCreator(DocumentCreator odfDocumentCreator) {
        this.odfDocumentCreator = odfDocumentCreator;
    }

    public void setCategoryManager(CategoryManager categoryManager) {
        this.categoryManager = categoryManager;
    }

    public void setCategoryTreeUpdateManager(CategoryTreeUpdateManager categoryTreeUpdateManager) {
        this.categoryTreeUpdateManager = categoryTreeUpdateManager;
    }

    public void setRulesManager(RulesManager rulesManager) {
        this.rulesManager = rulesManager;
    }

    public void setCompetitionManager(CompetitionManager competitionManager) {
        this.competitionManager = competitionManager;
    }

    public void setMatchManager(MatchManager matchManager) {
        this.matchManager = matchManager;
    }

    public void setClubManager(ClubManager clubManager) {
        this.clubManager = clubManager;
    }

    /*
     * Could not resolve type clashes
     */
    public void generateTreeReport(DocumentType documentType, Locale locale, OutputStream outputStream, List<Category> categories, boolean empty) {
        try {
            LinkedList<CategoryData> categoryDatas = new LinkedList<CategoryData>();
            for (Category category : categories) {
                Competition competition = this.competitionManager.getCompetitionForCategory(category = this.categoryManager.getFullById(category.getCategoryId()));
                CompetitionRules competitionRules = this.rulesManager.getCompetitionRules(competition.getRules());
                if (competitionRules == null) {
                    throw new RuntimeException("CompetitionRules for competition not found");
                }
                String[][] tableContent = null;
                LinkedHashMap<Round, Map<Rank, Map<Integer, String[][]>>> duoTable = null;
                LinkedList<MatchData> matchDatas = new LinkedList<MatchData>();
                LinkedHashMap<Rank, List<MatchData>> matchDataForRank = new LinkedHashMap<Rank, List<MatchData>>();
                ArrayList<PlacingData> placingDatas = new ArrayList<PlacingData>();
                LinkedHashMap<Rank, List<PlacingData>> placingsForRanks = new LinkedHashMap<Rank, List<PlacingData>>();
                boolean display3rdPlaceMatch = false;
                TreeCategory.TreeType treeType = null;
                TreeCategory.RepassageType repassageType = null;
                boolean custom = false;
                if (category instanceof TreeCategory) {
                    Object points2text;
                    HashMap<Integer, Match> matches = new HashMap<Integer, Match>();
                    List matchList = this.matchManager.getMatchesForCategory(category);
                    for (Match match : matchList) {
                        matches.put(match.getFightNumber(), match);
                    }
                    Round[] treeCategory = (Round[])category;
                    display3rdPlaceMatch = treeCategory.getDouble3rdPlace() == false;
                    treeType = treeCategory.getTreeType();
                    repassageType = treeCategory.getRepassageType();
                    TreeAdvancment treeAdvancment = treeCategory.getTreeAdvancment();
                    if (treeCategory.getTreeType() == TreeCategory.TreeType.BEST_OF_3) {
                        for (int i = 1; i <= 3; ++i) {
                            Match match = (Match)matches.get(i);
                            Set matchPoints = this.matchManager.getMatchPointsForMatch(match);
                            String competitor1 = "";
                            String competitor2 = "";
                            float points1 = DocumentReportGenerator.getPointsForMatch(match, CompetitorType.COMPETITOR1, competitionRules, matchPoints);
                            float points2 = DocumentReportGenerator.getPointsForMatch(match, CompetitorType.COMPETITOR2, competitionRules, matchPoints);
                            String points1text = "";
                            points2text = "";
                            if (match.getCompetitor1() != null) {
                                competitor1 = DocumentReportGenerator.getCompetitorShortName(match.getCompetitor1(), false);
                                if (!empty && (points1 > 0.0f || points2 > 0.0f)) {
                                    points1text = DocumentReportGenerator.getPointsText(match, points1);
                                }
                            }
                            if (match.getCompetitor2() != null) {
                                competitor2 = DocumentReportGenerator.getCompetitorShortName(match.getCompetitor2(), false);
                                if (!empty && (points1 > 0.0f || points2 > 0.0f)) {
                                    points2text = DocumentReportGenerator.getPointsText(match, points2);
                                }
                            }
                            matchDatas.add(new MatchData(competitor1, competitor2, points1text, (String)points2text));
                        }
                    } else if (treeCategory.getTreeType() == TreeCategory.TreeType.TABLE2 || treeCategory.getTreeType() == TreeCategory.TreeType.TABLE3 || treeCategory.getTreeType() == TreeCategory.TreeType.TABLE4 || treeCategory.getTreeType() == TreeCategory.TreeType.TABLE5) {
                        Table table = this.categoryTreeUpdateManager.getTable((Category)treeCategory);
                        tableContent = new String[table.getRows().length][9];
                        int i = 0;
                        for (Table.Row row : table.getRows()) {
                            int j;
                            tableContent[i][0] = row.getCompetitor() != null ? DocumentReportGenerator.getCompetitorShortName(row.getCompetitor(), true) : "";
                            boolean atLeastOneMatchFinished = false;
                            for (j = 0; j < 5; ++j) {
                                tableContent[i][j + 1] = "";
                            }
                            j = 0;
                            for (Table.Row.Match match : row.getMatches()) {
                                String points = "";
                                if (match != null && match.getMyPoints() != null && match.getOtherPoints() != null && (match.getMyPoints().floatValue() > 0.0f || match.getOtherPoints().floatValue() > 0.0f) && !empty) {
                                    atLeastOneMatchFinished = true;
                                    if (treeCategory.getType() == Category.Type.FIGHTING) {
                                        points = FIGHT_POINTS_FORMAT.format(match.getMyPoints()) + ":" + FIGHT_POINTS_FORMAT.format(match.getOtherPoints());
                                    } else if (treeCategory.getType() == Category.Type.DUO) {
                                        points = DUO_POINTS_FORMAT.format(match.getMyPoints()) + ":" + DUO_POINTS_FORMAT.format(match.getOtherPoints());
                                    } else if (treeCategory.getType() == Category.Type.NEWAZA) {
                                        points = FIGHT_POINTS_FORMAT.format(match.getMyPoints()) + ":" + FIGHT_POINTS_FORMAT.format(match.getOtherPoints());
                                    }
                                }
                                tableContent[i][j + 1] = points;
                                ++j;
                            }
                            if (atLeastOneMatchFinished && !empty) {
                                tableContent[i][6] = row.getWins().toString();
                                tableContent[i][7] = row.getFullIpponWins().toString();
                                if (treeCategory.getType() == Category.Type.FIGHTING) {
                                    tableContent[i][8] = FIGHT_POINTS_FORMAT.format(row.getPointsGained());
                                } else if (treeCategory.getType() == Category.Type.DUO) {
                                    tableContent[i][8] = DUO_POINTS_FORMAT.format(row.getPointsGained());
                                } else if (treeCategory.getType() == Category.Type.NEWAZA) {
                                    tableContent[i][8] = FIGHT_POINTS_FORMAT.format(row.getPointsGained());
                                }
                            } else {
                                tableContent[i][6] = "";
                                tableContent[i][7] = "";
                                tableContent[i][8] = "";
                            }
                            ++i;
                        }
                        for (int i2 = 1; i2 <= 10; ++i2) {
                            Match match = (Match)matches.get(i2);
                            Object matchPoints = this.matchManager.getMatchPointsForMatch(match);
                            String competitor1 = "";
                            String competitor2 = "";
                            float points1 = DocumentReportGenerator.getPointsForMatch(match, CompetitorType.COMPETITOR1, competitionRules, (Set<MatchPoint>)matchPoints);
                            float points2 = DocumentReportGenerator.getPointsForMatch(match, CompetitorType.COMPETITOR2, competitionRules, (Set<MatchPoint>)matchPoints);
                            String points1text = "";
                            points2text = "";
                            if (match.getCompetitor1() != null) {
                                competitor1 = DocumentReportGenerator.getCompetitorShortName(match.getCompetitor1(), false);
                                if (!empty && (points1 > 0.0f || points2 > 0.0f)) {
                                    points1text = DocumentReportGenerator.getPointsText(match, points1);
                                }
                            }
                            if (match.getCompetitor2() != null) {
                                competitor2 = DocumentReportGenerator.getCompetitorShortName(match.getCompetitor2(), false);
                                if (!empty && (points1 > 0.0f || points2 > 0.0f)) {
                                    points2text = DocumentReportGenerator.getPointsText(match, points2);
                                }
                            }
                            matchDatas.add(new MatchData(competitor1, competitor2, points1text, (String)points2text));
                        }
                    } else if (treeCategory.getTreeType() == TreeCategory.TreeType.TREE4) {
                        this.addTreeMatches(117, 118, locale, (TreeCategory)treeCategory, treeAdvancment, matches, matchDatas, this.matchManager, competitionRules, empty, true);
                        this.addTreeMatches(123, 124, locale, (TreeCategory)treeCategory, treeAdvancment, matches, matchDatas, this.matchManager, competitionRules, empty, !empty);
                    } else if (treeCategory.getTreeType() == TreeCategory.TreeType.TREE8) {
                        this.addTreeMatches(105, 108, locale, (TreeCategory)treeCategory, treeAdvancment, matches, matchDatas, this.matchManager, competitionRules, empty, true);
                        this.addTreeMatches(117, 124, locale, (TreeCategory)treeCategory, treeAdvancment, matches, matchDatas, this.matchManager, competitionRules, empty, !empty);
                    } else if (treeCategory.getTreeType() == TreeCategory.TreeType.TREE16) {
                        this.addTreeMatches(81, 88, locale, (TreeCategory)treeCategory, treeAdvancment, matches, matchDatas, this.matchManager, competitionRules, empty, true);
                        this.addTreeMatches(105, 124, locale, (TreeCategory)treeCategory, treeAdvancment, matches, matchDatas, this.matchManager, competitionRules, empty, !empty);
                    } else if (treeCategory.getTreeType() == TreeCategory.TreeType.TREE32) {
                        this.addTreeMatches(33, 48, locale, (TreeCategory)treeCategory, treeAdvancment, matches, matchDatas, this.matchManager, competitionRules, empty, true);
                        this.addTreeMatches(81, 124, locale, (TreeCategory)treeCategory, treeAdvancment, matches, matchDatas, this.matchManager, competitionRules, empty, !empty);
                    } else if (treeCategory.getTreeType() == TreeCategory.TreeType.TREE64) {
                        this.addTreeMatches(1, 32, locale, (TreeCategory)treeCategory, treeAdvancment, matches, matchDatas, this.matchManager, competitionRules, empty, true);
                        this.addTreeMatches(33, 124, locale, (TreeCategory)treeCategory, treeAdvancment, matches, matchDatas, this.matchManager, competitionRules, empty, !empty);
                    }
                    if (!empty) {
                        Map placingsMap = this.categoryTreeUpdateManager.getPlacings((Category)treeCategory);
                        for (Map.Entry placingEntry : placingsMap.entrySet()) {
                            Competitor competitor = (Competitor)placingEntry.getKey();
                            placingDatas.add(new PlacingData((Integer)placingEntry.getValue(), DocumentReportGenerator.getCompetitorName(competitor)));
                        }
                        Collections.sort(placingDatas, new Comparator<PlacingData>(){

                            @Override
                            public int compare(PlacingData o1, PlacingData o2) {
                                return new ObjectCompare().addValue((Comparable)o1.getPlacing(), (Object)o2.getPlacing()).addValue((Comparable)((Object)o1.getName()), (Object)o2.getName()).calculateCompare();
                            }
                        });
                    }
                }
                if (category instanceof Duo2023Category) {
                    Duo2023Category duo2023Category = (Duo2023Category)category;
                    display3rdPlaceMatch = duo2023Category.getDouble3rdPlace() == false;
                    List duoTables = this.categoryTreeUpdateManager.getDuoTables((Category)duo2023Category);
                    duoTable = new LinkedHashMap<Round, Map<Rank, Map<Integer, String[][]>>>();
                    for (Round round : Round.values()) {
                        if (duo2023Category.getKnockoutStage().booleanValue() && (round == Round.ROUND_4 || round == Round.ROUND_5)) continue;
                        LinkedHashMap rankTables = new LinkedHashMap();
                        for (Rank rank : Rank.values()) {
                            LinkedHashMap<Integer, String[][]> numTables = new LinkedHashMap<Integer, String[][]>();
                            int maxGroups = 4;
                            int minRows = 4;
                            if (round == Round.ROUND_5) {
                                maxGroups = 1;
                                minRows = 2;
                            } else if (round == Round.ROUND_4) {
                                maxGroups = 1;
                            } else if (round == Round.ROUND_3) {
                                maxGroups = 2;
                                if (rank == Rank.ADVANCED) {
                                    minRows = 6;
                                } else if (rank == Rank.NOVICE) {
                                    minRows = 8;
                                }
                            } else if (round == Round.ROUND_2) {
                                if (rank == Rank.NOVICE) {
                                    maxGroups = 2;
                                    minRows = 8;
                                }
                            } else if (round == Round.ROUND_1) {
                                minRows = 8;
                                if (rank == Rank.NOVICE) {
                                    maxGroups = 2;
                                }
                            }
                            for (int groupNumber = 1; groupNumber <= maxGroups; ++groupNumber) {
                                int i;
                                if (rank == Rank.ADVANCED && !duo2023Category.getAdvancedLevel().booleanValue() || rank == Rank.NOVICE && (!duo2023Category.getAdvancedLevel().booleanValue() || !duo2023Category.getNoviceLevel().booleanValue())) continue;
                                int gn = groupNumber;
                                duoTable.put(round, rankTables);
                                DuoTable table = duoTables.stream().filter(t -> t.getRound() == round && t.getRank() == rank && t.getGroupNumber() == gn).findFirst().orElse(null);
                                if (table != null && table.isNotNeeded() && !empty) continue;
                                if (!(table == null || table.getRows() == null || round != Round.ROUND_1 && empty)) {
                                    minRows = table.getRows().size();
                                }
                                String[][] tableData = new String[minRows][2];
                                if (table == null || table.getRows() == null || empty && round != Round.ROUND_1) {
                                    for (i = 0; i < minRows; ++i) {
                                        tableData[i][0] = " ";
                                        tableData[i][1] = " ";
                                    }
                                } else {
                                    for (i = 0; i < table.getRows().size(); ++i) {
                                        DuoTable.Row row = (DuoTable.Row)table.getRows().get(i);
                                        tableData[i][0] = DocumentReportGenerator.getCompetitorName(row.getCompetitor());
                                        tableData[i][1] = !empty && (table.isFinished() || row.getPoints() > 0.0f) ? DUO_PRESENTATION_POINTS_FORMAT.format(row.getPoints()) : " ";
                                    }
                                }
                                numTables.put(groupNumber, tableData);
                            }
                            if (numTables.isEmpty()) continue;
                            rankTables.put(rank, numTables);
                        }
                        if (rankTables.isEmpty()) continue;
                        duoTable.put(round, rankTables);
                    }
                    if (duo2023Category.getKnockoutStage().booleanValue()) {
                        Rank[] matches = new HashMap();
                        HashMap matchPoints = new HashMap();
                        for (Match match : this.matchManager.getMatchesForCategory((Category)duo2023Category)) {
                            matches.put(match.getFightNumber(), match);
                        }
                        for (Map.Entry entry : this.matchManager.getMatchPointsForMatches(new HashSet(matches.values())).entrySet()) {
                            matchPoints.put(((Match)entry.getKey()).getFightNumber(), entry.getValue());
                        }
                        LinkedList<MatchData> matchDataList = new LinkedList<MatchData>();
                        matchDataForRank.put(Rank.WORLD_LEVEL, matchDataList);
                        this.addDuoKnockoutMatches(Rank.WORLD_LEVEL, locale, (Map<Integer, Match>)matches, matchDataList, this.matchManager, competitionRules, empty);
                        if (duo2023Category.getAdvancedLevel().booleanValue()) {
                            matchDataList = new LinkedList();
                            matchDataForRank.put(Rank.ADVANCED, matchDataList);
                            this.addDuoKnockoutMatches(Rank.ADVANCED, locale, (Map<Integer, Match>)matches, matchDataList, this.matchManager, competitionRules, empty);
                            if (duo2023Category.getNoviceLevel().booleanValue()) {
                                matchDataList = new LinkedList();
                                matchDataForRank.put(Rank.NOVICE, matchDataList);
                                this.addDuoKnockoutMatches(Rank.NOVICE, locale, (Map<Integer, Match>)matches, matchDataList, this.matchManager, competitionRules, empty);
                            }
                        }
                    }
                    if (!empty) {
                        for (Rank rank : Rank.values()) {
                            Map placingsMap;
                            if (rank == Rank.ADVANCED && !duo2023Category.getAdvancedLevel().booleanValue() || rank == Rank.NOVICE && (!duo2023Category.getAdvancedLevel().booleanValue() || !duo2023Category.getNoviceLevel().booleanValue()) || MapUtil.isEmpty((Map)(placingsMap = this.categoryTreeUpdateManager.getPlacings((Category)duo2023Category, rank)))) continue;
                            ArrayList<PlacingData> placingList = new ArrayList<PlacingData>();
                            for (Map.Entry placingEntry : placingsMap.entrySet()) {
                                Competitor competitor = (Competitor)placingEntry.getKey();
                                placingList.add(new PlacingData((Integer)placingEntry.getValue(), DocumentReportGenerator.getCompetitorName(competitor)));
                            }
                            Collections.sort(placingList, new Comparator<PlacingData>(){

                                @Override
                                public int compare(PlacingData o1, PlacingData o2) {
                                    return new ObjectCompare().addValue((Comparable)o1.getPlacing(), (Object)o2.getPlacing()).addValue((Comparable)((Object)o1.getName()), (Object)o2.getName()).calculateCompare();
                                }
                            });
                            placingsForRanks.put(rank, placingList);
                        }
                    }
                } else if (category.getType() == Category.Type.CUSTOM) {
                    custom = true;
                    ArrayList matchesForCategory = new ArrayList(this.matchManager.getMatchesForCategory(category));
                    Collections.sort(matchesForCategory, new Comparator<Match>(){

                        @Override
                        public int compare(Match o1, Match o2) {
                            return o1.getFightNumber().compareTo(o2.getFightNumber());
                        }
                    });
                    for (Match match : matchesForCategory) {
                        Set matchPoints = this.matchManager.getMatchPointsForMatch(match);
                        String competitor1 = "";
                        String competitor2 = "";
                        float points1 = DocumentReportGenerator.getPointsForMatch(match, CompetitorType.COMPETITOR1, competitionRules, matchPoints);
                        float points2 = DocumentReportGenerator.getPointsForMatch(match, CompetitorType.COMPETITOR2, competitionRules, matchPoints);
                        String points1text = "";
                        String points2text = "";
                        if (match.getCompetitor1() != null) {
                            competitor1 = DocumentReportGenerator.getCompetitorShortName(match.getCompetitor1(), false);
                            if (!empty && (points1 > 0.0f || points2 > 0.0f)) {
                                points1text = DocumentReportGenerator.getPointsText(match, points1);
                            }
                        }
                        if (match.getCompetitor2() != null) {
                            competitor2 = DocumentReportGenerator.getCompetitorShortName(match.getCompetitor2(), false);
                            if (!empty && (points1 > 0.0f || points2 > 0.0f)) {
                                points2text = DocumentReportGenerator.getPointsText(match, points2);
                            }
                        }
                        matchDatas.add(new MatchData("", "", competitor1, competitor2, points1text, points2text, match.getFightNumber().toString()));
                    }
                }
                CategoryData categoryData = new CategoryData();
                categoryData.setCategoryName(category.getName());
                categoryData.setTableContent(tableContent);
                categoryData.setDuoTableContent(duoTable);
                categoryData.setMatchDatas(matchDatas);
                categoryData.setMatchDataForRank(matchDataForRank);
                categoryData.setPlacingDatas(placingDatas);
                categoryData.setPlacingsForRanks(placingsForRanks);
                categoryData.setDisplay3rdPlaceMatch(display3rdPlaceMatch);
                categoryData.setTreeType(treeType);
                categoryData.setRepassageType(repassageType);
                categoryData.setCustom(custom);
                categoryDatas.add(categoryData);
            }
            Document document = this.documentGenerator.generateTreeReport(locale, categoryDatas, empty);
            if (documentType == DocumentType.PDF) {
                this.pdfDocumentCreator.createDocument(document, outputStream);
            } else if (documentType == DocumentType.ODT) {
                this.odfDocumentCreator.createDocument(document, outputStream);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error creating tree report", (Throwable)e);
        }
    }

    public void generatePlacingsReport(DocumentType documentType, Locale locale, OutputStream outputStream, List<Category> categories, boolean oneCategoryPerPage) {
        try {
            LinkedList<CategoryPlacingData> categoryPlacingDataList = new LinkedList<CategoryPlacingData>();
            for (Category category : categories) {
                Competition competition = this.competitionManager.getCompetitionForCategory(category = this.categoryManager.getFullById(category.getCategoryId()));
                CompetitionRules competitionRules = this.rulesManager.getCompetitionRules(competition.getRules());
                if (competitionRules == null) {
                    throw new RuntimeException("CompetitionRules for competition not found");
                }
                HashMap<Integer, Match> matches = new HashMap<Integer, Match>();
                for (Match match : this.matchManager.getMatchesForCategory(category)) {
                    matches.put(match.getFightNumber(), match);
                }
                if (category instanceof TreeCategory) {
                    TreeCategory treeCategory = (TreeCategory)category;
                    Map placingsMap = this.categoryTreeUpdateManager.getPlacings((Category)treeCategory);
                    ArrayList placings = new ArrayList(64);
                    for (Map.Entry placingEntry : placingsMap.entrySet()) {
                        Competitor competitor = (Competitor)placingEntry.getKey();
                        placings.add(new PlacingData((Integer)placingEntry.getValue(), DocumentReportGenerator.getCompetitorName(competitor)));
                    }
                    Collections.sort(placings, new Comparator<PlacingData>(){

                        @Override
                        public int compare(PlacingData o1, PlacingData o2) {
                            if (o1.getPlacing() > o2.getPlacing()) {
                                return 1;
                            }
                            if (o1.getPlacing() < o2.getPlacing()) {
                                return -1;
                            }
                            return o1.getName().compareTo(o2.getName());
                        }
                    });
                    if (placings.isEmpty()) continue;
                    CategoryPlacingData categoryPlacingData = new CategoryPlacingData(category.getName(), placings);
                    categoryPlacingDataList.add(categoryPlacingData);
                    continue;
                }
                if (!(category instanceof Duo2023Category)) continue;
                Duo2023Category duo2023Category = (Duo2023Category)category;
                LinkedHashMap<Rank, List<PlacingData>> placingsForRanks = new LinkedHashMap<Rank, List<PlacingData>>();
                for (Rank rank : Rank.values()) {
                    Map placingsMap;
                    if (rank == Rank.ADVANCED && !duo2023Category.getAdvancedLevel().booleanValue() || rank == Rank.NOVICE && (!duo2023Category.getAdvancedLevel().booleanValue() || !duo2023Category.getNoviceLevel().booleanValue()) || MapUtil.isEmpty((Map)(placingsMap = this.categoryTreeUpdateManager.getPlacings((Category)duo2023Category, rank)))) continue;
                    ArrayList<PlacingData> placingList = new ArrayList<PlacingData>();
                    for (Map.Entry placingEntry : placingsMap.entrySet()) {
                        Competitor competitor = (Competitor)placingEntry.getKey();
                        placingList.add(new PlacingData((Integer)placingEntry.getValue(), DocumentReportGenerator.getCompetitorName(competitor)));
                    }
                    Collections.sort(placingList, new Comparator<PlacingData>(){

                        @Override
                        public int compare(PlacingData o1, PlacingData o2) {
                            return new ObjectCompare().addValue((Comparable)o1.getPlacing(), (Object)o2.getPlacing()).addValue((Comparable)((Object)o1.getName()), (Object)o2.getName()).calculateCompare();
                        }
                    });
                    placingsForRanks.put(rank, placingList);
                }
                if (placingsForRanks.isEmpty()) continue;
                CategoryPlacingData categoryPlacingData = new CategoryPlacingData(category.getName(), placingsForRanks);
                categoryPlacingDataList.add(categoryPlacingData);
            }
            Document document = this.documentGenerator.generateCompetitorPlacingsDocument(locale, categoryPlacingDataList, oneCategoryPerPage);
            if (documentType == DocumentType.PDF) {
                this.pdfDocumentCreator.createDocument(document, outputStream);
            } else if (documentType == DocumentType.ODT) {
                this.odfDocumentCreator.createDocument(document, outputStream);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error creating competitor placing report", (Throwable)e);
        }
    }

    public void generateClubPlacingsReport(DocumentType documentType, Locale locale, OutputStream outputStream, Competition competition, List<Category> categories) {
        try {
            CompetitionRules competitionRules = this.rulesManager.getCompetitionRules(competition.getRules());
            if (competitionRules == null) {
                throw new RuntimeException("CompetitionRules for competition not found");
            }
            Map competitionSettings = this.competitionManager.getCompetitionSettings(competition);
            HashMap<Integer, Integer> pointsForPlace = new HashMap<Integer, Integer>();
            for (int i = 1; i <= 7; ++i) {
                if (competitionSettings.get("clubPlacing.points." + i) == null) continue;
                pointsForPlace.put(i, ((Long)competitionSettings.get("clubPlacing.points." + i)).intValue());
            }
            boolean includeOneCompetitor = competitionSettings.get("clubPlacing.includeOneCompetitor") == null ? true : (Boolean)competitionSettings.get("clubPlacing.includeOneCompetitor");
            boolean includeSameClub = competitionSettings.get("clubPlacing.includeSameClub") == null ? true : (Boolean)competitionSettings.get("clubPlacing.includeSameClub");
            boolean includeAllCompetitors = competitionSettings.get("clubPlacing.includeAllCompetitors") == null ? false : (Boolean)competitionSettings.get("clubPlacing.includeAllCompetitors");
            Club clubExample = new Club();
            clubExample.setStatus(Club.Status.ACTIVE);
            clubExample.setCountForClubPlacings(Boolean.TRUE);
            SimpleDataFilter clubDataFilter = new SimpleDataFilter();
            clubDataFilter.setFetchCount(false);
            clubDataFilter.setFilter((Filter)new ExampleFilter((Object)clubExample));
            clubDataFilter.setItemLimit(Integer.valueOf(1000));
            clubDataFilter.setSort(new Sort());
            clubDataFilter.getSort().addField(new Sort.Field("name", Sort.Field.Direction.ASC, false));
            ArrayList<ClubPlacing> clubPlacings = new ArrayList<ClubPlacing>();
            for (Club club : this.clubManager.find(competition, (DataFilter)clubDataFilter).getData()) {
                ClubPlacing clubPlacing = new ClubPlacing();
                clubPlacing.setClub(club);
                clubPlacing.setPoints(Integer.valueOf(0));
                clubPlacings.add(clubPlacing);
            }
            for (Category category : categories) {
                Map map;
                ClubCompetitorPoints clubCompetitorPoints;
                Category category2 = this.categoryManager.getById(category.getCategoryId());
                if (category2 instanceof TreeCategory) {
                    Map map2 = this.categoryTreeUpdateManager.getPlacings(category2);
                    if (map2 == null) continue;
                    for (ClubPlacing clubPlacing : clubPlacings) {
                        clubCompetitorPoints = competitionRules.getPointsForClub(clubPlacing.getClub(), map2, pointsForPlace, includeOneCompetitor, includeSameClub, includeAllCompetitors);
                        if (clubCompetitorPoints.getTopPlace() == 1) {
                            clubPlacing.setPlace_1(Integer.valueOf(clubPlacing.getPlace_1() + 1));
                        } else if (clubCompetitorPoints.getTopPlace() == 2) {
                            clubPlacing.setPlace_1(Integer.valueOf(clubPlacing.getPlace_2() + 1));
                        } else if (clubCompetitorPoints.getTopPlace() == 3) {
                            clubPlacing.setPlace_1(Integer.valueOf(clubPlacing.getPlace_3() + 1));
                        } else if (clubCompetitorPoints.getTopPlace() == 4) {
                            clubPlacing.setPlace_1(Integer.valueOf(clubPlacing.getPlace_4() + 1));
                        } else if (clubCompetitorPoints.getTopPlace() == 5) {
                            clubPlacing.setPlace_1(Integer.valueOf(clubPlacing.getPlace_5() + 1));
                        }
                        clubPlacing.setPoints(Integer.valueOf(clubPlacing.getPoints() + clubCompetitorPoints.getPoints()));
                    }
                    continue;
                }
                if (!(category2 instanceof Duo2023Category) || (map = this.categoryTreeUpdateManager.getPlacings(category2, Rank.WORLD_LEVEL)) == null) continue;
                for (ClubPlacing clubPlacing : clubPlacings) {
                    clubCompetitorPoints = competitionRules.getPointsForClub(clubPlacing.getClub(), map, pointsForPlace, includeOneCompetitor, includeSameClub, includeAllCompetitors);
                    if (clubCompetitorPoints.getTopPlace() == 1) {
                        clubPlacing.setPlace_1(Integer.valueOf(clubPlacing.getPlace_1() + 1));
                    } else if (clubCompetitorPoints.getTopPlace() == 2) {
                        clubPlacing.setPlace_1(Integer.valueOf(clubPlacing.getPlace_2() + 1));
                    } else if (clubCompetitorPoints.getTopPlace() == 3) {
                        clubPlacing.setPlace_1(Integer.valueOf(clubPlacing.getPlace_3() + 1));
                    } else if (clubCompetitorPoints.getTopPlace() == 4) {
                        clubPlacing.setPlace_1(Integer.valueOf(clubPlacing.getPlace_4() + 1));
                    } else if (clubCompetitorPoints.getTopPlace() == 5) {
                        clubPlacing.setPlace_1(Integer.valueOf(clubPlacing.getPlace_5() + 1));
                    }
                    clubPlacing.setPoints(Integer.valueOf(clubPlacing.getPoints() + clubCompetitorPoints.getPoints()));
                }
            }
            Collections.sort(clubPlacings, new Comparator<ClubPlacing>(){

                @Override
                public int compare(ClubPlacing o1, ClubPlacing o2) {
                    return new ObjectCompare().addValue((Comparable)o2.getPoints(), (Object)o1.getPoints()).addValue((Comparable)o2.getPlace_1(), (Object)o1.getPlace_1()).addValue((Comparable)o2.getPlace_2(), (Object)o1.getPlace_2()).addValue((Comparable)o2.getPlace_3(), (Object)o1.getPlace_3()).addValue((Comparable)o2.getPlace_4(), (Object)o1.getPlace_4()).addValue((Comparable)o2.getPlace_5(), (Object)o1.getPlace_5()).calculateCompare();
                }
            });
            int placeNum = 1;
            for (ClubPlacing clubPlacing : clubPlacings) {
                clubPlacing.setPlace(Integer.valueOf(placeNum++));
            }
            LinkedList<PlacingData> linkedList = new LinkedList<PlacingData>();
            for (ClubPlacing clubPlacing : clubPlacings) {
                linkedList.add(new PlacingData(clubPlacing.getPlace(), clubPlacing.getClub().getName(), clubPlacing.getPoints()));
            }
            Document document = this.documentGenerator.generateClubPlacingsDocument(locale, linkedList);
            if (documentType == DocumentType.PDF) {
                this.pdfDocumentCreator.createDocument(document, outputStream);
            } else if (documentType == DocumentType.ODT) {
                this.odfDocumentCreator.createDocument(document, outputStream);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error creating club placing report", (Throwable)e);
        }
    }

    public void generateCompetitorRankingReport(DocumentType documentType, Locale locale, OutputStream outputStream, List<CompetitorRanking> competitorRankings, List<CompetitorRanking> coupleRankings) {
        try {
            Document document = this.documentGenerator.generateCompetitorRankingDocument(locale, competitorRankings, coupleRankings);
            if (documentType == DocumentType.PDF) {
                this.pdfDocumentCreator.createDocument(document, outputStream);
            } else if (documentType == DocumentType.ODT) {
                this.odfDocumentCreator.createDocument(document, outputStream);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error creating competitor ranking report", (Throwable)e);
        }
    }

    public void generateResultsForClub(DocumentType documentType, Locale locale, OutputStream outputStream, Competition competition, Club club) {
        try {
            Category categoryExample = new Category();
            categoryExample.setStatus(Category.Status.ACTIVE);
            SimpleDataFilter categoryDataFilter = new SimpleDataFilter();
            categoryDataFilter.setFilter((Filter)new ExampleFilter((Object)categoryExample));
            PageDataResult categoryDataResult = this.categoryManager.find(competition, (DataFilter)categoryDataFilter);
            LinkedList<CompetitorPlacingData> competitorPlacingDataList = new LinkedList<CompetitorPlacingData>();
            HashMap<Integer, Integer> placingCount = new HashMap<Integer, Integer>();
            for (Category category : categoryDataResult.getData()) {
                if ((category = this.categoryManager.getById(category.getCategoryId())) instanceof TreeCategory) {
                    Map competitorPlacings = this.categoryTreeUpdateManager.getPlacings(category);
                    if (competitorPlacings == null) continue;
                    for (Map.Entry entry : competitorPlacings.entrySet()) {
                        Competitor competitor = (Competitor)entry.getKey();
                        if (!club.getClubId().equals(competitor.getClub().getClubId())) continue;
                        Integer placing = (Integer)entry.getValue();
                        CompetitorPlacingData competitorPlacingData = new CompetitorPlacingData(competitor, category, placing);
                        competitorPlacingDataList.add(competitorPlacingData);
                        Integer count = (Integer)ObjectUtil.ifNull(placingCount.get(placing), (Object)0);
                        count = count + 1;
                        placingCount.put(placing, count);
                    }
                    continue;
                }
                if (!(category instanceof Duo2023Category)) continue;
                Duo2023Category duo2023Category = (Duo2023Category)category;
                for (Rank rank : Rank.values()) {
                    Map placingsMap;
                    if (rank == Rank.ADVANCED && !duo2023Category.getAdvancedLevel().booleanValue() || rank == Rank.NOVICE && (!duo2023Category.getAdvancedLevel().booleanValue() || !duo2023Category.getNoviceLevel().booleanValue()) || MapUtil.isEmpty((Map)(placingsMap = this.categoryTreeUpdateManager.getPlacings((Category)duo2023Category, rank)))) continue;
                    for (Map.Entry competitorPlacing : placingsMap.entrySet()) {
                        Competitor competitor = (Competitor)competitorPlacing.getKey();
                        if (!club.getClubId().equals(competitor.getClub().getClubId())) continue;
                        Integer placing = (Integer)competitorPlacing.getValue();
                        CompetitorPlacingData competitorPlacingData = new CompetitorPlacingData(competitor, category, placing, rank);
                        competitorPlacingDataList.add(competitorPlacingData);
                        Integer count = (Integer)ObjectUtil.ifNull(placingCount.get(placing), (Object)0);
                        count = count + 1;
                        placingCount.put(placing, count);
                    }
                }
            }
            competitorPlacingDataList.sort(new Comparator<CompetitorPlacingData>(){

                @Override
                public int compare(CompetitorPlacingData o1, CompetitorPlacingData o2) {
                    return new ObjectCompare().addValue((Comparable)((Object)o1.getCategory().getName()), (Object)o2.getCategory().getName()).addValue((Comparable)o1.getPlacing(), (Object)o2.getPlacing()).calculateCompare();
                }
            });
            Document document = this.documentGenerator.generateResultsForClubDocument(locale, competitorPlacingDataList, placingCount);
            if (documentType == DocumentType.PDF) {
                this.pdfDocumentCreator.createDocument(document, outputStream);
            } else if (documentType == DocumentType.ODT) {
                this.odfDocumentCreator.createDocument(document, outputStream);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error creating results for club report", (Throwable)e);
        }
    }

    public void generateMedalsForClubs(DocumentType documentType, Locale locale, OutputStream outputStream, Competition competition) {
        try {
            Category categoryExample = new Category();
            categoryExample.setStatus(Category.Status.ACTIVE);
            SimpleDataFilter categoryDataFilter = new SimpleDataFilter();
            categoryDataFilter.setFilter((Filter)new ExampleFilter((Object)categoryExample));
            PageDataResult categoryDataResult = this.categoryManager.find(competition, (DataFilter)categoryDataFilter);
            LinkedHashMap<Long, MedalsCount> clubs = new LinkedHashMap<Long, MedalsCount>();
            for (Category category : categoryDataResult.getData()) {
                if ((category = this.categoryManager.getById(category.getCategoryId())) instanceof TreeCategory) {
                    Map competitorPlacings;
                    TreeCategory treeCategory = (TreeCategory)category;
                    if (!treeCategory.getCountForClubPlacings().booleanValue() || (competitorPlacings = this.categoryTreeUpdateManager.getPlacings(category)) == null) continue;
                    for (Map.Entry competitorPlacing : competitorPlacings.entrySet()) {
                        Integer placing;
                        Competitor competitor = (Competitor)competitorPlacing.getKey();
                        Club club = competitor.getClub();
                        MedalsCount medalsCount = (MedalsCount)clubs.get(club.getClubId());
                        if (medalsCount == null) {
                            medalsCount = new MedalsCount(club);
                            clubs.put(club.getId(), medalsCount);
                        }
                        if ((placing = (Integer)competitorPlacing.getValue()) == 1) {
                            medalsCount.addFirstPlace();
                            continue;
                        }
                        if (placing == 2) {
                            medalsCount.addSecondPlace();
                            continue;
                        }
                        if (placing != 3) continue;
                        medalsCount.addThirdPlace();
                    }
                    continue;
                }
                if (!(category instanceof Duo2023Category)) continue;
                Duo2023Category duo2023Category = (Duo2023Category)category;
                for (Rank rank : Rank.values()) {
                    Map placingsMap;
                    if (rank == Rank.ADVANCED && !duo2023Category.getAdvancedLevel().booleanValue() || rank == Rank.NOVICE && (!duo2023Category.getAdvancedLevel().booleanValue() || !duo2023Category.getNoviceLevel().booleanValue()) || MapUtil.isEmpty((Map)(placingsMap = this.categoryTreeUpdateManager.getPlacings((Category)duo2023Category, rank)))) continue;
                    for (Map.Entry competitorPlacing : placingsMap.entrySet()) {
                        Integer placing;
                        Competitor competitor = (Competitor)competitorPlacing.getKey();
                        Club club = competitor.getClub();
                        MedalsCount medalsCount = (MedalsCount)clubs.get(club.getClubId());
                        if (medalsCount == null) {
                            medalsCount = new MedalsCount(club);
                            clubs.put(club.getId(), medalsCount);
                        }
                        if ((placing = (Integer)competitorPlacing.getValue()) == 1) {
                            medalsCount.addFirstPlace();
                            continue;
                        }
                        if (placing == 2) {
                            medalsCount.addSecondPlace();
                            continue;
                        }
                        if (placing != 3) continue;
                        medalsCount.addThirdPlace();
                    }
                }
            }
            ArrayList<MedalsCount> medalsCountList = new ArrayList<MedalsCount>(clubs.values());
            medalsCountList.sort(new Comparator<MedalsCount>(){

                @Override
                public int compare(MedalsCount o1, MedalsCount o2) {
                    return new ObjectCompare().addValue(o2.getFirstPlace(), o1.getFirstPlace()).addValue(o2.getSecondPlace(), o1.getSecondPlace()).addValue(o2.getThirdPlace(), o1.getThirdPlace()).addValue((Comparable)((Object)o1.getClub().getName()), (Object)o2.getClub().getName()).calculateCompare();
                }
            });
            for (int i = 0; i < medalsCountList.size(); ++i) {
                if (i == 0) {
                    ((MedalsCount)medalsCountList.get(i)).setPlacing(i + 1);
                    continue;
                }
                if (((MedalsCount)medalsCountList.get(i - 1)).isMedalCountEqual((MedalsCount)medalsCountList.get(i))) {
                    ((MedalsCount)medalsCountList.get(i)).setPlacing(((MedalsCount)medalsCountList.get(i - 1)).getPlacing());
                    continue;
                }
                ((MedalsCount)medalsCountList.get(i)).setPlacing(i + 1);
            }
            Document document = this.documentGenerator.generateMedalsForClubsDocument(locale, medalsCountList);
            if (documentType == DocumentType.PDF) {
                this.pdfDocumentCreator.createDocument(document, outputStream);
            } else if (documentType == DocumentType.ODT) {
                this.odfDocumentCreator.createDocument(document, outputStream);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error creating medals for clubs report", (Throwable)e);
        }
    }

    private static String getCompetitorShortName(Competitor competitor, boolean spaceBeforeClub) {
        String name = "";
        if (competitor instanceof PersonCompetitor) {
            PersonCompetitor personCompetitor = (PersonCompetitor)competitor;
            name = personCompetitor.getShortName() + (spaceBeforeClub ? " / " : "/") + personCompetitor.getClub().getShortName();
        }
        if (competitor instanceof CoupleCompetitor) {
            CoupleCompetitor coupleCompetitor = (CoupleCompetitor)competitor;
            name = coupleCompetitor.getShortName() + (spaceBeforeClub ? " / " : "/") + coupleCompetitor.getClub().getShortName();
        }
        return name;
    }

    private static String getCompetitorName(Competitor competitor) {
        String name = "";
        if (competitor instanceof PersonCompetitor) {
            PersonCompetitor personCompetitor = (PersonCompetitor)competitor;
            name = personCompetitor.getName() + " " + personCompetitor.getSurname() + "/" + personCompetitor.getClub().getShortName();
        }
        if (competitor instanceof CoupleCompetitor) {
            CoupleCompetitor coupleCompetitor = (CoupleCompetitor)competitor;
            name = coupleCompetitor.getName1() + " " + coupleCompetitor.getSurname1() + "," + coupleCompetitor.getName2() + " " + coupleCompetitor.getSurname2() + "/" + coupleCompetitor.getClub().getName();
        }
        return name;
    }

    private static float getPointsForMatch(Match match, CompetitorType competitorType, CompetitionRules competitionRules, Set<MatchPoint> matchPoints) {
        float points = competitionRules.sumPointsFor(match.getType(), competitorType, matchPoints);
        return points;
    }

    private static String getPointsText(Match match, float points) {
        if (match.getType() == Match.Type.FIGHT) {
            return FIGHT_POINTS_FORMAT.format(points);
        }
        if (match.getType() == Match.Type.DUO) {
            return DUO_POINTS_FORMAT.format(points);
        }
        if (match.getType() == Match.Type.NEWAZA) {
            return NEWAZZA_POINTS_FORMAT.format(points);
        }
        if (match.getType() == Match.Type.DUO2023) {
            return DUO_PRESENTATION_POINTS_FORMAT.format(points);
        }
        return "";
    }

    private void addTreeMatches(int startNum, int endNum, Locale locale, TreeCategory treeCategory, TreeAdvancment treeAdvancment, Map<Integer, Match> matches, List<MatchData> matchDatas, MatchManager matchManager, CompetitionRules competitionRules, boolean empty, boolean displayCompetitorNames) {
        for (int i = startNum; i <= endNum; ++i) {
            TreeAdvancmentItem treeAdvancmentItem2;
            TreeAdvancmentItem treeAdvancmentItem1;
            Match match = matches.get(i);
            Set matchPoints = matchManager.getMatchPointsForMatch(match);
            String source1 = "";
            String source2 = "";
            String matchNumber = "";
            String competitor1 = "";
            String competitor2 = "";
            float points1 = DocumentReportGenerator.getPointsForMatch(match, CompetitorType.COMPETITOR1, competitionRules, matchPoints);
            float points2 = DocumentReportGenerator.getPointsForMatch(match, CompetitorType.COMPETITOR2, competitionRules, matchPoints);
            String points1text = "";
            String points2text = "";
            matchNumber = String.valueOf(MatchNumberTool.getTransformedMatchNumber(treeCategory.getTreeType(), treeCategory.getDouble3rdPlace(), match.getFightNumber()));
            if (treeCategory.getTreeType() == TreeCategory.TreeType.TREE4) {
                if (match.getFightNumber() >= 117 && match.getFightNumber() <= 118) {
                    source1 = String.valueOf(MatchNumberTool.getLowestDrawNumber(match.getFightNumber(), CompetitorType.COMPETITOR1, treeAdvancment));
                    source2 = String.valueOf(MatchNumberTool.getLowestDrawNumber(match.getFightNumber(), CompetitorType.COMPETITOR2, treeAdvancment));
                } else if (match.getFightNumber() >= 123 && match.getFightNumber() <= 123) {
                    source1 = this.messageLoader.getMessage(locale, "competition.looserInitial") + String.valueOf(MatchNumberTool.getTransformedMatchNumber(treeCategory.getTreeType(), treeCategory.getDouble3rdPlace(), MatchNumberTool.getRepasagueLooserMatchNum(match.getFightNumber(), CompetitorType.COMPETITOR1, treeAdvancment)));
                    source2 = this.messageLoader.getMessage(locale, "competition.looserInitial") + String.valueOf(MatchNumberTool.getTransformedMatchNumber(treeCategory.getTreeType(), treeCategory.getDouble3rdPlace(), MatchNumberTool.getRepasagueLooserMatchNum(match.getFightNumber(), CompetitorType.COMPETITOR2, treeAdvancment)));
                } else {
                    treeAdvancmentItem1 = treeAdvancment.getTreeAdvancmentItem(match.getFightNumber().intValue(), CompetitorType.COMPETITOR1, TreeType.TREE);
                    treeAdvancmentItem2 = treeAdvancment.getTreeAdvancmentItem(match.getFightNumber().intValue(), CompetitorType.COMPETITOR2, TreeType.TREE);
                    if (treeAdvancmentItem1.getSelectType() == SelectType.WINNER) {
                        source1 = this.messageLoader.getMessage(locale, "competition.winInitial");
                    } else if (treeAdvancmentItem1.getSelectType() == SelectType.LOSER) {
                        source1 = this.messageLoader.getMessage(locale, "competition.looserInitial");
                    }
                    if (treeAdvancmentItem2.getSelectType() == SelectType.WINNER) {
                        source2 = this.messageLoader.getMessage(locale, "competition.winInitial");
                    } else if (treeAdvancmentItem2.getSelectType() == SelectType.LOSER) {
                        source2 = this.messageLoader.getMessage(locale, "competition.looserInitial");
                    }
                    source1 = source1 + String.valueOf(MatchNumberTool.getTransformedMatchNumber(treeCategory.getTreeType(), treeCategory.getDouble3rdPlace(), treeAdvancmentItem1.getFromMatch()));
                    source2 = source2 + String.valueOf(MatchNumberTool.getTransformedMatchNumber(treeCategory.getTreeType(), treeCategory.getDouble3rdPlace(), treeAdvancmentItem2.getFromMatch()));
                }
            } else if (treeCategory.getTreeType() == TreeCategory.TreeType.TREE8) {
                if (match.getFightNumber() >= 105 && match.getFightNumber() <= 108) {
                    source1 = String.valueOf(MatchNumberTool.getLowestDrawNumber(match.getFightNumber(), CompetitorType.COMPETITOR1, treeAdvancment));
                    source2 = String.valueOf(MatchNumberTool.getLowestDrawNumber(match.getFightNumber(), CompetitorType.COMPETITOR2, treeAdvancment));
                } else if (match.getFightNumber() >= 119 && match.getFightNumber() <= 120) {
                    source1 = this.messageLoader.getMessage(locale, "competition.looserInitial") + String.valueOf(MatchNumberTool.getTransformedMatchNumber(treeCategory.getTreeType(), treeCategory.getDouble3rdPlace(), MatchNumberTool.getRepasagueLooserMatchNum(match.getFightNumber(), CompetitorType.COMPETITOR1, treeAdvancment)));
                    source2 = this.messageLoader.getMessage(locale, "competition.looserInitial") + String.valueOf(MatchNumberTool.getTransformedMatchNumber(treeCategory.getTreeType(), treeCategory.getDouble3rdPlace(), MatchNumberTool.getRepasagueLooserMatchNum(match.getFightNumber(), CompetitorType.COMPETITOR2, treeAdvancment)));
                } else {
                    treeAdvancmentItem1 = treeAdvancment.getTreeAdvancmentItem(match.getFightNumber().intValue(), CompetitorType.COMPETITOR1, TreeType.TREE);
                    treeAdvancmentItem2 = treeAdvancment.getTreeAdvancmentItem(match.getFightNumber().intValue(), CompetitorType.COMPETITOR2, TreeType.TREE);
                    if (treeAdvancmentItem1.getSelectType() == SelectType.WINNER) {
                        source1 = this.messageLoader.getMessage(locale, "competition.winInitial");
                    } else if (treeAdvancmentItem1.getSelectType() == SelectType.LOSER) {
                        source1 = this.messageLoader.getMessage(locale, "competition.looserInitial");
                    }
                    if (treeAdvancmentItem2.getSelectType() == SelectType.WINNER) {
                        source2 = this.messageLoader.getMessage(locale, "competition.winInitial");
                    } else if (treeAdvancmentItem2.getSelectType() == SelectType.LOSER) {
                        source2 = this.messageLoader.getMessage(locale, "competition.looserInitial");
                    }
                    source1 = source1 + String.valueOf(MatchNumberTool.getTransformedMatchNumber(treeCategory.getTreeType(), treeCategory.getDouble3rdPlace(), treeAdvancmentItem1.getFromMatch()));
                    source2 = source2 + String.valueOf(MatchNumberTool.getTransformedMatchNumber(treeCategory.getTreeType(), treeCategory.getDouble3rdPlace(), treeAdvancmentItem2.getFromMatch()));
                }
            } else if (treeCategory.getTreeType() == TreeCategory.TreeType.TREE16) {
                if (match.getFightNumber() >= 81 && match.getFightNumber() <= 88) {
                    source1 = String.valueOf(MatchNumberTool.getLowestDrawNumber(match.getFightNumber(), CompetitorType.COMPETITOR1, treeAdvancment));
                    source2 = String.valueOf(MatchNumberTool.getLowestDrawNumber(match.getFightNumber(), CompetitorType.COMPETITOR2, treeAdvancment));
                } else if (match.getFightNumber() >= 109 && match.getFightNumber() <= 112) {
                    source1 = this.messageLoader.getMessage(locale, "competition.looserInitial") + String.valueOf(MatchNumberTool.getTransformedMatchNumber(treeCategory.getTreeType(), treeCategory.getDouble3rdPlace(), MatchNumberTool.getRepasagueLooserMatchNum(match.getFightNumber(), CompetitorType.COMPETITOR1, treeAdvancment)));
                    source2 = this.messageLoader.getMessage(locale, "competition.looserInitial") + String.valueOf(MatchNumberTool.getTransformedMatchNumber(treeCategory.getTreeType(), treeCategory.getDouble3rdPlace(), MatchNumberTool.getRepasagueLooserMatchNum(match.getFightNumber(), CompetitorType.COMPETITOR2, treeAdvancment)));
                } else {
                    treeAdvancmentItem1 = treeAdvancment.getTreeAdvancmentItem(match.getFightNumber().intValue(), CompetitorType.COMPETITOR1, TreeType.TREE);
                    treeAdvancmentItem2 = treeAdvancment.getTreeAdvancmentItem(match.getFightNumber().intValue(), CompetitorType.COMPETITOR2, TreeType.TREE);
                    if (treeAdvancmentItem1.getSelectType() == SelectType.WINNER) {
                        source1 = this.messageLoader.getMessage(locale, "competition.winInitial");
                    } else if (treeAdvancmentItem1.getSelectType() == SelectType.LOSER) {
                        source1 = this.messageLoader.getMessage(locale, "competition.looserInitial");
                    }
                    if (treeAdvancmentItem2.getSelectType() == SelectType.WINNER) {
                        source2 = this.messageLoader.getMessage(locale, "competition.winInitial");
                    } else if (treeAdvancmentItem2.getSelectType() == SelectType.LOSER) {
                        source2 = this.messageLoader.getMessage(locale, "competition.looserInitial");
                    }
                    source1 = source1 + String.valueOf(MatchNumberTool.getTransformedMatchNumber(treeCategory.getTreeType(), treeCategory.getDouble3rdPlace(), treeAdvancmentItem1.getFromMatch()));
                    source2 = source2 + String.valueOf(MatchNumberTool.getTransformedMatchNumber(treeCategory.getTreeType(), treeCategory.getDouble3rdPlace(), treeAdvancmentItem2.getFromMatch()));
                }
            } else if (treeCategory.getTreeType() == TreeCategory.TreeType.TREE32) {
                if (match.getFightNumber() >= 33 && match.getFightNumber() <= 48) {
                    source1 = String.valueOf(MatchNumberTool.getLowestDrawNumber(match.getFightNumber(), CompetitorType.COMPETITOR1, treeAdvancment));
                    source2 = String.valueOf(MatchNumberTool.getLowestDrawNumber(match.getFightNumber(), CompetitorType.COMPETITOR2, treeAdvancment));
                } else if (match.getFightNumber() >= 89 && match.getFightNumber() <= 96) {
                    source1 = this.messageLoader.getMessage(locale, "competition.looserInitial") + String.valueOf(MatchNumberTool.getTransformedMatchNumber(treeCategory.getTreeType(), treeCategory.getDouble3rdPlace(), MatchNumberTool.getRepasagueLooserMatchNum(match.getFightNumber(), CompetitorType.COMPETITOR1, treeAdvancment)));
                    source2 = this.messageLoader.getMessage(locale, "competition.looserInitial") + String.valueOf(MatchNumberTool.getTransformedMatchNumber(treeCategory.getTreeType(), treeCategory.getDouble3rdPlace(), MatchNumberTool.getRepasagueLooserMatchNum(match.getFightNumber(), CompetitorType.COMPETITOR2, treeAdvancment)));
                } else {
                    treeAdvancmentItem1 = treeAdvancment.getTreeAdvancmentItem(match.getFightNumber().intValue(), CompetitorType.COMPETITOR1, TreeType.TREE);
                    treeAdvancmentItem2 = treeAdvancment.getTreeAdvancmentItem(match.getFightNumber().intValue(), CompetitorType.COMPETITOR2, TreeType.TREE);
                    if (treeAdvancmentItem1.getSelectType() == SelectType.WINNER) {
                        source1 = this.messageLoader.getMessage(locale, "competition.winInitial");
                    } else if (treeAdvancmentItem1.getSelectType() == SelectType.LOSER) {
                        source1 = this.messageLoader.getMessage(locale, "competition.looserInitial");
                    }
                    if (treeAdvancmentItem2.getSelectType() == SelectType.WINNER) {
                        source2 = this.messageLoader.getMessage(locale, "competition.winInitial");
                    } else if (treeAdvancmentItem2.getSelectType() == SelectType.LOSER) {
                        source2 = this.messageLoader.getMessage(locale, "competition.looserInitial");
                    }
                    source1 = source1 + String.valueOf(MatchNumberTool.getTransformedMatchNumber(treeCategory.getTreeType(), treeCategory.getDouble3rdPlace(), treeAdvancmentItem1.getFromMatch()));
                    source2 = source2 + String.valueOf(MatchNumberTool.getTransformedMatchNumber(treeCategory.getTreeType(), treeCategory.getDouble3rdPlace(), treeAdvancmentItem2.getFromMatch()));
                }
            } else if (treeCategory.getTreeType() == TreeCategory.TreeType.TREE64) {
                if (match.getFightNumber() >= 1 && match.getFightNumber() <= 32) {
                    source1 = String.valueOf(MatchNumberTool.getLowestDrawNumber(match.getFightNumber(), CompetitorType.COMPETITOR1, treeAdvancment));
                    source2 = String.valueOf(MatchNumberTool.getLowestDrawNumber(match.getFightNumber(), CompetitorType.COMPETITOR2, treeAdvancment));
                } else if (match.getFightNumber() >= 49 && match.getFightNumber() <= 64) {
                    source1 = this.messageLoader.getMessage(locale, "competition.looserInitial") + String.valueOf(MatchNumberTool.getTransformedMatchNumber(treeCategory.getTreeType(), treeCategory.getDouble3rdPlace(), MatchNumberTool.getRepasagueLooserMatchNum(match.getFightNumber(), CompetitorType.COMPETITOR1, treeAdvancment)));
                    source2 = this.messageLoader.getMessage(locale, "competition.looserInitial") + String.valueOf(MatchNumberTool.getTransformedMatchNumber(treeCategory.getTreeType(), treeCategory.getDouble3rdPlace(), MatchNumberTool.getRepasagueLooserMatchNum(match.getFightNumber(), CompetitorType.COMPETITOR2, treeAdvancment)));
                } else {
                    treeAdvancmentItem1 = treeAdvancment.getTreeAdvancmentItem(match.getFightNumber().intValue(), CompetitorType.COMPETITOR1, TreeType.TREE);
                    treeAdvancmentItem2 = treeAdvancment.getTreeAdvancmentItem(match.getFightNumber().intValue(), CompetitorType.COMPETITOR2, TreeType.TREE);
                    if (treeAdvancmentItem1.getSelectType() == SelectType.WINNER) {
                        source1 = this.messageLoader.getMessage(locale, "competition.winInitial");
                    } else if (treeAdvancmentItem1.getSelectType() == SelectType.LOSER) {
                        source1 = this.messageLoader.getMessage(locale, "competition.looserInitial");
                    }
                    if (treeAdvancmentItem2.getSelectType() == SelectType.WINNER) {
                        source2 = this.messageLoader.getMessage(locale, "competition.winInitial");
                    } else if (treeAdvancmentItem2.getSelectType() == SelectType.LOSER) {
                        source2 = this.messageLoader.getMessage(locale, "competition.looserInitial");
                    }
                    source1 = source1 + String.valueOf(MatchNumberTool.getTransformedMatchNumber(treeCategory.getTreeType(), treeCategory.getDouble3rdPlace(), treeAdvancmentItem1.getFromMatch()));
                    source2 = source2 + String.valueOf(MatchNumberTool.getTransformedMatchNumber(treeCategory.getTreeType(), treeCategory.getDouble3rdPlace(), treeAdvancmentItem2.getFromMatch()));
                }
            }
            if (displayCompetitorNames && match.getCompetitor1() != null) {
                competitor1 = DocumentReportGenerator.getCompetitorShortName(match.getCompetitor1(), false);
                if (!empty && (points1 > 0.0f || points2 > 0.0f)) {
                    points1text = DocumentReportGenerator.getPointsText(match, points1);
                }
            }
            if (displayCompetitorNames && match.getCompetitor2() != null) {
                competitor2 = DocumentReportGenerator.getCompetitorShortName(match.getCompetitor2(), false);
                if (!empty && (points1 > 0.0f || points2 > 0.0f)) {
                    points2text = DocumentReportGenerator.getPointsText(match, points2);
                }
            }
            matchDatas.add(new MatchData(source1, source2, competitor1, competitor2, points1text, points2text, matchNumber));
        }
    }

    private void addDuoKnockoutMatches(Rank rank, Locale locale, Map<Integer, Match> matches, List<MatchData> matchDatas, MatchManager matchManager, CompetitionRules competitionRules, boolean empty) {
        int matchOffset = 0;
        if (rank == Rank.ADVANCED) {
            matchOffset = 8;
        } else if (rank == Rank.NOVICE) {
            matchOffset = 16;
        }
        boolean displayQuarterFinals = false;
        for (int i = 1; i <= 8; ++i) {
            Match match = matches.get(matchOffset + i);
            Set matchPoints = matchManager.getMatchPointsForMatch(match);
            String source1 = "";
            String source2 = "";
            String matchNumber = "";
            String competitor1 = "";
            String competitor2 = "";
            float points1 = DocumentReportGenerator.getPointsForMatch(match, CompetitorType.COMPETITOR1, competitionRules, matchPoints);
            float points2 = DocumentReportGenerator.getPointsForMatch(match, CompetitorType.COMPETITOR2, competitionRules, matchPoints);
            String points1text = "";
            String points2text = "";
            if (i == 1) {
                source1 = this.messageLoader.getMessage(locale, "competition.groupInitial") + "1" + this.messageLoader.getMessage(locale, "competition.positionInitial") + "1";
                source2 = this.messageLoader.getMessage(locale, "competition.groupInitial") + "2" + this.messageLoader.getMessage(locale, "competition.positionInitial") + "4";
            } else if (i == 2) {
                source1 = this.messageLoader.getMessage(locale, "competition.groupInitial") + "2" + this.messageLoader.getMessage(locale, "competition.positionInitial") + "2";
                source2 = this.messageLoader.getMessage(locale, "competition.groupInitial") + "1" + this.messageLoader.getMessage(locale, "competition.positionInitial") + "3";
            } else if (i == 3) {
                source1 = this.messageLoader.getMessage(locale, "competition.groupInitial") + "2" + this.messageLoader.getMessage(locale, "competition.positionInitial") + "1";
                source2 = this.messageLoader.getMessage(locale, "competition.groupInitial") + "1" + this.messageLoader.getMessage(locale, "competition.positionInitial") + "4";
            } else if (i == 4) {
                source1 = this.messageLoader.getMessage(locale, "competition.groupInitial") + "1" + this.messageLoader.getMessage(locale, "competition.positionInitial") + "2";
                source2 = this.messageLoader.getMessage(locale, "competition.groupInitial") + "2" + this.messageLoader.getMessage(locale, "competition.positionInitial") + "3";
            } else if (i == 5) {
                if (displayQuarterFinals) {
                    source1 = this.messageLoader.getMessage(locale, "competition.winInitial") + "1";
                    source2 = this.messageLoader.getMessage(locale, "competition.winInitial") + "2";
                } else {
                    source1 = this.messageLoader.getMessage(locale, "competition.groupInitial") + "1" + this.messageLoader.getMessage(locale, "competition.positionInitial") + "1";
                    source2 = this.messageLoader.getMessage(locale, "competition.groupInitial") + "2" + this.messageLoader.getMessage(locale, "competition.positionInitial") + "2";
                }
            } else if (i == 6) {
                if (displayQuarterFinals) {
                    source1 = this.messageLoader.getMessage(locale, "competition.winInitial") + "3";
                    source2 = this.messageLoader.getMessage(locale, "competition.winInitial") + "4";
                } else {
                    source1 = this.messageLoader.getMessage(locale, "competition.groupInitial") + "2" + this.messageLoader.getMessage(locale, "competition.positionInitial") + "1";
                    source2 = this.messageLoader.getMessage(locale, "competition.groupInitial") + "1" + this.messageLoader.getMessage(locale, "competition.positionInitial") + "2";
                }
            } else if (i == 7) {
                if (displayQuarterFinals) {
                    source1 = this.messageLoader.getMessage(locale, "competition.looserInitial") + "5";
                    source2 = this.messageLoader.getMessage(locale, "competition.looserInitial") + "6";
                } else {
                    source1 = this.messageLoader.getMessage(locale, "competition.looserInitial") + "1";
                    source2 = this.messageLoader.getMessage(locale, "competition.looserInitial") + "2";
                }
            } else if (i == 8) {
                if (displayQuarterFinals) {
                    source1 = this.messageLoader.getMessage(locale, "competition.winInitial") + "5";
                    source2 = this.messageLoader.getMessage(locale, "competition.winInitial") + "6";
                } else {
                    source1 = this.messageLoader.getMessage(locale, "competition.winInitial") + "1";
                    source2 = this.messageLoader.getMessage(locale, "competition.winInitial") + "2";
                }
            }
            if (match.getCompetitor1() != null) {
                if (!empty || i <= 4) {
                    competitor1 = DocumentReportGenerator.getCompetitorShortName(match.getCompetitor1(), false);
                }
                if (!empty && (points1 > 0.0f || points2 > 0.0f)) {
                    points1text = DocumentReportGenerator.getPointsText(match, points1);
                }
            }
            if (match.getCompetitor2() != null) {
                if (!empty || i <= 4) {
                    competitor2 = DocumentReportGenerator.getCompetitorShortName(match.getCompetitor2(), false);
                }
                if (!empty && (points1 > 0.0f || points2 > 0.0f)) {
                    points2text = DocumentReportGenerator.getPointsText(match, points2);
                }
            }
            if (i <= 4 && StringUtil.isNotEmpty((String)competitor1) && StringUtil.isNotEmpty((String)competitor2)) {
                displayQuarterFinals = true;
            }
            matchDatas.add(new MatchData(source1, source2, competitor1, competitor2, points1text, points2text, matchNumber));
        }
    }

    static {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        decimalFormatSymbols.setGroupingSeparator(',');
        FIGHT_POINTS_FORMAT = new DecimalFormat("0");
        DUO_POINTS_FORMAT = new DecimalFormat("0.0", decimalFormatSymbols);
        NEWAZZA_POINTS_FORMAT = new DecimalFormat("0");
        DUO_PRESENTATION_POINTS_FORMAT = new DecimalFormat("0");
    }
}

