/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.management.updaters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import si.nevensrok.common.utils.NumberUtil;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.category.Duo2023Category;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.competitors.Competitor;
import si.nevensrok.jtekma.common.management.RulesManager;
import si.nevensrok.jtekma.common.matches.Match;
import si.nevensrok.jtekma.common.matches.Rank;
import si.nevensrok.jtekma.common.matches.Round;
import si.nevensrok.jtekma.common.rules.CompetitionRules;
import si.nevensrok.jtekma.common.rules.DuoTable;
import si.nevensrok.jtekma.server.management.CategoryManager;
import si.nevensrok.jtekma.server.management.CompetitionManager;
import si.nevensrok.jtekma.server.management.DuoPresentationManager;
import si.nevensrok.jtekma.server.management.MatchManager;
import si.nevensrok.jtekma.server.management.updaters.Duo2023Updater;

public class Duo2023PlacingCalculator {
    private CompetitionManager competitionManager;
    private RulesManager rulesManager;
    private CategoryManager categoryManager;
    private DuoPresentationManager duoPresentationManager;
    private Duo2023Updater duo2023Updater;
    private MatchManager matchManager;

    public void setCompetitionManager(CompetitionManager competitionManager) {
        this.competitionManager = competitionManager;
    }

    public void setRulesManager(RulesManager rulesManager) {
        this.rulesManager = rulesManager;
    }

    public void setCategoryManager(CategoryManager categoryManager) {
        this.categoryManager = categoryManager;
    }

    public void setDuoPresentationManager(DuoPresentationManager duoPresentationManager) {
        this.duoPresentationManager = duoPresentationManager;
    }

    public void setDuo2023Updater(Duo2023Updater duo2023Updater) {
        this.duo2023Updater = duo2023Updater;
    }

    public void setMatchManager(MatchManager matchManager) {
        this.matchManager = matchManager;
    }

    public Map<Competitor, Integer> getPlacings(Duo2023Category duo2023Category, Rank rank) {
        List<DuoTable> duoTables = this.duo2023Updater.getDuoTables(duo2023Category);
        return this.calculatePlacings(duo2023Category, duoTables, rank);
    }

    public Map<Competitor, Integer> calculatePlacings(Duo2023Category duo2023Category, List<DuoTable> duoTables, Rank rank) {
        LinkedHashMap<Competitor, Integer> placings = new LinkedHashMap<Competitor, Integer>();
        if (rank == Rank.ADVANCED && !duo2023Category.getAdvancedLevel().booleanValue()) {
            return placings;
        }
        if (!(rank != Rank.NOVICE || duo2023Category.getAdvancedLevel().booleanValue() && duo2023Category.getNoviceLevel().booleanValue())) {
            return placings;
        }
        if (duo2023Category.getKnockoutStage().booleanValue()) {
            Competitor loser;
            Competitor winner;
            Competition competition = this.competitionManager.getCompetitionForCategory((Category)duo2023Category);
            CompetitionRules competitionRules = this.rulesManager.getCompetitionRules(competition.getRules());
            HashMap<Integer, Match> matches = new HashMap<Integer, Match>();
            HashMap matchPoints = new HashMap();
            for (Match match : this.matchManager.getMatchesForCategory((Category)duo2023Category)) {
                matches.put(match.getFightNumber(), match);
            }
            for (Map.Entry entry : this.matchManager.getMatchPointsForMatches(new HashSet(matches.values())).entrySet()) {
                matchPoints.put(((Match)entry.getKey()).getFightNumber(), entry.getValue());
            }
            int matchOffset = 0;
            if (rank == Rank.ADVANCED) {
                matchOffset = 8;
            } else if (rank == Rank.NOVICE) {
                matchOffset = 16;
            }
            Match match = (Match)matches.get(matchOffset + 8);
            if (match != null && !match.getMatchEmpty().booleanValue() && !match.getNoWinner().booleanValue()) {
                if (match.getNotNeeded().booleanValue()) {
                    if (match.getCompetitor1() != null) {
                        placings.put(match.getCompetitor1(), 1);
                    } else if (match.getCompetitor2() != null) {
                        placings.put(match.getCompetitor2(), 1);
                    }
                } else {
                    winner = competitionRules.getMatchWinner(match, (Set)matchPoints.get(match.getFightNumber()));
                    if (winner != null) {
                        placings.put(winner, 1);
                    }
                    if ((loser = competitionRules.getMatchLoser(match, (Set)matchPoints.get(match.getFightNumber()))) != null) {
                        placings.put(loser, 2);
                    }
                }
            }
            if (duo2023Category.getDouble3rdPlace().booleanValue()) {
                for (int i = 0; i < 2; ++i) {
                    Match match2 = (Match)matches.get(matchOffset + 5 + i);
                    if (match2 == null || match2.getMatchEmpty().booleanValue() || match2.getNotNeeded().booleanValue()) continue;
                    if (match2.getNoWinner().booleanValue()) {
                        if (match2.getCompetitor1() != null) {
                            placings.put(match2.getCompetitor1(), 3);
                            continue;
                        }
                        if (match2.getCompetitor2() == null) continue;
                        placings.put(match2.getCompetitor2(), 3);
                        continue;
                    }
                    loser = competitionRules.getMatchLoser(match2, (Set)matchPoints.get(match2.getFightNumber()));
                    if (loser == null) continue;
                    placings.put(loser, 3);
                }
            } else {
                Match match3 = (Match)matches.get(matchOffset + 7);
                if (match3 != null && !match3.getMatchEmpty().booleanValue() && !match3.getNoWinner().booleanValue()) {
                    if (match3.getNotNeeded().booleanValue()) {
                        if (match3.getCompetitor1() != null) {
                            placings.put(match3.getCompetitor1(), 3);
                        } else if (match3.getCompetitor2() != null) {
                            placings.put(match3.getCompetitor2(), 3);
                        }
                    } else {
                        winner = competitionRules.getMatchWinner(match3, (Set)matchPoints.get(match3.getFightNumber()));
                        if (winner != null) {
                            placings.put(winner, 3);
                        }
                        if ((loser = competitionRules.getMatchLoser(match3, (Set)matchPoints.get(match3.getFightNumber()))) != null) {
                            placings.put(loser, 4);
                        }
                    }
                }
            }
            for (int i = 1; i <= 4; ++i) {
                Match match4 = (Match)matches.get(matchOffset + i);
                if (match4 == null || match4.getMatchEmpty().booleanValue() || match4.getNotNeeded().booleanValue()) continue;
                if (match4.getNoWinner().booleanValue()) {
                    if (match4.getCompetitor1() != null) {
                        placings.put(match4.getCompetitor1(), 5);
                        continue;
                    }
                    if (match4.getCompetitor2() == null) continue;
                    placings.put(match4.getCompetitor2(), 5);
                    continue;
                }
                loser = competitionRules.getMatchLoser(match4, (Set)matchPoints.get(match4.getFightNumber()));
                if (loser == null) continue;
                placings.put(loser, 5);
            }
            for (DuoTable duoTable : duoTables) {
                if (!duoTable.isFinished() || duoTable.getRank() != rank) continue;
                if (duoTable.getRound() == Round.ROUND_3) {
                    if (rank == Rank.WORLD_LEVEL && !duo2023Category.getAdvancedLevel().booleanValue()) {
                        for (Competitor competitor : duoTable.getLosers(0)) {
                            placings.put(competitor, 5);
                        }
                        continue;
                    }
                    if (rank == Rank.ADVANCED && !duo2023Category.getNoviceLevel().booleanValue()) {
                        for (Competitor competitor : duoTable.getLosers(0)) {
                            placings.put(competitor, 5);
                        }
                        continue;
                    }
                    if (rank != Rank.NOVICE) continue;
                    for (Competitor competitor : duoTable.getLosers(0)) {
                        placings.put(competitor, 5);
                    }
                    continue;
                }
                if (duoTable.getRound() == Round.ROUND_2) {
                    if (rank == Rank.WORLD_LEVEL && !duo2023Category.getAdvancedLevel().booleanValue()) {
                        for (Competitor competitor : duoTable.getLosers(0)) {
                            placings.put(competitor, 9);
                        }
                        continue;
                    }
                    if (rank == Rank.ADVANCED && !duo2023Category.getNoviceLevel().booleanValue()) {
                        for (Competitor competitor : duoTable.getLosers(0)) {
                            placings.put(competitor, 13);
                        }
                        continue;
                    }
                    if (rank != Rank.NOVICE) continue;
                    for (Competitor competitor : duoTable.getLosers(0)) {
                        placings.put(competitor, 17);
                    }
                    continue;
                }
                if (duoTable.getRound() != Round.ROUND_1) continue;
                if (rank == Rank.WORLD_LEVEL && !duo2023Category.getAdvancedLevel().booleanValue()) {
                    for (Competitor competitor : duoTable.getLosers(0)) {
                        placings.put(competitor, 17);
                    }
                    continue;
                }
                if (rank == Rank.ADVANCED && !duo2023Category.getNoviceLevel().booleanValue()) {
                    for (Competitor competitor : duoTable.getLosers(0)) {
                        placings.put(competitor, 17);
                    }
                    continue;
                }
                if (rank != Rank.NOVICE) continue;
                for (Competitor competitor : duoTable.getLosers(0)) {
                    placings.put(competitor, 25);
                }
            }
        } else {
            for (DuoTable duoTable : duoTables) {
                if (!duoTable.isFinished() || duoTable.getRank() != rank) continue;
                if (duoTable.getRound() == Round.ROUND_5) {
                    if (duoTable.getRows() == null) continue;
                    ArrayList rows = new ArrayList(duoTable.getRows());
                    Collections.sort(rows, new Comparator<DuoTable.Row>(){

                        @Override
                        public int compare(DuoTable.Row o1, DuoTable.Row o2) {
                            return -Float.compare(o1.getPoints(), o2.getPoints());
                        }
                    });
                    for (int i = 0; i < rows.size(); ++i) {
                        if (i == 0) {
                            placings.put(((DuoTable.Row)rows.get(i)).getCompetitor(), i + 1);
                            continue;
                        }
                        if (NumberUtil.areFloatsEqual((float)((DuoTable.Row)rows.get(i - 1)).getPoints(), (float)((DuoTable.Row)rows.get(i)).getPoints(), (float)0.001f)) {
                            placings.put(((DuoTable.Row)rows.get(i)).getCompetitor(), (Integer)placings.get(((DuoTable.Row)rows.get(i - 1)).getCompetitor()));
                            continue;
                        }
                        placings.put(((DuoTable.Row)rows.get(i)).getCompetitor(), i + 1);
                    }
                    continue;
                }
                if (duoTable.getRound() == Round.ROUND_4) {
                    for (Competitor competitor : duoTable.getLosers(0)) {
                        placings.put(competitor, 3);
                    }
                    continue;
                }
                if (duoTable.getRound() == Round.ROUND_3) {
                    if (rank == Rank.WORLD_LEVEL && !duo2023Category.getAdvancedLevel().booleanValue()) {
                        for (Competitor competitor : duoTable.getLosers(0)) {
                            placings.put(competitor, 5);
                        }
                        continue;
                    }
                    if (rank == Rank.ADVANCED && !duo2023Category.getNoviceLevel().booleanValue()) {
                        for (Competitor competitor : duoTable.getLosers(0)) {
                            placings.put(competitor, 5);
                        }
                        continue;
                    }
                    if (rank != Rank.NOVICE) continue;
                    for (Competitor competitor : duoTable.getLosers(0)) {
                        placings.put(competitor, 5);
                    }
                    continue;
                }
                if (duoTable.getRound() == Round.ROUND_2) {
                    if (rank == Rank.WORLD_LEVEL && !duo2023Category.getAdvancedLevel().booleanValue()) {
                        for (Competitor competitor : duoTable.getLosers(0)) {
                            placings.put(competitor, 9);
                        }
                        continue;
                    }
                    if (rank == Rank.ADVANCED && !duo2023Category.getNoviceLevel().booleanValue()) {
                        for (Competitor competitor : duoTable.getLosers(0)) {
                            placings.put(competitor, 13);
                        }
                        continue;
                    }
                    if (rank != Rank.NOVICE) continue;
                    for (Competitor competitor : duoTable.getLosers(0)) {
                        placings.put(competitor, 17);
                    }
                    continue;
                }
                if (duoTable.getRound() != Round.ROUND_1) continue;
                if (rank == Rank.WORLD_LEVEL && !duo2023Category.getAdvancedLevel().booleanValue()) {
                    for (Competitor competitor : duoTable.getLosers(0)) {
                        placings.put(competitor, 17);
                    }
                    continue;
                }
                if (rank == Rank.ADVANCED && !duo2023Category.getNoviceLevel().booleanValue()) {
                    for (Competitor competitor : duoTable.getLosers(0)) {
                        placings.put(competitor, 17);
                    }
                    continue;
                }
                if (rank != Rank.NOVICE) continue;
                for (Competitor competitor : duoTable.getLosers(0)) {
                    placings.put(competitor, 25);
                }
            }
        }
        return placings;
    }
}

