/*
 * Decompiled with CFR 0.152.
 */
package javafx.beans.binding;

import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.binding.NumberExpressionBase;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.binding.ObjectExpression;
import javafx.beans.value.ObservableDoubleValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public abstract class DoubleExpression
extends NumberExpressionBase
implements ObservableDoubleValue {
    @Override
    public int intValue() {
        return (int)this.get();
    }

    @Override
    public long longValue() {
        return (long)this.get();
    }

    @Override
    public float floatValue() {
        return (float)this.get();
    }

    @Override
    public double doubleValue() {
        return this.get();
    }

    @Override
    public Double getValue() {
        return this.get();
    }

    public static DoubleExpression doubleExpression(final ObservableDoubleValue value) {
        if (value == null) {
            throw new NullPointerException("Value must be specified.");
        }
        return value instanceof DoubleExpression ? (DoubleExpression)value : new DoubleBinding(){
            {
                super.bind(value);
            }

            @Override
            public void dispose() {
                super.unbind(value);
            }

            @Override
            protected double computeValue() {
                return value.get();
            }

            @Override
            public ObservableList<ObservableDoubleValue> getDependencies() {
                return FXCollections.singletonObservableList(value);
            }
        };
    }

    public static <T extends Number> DoubleExpression doubleExpression(final ObservableValue<T> value) {
        if (value == null) {
            throw new NullPointerException("Value must be specified.");
        }
        return value instanceof DoubleExpression ? (DoubleExpression)value : new DoubleBinding(){
            {
                super.bind(value);
            }

            @Override
            public void dispose() {
                super.unbind(value);
            }

            @Override
            protected double computeValue() {
                Number val = (Number)value.getValue();
                return val == null ? 0.0 : val.doubleValue();
            }

            @Override
            public ObservableList<ObservableValue<T>> getDependencies() {
                return FXCollections.singletonObservableList(value);
            }
        };
    }

    @Override
    public DoubleBinding negate() {
        return (DoubleBinding)Bindings.negate(this);
    }

    @Override
    public DoubleBinding add(ObservableNumberValue other) {
        return (DoubleBinding)Bindings.add((ObservableNumberValue)this, other);
    }

    @Override
    public DoubleBinding add(double other) {
        return Bindings.add((ObservableNumberValue)this, other);
    }

    @Override
    public DoubleBinding add(float other) {
        return (DoubleBinding)Bindings.add((ObservableNumberValue)this, other);
    }

    @Override
    public DoubleBinding add(long other) {
        return (DoubleBinding)Bindings.add((ObservableNumberValue)this, other);
    }

    @Override
    public DoubleBinding add(int other) {
        return (DoubleBinding)Bindings.add((ObservableNumberValue)this, other);
    }

    @Override
    public DoubleBinding subtract(ObservableNumberValue other) {
        return (DoubleBinding)Bindings.subtract((ObservableNumberValue)this, other);
    }

    @Override
    public DoubleBinding subtract(double other) {
        return Bindings.subtract((ObservableNumberValue)this, other);
    }

    @Override
    public DoubleBinding subtract(float other) {
        return (DoubleBinding)Bindings.subtract((ObservableNumberValue)this, other);
    }

    @Override
    public DoubleBinding subtract(long other) {
        return (DoubleBinding)Bindings.subtract((ObservableNumberValue)this, other);
    }

    @Override
    public DoubleBinding subtract(int other) {
        return (DoubleBinding)Bindings.subtract((ObservableNumberValue)this, other);
    }

    @Override
    public DoubleBinding multiply(ObservableNumberValue other) {
        return (DoubleBinding)Bindings.multiply((ObservableNumberValue)this, other);
    }

    @Override
    public DoubleBinding multiply(double other) {
        return Bindings.multiply((ObservableNumberValue)this, other);
    }

    @Override
    public DoubleBinding multiply(float other) {
        return (DoubleBinding)Bindings.multiply((ObservableNumberValue)this, other);
    }

    @Override
    public DoubleBinding multiply(long other) {
        return (DoubleBinding)Bindings.multiply((ObservableNumberValue)this, other);
    }

    @Override
    public DoubleBinding multiply(int other) {
        return (DoubleBinding)Bindings.multiply((ObservableNumberValue)this, other);
    }

    @Override
    public DoubleBinding divide(ObservableNumberValue other) {
        return (DoubleBinding)Bindings.divide((ObservableNumberValue)this, other);
    }

    @Override
    public DoubleBinding divide(double other) {
        return Bindings.divide((ObservableNumberValue)this, other);
    }

    @Override
    public DoubleBinding divide(float other) {
        return (DoubleBinding)Bindings.divide((ObservableNumberValue)this, other);
    }

    @Override
    public DoubleBinding divide(long other) {
        return (DoubleBinding)Bindings.divide((ObservableNumberValue)this, other);
    }

    @Override
    public DoubleBinding divide(int other) {
        return (DoubleBinding)Bindings.divide((ObservableNumberValue)this, other);
    }

    public ObjectExpression<Double> asObject() {
        return new ObjectBinding<Double>(){
            {
                this.bind(DoubleExpression.this);
            }

            @Override
            public void dispose() {
                this.unbind(DoubleExpression.this);
            }

            @Override
            protected Double computeValue() {
                return DoubleExpression.this.getValue();
            }
        };
    }
}

