/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.ssl;

import java.security.cert.Certificate;
import java.util.LinkedList;
import java.util.List;
import si.nevensrok.common.ssl.RevokedCertificateChecker;

public class MultipleRevokedCertificateChecker
implements RevokedCertificateChecker {
    private List<RevokedCertificateChecker> checkers = new LinkedList<RevokedCertificateChecker>();

    public MultipleRevokedCertificateChecker() {
    }

    public MultipleRevokedCertificateChecker(List<RevokedCertificateChecker> revokedCertificateChecker) {
        this.checkers.addAll(this.checkers);
    }

    public MultipleRevokedCertificateChecker(RevokedCertificateChecker ... revokedCertificateChecker) {
        for (RevokedCertificateChecker r : revokedCertificateChecker) {
            this.checkers.add(r);
        }
    }

    public void addChecker(RevokedCertificateChecker ... revokedCertificateChecker) {
        for (RevokedCertificateChecker r : revokedCertificateChecker) {
            this.checkers.add(r);
        }
    }

    @Override
    public boolean isCertificateRevoked(Certificate certificate) {
        for (RevokedCertificateChecker revokedCertificateChecker : this.checkers) {
            if (!revokedCertificateChecker.isCertificateRevoked(certificate)) continue;
            return true;
        }
        return false;
    }
}

