/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.gui.horizontal;

import java.awt.Color;
import javax.swing.JLabel;
import javax.swing.JPanel;
import si.nevensrok.jtekma.tabla.common.Constants;
import si.nevensrok.jtekma.tabla.common.MatchData;
import si.nevensrok.jtekma.tabla.common.TableType;
import si.nevensrok.jtekma.tabla.fw.TimeTracker;
import si.nevensrok.jtekma.tabla.util.FontSizeUtil;

public class TimePanel
extends JPanel {
    private JLabel timeLabel = new JLabel();
    private MatchData matchData;
    private TimeTracker timeTracker;

    public TimePanel() {
        this.setLayout(null);
        this.add(this.timeLabel);
        this.timeLabel.setFont(Constants.FONT);
        this.timeLabel.setHorizontalAlignment(0);
    }

    public void setMatchData(MatchData matchData) {
        this.matchData = matchData;
    }

    public void setTimeTracker(TimeTracker timeTracker) {
        this.timeTracker = timeTracker;
    }

    public void redrawElements() {
        this.timeLabel.setSize(this.getWidth(), this.getHeight());
        this.timeLabel.setLocation(0, 0);
        if (this.matchData.getTableType() == TableType.FIGHT || this.matchData.getTableType() == TableType.NEWAZA) {
            long time = this.matchData.getTimeLeft() / 1000L;
            long minutes = time / 60L;
            long seconds = time % 60L;
            this.timeLabel.setText(String.valueOf(minutes) + ":" + Constants.SECONDS_NUMBER_FORMAT.format(seconds));
        } else {
            this.timeLabel.setText("");
        }
        if (this.timeTracker.isTimeRunning()) {
            this.setBackground(Constants.TIME_RUNNING_BG_COLOR);
            this.timeLabel.setForeground(Constants.TIME_RUNNING_FG_COLOR);
        } else {
            this.setBackground(Constants.INFO_BG_COLOR);
            this.timeLabel.setForeground(Constants.INFO_FG_COLOR);
        }
        FontSizeUtil.refitFontSize(Constants.FONT, this.timeLabel);
        this.repaint();
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.timeLabel != null) {
            this.timeLabel.setBackground(bg);
        }
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.timeLabel != null) {
            this.timeLabel.setForeground(fg);
        }
    }
}

