/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.gui.horizontal;

import java.awt.Color;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import si.nevensrok.jtekma.common.matches.PointType;
import si.nevensrok.jtekma.common.rules.CompetitorType;
import si.nevensrok.jtekma.tabla.common.FightPoints;
import si.nevensrok.jtekma.tabla.common.MatchData;
import si.nevensrok.jtekma.tabla.fw.TablaManager;
import si.nevensrok.jtekma.tabla.gui.TextSource;
import si.nevensrok.jtekma.tabla.gui.horizontal.ChallengePanel;
import si.nevensrok.jtekma.tabla.gui.horizontal.FightPointBox;
import si.nevensrok.jtekma.tabla.gui.horizontal.PenaltyTracker;

public class FightPointsPanel
extends JLabel {
    private JPanel pointsPanel = new JPanel();
    private FightPointBox wazariBox;
    private FightPointBox ippon1Box;
    private FightPointBox ippon2Box;
    private FightPointBox ippon3Box;
    private FightPointBox shidoBox;
    private FightPointBox chuiBox;
    private FightPointBox hansokumakeBox;
    private PenaltyTracker penaltyTracker;
    private ChallengePanel challengePanel;

    public FightPointsPanel(CompetitorType competitorType) {
        this.wazariBox = new FightPointBox("W", competitorType, PointType.WAZARI);
        this.ippon1Box = new FightPointBox("I1", competitorType, PointType.IPPON1);
        this.ippon2Box = new FightPointBox("I2", competitorType, PointType.IPPON2);
        this.ippon3Box = new FightPointBox("I3", competitorType, PointType.IPPON3);
        this.shidoBox = new FightPointBox("S", competitorType, PointType.SHIDO);
        this.chuiBox = new FightPointBox("C", competitorType, PointType.CHUI);
        this.hansokumakeBox = new FightPointBox("H", competitorType, PointType.HANSOKUMAKE);
        this.penaltyTracker = new PenaltyTracker(competitorType);
        this.challengePanel = new ChallengePanel(competitorType);
        this.setLayout(null);
        this.pointsPanel.setLayout(new GridLayout(1, 7, 4, 0));
        this.pointsPanel.add(this.wazariBox);
        this.pointsPanel.add(this.ippon1Box);
        this.pointsPanel.add(this.ippon2Box);
        this.pointsPanel.add(this.ippon3Box);
        this.pointsPanel.add(this.shidoBox);
        this.pointsPanel.add(this.chuiBox);
        this.pointsPanel.add(this.hansokumakeBox);
        this.add(this.pointsPanel);
        this.add(this.penaltyTracker);
        this.add(this.challengePanel);
    }

    public void setFightPoints(FightPoints fightPoints) {
        this.wazariBox.setFightPoints(fightPoints);
        this.ippon1Box.setFightPoints(fightPoints);
        this.ippon2Box.setFightPoints(fightPoints);
        this.ippon3Box.setFightPoints(fightPoints);
        this.shidoBox.setFightPoints(fightPoints);
        this.chuiBox.setFightPoints(fightPoints);
        this.hansokumakeBox.setFightPoints(fightPoints);
        this.penaltyTracker.setFightPoints(fightPoints);
    }

    public void setMatchData(MatchData matchData) {
        this.wazariBox.setMatchData(matchData);
        this.ippon1Box.setMatchData(matchData);
        this.ippon2Box.setMatchData(matchData);
        this.ippon3Box.setMatchData(matchData);
        this.shidoBox.setMatchData(matchData);
        this.chuiBox.setMatchData(matchData);
        this.hansokumakeBox.setMatchData(matchData);
        this.penaltyTracker.setMatchData(matchData);
        this.challengePanel.setMatchData(matchData);
    }

    public void setTablaManager(TablaManager tablaManager) {
        this.wazariBox.setTablaManager(tablaManager);
        this.ippon1Box.setTablaManager(tablaManager);
        this.ippon2Box.setTablaManager(tablaManager);
        this.ippon3Box.setTablaManager(tablaManager);
        this.shidoBox.setTablaManager(tablaManager);
        this.chuiBox.setTablaManager(tablaManager);
        this.hansokumakeBox.setTablaManager(tablaManager);
        this.penaltyTracker.setTablaManager(tablaManager);
        this.challengePanel.setTablaManager(tablaManager);
    }

    public void setTextSource(TextSource textSource) {
        this.challengePanel.setTextSource(textSource);
        this.penaltyTracker.setTextSource(textSource);
    }

    public void redrawElements() {
        int width = this.getWidth();
        int height = this.getHeight();
        int pointsPanelHeight = (int)Math.floor((float)height * 0.5f);
        this.pointsPanel.setLocation(0, 0);
        this.pointsPanel.setSize(width, pointsPanelHeight);
        int penaltyTrackerHeight = (int)Math.floor((float)height * 0.25f);
        this.penaltyTracker.setLocation(0, pointsPanelHeight);
        this.penaltyTracker.setSize(width, penaltyTrackerHeight);
        this.challengePanel.setLocation(0, pointsPanelHeight + penaltyTrackerHeight);
        this.challengePanel.setSize(width, height - pointsPanelHeight - penaltyTrackerHeight);
        this.wazariBox.redrawElements();
        this.ippon1Box.redrawElements();
        this.ippon2Box.redrawElements();
        this.ippon3Box.redrawElements();
        this.shidoBox.redrawElements();
        this.chuiBox.redrawElements();
        this.hansokumakeBox.redrawElements();
        this.penaltyTracker.redrawElements();
        this.challengePanel.redrawElements();
        this.repaint();
    }

    @Override
    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.pointsPanel != null) {
            this.pointsPanel.setBackground(bg);
        }
        if (this.wazariBox != null) {
            this.wazariBox.setBackground(bg);
        }
        if (this.ippon1Box != null) {
            this.ippon1Box.setBackground(bg);
        }
        if (this.ippon2Box != null) {
            this.ippon2Box.setBackground(bg);
        }
        if (this.ippon3Box != null) {
            this.ippon3Box.setBackground(bg);
        }
        if (this.shidoBox != null) {
            this.shidoBox.setBackground(bg);
        }
        if (this.chuiBox != null) {
            this.chuiBox.setBackground(bg);
        }
        if (this.hansokumakeBox != null) {
            this.hansokumakeBox.setBackground(bg);
        }
        if (this.challengePanel != null) {
            this.challengePanel.setBackground(bg);
        }
        if (this.penaltyTracker != null) {
            this.penaltyTracker.setBackground(bg);
        }
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.pointsPanel != null) {
            this.pointsPanel.setForeground(fg);
        }
        if (this.wazariBox != null) {
            this.wazariBox.setForeground(fg);
        }
        if (this.ippon1Box != null) {
            this.ippon1Box.setForeground(fg);
        }
        if (this.ippon2Box != null) {
            this.ippon2Box.setForeground(fg);
        }
        if (this.ippon3Box != null) {
            this.ippon3Box.setForeground(fg);
        }
        if (this.shidoBox != null) {
            this.shidoBox.setForeground(fg);
        }
        if (this.chuiBox != null) {
            this.chuiBox.setForeground(fg);
        }
        if (this.hansokumakeBox != null) {
            this.hansokumakeBox.setForeground(fg);
        }
        if (this.challengePanel != null) {
            this.challengePanel.setForeground(fg);
        }
        if (this.penaltyTracker != null) {
            this.penaltyTracker.setForeground(fg);
        }
    }
}

