/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.management.impl;

import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import si.nevensrok.common.dl.Pojo;
import si.nevensrok.common.dl.query.DataFilter;
import si.nevensrok.common.dl.query.FieldFilter;
import si.nevensrok.common.dl.query.Filter;
import si.nevensrok.common.dl.query.GroupFilter;
import si.nevensrok.common.dl.query.PageDataResult;
import si.nevensrok.common.dl.query.SimpleDataFilter;
import si.nevensrok.jtekma.common.category.Category;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.matches.Match;
import si.nevensrok.jtekma.common.matchupload.NextMatchUpload;
import si.nevensrok.jtekma.common.tatami.FightOrder;
import si.nevensrok.jtekma.common.tatami.Tatami;
import si.nevensrok.jtekma.common.tatami.TatamiFightOrder;
import si.nevensrok.jtekma.server.dl.dao.NextMatchUploadDAO;
import si.nevensrok.jtekma.server.fileuploader.FileUploader;
import si.nevensrok.jtekma.server.fileuploader.FtpFileUploader;
import si.nevensrok.jtekma.server.fileuploader.FtpsFileUploader;
import si.nevensrok.jtekma.server.fileuploader.ScpFileUploader;
import si.nevensrok.jtekma.server.fileuploader.SftpFileUploader;
import si.nevensrok.jtekma.server.htmlgenerator.NextFightHtmlGenerator;
import si.nevensrok.jtekma.server.jobs.NextMatchUploadJob;
import si.nevensrok.jtekma.server.management.CategoryManager;
import si.nevensrok.jtekma.server.management.CompetitionManager;
import si.nevensrok.jtekma.server.management.MatchManager;
import si.nevensrok.jtekma.server.management.NextMatchUploadManager;
import si.nevensrok.jtekma.server.management.TatamiManager;

public class NextMatchUploadManagerImpl
implements NextMatchUploadManager {
    private static final Logger log = LoggerFactory.getLogger(NextMatchUploadManagerImpl.class);
    private NextMatchUploadDAO nextMatchUploadDAO;
    private Scheduler scheduler;
    private NextFightHtmlGenerator nextFightHtmlGenerator;
    private CompetitionManager competitionManager;
    private TatamiManager tatamiManager;
    private MatchManager matchManager;
    private CategoryManager categoryManager;

    public void setNextMatchUploadDAO(NextMatchUploadDAO nextMatchUploadDAO) {
        this.nextMatchUploadDAO = nextMatchUploadDAO;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void setNextFightHtmlGenerator(NextFightHtmlGenerator nextFightHtmlGenerator) {
        this.nextFightHtmlGenerator = nextFightHtmlGenerator;
    }

    public void setCompetitionManager(CompetitionManager competitionManager) {
        this.competitionManager = competitionManager;
    }

    public void setTatamiManager(TatamiManager tatamiManager) {
        this.tatamiManager = tatamiManager;
    }

    public void setMatchManager(MatchManager matchManager) {
        this.matchManager = matchManager;
    }

    public void setCategoryManager(CategoryManager categoryManager) {
        this.categoryManager = categoryManager;
    }

    @Transactional(value="jtekmaTransactionManager")
    public NextMatchUpload createNextMatchUpload(NextMatchUpload nextMatchUpload) {
        log.debug("Creating next match upload: {}", (Object)nextMatchUpload);
        nextMatchUpload = (NextMatchUpload)this.nextMatchUploadDAO.create((Pojo)nextMatchUpload);
        if (nextMatchUpload.getStatus() == NextMatchUpload.Status.ACTIVE) {
            this.scheduleJobFor(nextMatchUpload);
        }
        return nextMatchUpload;
    }

    @Transactional(value="jtekmaTransactionManager")
    public NextMatchUpload updateNextMatchUpload(NextMatchUpload nextMatchUpload) {
        log.debug("Updating next match upload: {}", (Object)nextMatchUpload);
        nextMatchUpload = (NextMatchUpload)this.nextMatchUploadDAO.update((Pojo)nextMatchUpload);
        if (nextMatchUpload.getStatus() == NextMatchUpload.Status.ACTIVE) {
            this.scheduleJobFor(nextMatchUpload);
        } else {
            this.unscheduleJobFor(nextMatchUpload);
        }
        return nextMatchUpload;
    }

    @Transactional(value="jtekmaTransactionManager")
    public void deleteNextMatchUpload(NextMatchUpload nextMatchUpload) {
        this.unscheduleJobFor(nextMatchUpload);
        this.nextMatchUploadDAO.delete((Pojo)nextMatchUpload);
    }

    @Transactional(value="jtekmaTransactionManager")
    public NextMatchUpload getNextMatchUploadById(Long nextMatchUploadId) {
        return (NextMatchUpload)this.nextMatchUploadDAO.getById((Object)nextMatchUploadId);
    }

    @Transactional(value="jtekmaTransactionManager")
    public PageDataResult<NextMatchUpload> find(Competition competition, DataFilter dataFilter) {
        GroupFilter rootFilter = new GroupFilter(GroupFilter.Combine.AND);
        rootFilter.addFilter((Filter)new FieldFilter("competition", FieldFilter.Comparator.EQUAL, (Object)competition.getId()));
        rootFilter.addFilter(dataFilter.getFilter());
        ((SimpleDataFilter)dataFilter).setFilter((Filter)rootFilter);
        return this.nextMatchUploadDAO.find(dataFilter);
    }

    public void executeUpload(NextMatchUpload nextMatchUpload) {
        try {
            Competition competition = this.competitionManager.getCompetitionForNextMatchUpload(nextMatchUpload);
            SimpleDataFilter dataFilter = new SimpleDataFilter();
            dataFilter.setFetchCount(false);
            List tatamis = this.tatamiManager.find(competition, (DataFilter)dataFilter).getData();
            Collections.sort(tatamis, new Comparator<Tatami>(){

                @Override
                public int compare(Tatami o1, Tatami o2) {
                    return o1.getDisplayText().compareTo(o2.getDisplayText());
                }
            });
            LinkedList<TatamiFightOrder> tatamiFightOrders = new LinkedList<TatamiFightOrder>();
            for (Tatami tatami : tatamis) {
                TatamiFightOrder tatamiFightOrder = new TatamiFightOrder();
                tatamiFightOrders.add(tatamiFightOrder);
                tatami.setPassword(null);
                tatamiFightOrder.setTatami(tatami);
                tatamiFightOrder.setFightOrders(this.tatamiManager.getFightOrderForTatami(tatami));
                for (FightOrder fightOrder : tatamiFightOrder.getFightOrders()) {
                    Match match = fightOrder.getMatch();
                    if (match == null) continue;
                    match = this.matchManager.getByIdWithCompetitors(match.getMatchId());
                    fightOrder.setMatch(match);
                    Category category = this.categoryManager.getCategoryForMatch(match);
                    match.setCategory(category);
                }
            }
            String templatePage = nextMatchUpload.getPageTemplate();
            Locale locale = new Locale(nextMatchUpload.getPageLocale());
            String html = this.nextFightHtmlGenerator.generateHtml(templatePage, locale, tatamiFightOrders);
            FileUploader fileUploader = null;
            if (nextMatchUpload.getServerType() == NextMatchUpload.ServerType.FTP) {
                fileUploader = new FtpFileUploader();
            } else if (nextMatchUpload.getServerType() == NextMatchUpload.ServerType.FTPS) {
                fileUploader = new FtpsFileUploader();
            } else if (nextMatchUpload.getServerType() == NextMatchUpload.ServerType.SFTP) {
                fileUploader = new SftpFileUploader();
            } else if (nextMatchUpload.getServerType() == NextMatchUpload.ServerType.SCP) {
                fileUploader = new ScpFileUploader();
            }
            String hostname = nextMatchUpload.getHostname();
            int port = nextMatchUpload.getPort();
            String username = nextMatchUpload.getUsername();
            String password = nextMatchUpload.getPassword();
            String path = nextMatchUpload.getFileDirectory();
            String fileName = nextMatchUpload.getFileName();
            byte[] fileContent = html.getBytes("UTF8");
            boolean overrideExisting = true;
            fileUploader.uploadFile(hostname, port, username, password, path, fileName, fileContent, overrideExisting);
        }
        catch (Exception e) {
            log.error("Error uploading next fight match page", (Throwable)e);
        }
    }

    private void scheduleJobFor(NextMatchUpload nextMatchUpload) {
        try {
            TriggerKey triggerKey = new TriggerKey("nextMatchUpload_" + nextMatchUpload.getNextMatchUploadId(), "nextMatchUploads");
            Calendar startTime = Calendar.getInstance();
            startTime.add(13, 5);
            Trigger trigger = TriggerBuilder.newTrigger().withIdentity(triggerKey).startAt(startTime.getTime()).withSchedule((ScheduleBuilder)SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds(nextMatchUpload.getUploadDelay().longValue()).repeatForever()).withPriority(3).build();
            if (this.scheduler.checkExists(triggerKey)) {
                log.debug("Rescheduling next match upload job [{}]", (Object)nextMatchUpload);
                this.scheduler.rescheduleJob(triggerKey, trigger);
            } else {
                JobKey jobKey = new JobKey(triggerKey.getName(), triggerKey.getGroup());
                JobDataMap jobDataMap = new JobDataMap();
                jobDataMap.put("nextMatchUploadId", (Object)nextMatchUpload.getNextMatchUploadId());
                JobDetail jobDetail = JobBuilder.newJob(NextMatchUploadJob.class).withIdentity(jobKey).usingJobData(jobDataMap).build();
                log.debug("Scheduling next match upload job [{}]", (Object)nextMatchUpload);
                this.scheduler.scheduleJob(jobDetail, trigger);
            }
        }
        catch (Exception e) {
            log.error("Error scheduling next match upload job", (Throwable)e);
        }
    }

    private void unscheduleJobFor(NextMatchUpload nextMatchUpload) {
        try {
            TriggerKey triggerKey = new TriggerKey("nextMatchUpload_" + nextMatchUpload.getNextMatchUploadId(), "nextMatchUploads");
            if (this.scheduler.checkExists(triggerKey)) {
                log.debug("Unscheduling next match upload job for [{}]", (Object)nextMatchUpload);
                this.scheduler.unscheduleJob(triggerKey);
            }
        }
        catch (Exception e) {
            log.error("Error unscheduling next match upload job", (Throwable)e);
        }
    }
}

