/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.dataimport;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import si.nevensrok.common.dataexport.FileWriter;
import si.nevensrok.common.dataimport.FileContent;
import si.nevensrok.common.dataimport.FileLine;
import si.nevensrok.common.dataimport.FileReader;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.tatami.Semaphore;
import si.nevensrok.jtekma.server.dataimport.DataImportException;
import si.nevensrok.jtekma.server.dataimport.FileType;
import si.nevensrok.jtekma.server.dataimport.ImportUtil;
import si.nevensrok.jtekma.server.dataimport.ImporterUtil;
import si.nevensrok.jtekma.server.management.SemaphoreManager;

public class SemaphoreImporter {
    private static final int bufferSize = 65536;
    private SemaphoreManager semaphoreManager;

    public void setSemaphoreManager(SemaphoreManager semaphoreManager) {
        this.semaphoreManager = semaphoreManager;
    }

    public List<Semaphore> parseSemaphores(FileType fileType, byte[] fileData) throws Exception {
        LinkedList<Semaphore> semaphores = new LinkedList<Semaphore>();
        FileReader fileReader = ImporterUtil.getFileReader(fileType);
        FileContent fileContent = fileReader.readFile((InputStream)new ByteArrayInputStream(fileData));
        int semaphoreNameIndex = fileContent.getIndexOfHeaderCaseInsensitive(new String[]{"Semafor", "Ime semaforja", "Ime", "Naziv", "Semaphore", "Semaphore name", "Name"});
        int semaphorePasswordIndex = fileContent.getIndexOfHeaderCaseInsensitive(new String[]{"Geslo", "Password", "Semaphore password"});
        int semaphoreLinesIndex = fileContent.getIndexOfHeaderCaseInsensitive(new String[]{"Vrstice", "Rows"});
        if (semaphoreNameIndex < 0) {
            throw new DataImportException(DataImportException.ErrorType.NoSemaphoreName);
        }
        if (semaphorePasswordIndex < 0) {
            throw new DataImportException(DataImportException.ErrorType.NoSemaphorePassword);
        }
        for (FileLine fileLine : fileContent.getLines()) {
            String name = ImportUtil.formatName(fileLine.getData(semaphoreNameIndex));
            String password = fileLine.getData(semaphorePasswordIndex);
            Integer displayRows = ImportUtil.parseInt(fileLine.getData(semaphoreLinesIndex), 1);
            if (name == null || name.isEmpty()) continue;
            Semaphore semaphore = new Semaphore();
            semaphore.setName(name);
            semaphore.setPassword(password);
            semaphore.setDisplayRows(displayRows);
            semaphores.add(semaphore);
        }
        return semaphores;
    }

    public void importSemaphores(Competition competition, List<Semaphore> semaphores) throws Exception {
        for (Semaphore semaphore : semaphores) {
            semaphore.setCompetition(competition);
            if (this.semaphoreManager.getActiveSemaphoreByName(competition, semaphore.getName()) != null) continue;
            this.semaphoreManager.createSemaphore(semaphore);
        }
    }

    public byte[] exportSemaphores(FileType fileType, List<Semaphore> semaphores, String[] header) throws Exception {
        FileWriter fileWriter = ImporterUtil.getFileWriter(fileType);
        String[][] fileContent = new String[semaphores.size() + 1][];
        fileContent[0] = header;
        int i = 1;
        for (Semaphore semaphore : semaphores) {
            fileContent[i] = new String[]{semaphore.getName(), "", semaphore.getDisplayRows() != null ? semaphore.getDisplayRows().toString() : "1"};
            ++i;
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(65536);
        fileWriter.writeFile((OutputStream)buffer, fileContent);
        return buffer.toByteArray();
    }
}

