/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.ImageMath;
import com.jhlabs.image.WarpGrid;
import com.jhlabs.image.WholeImageFilter;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.PixelGrabber;

public class WarpFilter
extends WholeImageFilter {
    static final long serialVersionUID = 1299148944426051330L;
    private WarpGrid sourceGrid;
    private WarpGrid destGrid;
    private int frames = 1;

    public WarpFilter() {
    }

    public WarpFilter(WarpGrid warpGrid, WarpGrid warpGrid2) {
        this.sourceGrid = warpGrid;
        this.destGrid = warpGrid2;
    }

    public void setSourceGrid(WarpGrid warpGrid) {
        this.sourceGrid = warpGrid;
    }

    public WarpGrid getSourceGrid() {
        return this.sourceGrid;
    }

    public void setDestGrid(WarpGrid warpGrid) {
        this.destGrid = warpGrid;
    }

    public WarpGrid getDestGrid() {
        return this.destGrid;
    }

    public void setFrames(int n) {
        this.frames = n;
    }

    public int getFrames() {
        return this.frames;
    }

    protected void transformSpace(Rectangle rectangle) {
        rectangle.width *= this.frames;
    }

    public void imageComplete(int n) {
        if (n == 1 || n == 4) {
            this.consumer.imageComplete(n);
            return;
        }
        int n2 = this.originalSpace.width;
        int n3 = this.originalSpace.height;
        int[] nArray = new int[n2 * n3];
        if (this.frames <= 1) {
            this.sourceGrid.warp(this.inPixels, n2, n3, this.sourceGrid, this.destGrid, nArray);
            this.consumer.setPixels(0, 0, n2, n3, this.defaultRGBModel, nArray, 0, n2);
        } else {
            WarpGrid warpGrid = new WarpGrid(this.sourceGrid.rows, this.sourceGrid.cols, n2, n3);
            int n4 = 0;
            while (n4 < this.frames) {
                double d = (double)n4 / (double)(this.frames - 1);
                this.sourceGrid.lerp(d, this.destGrid, warpGrid);
                this.sourceGrid.warp(this.inPixels, n2, n3, this.sourceGrid, warpGrid, nArray);
                this.consumer.setPixels(n4 * n2, 0, n2, n3, this.defaultRGBModel, nArray, 0, n2);
                ++n4;
            }
        }
        this.consumer.imageComplete(n);
        this.inPixels = null;
    }

    public int[] getPixels(Image image, int n, int n2) {
        int[] nArray = new int[n * n2];
        nArray = new int[n * n2];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, n, n2, nArray, 0, n);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            System.err.println("interrupted waiting for pixels!");
            return null;
        }
        if ((pixelGrabber.status() & 0x80) != 0) {
            System.err.println("image fetch aborted or errored");
            return null;
        }
        return nArray;
    }

    public void morph(int[] nArray, int[] nArray2, int[] nArray3, WarpGrid warpGrid, WarpGrid warpGrid2, int n, int n2, double d) {
        WarpGrid warpGrid3 = new WarpGrid(warpGrid.rows, warpGrid.cols, n, n2);
        warpGrid.lerp(d, warpGrid2, warpGrid3);
        warpGrid.warp(nArray, n, n2, warpGrid, warpGrid3, nArray3);
        int[] nArray4 = new int[n * n2];
        warpGrid2.warp(nArray2, n, n2, warpGrid2, warpGrid3, nArray4);
        this.crossDissolve(nArray3, nArray4, n, n2, d);
    }

    public void crossDissolve(int[] nArray, int[] nArray2, int n, int n2, double d) {
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = 0;
            while (n5 < n) {
                nArray[n3] = ImageMath.mixColors(d, nArray[n3], nArray2[n3]);
                ++n3;
                ++n5;
            }
            ++n4;
        }
    }

    public String toString() {
        return "Distort/Mesh Warp...";
    }
}

