/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.css.converters.SizeConverter;
import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.skin.LabeledSkinBase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.css.CssMetaData;
import javafx.css.StyleOrigin;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableProperty;
import javafx.scene.control.Cell;
import javafx.scene.control.SkinBase;

public class CellSkinBase<C extends Cell, B extends BehaviorBase<C>>
extends LabeledSkinBase<C, B> {
    private DoubleProperty cellSize;
    static final double DEFAULT_CELL_SIZE = 24.0;

    public final double getCellSize() {
        return this.cellSize == null ? 24.0 : this.cellSize.get();
    }

    public final ReadOnlyDoubleProperty cellSizeProperty() {
        return this.cellSizePropertyImpl();
    }

    private DoubleProperty cellSizePropertyImpl() {
        if (this.cellSize == null) {
            this.cellSize = new StyleableDoubleProperty(24.0){

                @Override
                public void applyStyle(StyleOrigin origin, Number value) {
                    double size = value == null ? 24.0 : value.doubleValue();
                    super.applyStyle(origin, size <= 0.0 ? 24.0 : size);
                }

                @Override
                public void set(double value) {
                    super.set(value);
                    ((Cell)CellSkinBase.this.getSkinnable()).requestLayout();
                }

                @Override
                public Object getBean() {
                    return CellSkinBase.this;
                }

                @Override
                public String getName() {
                    return "cellSize";
                }

                @Override
                public CssMetaData<Cell<?>, Number> getCssMetaData() {
                    return StyleableProperties.CELL_SIZE;
                }
            };
        }
        return this.cellSize;
    }

    public CellSkinBase(C control, B behavior) {
        super(control, behavior);
        this.consumeMouseEvents(false);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    @Override
    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return CellSkinBase.getClassCssMetaData();
    }

    private static class StyleableProperties {
        private static final CssMetaData<Cell<?>, Number> CELL_SIZE = new CssMetaData<Cell<?>, Number>("-fx-cell-size", SizeConverter.getInstance(), 24.0){

            @Override
            public boolean isSettable(Cell<?> n) {
                CellSkinBase skin = (CellSkinBase)n.getSkin();
                return skin.cellSize == null || !skin.cellSize.isBound();
            }

            @Override
            public StyleableProperty<Number> getStyleableProperty(Cell<?> n) {
                CellSkinBase skin = (CellSkinBase)n.getSkin();
                return (StyleableProperty)((Object)skin.cellSizePropertyImpl());
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(SkinBase.getClassCssMetaData());
            styleables.add(CELL_SIZE);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

