/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.dl.dao;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.query.Query;
import si.nevensrok.common.dl.ExtendedDao;
import si.nevensrok.common.dl.ParamsBinder;
import si.nevensrok.jtekma.common.club.Club;
import si.nevensrok.jtekma.common.club.ClubCompetitorCount;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.competitors.Competitor;
import si.nevensrok.jtekma.server.dl.dto.club.ClubCompetitorCountDTO;
import si.nevensrok.jtekma.server.dl.dto.club.ClubDTO;

public class ClubDAO
extends ExtendedDao<Long, ClubDTO, Club> {
    public ClubDAO() {
        super(ClubDTO.class, Club.class);
    }

    protected String getTableFieldName(String fieldName) {
        if (fieldName.equalsIgnoreCase("id")) {
            return "id";
        }
        if (fieldName.equalsIgnoreCase("clubId")) {
            return "id";
        }
        if (fieldName.equalsIgnoreCase("name")) {
            return "name";
        }
        if (fieldName.equalsIgnoreCase("shortName")) {
            return "shortName";
        }
        if (fieldName.equalsIgnoreCase("competition")) {
            return "competition.id";
        }
        if (fieldName.equalsIgnoreCase("status")) {
            return "status";
        }
        throw new IllegalArgumentException("Unknown field name " + fieldName);
    }

    public Club getByIdForCompetition(Competition competition, Long clubId) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("select club from ClubDTO as club where club.id=");
        sqlQuery.append(params.addParam(clubId));
        sqlQuery.append(" and club.competition.id=");
        sqlQuery.append(params.addParam(competition.getCompetitionId()));
        Query query = this.createQuery(sqlQuery.toString());
        params.bindParams(query);
        query.setMaxResults(1);
        ClubDTO clubDTO = (ClubDTO)ClubDAO.getSingleResult((Query)query);
        Club club = null;
        if (clubDTO != null) {
            club = (Club)this.getAdapterPool().create(Club.class, (Object)clubDTO);
        }
        this.flush();
        return club;
    }

    public Club getClubForCompetitor(Competitor competitor) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("select competitor.club from CompetitorDTO as competitor where competitor.id=");
        sqlQuery.append(params.addParam(competitor.getCompetitorId()));
        Query query = this.createQuery(sqlQuery.toString());
        params.bindParams(query);
        query.setMaxResults(1);
        ClubDTO clubDTO = (ClubDTO)ClubDAO.getSingleResult((Query)query);
        Club club = null;
        if (clubDTO != null) {
            club = (Club)this.getAdapterPool().create(Club.class, (Object)clubDTO);
        }
        this.flush();
        return club;
    }

    public Club getActiveClubByName(Competition competition, String name) {
        ParamsBinder params = new ParamsBinder();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("select club from ClubDTO as club where club.competition.id=");
        sqlQuery.append(params.addParam(competition.getCompetitionId()));
        sqlQuery.append(" and UPPER(club.name)=UPPER(");
        sqlQuery.append(params.addParam(name));
        sqlQuery.append(") and club.status=");
        sqlQuery.append(params.addParam((Object)Club.Status.ACTIVE));
        Query query = this.createQuery(sqlQuery.toString());
        params.bindParams(query);
        query.setMaxResults(1);
        ClubDTO clubDTO = (ClubDTO)ClubDAO.getSingleResult((Query)query);
        Club club = null;
        if (clubDTO != null) {
            club = (Club)this.getAdapterPool().create(Club.class, (Object)clubDTO);
        }
        this.flush();
        return club;
    }

    public Map<Club, ClubCompetitorCount> getClubCompetitorCount(Set<Club> clubs) {
        HashMap<Club, ClubCompetitorCount> clubCompetitorCounts = new HashMap<Club, ClubCompetitorCount>();
        if (clubs.isEmpty()) {
            return clubCompetitorCounts;
        }
        HashMap<Long, Club> clubById = new HashMap<Long, Club>();
        for (Club club : clubs) {
            clubById.put(club.getClubId(), club);
        }
        ParamsBinder params = new ParamsBinder();
        StringBuilder sqlQuery = new StringBuilder();
        sqlQuery.append("select clubCompetitorCount from ClubCompetitorCountDTO as clubCompetitorCount where clubCompetitorCount.clubId in ");
        sqlQuery.append(params.addParam(clubById.keySet()));
        Query query = this.createQuery(sqlQuery.toString());
        params.bindParams(query);
        List list = query.getResultList();
        for (ClubCompetitorCountDTO clubCompetitorCountDTO : list) {
            ClubCompetitorCount clubCompetitorCount = (ClubCompetitorCount)this.getAdapterPool().create(ClubCompetitorCount.class, (Object)clubCompetitorCountDTO);
            clubCompetitorCounts.put((Club)clubById.get(clubCompetitorCountDTO.getClubId()), clubCompetitorCount);
        }
        this.flush();
        return clubCompetitorCounts;
    }
}

