/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.qrcode.codes;

import java.io.Serializable;
import java.net.URLDecoder;
import java.net.URLEncoder;
import si.nevensrok.common.qrcode.QRCode;
import si.nevensrok.common.qrcode.QRCodeException;
import si.nevensrok.common.qrcode.QRCodeType;

public class QRGAuthCode
implements QRCode,
Serializable {
    private static final long serialVersionUID = -3370340185875190424L;
    private Type type;
    private String applicationName;
    private String username;
    private String secret;
    private String issuer;
    private Algorithm algorithm;
    private Integer digits;
    private Integer counter;
    private Integer period;

    public QRGAuthCode() {
    }

    public QRGAuthCode(Type type, String applicationName, String username, String secret) {
        this.type = type;
        this.applicationName = applicationName;
        this.username = username;
        this.secret = secret;
    }

    public QRGAuthCode(Type type, String applicationName, String username, String secret, Integer counter) {
        this.type = type;
        this.applicationName = applicationName;
        this.username = username;
        this.secret = secret;
        this.counter = counter;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(Algorithm algorithm) {
        this.algorithm = algorithm;
    }

    public Integer getDigits() {
        return this.digits;
    }

    public void setDigits(Integer digits) {
        this.digits = digits;
    }

    public Integer getCounter() {
        return this.counter;
    }

    public void setCounter(Integer counter) {
        this.counter = counter;
    }

    public Integer getPeriod() {
        return this.period;
    }

    public void setPeriod(Integer period) {
        this.period = period;
    }

    public void setType(Type type) {
        this.type = type;
    }

    @Override
    public QRCodeType getType() {
        return QRCodeType.GAUTH;
    }

    @Override
    public String getCodeText() {
        try {
            StringBuilder codeText = new StringBuilder();
            codeText.append("otpauth://");
            codeText.append(this.type.name());
            codeText.append("/");
            codeText.append(URLEncoder.encode(this.applicationName, "UTF8"));
            codeText.append(":");
            codeText.append(URLEncoder.encode(this.username, "UTF8"));
            codeText.append("?secret=");
            codeText.append(URLEncoder.encode(this.secret, "UTF8"));
            if (this.issuer != null) {
                codeText.append("&issuer=");
                codeText.append(URLEncoder.encode(this.issuer, "UTF8"));
            }
            if (this.algorithm != null) {
                codeText.append("&algorithm=");
                codeText.append(URLEncoder.encode(this.algorithm.name(), "UTF8"));
            }
            if (this.digits != null) {
                codeText.append("&digits=");
                codeText.append(URLEncoder.encode(this.digits.toString(), "UTF8"));
            }
            if (this.counter != null) {
                codeText.append("&counter=");
                codeText.append(URLEncoder.encode(this.counter.toString(), "UTF8"));
            }
            if (this.period != null) {
                codeText.append("&period=");
                codeText.append(URLEncoder.encode(this.period.toString(), "UTF8"));
            }
            return codeText.toString();
        }
        catch (Exception e) {
            throw new QRCodeException("Error generating code text", e);
        }
    }

    @Override
    public void parseCode(String text) throws QRCodeException {
        try {
            String[] parts;
            if (!text.startsWith("otpauth://")) {
                throw new QRCodeException("Not a GAuth QR code");
            }
            int n = (text = text.substring(10)).indexOf(47);
            if (n < 0) {
                throw new QRCodeException("Not a GAuth QR code");
            }
            this.type = Type.valueOf(text.substring(0, n));
            if ((n = (text = text.substring(n + 1)).indexOf(58)) < 0) {
                throw new QRCodeException("Not a GAuth QR code");
            }
            this.applicationName = URLDecoder.decode(text.substring(0, n), "UTF8");
            if ((n = (text = text.substring(n + 1)).indexOf(63)) < 0) {
                throw new QRCodeException("Not a GAuth QR code");
            }
            this.username = URLDecoder.decode(text.substring(0, n), "UTF8");
            text = text.substring(n + 1);
            for (String part : parts = text.split("\\x26")) {
                n = part.indexOf(61);
                String name = part.substring(0, n);
                String value = URLDecoder.decode(part.substring(n + 1), "UTF8");
                if (name.equals("secret")) {
                    this.secret = value;
                    continue;
                }
                if (name.equals("issuer")) {
                    this.issuer = value;
                    continue;
                }
                if (name.equals("algorithm")) {
                    this.algorithm = Algorithm.valueOf(value);
                    continue;
                }
                if (name.equals("digits")) {
                    this.digits = Integer.parseInt(value);
                    continue;
                }
                if (name.equals("counter")) {
                    this.counter = Integer.parseInt(value);
                    continue;
                }
                if (name.equals("period")) {
                    this.period = Integer.parseInt(value);
                    continue;
                }
                throw new QRCodeException("Unknown parameter type: " + name);
            }
        }
        catch (Exception e) {
            throw new QRCodeException("Error while parsing QR code", e);
        }
    }

    public String toString() {
        return "QRGAuthCode [type=" + (Object)((Object)this.type) + ", applicationName=" + this.applicationName + ", username=" + this.username + ", secret=" + this.secret + ", issuer=" + this.issuer + ", algorithm=" + (Object)((Object)this.algorithm) + ", digits=" + this.digits + ", counter=" + this.counter + ", period=" + this.period + "]";
    }

    public static enum Algorithm {
        SHA1,
        SHA256,
        SHA512;

    }

    public static enum Type {
        totp,
        hotp;

    }
}

