/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.dataexport;

import java.io.OutputStream;
import java.util.regex.Pattern;
import si.nevensrok.common.dataexport.AbstractFileWriter;

public class CsvFileWriter
extends AbstractFileWriter {
    private String charsetName = "UTF-8";
    private char seperator = (char)59;
    private char quotechar = (char)34;
    private boolean alwaysUsequotechar = false;
    private boolean useWindowsEndLine = true;
    private OutputStream outputStream;

    public void setCharsetName(String charsetName) {
        this.charsetName = charsetName;
    }

    public void setSeperator(char seperator) {
        this.seperator = seperator;
    }

    public void setQuotechar(char quotechar) {
        this.quotechar = quotechar;
    }

    public void setAlwaysUsequotechar(boolean alwaysUsequotechar) {
        this.alwaysUsequotechar = alwaysUsequotechar;
    }

    public void setUseWindowsEndLine(boolean useWindowsEndLine) {
        this.useWindowsEndLine = useWindowsEndLine;
    }

    @Override
    public void init(OutputStream outputStream) throws Exception {
        this.outputStream = outputStream;
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public void writeLine(String[] line) throws Exception {
        for (int i = 0; i < line.length; ++i) {
            boolean useQuotes;
            if (i > 0) {
                this.outputStream.write(String.valueOf(this.seperator).getBytes(this.charsetName));
            }
            boolean bl = useQuotes = this.alwaysUsequotechar || line[i].indexOf(this.seperator) >= 0;
            if (useQuotes) {
                this.outputStream.write(String.valueOf(this.quotechar).getBytes(this.charsetName));
                this.outputStream.write(line[i].replaceAll(Pattern.quote(String.valueOf(this.seperator)), "\\" + this.seperator).getBytes(this.charsetName));
                this.outputStream.write(String.valueOf(this.quotechar).getBytes(this.charsetName));
                continue;
            }
            this.outputStream.write(line[i].getBytes(this.charsetName));
        }
        if (this.useWindowsEndLine) {
            this.outputStream.write(13);
        }
        this.outputStream.write(10);
    }
}

