/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.jms;

import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.task.TaskExecutor;
import si.nevensrok.common.jms.JmsMessageCoopier;
import si.nevensrok.common.jms.JmsMessageProcessor;
import si.nevensrok.common.jms.JmsMessageSenderImpl;
import si.nevensrok.common.jms.MessageCreator;
import si.nevensrok.common.jms.MessageHandler;
import si.nevensrok.common.jms.MessageProcessorChecker;
import si.nevensrok.common.jms.SimpleJmsMessageCoopier;
import si.nevensrok.common.jms.SourceType;

public class JmsMessageReplicator
implements InitializingBean,
DisposableBean {
    private ConnectionFactory sourceConnectionFactory;
    private String source;
    private SourceType sourceType = SourceType.QUEUE;
    private ConnectionFactory destinationConnectionFactory;
    private String destination;
    private SourceType destinationType = SourceType.QUEUE;
    private JmsMessageCoopier jmsMessageCoopier;
    private int consumers = 1;
    private MessageProcessorChecker messageProcessorChecker = null;
    private TaskExecutor taskExecutor = null;
    private JmsMessageProcessor jmsMessageProcessor;
    private JmsMessageSenderImpl jmsMessageSender;

    public ConnectionFactory getSourceConnectionFactory() {
        return this.sourceConnectionFactory;
    }

    public void setSourceConnectionFactory(ConnectionFactory sourceConnectionFactory) {
        this.sourceConnectionFactory = sourceConnectionFactory;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public SourceType getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(SourceType sourceType) {
        this.sourceType = sourceType;
    }

    public ConnectionFactory getDestinationConnectionFactory() {
        return this.destinationConnectionFactory;
    }

    public void setDestinationConnectionFactory(ConnectionFactory destinationConnectionFactory) {
        this.destinationConnectionFactory = destinationConnectionFactory;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public SourceType getDestinationType() {
        return this.destinationType;
    }

    public void setDestinationType(SourceType destinationType) {
        this.destinationType = destinationType;
    }

    public JmsMessageCoopier getJmsMessageCoopier() {
        return this.jmsMessageCoopier;
    }

    public void setJmsMessageCoopier(JmsMessageCoopier jmsMessageCoopier) {
        this.jmsMessageCoopier = jmsMessageCoopier;
    }

    public int getConsumers() {
        return this.consumers;
    }

    public void setConsumers(int consumers) {
        this.consumers = consumers;
    }

    public MessageProcessorChecker getMessageProcessorChecker() {
        return this.messageProcessorChecker;
    }

    public void setMessageProcessorChecker(MessageProcessorChecker messageProcessorChecker) {
        this.messageProcessorChecker = messageProcessorChecker;
    }

    public TaskExecutor getTaskExecutor() {
        return this.taskExecutor;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.getSourceConnectionFactory() == null) {
            throw new IllegalArgumentException("Property 'sourceConnectionFactory' is required");
        }
        if (this.getSource() == null) {
            throw new IllegalArgumentException("Property 'source' is required");
        }
        if (this.getSourceType() == null) {
            throw new IllegalArgumentException("Property 'sourceType' is required");
        }
        if (this.getDestinationConnectionFactory() == null) {
            throw new IllegalArgumentException("Property 'destinationConnectionFactory' is required");
        }
        if (this.getDestination() == null) {
            throw new IllegalArgumentException("Property 'destination' is required");
        }
        if (this.getDestinationType() == null) {
            throw new IllegalArgumentException("Property 'destinationType' is required");
        }
        if (this.getJmsMessageCoopier() == null) {
            this.setJmsMessageCoopier(new SimpleJmsMessageCoopier());
        }
        this.jmsMessageSender = new JmsMessageSenderImpl();
        this.jmsMessageSender.setConnectionFactory(this.getDestinationConnectionFactory());
        this.jmsMessageSender.setDestination(this.getDestination());
        this.jmsMessageSender.setDestinationType(this.getDestinationType());
        this.jmsMessageSender.afterPropertiesSet();
        this.jmsMessageProcessor = new JmsMessageProcessor();
        this.jmsMessageProcessor.setConnectionFactory(this.getSourceConnectionFactory());
        this.jmsMessageProcessor.setSource(this.getSource());
        this.jmsMessageProcessor.setSourceType(this.getSourceType());
        this.jmsMessageProcessor.setConsumers(this.getConsumers());
        this.jmsMessageProcessor.setMessageProcessorChecker(this.getMessageProcessorChecker());
        this.jmsMessageProcessor.setTaskExecutor(this.getTaskExecutor());
        this.jmsMessageProcessor.setMessageHandler(new MessageHandler(){

            @Override
            public Message handleMessage(Session sourceSession, final Message sourceMessage) throws Exception {
                JmsMessageReplicator.this.jmsMessageSender.send(new MessageCreator(){

                    @Override
                    public Message createMessage(Session destinationSession) throws JMSException {
                        return JmsMessageReplicator.this.getJmsMessageCoopier().copyMessage(destinationSession, sourceMessage);
                    }
                });
                return null;
            }
        });
        this.jmsMessageProcessor.afterPropertiesSet();
    }

    public void destroy() throws Exception {
        try {
            this.jmsMessageProcessor.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.jmsMessageSender.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

