/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.management.impl;

import org.jasypt.util.password.PasswordEncryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import si.nevensrok.common.dl.Pojo;
import si.nevensrok.common.dl.query.DataFilter;
import si.nevensrok.common.dl.query.FieldFilter;
import si.nevensrok.common.dl.query.Filter;
import si.nevensrok.common.dl.query.GroupFilter;
import si.nevensrok.common.dl.query.PageDataResult;
import si.nevensrok.common.dl.query.SimpleDataFilter;
import si.nevensrok.jtekma.common.competition.Competition;
import si.nevensrok.jtekma.common.fightinfo.FightInfo;
import si.nevensrok.jtekma.server.dl.dao.FightInfoDAO;
import si.nevensrok.jtekma.server.management.FightInfoManager;
import si.nevensrok.jtekma.services.common.Credentials;

@Transactional(value="jtekmaTransactionManager")
public class FightInfoManagerImpl
implements FightInfoManager {
    private static final Logger log = LoggerFactory.getLogger(FightInfoManagerImpl.class);
    private PasswordEncryptor passwordEncryptor;
    private FightInfoDAO fightInfoDAO;

    public void setPasswordEncryptor(PasswordEncryptor passwordEncryptor) {
        this.passwordEncryptor = passwordEncryptor;
    }

    public void setFightInfoDAO(FightInfoDAO fightInfoDAO) {
        this.fightInfoDAO = fightInfoDAO;
    }

    public FightInfo createFightInfo(FightInfo fightInfo) {
        fightInfo.setPassword(this.passwordEncryptor.encryptPassword(fightInfo.getPassword()));
        log.debug("Creating fight info: {}", (Object)fightInfo);
        return (FightInfo)this.fightInfoDAO.create((Pojo)fightInfo);
    }

    public FightInfo createFightInfoWithPassword(FightInfo fightInfo) {
        log.debug("Creating fight info: {}", (Object)fightInfo);
        return (FightInfo)this.fightInfoDAO.create((Pojo)fightInfo);
    }

    public FightInfo updateFightInfo(FightInfo fightInfo) {
        log.debug("Updating fight info: {}", (Object)fightInfo);
        return (FightInfo)this.fightInfoDAO.update((Pojo)fightInfo);
    }

    public void updateFightInfoPassword(FightInfo fightInfo) {
        fightInfo.setPassword(this.passwordEncryptor.encryptPassword(fightInfo.getPassword()));
        this.fightInfoDAO.updateFightInfoPassword(fightInfo);
    }

    public void deleteFightInfo(FightInfo fightInfo) {
        log.debug("Deleting fight info: {}", (Object)fightInfo);
        this.fightInfoDAO.delete((Pojo)fightInfo);
    }

    public FightInfo getFightInfoById(Long fightInfoId) {
        return (FightInfo)this.fightInfoDAO.getById((Object)fightInfoId);
    }

    public PageDataResult<FightInfo> find(Competition competition, DataFilter dataFilter) {
        GroupFilter rootFilter = new GroupFilter(GroupFilter.Combine.AND);
        rootFilter.addFilter((Filter)new FieldFilter("competition", FieldFilter.Comparator.EQUAL, (Object)competition.getId()));
        rootFilter.addFilter(dataFilter.getFilter());
        ((SimpleDataFilter)dataFilter).setFilter((Filter)rootFilter);
        return this.fightInfoDAO.find(dataFilter);
    }

    public FightInfo getFightInfoByCredentials(Credentials credentials) {
        if (credentials.getUsername() == null || credentials.getPassword() == null) {
            return null;
        }
        FightInfo fightInfo = this.fightInfoDAO.getFightInfoForActiveCompetition(credentials.getUsername());
        if (fightInfo == null) {
            return null;
        }
        if (this.passwordEncryptor.checkPassword(credentials.getPassword(), fightInfo.getPassword())) {
            return fightInfo;
        }
        return null;
    }

    public FightInfo getActiveFightInfoByUsername(Competition competition, String username) {
        return this.fightInfoDAO.getActiveFightInfoByName(competition, username);
    }
}

