/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.server.dl.dto.matches;

import java.util.Date;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import si.nevensrok.common.dl.Dto;
import si.nevensrok.common.objects.ObjectToString;
import si.nevensrok.jtekma.common.matches.Match;
import si.nevensrok.jtekma.server.dl.dto.category.CategoryDTO;
import si.nevensrok.jtekma.server.dl.dto.competitors.CompetitorDTO;
import si.nevensrok.jtekma.server.dl.dto.matches.MatchPointDTO;
import si.nevensrok.jtekma.server.dl.dto.matches.PointDetailDTO;

@Entity
@Table(name="matches")
public class MatchDTO
implements Dto<Long> {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="MATCHID_SEQ")
    @SequenceGenerator(name="MATCHID_SEQ", sequenceName="matchidseq", allocationSize=0)
    @Column(name="matchid", nullable=false)
    private Long matchId;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="competitor1", nullable=true, updatable=false)
    private CompetitorDTO competitor1;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="competitor2", nullable=true, updatable=false)
    private CompetitorDTO competitor2;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="categoryid", nullable=false, updatable=false)
    private CategoryDTO category;
    @Enumerated(value=EnumType.STRING)
    @Column(length=32, name="status", nullable=false)
    private Match.Status status;
    @Enumerated(value=EnumType.STRING)
    @Column(length=32, name="type", nullable=false)
    private Match.Type type;
    @Column(name="fightnumber", nullable=false)
    private Integer fightNumber;
    @Column(name="nowinner", nullable=false)
    private Boolean noWinner;
    @Column(name="notneeded", nullable=false)
    private Boolean notNeeded;
    @Column(name="matchempty", nullable=false)
    private Boolean matchEmpty;
    @OneToMany(mappedBy="match", fetch=FetchType.LAZY)
    private Set<MatchPointDTO> matchPoints;
    @OneToMany(mappedBy="match", fetch=FetchType.LAZY)
    private Set<PointDetailDTO> pointDetails;
    @Column(name="startedat", nullable=true)
    private Date startedAt;
    @Column(name="finishedat", nullable=true)
    private Date finishedAt;
    @Column(name="matchduration", nullable=true)
    private Integer matchDuration;
    @Column(name="fighttimeleft", nullable=true)
    private Integer fightTimeLeft;
    @Column(name="hosekomitime", nullable=true)
    private Integer hosekomiTime;
    @Column(name="injurytime1", nullable=true)
    private Integer injuryTime1;
    @Column(name="injurytime2", nullable=true)
    private Integer injuryTime2;
    @Column(name="challengeswon1", nullable=true)
    private Integer challengesWon1;
    @Column(name="challengeswon2", nullable=true)
    private Integer challengesWon2;
    @Column(name="challengeslost1", nullable=true)
    private Integer challengesLost1;
    @Column(name="challengeslost2", nullable=true)
    private Integer challengesLost2;

    public Long getId() {
        return this.getMatchId();
    }

    public void setId(Long id) {
        this.setMatchId(id);
    }

    public Long getMatchId() {
        return this.matchId;
    }

    public void setMatchId(Long matchId) {
        this.matchId = matchId;
    }

    public CompetitorDTO getCompetitor1() {
        return this.competitor1;
    }

    public void setCompetitor1(CompetitorDTO competitor1) {
        this.competitor1 = competitor1;
    }

    public CompetitorDTO getCompetitor2() {
        return this.competitor2;
    }

    public void setCompetitor2(CompetitorDTO competitor2) {
        this.competitor2 = competitor2;
    }

    public CategoryDTO getCategory() {
        return this.category;
    }

    public void setCategory(CategoryDTO category) {
        this.category = category;
    }

    public Match.Status getStatus() {
        return this.status;
    }

    public void setStatus(Match.Status status) {
        this.status = status;
    }

    public Match.Type getType() {
        return this.type;
    }

    public void setType(Match.Type type) {
        this.type = type;
    }

    public Integer getFightNumber() {
        return this.fightNumber;
    }

    public void setFightNumber(Integer fightNumber) {
        this.fightNumber = fightNumber;
    }

    public Boolean getNoWinner() {
        return this.noWinner;
    }

    public void setNoWinner(Boolean noWinner) {
        this.noWinner = noWinner;
    }

    public Boolean getNotNeeded() {
        return this.notNeeded;
    }

    public void setNotNeeded(Boolean notNeeded) {
        this.notNeeded = notNeeded;
    }

    public Boolean getMatchEmpty() {
        return this.matchEmpty;
    }

    public void setMatchEmpty(Boolean matchEmpty) {
        this.matchEmpty = matchEmpty;
    }

    public Set<MatchPointDTO> getMatchPoints() {
        return this.matchPoints;
    }

    public void setMatchPoints(Set<MatchPointDTO> matchPoints) {
        for (MatchPointDTO matchPointDTO : matchPoints) {
            matchPointDTO.setMatch(this);
        }
        this.matchPoints = matchPoints;
    }

    public Set<PointDetailDTO> getPointDetails() {
        return this.pointDetails;
    }

    public void setPointDetails(Set<PointDetailDTO> pointDetails) {
        for (PointDetailDTO pointDetailDTO : pointDetails) {
            pointDetailDTO.setMatch(this);
        }
        this.pointDetails = pointDetails;
    }

    public Date getStartedAt() {
        return this.startedAt;
    }

    public void setStartedAt(Date startedAt) {
        this.startedAt = startedAt;
    }

    public Date getFinishedAt() {
        return this.finishedAt;
    }

    public void setFinishedAt(Date finishedAt) {
        this.finishedAt = finishedAt;
    }

    public Integer getMatchDuration() {
        return this.matchDuration;
    }

    public void setMatchDuration(Integer matchDuration) {
        this.matchDuration = matchDuration;
    }

    public Integer getFightTimeLeft() {
        return this.fightTimeLeft;
    }

    public void setFightTimeLeft(Integer fightTimeLeft) {
        this.fightTimeLeft = fightTimeLeft;
    }

    public Integer getHosekomiTime() {
        return this.hosekomiTime;
    }

    public void setHosekomiTime(Integer hosekomiTime) {
        this.hosekomiTime = hosekomiTime;
    }

    public Integer getInjuryTime1() {
        return this.injuryTime1;
    }

    public void setInjuryTime1(Integer injuryTime1) {
        this.injuryTime1 = injuryTime1;
    }

    public Integer getInjuryTime2() {
        return this.injuryTime2;
    }

    public void setInjuryTime2(Integer injuryTime2) {
        this.injuryTime2 = injuryTime2;
    }

    public Integer getChallengesWon1() {
        return this.challengesWon1;
    }

    public void setChallengesWon1(Integer challengesWon1) {
        this.challengesWon1 = challengesWon1;
    }

    public Integer getChallengesWon2() {
        return this.challengesWon2;
    }

    public void setChallengesWon2(Integer challengesWon2) {
        this.challengesWon2 = challengesWon2;
    }

    public Integer getChallengesLost1() {
        return this.challengesLost1;
    }

    public void setChallengesLost1(Integer challengesLost1) {
        this.challengesLost1 = challengesLost1;
    }

    public Integer getChallengesLost2() {
        return this.challengesLost2;
    }

    public void setChallengesLost2(Integer challengesLost2) {
        this.challengesLost2 = challengesLost2;
    }

    public String toString() {
        return new ObjectToString(MatchDTO.class).addProperty("matchId", (Object)this.matchId).addProperty("competitor1", (Object)this.competitor1).addProperty("competitor2", (Object)this.competitor2).addProperty("status", (Object)this.status).addProperty("type", (Object)this.type).addProperty("fightNumber", (Object)this.fightNumber).addProperty("noWinner", (Object)this.noWinner).addProperty("notNeeded", (Object)this.notNeeded).addProperty("matchEmpty", (Object)this.matchEmpty).addPropertyDate("startedAt", this.startedAt).addPropertyDate("finishedAt", this.finishedAt).addProperty("matchDuration", (Object)this.matchDuration).addProperty("fightTimeLeft", (Object)this.fightTimeLeft).addProperty("hosekomiTime", (Object)this.hosekomiTime).addProperty("injuryTime1", (Object)this.injuryTime1).addProperty("injuryTime2", (Object)this.injuryTime2).addProperty("challengesWon1", (Object)this.challengesWon1).addProperty("challengesWon2", (Object)this.challengesWon2).addProperty("challengesLost1", (Object)this.challengesLost1).addProperty("challengesLost2", (Object)this.challengesLost2).generateString();
    }
}

