/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.ssl;

import java.io.ByteArrayInputStream;
import java.net.Socket;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import javax.security.cert.X509Certificate;
import org.bouncycastle.tls.crypto.TlsCertificate;
import si.nevensrok.common.network.tcp.CustomTlsClient;

public class BcSslSession
implements SSLSession {
    private CustomTlsClient tlsClient;
    private Socket socket;

    public BcSslSession(CustomTlsClient tlsClient, Socket socket) {
        this.tlsClient = tlsClient;
        this.socket = socket;
    }

    @Override
    public byte[] getId() {
        return new byte[0];
    }

    @Override
    public SSLSessionContext getSessionContext() {
        return null;
    }

    @Override
    public long getCreationTime() {
        return 0L;
    }

    @Override
    public long getLastAccessedTime() {
        return 0L;
    }

    @Override
    public void invalidate() {
    }

    @Override
    public boolean isValid() {
        return this.tlsClient.isSslSessionValid();
    }

    @Override
    public void putValue(String name, Object value) {
    }

    @Override
    public Object getValue(String name) {
        return null;
    }

    @Override
    public void removeValue(String name) {
    }

    @Override
    public String[] getValueNames() {
        return new String[0];
    }

    @Override
    public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
        try {
            TlsCertificate tlsCertificate = this.tlsClient.getServerCertificate();
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            return new Certificate[]{certificateFactory.generateCertificate(new ByteArrayInputStream(tlsCertificate.getEncoded()))};
        }
        catch (Exception e) {
            throw new RuntimeException("Error fetching server certificate", e);
        }
    }

    @Override
    public Certificate[] getLocalCertificates() {
        return new Certificate[0];
    }

    @Override
    public X509Certificate[] getPeerCertificateChain() throws SSLPeerUnverifiedException {
        return new X509Certificate[0];
    }

    @Override
    public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
        return null;
    }

    @Override
    public Principal getLocalPrincipal() {
        return null;
    }

    @Override
    public String getCipherSuite() {
        return "X.509";
    }

    @Override
    public String getProtocol() {
        return null;
    }

    @Override
    public String getPeerHost() {
        return this.tlsClient.getHostname();
    }

    @Override
    public int getPeerPort() {
        return this.socket.getPort();
    }

    @Override
    public int getPacketBufferSize() {
        return 0;
    }

    @Override
    public int getApplicationBufferSize() {
        return 0;
    }
}

