
/* Drop */

DROP TRIGGER methodusageid;
DROP TABLE IF EXISTS methodusage;
DROP SEQUENCE IF EXISTS methodusage_seq;



/* Create */

CREATE TABLE methodusage
(
	Id NUMBER(38) NOT NULL,
	UsageDate timestamp NOT NULL,
	MethodName VARCHAR2(2000) NOT NULL,
	BeanName VARCHAR2(2000),
	UsageCount NUMBER(8),
	MaxDuration NUMBER(38) NOT NULL,
	MinDuration NUMBER(38) NOT NULL,
	AverageDuration NUMBER(38) NOT NULL,
	PRIMARY KEY (Id)
);

--Sequence
create sequence methodusage_seq minvalue 1 start with 1 increment by 1 cache 20;

--Trigger
CREATE OR REPLACE TRIGGER methodusageid
BEFORE INSERT
	ON methodusage
	FOR EACH ROW
DECLARE
	generatedid NUMBER(38);
BEGIN
	SELECT methodusage_seq.nextval INTO generatedid from dual;
	:new.Id:=generatedid;
END;

/* Create indexes */
CREATE INDEX MethodusageSearchIndex1 ON methodusage (UsageDate, MethodName, BeanName);

