/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.rules.management;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import si.nevensrok.jtekma.common.management.RulesManager;
import si.nevensrok.jtekma.common.rules.CompetitionRules;

public class RulesManagerImpl
implements RulesManager,
BeanPostProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(RulesManagerImpl.class);
    private Map<String, CompetitionRules> rules = new LinkedHashMap<String, CompetitionRules>();
    private List<String> availableCompetitionRules = new LinkedList<String>();

    public List<String> getAvailableCompetitionRules() {
        return new LinkedList<String>(this.availableCompetitionRules);
    }

    public CompetitionRules getCompetitionRules(String name) {
        return this.rules.get(name);
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        CompetitionRules competitionRules;
        if (bean instanceof CompetitionRules && (competitionRules = (CompetitionRules)bean).getName() != null) {
            LOGGER.info("Competition rules bean with name {} found {}", (Object)competitionRules.getName(), (Object)competitionRules);
            this.rules.put(competitionRules.getName(), competitionRules);
        }
        ArrayList<CompetitionRules> rulesList = new ArrayList<CompetitionRules>(this.rules.values());
        Collections.sort(rulesList, new Comparator<CompetitionRules>(){

            @Override
            public int compare(CompetitionRules o1, CompetitionRules o2) {
                return -Integer.compare(o1.getPriority(), o2.getPriority());
            }
        });
        this.availableCompetitionRules.clear();
        for (CompetitionRules rules : rulesList) {
            this.availableCompetitionRules.add(rules.getName());
        }
        return bean;
    }
}

