/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.rules.rules2023;

import java.util.Set;
import si.nevensrok.jtekma.common.category.AgeCategoryOption;
import si.nevensrok.jtekma.common.matches.Match;
import si.nevensrok.jtekma.common.matches.MatchPoint;
import si.nevensrok.jtekma.common.matches.PointType;
import si.nevensrok.jtekma.common.rules.CompetitorType;
import si.nevensrok.jtekma.rules.basic.AbstractCompetitionRules;

public class CompetitionRules2023
extends AbstractCompetitionRules {
    public String getName() {
        return "Rules2023";
    }

    public int getPriority() {
        return 2023;
    }

    public float getFullIpponPoints() {
        return 50.0f;
    }

    public float getNewazaFinishingMovePoints() {
        return 100.0f;
    }

    public int getShidoWazariValue() {
        return 1;
    }

    public int getChuiWazariValue() {
        return 3;
    }

    public int getFightMaxPenaltyPoints() {
        return 6;
    }

    public int getNewazaMaxPenaltyPoints(AgeCategoryOption ageCategoryOption) {
        if (ageCategoryOption == null || ageCategoryOption.getNewazaPenaltyHansokumake() == null) {
            return 4;
        }
        return ageCategoryOption.getNewazaPenaltyHansokumake();
    }

    public boolean isDisqualificationByPenalties(Match.Type matchType, CompetitorType competitorType, Set<MatchPoint> points, AgeCategoryOption ageCategoryOption) {
        float chui;
        float shido;
        float hansokumake = this.getPoints(competitorType, PointType.HANSOKUMAKE, points);
        if (hansokumake > 0.0f) {
            return true;
        }
        if (matchType == Match.Type.FIGHT && (shido = this.getPoints(competitorType, PointType.SHIDO, points)) + (chui = this.getPoints(competitorType, PointType.CHUI, points)) * 3.0f >= 6.0f) {
            return true;
        }
        if (matchType == Match.Type.NEWAZA) {
            float penalty = this.getPoints(competitorType, PointType.PENALTY, points);
            if ((ageCategoryOption == null || ageCategoryOption.getNewazaPenaltyHansokumake() == null) && penalty >= 4.0f) {
                return true;
            }
            int hansokumakePenalties = ageCategoryOption.getNewazaPenaltyHansokumake();
            if (penalty >= (float)hansokumakePenalties) {
                return true;
            }
        }
        return false;
    }

    public boolean isFullIpponFor(CompetitorType competitorType, Set<MatchPoint> points) {
        float ippon1 = this.getPoints(competitorType, PointType.IPPON1, points);
        float ippon2 = this.getPoints(competitorType, PointType.IPPON2, points);
        float ippon3 = this.getPoints(competitorType, PointType.IPPON3, points);
        float ippon1_3p = this.getPoints(competitorType, PointType.IPPON1_3P, points);
        float ippon2_3p = this.getPoints(competitorType, PointType.IPPON2_3P, points);
        float ippon3_3p = this.getPoints(competitorType, PointType.IPPON3_3P, points);
        return ippon1 + ippon1_3p > 0.0f && ippon2 + ippon2_3p > 0.0f && (ippon3 > 0.0f || ippon3_3p > 0.0f);
    }

    public boolean isFinishingMove(CompetitorType competitorType, Set<MatchPoint> points) {
        float finishingMove = this.getPoints(competitorType, PointType.FINISHINGMOVE, points);
        float points100 = this.getPoints(competitorType, PointType.POINT100, points);
        return finishingMove > 0.0f || points100 > 0.0f;
    }

    public float sumIpponsFor(CompetitorType competitorType, Set<MatchPoint> points) {
        float ippon1 = this.getPoints(competitorType, PointType.IPPON1, points);
        float ippon2 = this.getPoints(competitorType, PointType.IPPON2, points);
        float ippon3 = this.getPoints(competitorType, PointType.IPPON3, points);
        float ippon1_3p = this.getPoints(competitorType, PointType.IPPON1_3P, points);
        float ippon2_3p = this.getPoints(competitorType, PointType.IPPON2_3P, points);
        float ippon3_3p = this.getPoints(competitorType, PointType.IPPON3_3P, points);
        return ippon1 + ippon2 + ippon3 + ippon1_3p + ippon2_3p + ippon3_3p;
    }

    protected float sumFightPointsFor(CompetitorType competitorType, Set<MatchPoint> points) {
        float wazari = this.getPoints(competitorType, PointType.WAZARI, points);
        float ippon1 = this.getPoints(competitorType, PointType.IPPON1, points);
        float ippon2 = this.getPoints(competitorType, PointType.IPPON2, points);
        float ippon3 = this.getPoints(competitorType, PointType.IPPON3, points);
        float ippon1_3p = this.getPoints(competitorType, PointType.IPPON1_3P, points);
        float ippon2_3p = this.getPoints(competitorType, PointType.IPPON2_3P, points);
        float ippon3_3p = this.getPoints(competitorType, PointType.IPPON3_3P, points);
        return wazari + (ippon1 + ippon2 + ippon3) * 2.0f + (ippon1_3p + ippon2_3p + ippon3_3p) * 3.0f;
    }

    protected float sumDuoPointsFor(CompetitorType competitorType, Set<MatchPoint> points) {
        float sum = 0.0f;
        for (int round = 1; round <= 5; ++round) {
            float min = Float.MAX_VALUE;
            float max = Float.MIN_VALUE;
            for (int judge = 1; judge <= 5; ++judge) {
                float p = this.getPoints(competitorType, round, judge, points);
                sum += p;
                if (p > max) {
                    max = p;
                }
                if (!(p < min)) continue;
                min = p;
            }
            sum -= min + max;
        }
        sum = (float)Math.round(sum * 100.0f) / 100.0f;
        return sum;
    }

    protected int sumIpponCategoriesFor(CompetitorType competitorType, Set<MatchPoint> points) {
        float ippon1 = this.getPoints(competitorType, PointType.IPPON1, points);
        float ippon2 = this.getPoints(competitorType, PointType.IPPON2, points);
        float ippon3 = this.getPoints(competitorType, PointType.IPPON3, points);
        float ippon1_3p = this.getPoints(competitorType, PointType.IPPON1_3P, points);
        float ippon2_3p = this.getPoints(competitorType, PointType.IPPON2_3P, points);
        float ippon3_3p = this.getPoints(competitorType, PointType.IPPON3_3P, points);
        return (ippon1 > 0.0f || ippon1_3p > 0.0f ? 1 : 0) + (ippon2 > 0.0f || ippon2_3p > 0.0f ? 1 : 0) + (ippon3 > 0.0f || ippon3_3p > 0.0f ? 1 : 0);
    }

    protected float sumNewazaPointsFor(CompetitorType competitorType, Set<MatchPoint> points) {
        float point1 = this.getPoints(competitorType, PointType.POINT1, points);
        float point2 = this.getPoints(competitorType, PointType.POINT2, points);
        float point3 = this.getPoints(competitorType, PointType.POINT3, points);
        float point4 = this.getPoints(competitorType, PointType.POINT4, points);
        float point5 = this.getPoints(competitorType, PointType.POINT5, points);
        float point6 = this.getPoints(competitorType, PointType.POINT6, points);
        float point7 = this.getPoints(competitorType, PointType.POINT7, points);
        float point100 = this.getPoints(competitorType, PointType.POINT100, points);
        if (point100 > 0.0f) {
            return 100.0f;
        }
        return point1 + point2 * 2.0f + point3 * 3.0f + point4 * 4.0f + point5 * 5.0f + point6 * 6.0f + point7 * 7.0f;
    }
}

