/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.streams;

import java.io.IOException;
import java.io.InputStream;
import si.nevensrok.common.buffer.ReadByteBuffer;
import si.nevensrok.common.encryption.Decryptor;
import si.nevensrok.common.streams.DataInputStream;

public class EncryptedInputStream
extends InputStream {
    private DataInputStream inputStream;
    private Decryptor decryptor;
    private boolean closed = false;
    private ReadByteBuffer buffer = new ReadByteBuffer(new byte[0]);
    private int maxMessageSize = 0x10000000;

    public EncryptedInputStream(InputStream inputStream, Decryptor decryptor) {
        this.inputStream = new DataInputStream(inputStream);
        this.decryptor = decryptor;
    }

    private void readData() throws IOException {
        int length = this.inputStream.readInt();
        if (length > this.maxMessageSize) {
            throw new IOException("Received array length " + length + " is too big");
        }
        byte[] data = this.inputStream.readBytes(length);
        this.buffer = new ReadByteBuffer(this.decryptor.decrypt(data));
    }

    @Override
    public synchronized int read() throws IOException {
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        while (this.buffer.isBufferEmpty()) {
            this.readData();
        }
        return this.buffer.get() & 0xFF;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        while (this.buffer.isBufferEmpty()) {
            this.readData();
        }
        int bytesToRead = Math.min(this.buffer.getDataAvailable(), len);
        this.buffer.get(b, off, bytesToRead);
        return bytesToRead;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.inputStream.close();
    }

    public void setMaxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }
}

