/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.fightinfo.gui;

import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import si.nevensrok.jtekma.common.competitors.Competitor;
import si.nevensrok.jtekma.common.competitors.CoupleCompetitor;
import si.nevensrok.jtekma.common.competitors.PersonCompetitor;
import si.nevensrok.jtekma.common.matches.Match;
import si.nevensrok.jtekma.common.tatami.Event;
import si.nevensrok.jtekma.common.tatami.FightOrder;

public class TatamiFightList
extends JPanel {
    private static final long serialVersionUID = -7337132073769189208L;
    private List<JPanel> lines = new LinkedList<JPanel>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFightOrder(List<FightOrder> fightOrders) {
        List<JPanel> list = this.lines;
        synchronized (list) {
            for (JPanel panel : this.lines) {
                this.remove(panel);
            }
            this.setLayout(new GridLayout(fightOrders.size(), 1));
            int num = 1;
            for (FightOrder fightOrder : fightOrders) {
                JPanel panel = new JPanel();
                panel.setLayout(new FlowLayout(0));
                panel.add(new JLabel(String.valueOf(num++)));
                panel.add(new JLabel(" | "));
                if (fightOrder.getMatch() != null) {
                    Competitor competitor2;
                    Match match = fightOrder.getMatch();
                    String competitor1Text = "";
                    String competitor2Text = "";
                    Competitor competitor1 = match.getCompetitor1();
                    if (competitor1 != null) {
                        if (competitor1 instanceof PersonCompetitor) {
                            PersonCompetitor personCompetitor = (PersonCompetitor)competitor1;
                            competitor1Text = personCompetitor.getShortName();
                        }
                        if (competitor1 instanceof CoupleCompetitor) {
                            CoupleCompetitor coupleCompetitor = (CoupleCompetitor)competitor1;
                            competitor1Text = coupleCompetitor.getShortName();
                        }
                        competitor1Text = competitor1Text + "/" + competitor1.getClub().getShortName();
                    }
                    if ((competitor2 = match.getCompetitor2()) != null) {
                        if (competitor2 instanceof PersonCompetitor) {
                            PersonCompetitor personCompetitor = (PersonCompetitor)competitor2;
                            competitor2Text = personCompetitor.getShortName();
                        }
                        if (competitor2 instanceof CoupleCompetitor) {
                            CoupleCompetitor coupleCompetitor = (CoupleCompetitor)competitor2;
                            competitor2Text = coupleCompetitor.getShortName();
                        }
                        competitor2Text = competitor2Text + "/" + competitor2.getClub().getShortName();
                    }
                    panel.add(new JLabel(competitor1Text));
                    panel.add(new JLabel(" - "));
                    panel.add(new JLabel(competitor2Text));
                    panel.add(new JLabel(" | "));
                    panel.add(new JLabel(match.getCategory().getShortName()));
                } else if (fightOrder.getEvent() != null) {
                    Event event = fightOrder.getEvent();
                    panel.add(new JLabel(event.getText()));
                }
                this.add(panel);
                this.lines.add(panel);
            }
            this.revalidate();
            this.repaint();
        }
    }
}

