/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.bytes;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import si.nevensrok.common.buffer.WriteByteBuffer;
import si.nevensrok.common.bytes.ByteBlock;
import si.nevensrok.common.utils.ArrayUtil;
import si.nevensrok.common.utils.FileUtil;

public class MemoryByteBlock
implements ByteBlock {
    private static final Charset UTF8 = Charset.forName("UTF8");
    private int position = 0;
    private int size = 0;
    private byte[] data;

    public MemoryByteBlock() {
        this(1024);
    }

    public MemoryByteBlock(byte[] data) {
        this.data = data;
    }

    public MemoryByteBlock(int initialSize) {
        this.data = new byte[initialSize];
    }

    @Override
    public long getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
        this.position = Math.min(this.position, this.size);
    }

    @Override
    public void clear() {
        this.setSize(0);
    }

    public int getBufferSize() {
        return this.data.length;
    }

    public byte[] getData() {
        return ArrayUtil.subArray((byte[])this.data, (int)0, (int)this.size);
    }

    public void copyData(byte[] target) {
        System.arraycopy(this.data, 0, target, 0, this.data.length);
    }

    public void copyData(byte[] target, int offset) {
        System.arraycopy(this.data, 0, target, offset, this.data.length);
    }

    public void copyData(byte[] target, int offset, int length) {
        System.arraycopy(this.data, 0, target, offset, length);
    }

    public synchronized void writeToFile(File file) throws IOException {
        FileUtil.writeFile((File)file, (byte[])this.data, (int)0, (int)this.size);
    }

    public synchronized void writeToStream(OutputStream outputStream) throws IOException {
        outputStream.write(this.data, 0, this.size);
    }

    protected void checkBufferSize() {
        this.checkBufferSize(0);
    }

    protected void checkBufferSize(int additionalSize) {
        long newSize;
        int sizeToCheck = this.position + additionalSize;
        if (sizeToCheck < this.data.length) {
            return;
        }
        for (newSize = (long)this.data.length; newSize <= (long)sizeToCheck; newSize *= 2L) {
        }
        if ((long)this.data.length == (newSize = Math.min(newSize, Integer.MAX_VALUE))) {
            throw new IllegalStateException("Buffer is already at maximum size");
        }
        byte[] newData = new byte[(int)newSize];
        System.arraycopy(this.data, 0, newData, 0, this.data.length);
        this.data = newData;
    }

    @Override
    public synchronized void setPosition(long position) {
        this.position = (int)position;
    }

    @Override
    public synchronized void changePositionBy(long positionDifference) {
        this.position = (int)((long)this.position + positionDifference);
    }

    @Override
    public synchronized long getCurrentPosition() {
        return this.position;
    }

    @Override
    public synchronized byte readBit() {
        this.checkBufferSize();
        byte b = (byte)(this.data[this.position++] & 1);
        this.size = Math.max(this.size, this.position);
        return b;
    }

    @Override
    public synchronized void writeBit(byte bit) {
        this.checkBufferSize();
        this.data[this.position++] = (byte)(bit & 1);
        this.size = Math.max(this.size, this.position);
    }

    @Override
    public synchronized boolean readBoolean() {
        this.checkBufferSize();
        boolean b = this.data[this.position++] != 0;
        this.size = Math.max(this.size, this.position);
        return b;
    }

    @Override
    public synchronized void writeBoolean(boolean value) {
        this.checkBufferSize();
        this.data[this.position++] = value ? (byte)1 : 0;
        this.size = Math.max(this.size, this.position);
    }

    @Override
    public synchronized void writeByte(byte b) {
        this.checkBufferSize();
        this.data[this.position++] = b;
        this.size = Math.max(this.size, this.position);
    }

    @Override
    public synchronized void writeByte(int b) {
        this.checkBufferSize();
        this.data[this.position++] = (byte)b;
        this.size = Math.max(this.size, this.position);
    }

    @Override
    public synchronized byte readByte() {
        this.checkBufferSize();
        byte b = this.data[this.position++];
        this.size = Math.max(this.size, this.position);
        return b;
    }

    @Override
    public synchronized int readUnsignedByte() {
        this.checkBufferSize();
        int b = this.data[this.position++] & 0xFF;
        this.size = Math.max(this.size, this.position);
        return b;
    }

    @Override
    public synchronized void writeUnsignedByte(int b) {
        this.checkBufferSize();
        this.data[this.position++] = (byte)b;
        this.size = Math.max(this.size, this.position);
    }

    @Override
    public synchronized short readShort() {
        this.checkBufferSize(2);
        short value = (short)(this.data[this.position++] << 8 & 0xFF00);
        value = (short)(value + (this.data[this.position++] & 0xFF));
        this.size = Math.max(this.size, this.position);
        return value;
    }

    @Override
    public synchronized void writeShort(short b) {
        this.checkBufferSize(2);
        this.data[this.position++] = (byte)(b >> 8 & 0xFF);
        this.data[this.position++] = (byte)(b & 0xFF);
        this.size = Math.max(this.size, this.position);
    }

    @Override
    public synchronized int readUnsignedShort() {
        this.checkBufferSize(2);
        int value = this.data[this.position++] << 8 & 0xFF00;
        this.size = Math.max(this.size, this.position);
        return value += this.data[this.position++] & 0xFF;
    }

    @Override
    public synchronized void writeUnsignedShort(int b) {
        this.checkBufferSize(2);
        this.data[this.position++] = (byte)(b >> 8 & 0xFF);
        this.data[this.position++] = (byte)(b & 0xFF);
        this.size = Math.max(this.size, this.position);
    }

    @Override
    public synchronized int readInt() {
        this.checkBufferSize(4);
        int value = this.data[this.position++] << 24 & 0xFF000000;
        value += this.data[this.position++] << 16 & 0xFF0000;
        value += this.data[this.position++] << 8 & 0xFF00;
        this.size = Math.max(this.size, this.position);
        return value += this.data[this.position++] & 0xFF;
    }

    @Override
    public synchronized void writeInt(int b) {
        this.checkBufferSize(4);
        this.data[this.position++] = (byte)(b >> 24 & 0xFF);
        this.data[this.position++] = (byte)(b >> 16 & 0xFF);
        this.data[this.position++] = (byte)(b >> 8 & 0xFF);
        this.data[this.position++] = (byte)(b & 0xFF);
        this.size = Math.max(this.size, this.position);
    }

    @Override
    public synchronized long readUnsignedInt() {
        this.checkBufferSize(4);
        long value = (long)this.data[this.position++] << 24 & 0xFF000000L;
        value += (long)this.data[this.position++] << 16 & 0xFF0000L;
        value += (long)this.data[this.position++] << 8 & 0xFF00L;
        this.size = Math.max(this.size, this.position);
        return value += (long)(this.data[this.position++] & 0xFF);
    }

    @Override
    public synchronized void writeUnsignedInt(long b) {
        this.checkBufferSize(4);
        this.data[this.position++] = (byte)(b >> 24 & 0xFFL);
        this.data[this.position++] = (byte)(b >> 16 & 0xFFL);
        this.data[this.position++] = (byte)(b >> 8 & 0xFFL);
        this.data[this.position++] = (byte)(b & 0xFFL);
        this.size = Math.max(this.size, this.position);
    }

    @Override
    public synchronized long readLong() {
        this.checkBufferSize(8);
        long value = (long)this.data[this.position++] << 56 & 0xFF00000000000000L;
        value += (long)this.data[this.position++] << 48 & 0xFF000000000000L;
        value += (long)this.data[this.position++] << 40 & 0xFF0000000000L;
        value += (long)this.data[this.position++] << 32 & 0xFF00000000L;
        value += (long)this.data[this.position++] << 24 & 0xFF000000L;
        value += (long)this.data[this.position++] << 16 & 0xFF0000L;
        value += (long)this.data[this.position++] << 8 & 0xFF00L;
        this.size = Math.max(this.size, this.position);
        return value += (long)(this.data[this.position++] & 0xFF);
    }

    @Override
    public synchronized void writeLong(long b) {
        this.checkBufferSize(8);
        this.data[this.position++] = (byte)(b >> 56 & 0xFFL);
        this.data[this.position++] = (byte)(b >> 48 & 0xFFL);
        this.data[this.position++] = (byte)(b >> 40 & 0xFFL);
        this.data[this.position++] = (byte)(b >> 32 & 0xFFL);
        this.data[this.position++] = (byte)(b >> 24 & 0xFFL);
        this.data[this.position++] = (byte)(b >> 16 & 0xFFL);
        this.data[this.position++] = (byte)(b >> 8 & 0xFFL);
        this.data[this.position++] = (byte)(b & 0xFFL);
        this.size = Math.max(this.size, this.position);
    }

    @Override
    public synchronized float readFloat() {
        int n = this.readInt();
        return Float.intBitsToFloat(n);
    }

    @Override
    public synchronized void writeFloat(float b) {
        this.writeInt(Float.floatToIntBits(b));
    }

    @Override
    public synchronized double readDouble() {
        long n = this.readLong();
        return Double.longBitsToDouble(n);
    }

    @Override
    public synchronized void writeDouble(double b) {
        this.writeLong(Double.doubleToLongBits(b));
    }

    @Override
    public synchronized byte[] readBytes(int length) {
        byte[] bytes = new byte[length];
        this.readBytes(bytes);
        return bytes;
    }

    @Override
    public synchronized void readBytes(byte[] buffer) {
        this.readBytes(buffer, 0, buffer.length);
    }

    @Override
    public synchronized void readBytes(byte[] buffer, int offset, int length) {
        this.checkBufferSize(length);
        System.arraycopy(this.data, this.position, buffer, offset, length);
        this.position += length;
        this.size = Math.max(this.size, this.position);
    }

    @Override
    public synchronized void writeBytes(byte[] buffer) {
        this.writeBytes(buffer, 0, buffer.length);
    }

    @Override
    public synchronized void writeBytes(byte[] buffer, int offset, int length) {
        this.checkBufferSize(length);
        System.arraycopy(buffer, offset, this.data, this.position, length);
        this.position += length;
        this.size = Math.max(this.size, this.position);
    }

    @Override
    public synchronized char readAsciiCharacter() {
        this.checkBufferSize();
        char b = (char)this.data[this.position++];
        this.size = Math.max(this.size, this.position);
        return b;
    }

    @Override
    public synchronized void writeAsciiCharacter(char b) {
        this.checkBufferSize();
        this.data[this.position++] = (byte)b;
        this.size = Math.max(this.size, this.position);
    }

    @Override
    public synchronized char readUtf8Character() {
        int n = this.readUnsignedByte();
        if (n <= 127) {
            return (char)n;
        }
        if (n >= 192 && n <= 223) {
            int n2 = this.readUnsignedByte();
            if (n2 >= 128 && n2 <= 191) {
                return new String(new byte[]{(byte)n, (byte)n2}, UTF8).charAt(0);
            }
        } else if (n >= 224 && n <= 239) {
            int n2 = this.readUnsignedByte();
            int n3 = this.readUnsignedByte();
            if (n2 >= 128 && n2 <= 191 && n3 >= 128 && n3 <= 191) {
                return new String(new byte[]{(byte)n, (byte)n2, (byte)n3}, UTF8).charAt(0);
            }
        } else if (n >= 240 && n <= 247) {
            int n2 = this.readUnsignedByte();
            int n3 = this.readUnsignedByte();
            int n4 = this.readUnsignedByte();
            if (n2 >= 128 && n2 <= 191 && n3 >= 128 && n3 <= 191 && n4 >= 128 && n4 <= 191) {
                return new String(new byte[]{(byte)n, (byte)n2, (byte)n3, (byte)n4}, UTF8).charAt(0);
            }
        }
        throw new IllegalStateException("Unknown UTF8 character");
    }

    @Override
    public synchronized void writeUtf8Character(char b) {
        if (b <= '\u007f') {
            this.writeByte(b);
        } else {
            byte[] bytes = new String(new char[]{b}).getBytes(UTF8);
            this.writeBytes(bytes);
        }
    }

    @Override
    public synchronized String readAsciiString() {
        int n;
        StringBuilder value = new StringBuilder();
        while ((n = this.readUnsignedByte()) != 0) {
            value.append((char)n);
        }
        return value.toString();
    }

    @Override
    public synchronized void writeAsciiString(String b) {
        for (int i = 0; i < b.length(); ++i) {
            char c = b.charAt(i);
            this.writeAsciiCharacter(c);
        }
        this.writeByte(0);
    }

    @Override
    public synchronized String readUtf8String() {
        int n;
        WriteByteBuffer buffer = new WriteByteBuffer();
        while ((n = this.readUnsignedByte()) != 0) {
            buffer.add((byte)n);
        }
        return new String(buffer.getBuffer(), 0, buffer.getLength(), UTF8);
    }

    @Override
    public synchronized void writeUtf8String(String b) {
        byte[] bytes = b.getBytes(UTF8);
        this.writeBytes(bytes);
        this.writeByte(0);
    }
}

