/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.gui.horizontal;

import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import javax.swing.JLabel;
import javax.swing.JPanel;
import si.nevensrok.jtekma.common.matches.Match;
import si.nevensrok.jtekma.common.matches.MatchPoint;
import si.nevensrok.jtekma.common.matches.PointDetail;
import si.nevensrok.jtekma.common.matches.PointType;
import si.nevensrok.jtekma.common.rules.CompetitionRules;
import si.nevensrok.jtekma.common.rules.CompetitorType;
import si.nevensrok.jtekma.rules.rules2023.CompetitionRules2023;
import si.nevensrok.jtekma.tabla.common.Constants;
import si.nevensrok.jtekma.tabla.common.FightPoints;
import si.nevensrok.jtekma.tabla.common.MatchData;
import si.nevensrok.jtekma.tabla.fw.TablaManager;
import si.nevensrok.jtekma.tabla.util.FontSizeUtil;

public class FightPointBox
extends JPanel {
    private CompetitorType competitorType;
    private PointType pointType;
    private JLabel pointNameLabel = new JLabel();
    private JLabel pointValue1Label = new JLabel("0");
    private JLabel pointValue2Label = new JLabel("0");
    private JLabel emptyLabel = new JLabel();
    private FightPoints fightPoints;
    private MatchData matchData;
    private TablaManager tablaManager;
    private Color backgroundColor;

    public FightPointBox(String pointName, CompetitorType competitorType, PointType pointType) {
        this.competitorType = competitorType;
        this.pointType = pointType;
        this.pointNameLabel.setText(pointName);
        this.pointNameLabel.setHorizontalAlignment(0);
        this.pointValue1Label.setHorizontalAlignment(0);
        this.pointValue2Label.setHorizontalAlignment(0);
        this.setLayout(new GridLayout(3, 1));
        this.add(this.pointNameLabel);
        this.add(this.pointValue1Label);
        this.pointValue1Label.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 1) {
                    FightPointBox.this.increasePoint1();
                } else {
                    FightPointBox.this.decreasePoint1();
                }
            }
        });
        if (pointType == PointType.IPPON1 || pointType == PointType.IPPON2 || pointType == PointType.IPPON3) {
            this.add(this.pointValue2Label);
            this.pointValue2Label.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.getButton() == 1) {
                        FightPointBox.this.increasePoint2();
                    } else {
                        FightPointBox.this.decreasePoint2();
                    }
                }
            });
        } else {
            this.add(this.emptyLabel);
        }
    }

    public void setFightPoints(FightPoints fightPoints) {
        this.fightPoints = fightPoints;
    }

    public void setMatchData(MatchData matchData) {
        this.matchData = matchData;
    }

    public void setTablaManager(TablaManager tablaManager) {
        this.tablaManager = tablaManager;
    }

    private void increasePoint1() {
        if (this.pointType == PointType.WAZARI) {
            if (this.competitorType == CompetitorType.COMPETITOR1) {
                int p = this.fightPoints.getWazari1() + 1;
                this.fightPoints.setWazari1(p);
            } else if (this.competitorType == CompetitorType.COMPETITOR2) {
                int p = this.fightPoints.getWazari2() + 1;
                this.fightPoints.setWazari2(p);
            }
            this.fightPoints.addPointDetail(new PointDetail(Integer.valueOf((int)(this.matchData.getTimeFromStart() / 1000L)), this.pointType, this.competitorType, PointDetail.ChangeType.ADD));
        } else if (this.pointType == PointType.IPPON1) {
            if (this.competitorType == CompetitorType.COMPETITOR1) {
                int p = this.fightPoints.getIppon1_1() + 1;
                this.fightPoints.setIppon1_1(p);
            } else if (this.competitorType == CompetitorType.COMPETITOR2) {
                int p = this.fightPoints.getIppon2_1() + 1;
                this.fightPoints.setIppon2_1(p);
            }
            this.fightPoints.addPointDetail(new PointDetail(Integer.valueOf((int)(this.matchData.getTimeFromStart() / 1000L)), this.pointType, this.competitorType, PointDetail.ChangeType.ADD));
        } else if (this.pointType == PointType.IPPON2) {
            if (this.competitorType == CompetitorType.COMPETITOR1) {
                int p = this.fightPoints.getIppon1_2() + 1;
                this.fightPoints.setIppon1_2(p);
            } else if (this.competitorType == CompetitorType.COMPETITOR2) {
                int p = this.fightPoints.getIppon2_2() + 1;
                this.fightPoints.setIppon2_2(p);
            }
            this.fightPoints.addPointDetail(new PointDetail(Integer.valueOf((int)(this.matchData.getTimeFromStart() / 1000L)), this.pointType, this.competitorType, PointDetail.ChangeType.ADD));
        } else if (this.pointType == PointType.IPPON3) {
            if (this.competitorType == CompetitorType.COMPETITOR1) {
                int p = this.fightPoints.getIppon1_3() + 1;
                this.fightPoints.setIppon1_3(p);
            } else if (this.competitorType == CompetitorType.COMPETITOR2) {
                int p = this.fightPoints.getIppon2_3() + 1;
                this.fightPoints.setIppon2_3(p);
            }
            this.fightPoints.addPointDetail(new PointDetail(Integer.valueOf((int)(this.matchData.getTimeFromStart() / 1000L)), this.pointType, this.competitorType, PointDetail.ChangeType.ADD));
        } else if (this.pointType == PointType.SHIDO) {
            if (this.competitorType == CompetitorType.COMPETITOR1) {
                HashSet<MatchPoint> points = new HashSet<MatchPoint>();
                points.add(this.generateMatchPoint(PointType.SHIDO, this.fightPoints.getShido1() + 1, CompetitorType.COMPETITOR1));
                points.add(this.generateMatchPoint(PointType.CHUI, this.fightPoints.getChui1(), CompetitorType.COMPETITOR1));
                boolean isHansokumake = this.tablaManager.getCurrentCompetitionRules().isDisqualificationByPenalties(Match.Type.FIGHT, CompetitorType.COMPETITOR1, points, null);
                if (!isHansokumake) {
                    int s = this.fightPoints.getShido1() + 1;
                    this.fightPoints.setShido1(s);
                    int p = this.fightPoints.getWazari2() + this.tablaManager.getCurrentCompetitionRules().getShidoWazariValue();
                    this.fightPoints.setWazari2(p);
                    this.fightPoints.addPointDetail(new PointDetail(Integer.valueOf((int)(this.matchData.getTimeFromStart() / 1000L)), this.pointType, this.competitorType, PointDetail.ChangeType.ADD));
                } else {
                    this.fightPoints.setHansokumake1(1);
                    this.fightPoints.addPointDetail(new PointDetail(Integer.valueOf((int)(this.matchData.getTimeFromStart() / 1000L)), PointType.HANSOKUMAKE, this.competitorType, PointDetail.ChangeType.ADD));
                }
            } else if (this.competitorType == CompetitorType.COMPETITOR2) {
                HashSet<MatchPoint> points = new HashSet<MatchPoint>();
                points.add(this.generateMatchPoint(PointType.SHIDO, this.fightPoints.getShido2() + 1, CompetitorType.COMPETITOR2));
                points.add(this.generateMatchPoint(PointType.CHUI, this.fightPoints.getChui2(), CompetitorType.COMPETITOR2));
                boolean isHansokumake = this.tablaManager.getCurrentCompetitionRules().isDisqualificationByPenalties(Match.Type.FIGHT, CompetitorType.COMPETITOR2, points, null);
                if (!isHansokumake) {
                    int s = this.fightPoints.getShido2() + 1;
                    this.fightPoints.setShido2(s);
                    int p = this.fightPoints.getWazari1() + this.tablaManager.getCurrentCompetitionRules().getShidoWazariValue();
                    this.fightPoints.setWazari1(p);
                    this.fightPoints.addPointDetail(new PointDetail(Integer.valueOf((int)(this.matchData.getTimeFromStart() / 1000L)), this.pointType, this.competitorType, PointDetail.ChangeType.ADD));
                } else {
                    this.fightPoints.setHansokumake2(1);
                    this.fightPoints.addPointDetail(new PointDetail(Integer.valueOf((int)(this.matchData.getTimeFromStart() / 1000L)), PointType.HANSOKUMAKE, this.competitorType, PointDetail.ChangeType.ADD));
                }
            }
        } else if (this.pointType == PointType.CHUI) {
            if (this.competitorType == CompetitorType.COMPETITOR1) {
                HashSet<MatchPoint> points = new HashSet<MatchPoint>();
                points.add(this.generateMatchPoint(PointType.SHIDO, this.fightPoints.getShido1(), CompetitorType.COMPETITOR1));
                points.add(this.generateMatchPoint(PointType.CHUI, this.fightPoints.getChui1() + 1, CompetitorType.COMPETITOR1));
                boolean isHansokumake = this.tablaManager.getCurrentCompetitionRules().isDisqualificationByPenalties(Match.Type.FIGHT, CompetitorType.COMPETITOR1, points, null);
                if (!isHansokumake) {
                    int s = this.fightPoints.getChui1() + 1;
                    this.fightPoints.setChui1(s);
                    int p = this.fightPoints.getWazari2() + this.tablaManager.getCurrentCompetitionRules().getChuiWazariValue();
                    this.fightPoints.setWazari2(p);
                    this.fightPoints.addPointDetail(new PointDetail(Integer.valueOf((int)(this.matchData.getTimeFromStart() / 1000L)), this.pointType, this.competitorType, PointDetail.ChangeType.ADD));
                } else {
                    this.fightPoints.setHansokumake1(1);
                    this.fightPoints.addPointDetail(new PointDetail(Integer.valueOf((int)(this.matchData.getTimeFromStart() / 1000L)), PointType.HANSOKUMAKE, this.competitorType, PointDetail.ChangeType.ADD));
                }
            } else if (this.competitorType == CompetitorType.COMPETITOR2) {
                HashSet<MatchPoint> points = new HashSet<MatchPoint>();
                points.add(this.generateMatchPoint(PointType.SHIDO, this.fightPoints.getShido2(), CompetitorType.COMPETITOR2));
                points.add(this.generateMatchPoint(PointType.CHUI, this.fightPoints.getChui2() + 1, CompetitorType.COMPETITOR2));
                boolean isHansokumake = this.tablaManager.getCurrentCompetitionRules().isDisqualificationByPenalties(Match.Type.FIGHT, CompetitorType.COMPETITOR2, points, null);
                if (!isHansokumake) {
                    int s = this.fightPoints.getChui2() + 1;
                    this.fightPoints.setChui2(s);
                    int p = this.fightPoints.getWazari1() + this.tablaManager.getCurrentCompetitionRules().getChuiWazariValue();
                    this.fightPoints.setWazari1(p);
                    this.fightPoints.addPointDetail(new PointDetail(Integer.valueOf((int)(this.matchData.getTimeFromStart() / 1000L)), this.pointType, this.competitorType, PointDetail.ChangeType.ADD));
                } else {
                    this.fightPoints.setHansokumake2(1);
                    this.fightPoints.addPointDetail(new PointDetail(Integer.valueOf((int)(this.matchData.getTimeFromStart() / 1000L)), PointType.HANSOKUMAKE, this.competitorType, PointDetail.ChangeType.ADD));
                }
            }
        } else if (this.pointType == PointType.HANSOKUMAKE) {
            if (this.competitorType == CompetitorType.COMPETITOR1) {
                if (this.fightPoints.getHansokumake1() == 0) {
                    this.fightPoints.setHansokumake1(1);
                    this.fightPoints.addPointDetail(new PointDetail(Integer.valueOf((int)(this.matchData.getTimeFromStart() / 1000L)), PointType.HANSOKUMAKE, this.competitorType, PointDetail.ChangeType.ADD));
                }
            } else if (this.competitorType == CompetitorType.COMPETITOR2 && this.fightPoints.getHansokumake2() == 0) {
                this.fightPoints.setHansokumake2(1);
                this.fightPoints.addPointDetail(new PointDetail(Integer.valueOf((int)(this.matchData.getTimeFromStart() / 1000L)), PointType.HANSOKUMAKE, this.competitorType, PointDetail.ChangeType.ADD));
            }
        }
        this.tablaManager.recalculatePoints();
    }

    private void decreasePoint1() {
        if (this.pointType == PointType.WAZARI) {
            int p;
            if (this.competitorType == CompetitorType.COMPETITOR1) {
                int p2 = this.fightPoints.getWazari1() - 1;
                if (p2 >= 0) {
                    this.fightPoints.setWazari1(p2);
                }
            } else if (this.competitorType == CompetitorType.COMPETITOR2 && (p = this.fightPoints.getWazari2() - 1) >= 0) {
                this.fightPoints.setWazari2(p);
            }
            this.fightPoints.addPointDetail(new PointDetail(Integer.valueOf((int)(this.matchData.getTimeFromStart() / 1000L)), this.pointType, this.competitorType, PointDetail.ChangeType.REMOVE));
        } else if (this.pointType == PointType.IPPON1) {
            int p;
            if (this.competitorType == CompetitorType.COMPETITOR1) {
                int p3 = this.fightPoints.getIppon1_1() - 1;
                if (p3 >= 0) {
                    this.fightPoints.setIppon1_1(p3);
                }
            } else if (this.competitorType == CompetitorType.COMPETITOR2 && (p = this.fightPoints.getIppon2_1() - 1) >= 0) {
                this.fightPoints.setIppon2_1(p);
            }
            this.fightPoints.addPointDetail(new PointDetail(Integer.valueOf((int)(this.matchData.getTimeFromStart() / 1000L)), this.pointType, this.competitorType, PointDetail.ChangeType.REMOVE));
        } else if (this.pointType == PointType.IPPON2) {
            int p;
            if (this.competitorType == CompetitorType.COMPETITOR1) {
                int p4 = this.fightPoints.getIppon1_2() - 1;
                if (p4 >= 0) {
                    this.fightPoints.setIppon1_2(p4);
                }
            } else if (this.competitorType == CompetitorType.COMPETITOR2 && (p = this.fightPoints.getIppon2_2() - 1) >= 0) {
                this.fightPoints.setIppon2_2(p);
            }
            this.fightPoints.addPointDetail(new PointDetail(Integer.valueOf((int)(this.matchData.getTimeFromStart() / 1000L)), this.pointType, this.competitorType, PointDetail.ChangeType.REMOVE));
        } else if (this.pointType == PointType.IPPON3) {
            int p;
            if (this.competitorType == CompetitorType.COMPETITOR1) {
                int p5 = this.fightPoints.getIppon1_3() - 1;
                if (p5 >= 0) {
                    this.fightPoints.setIppon1_3(p5);
                }
            } else if (this.competitorType == CompetitorType.COMPETITOR2 && (p = this.fightPoints.getIppon2_3() - 1) >= 0) {
                this.fightPoints.setIppon2_3(p);
            }
            this.fightPoints.addPointDetail(new PointDetail(Integer.valueOf((int)(this.matchData.getTimeFromStart() / 1000L)), this.pointType, this.competitorType, PointDetail.ChangeType.REMOVE));
        } else if (this.pointType == PointType.SHIDO) {
            int s;
            if (this.competitorType == CompetitorType.COMPETITOR1) {
                int s2 = this.fightPoints.getShido1() - 1;
                if (s2 >= 0) {
                    this.fightPoints.setShido1(s2);
                    int p = this.fightPoints.getWazari2() - this.tablaManager.getCurrentCompetitionRules().getShidoWazariValue();
                    if (p < 0) {
                        p = 0;
                    }
                    this.fightPoints.setWazari2(p);
                    this.fightPoints.addPointDetail(new PointDetail(Integer.valueOf((int)(this.matchData.getTimeFromStart() / 1000L)), this.pointType, this.competitorType, PointDetail.ChangeType.REMOVE));
                }
            } else if (this.competitorType == CompetitorType.COMPETITOR2 && (s = this.fightPoints.getShido2() - 1) >= 0) {
                this.fightPoints.setShido2(s);
                int p = this.fightPoints.getWazari1() - this.tablaManager.getCurrentCompetitionRules().getShidoWazariValue();
                if (p < 0) {
                    p = 0;
                }
                this.fightPoints.setWazari1(p);
                this.fightPoints.addPointDetail(new PointDetail(Integer.valueOf((int)(this.matchData.getTimeFromStart() / 1000L)), this.pointType, this.competitorType, PointDetail.ChangeType.REMOVE));
            }
        } else if (this.pointType == PointType.CHUI) {
            int s;
            if (this.competitorType == CompetitorType.COMPETITOR1) {
                int s3 = this.fightPoints.getChui1() - 1;
                if (s3 >= 0) {
                    this.fightPoints.setChui1(s3);
                    int p = this.fightPoints.getWazari2() - this.tablaManager.getCurrentCompetitionRules().getChuiWazariValue();
                    if (p < 0) {
                        p = 0;
                    }
                    this.fightPoints.setWazari2(p);
                    this.fightPoints.addPointDetail(new PointDetail(Integer.valueOf((int)(this.matchData.getTimeFromStart() / 1000L)), this.pointType, this.competitorType, PointDetail.ChangeType.REMOVE));
                }
            } else if (this.competitorType == CompetitorType.COMPETITOR2 && (s = this.fightPoints.getChui2() - 1) >= 0) {
                this.fightPoints.setChui2(s);
                int p = this.fightPoints.getWazari1() - this.tablaManager.getCurrentCompetitionRules().getChuiWazariValue();
                if (p < 0) {
                    p = 0;
                }
                this.fightPoints.setWazari1(p);
                this.fightPoints.addPointDetail(new PointDetail(Integer.valueOf((int)(this.matchData.getTimeFromStart() / 1000L)), this.pointType, this.competitorType, PointDetail.ChangeType.REMOVE));
            }
        } else if (this.pointType == PointType.HANSOKUMAKE) {
            if (this.competitorType == CompetitorType.COMPETITOR1) {
                if (this.fightPoints.getHansokumake1() == 1) {
                    this.fightPoints.setHansokumake1(0);
                    this.fightPoints.addPointDetail(new PointDetail(Integer.valueOf((int)(this.matchData.getTimeFromStart() / 1000L)), PointType.HANSOKUMAKE, this.competitorType, PointDetail.ChangeType.REMOVE));
                }
            } else if (this.competitorType == CompetitorType.COMPETITOR2 && this.fightPoints.getHansokumake2() == 1) {
                this.fightPoints.setHansokumake2(0);
                this.fightPoints.addPointDetail(new PointDetail(Integer.valueOf((int)(this.matchData.getTimeFromStart() / 1000L)), PointType.HANSOKUMAKE, this.competitorType, PointDetail.ChangeType.REMOVE));
            }
        }
        this.tablaManager.recalculatePoints();
    }

    private void increasePoint2() {
        CompetitionRules competitionRules = this.tablaManager.getCurrentCompetitionRules();
        if (this.pointType == PointType.IPPON1) {
            if (this.competitorType == CompetitorType.COMPETITOR1) {
                int p = this.fightPoints.getIppon1_1_3p() + 1;
                this.fightPoints.setIppon1_1_3p(p);
            } else if (this.competitorType == CompetitorType.COMPETITOR2) {
                int p = this.fightPoints.getIppon2_1_3p() + 1;
                this.fightPoints.setIppon2_1_3p(p);
            }
            this.fightPoints.addPointDetail(new PointDetail(Integer.valueOf((int)(this.matchData.getTimeFromStart() / 1000L)), PointType.IPPON1_3P, this.competitorType, PointDetail.ChangeType.ADD));
        } else if (this.pointType == PointType.IPPON2) {
            if (this.competitorType == CompetitorType.COMPETITOR1) {
                int p = this.fightPoints.getIppon1_2_3p() + 1;
                this.fightPoints.setIppon1_2_3p(p);
            } else if (this.competitorType == CompetitorType.COMPETITOR2) {
                int p = this.fightPoints.getIppon2_2_3p() + 1;
                this.fightPoints.setIppon2_2_3p(p);
            }
            this.fightPoints.addPointDetail(new PointDetail(Integer.valueOf((int)(this.matchData.getTimeFromStart() / 1000L)), PointType.IPPON2_3P, this.competitorType, PointDetail.ChangeType.ADD));
        } else if (this.pointType == PointType.IPPON3) {
            if (this.competitorType == CompetitorType.COMPETITOR1) {
                int p = this.fightPoints.getIppon1_3_3p() + 1;
                this.fightPoints.setIppon1_3_3p(p);
            } else if (this.competitorType == CompetitorType.COMPETITOR2) {
                int p = this.fightPoints.getIppon2_3_3p() + 1;
                this.fightPoints.setIppon2_3_3p(p);
            }
            if (competitionRules instanceof CompetitionRules2023) {
                this.fightPoints.addPointDetail(new PointDetail(Integer.valueOf((int)(this.matchData.getTimeFromStart() / 1000L)), PointType.IPPON3_3P, this.competitorType, PointDetail.ChangeType.ADD));
            } else {
                this.fightPoints.addPointDetail(new PointDetail(Integer.valueOf((int)(this.matchData.getTimeFromStart() / 1000L)), PointType.IPPON3POINTS, this.competitorType, PointDetail.ChangeType.ADD));
            }
        }
        this.tablaManager.recalculatePoints();
    }

    private void decreasePoint2() {
        CompetitionRules competitionRules = this.tablaManager.getCurrentCompetitionRules();
        if (this.pointType == PointType.IPPON1) {
            int p;
            if (this.competitorType == CompetitorType.COMPETITOR1) {
                int p2 = this.fightPoints.getIppon1_1_3p() - 1;
                if (p2 >= 0) {
                    this.fightPoints.setIppon1_1_3p(p2);
                }
            } else if (this.competitorType == CompetitorType.COMPETITOR2 && (p = this.fightPoints.getIppon2_1_3p() - 1) >= 0) {
                this.fightPoints.setIppon2_1_3p(p);
            }
            this.fightPoints.addPointDetail(new PointDetail(Integer.valueOf((int)(this.matchData.getTimeFromStart() / 1000L)), PointType.IPPON1_3P, this.competitorType, PointDetail.ChangeType.REMOVE));
        } else if (this.pointType == PointType.IPPON2) {
            int p;
            if (this.competitorType == CompetitorType.COMPETITOR1) {
                int p3 = this.fightPoints.getIppon1_2_3p() - 1;
                if (p3 >= 0) {
                    this.fightPoints.setIppon1_2_3p(p3);
                }
            } else if (this.competitorType == CompetitorType.COMPETITOR2 && (p = this.fightPoints.getIppon2_2_3p() - 1) >= 0) {
                this.fightPoints.setIppon2_2_3p(p);
            }
            this.fightPoints.addPointDetail(new PointDetail(Integer.valueOf((int)(this.matchData.getTimeFromStart() / 1000L)), PointType.IPPON2_3P, this.competitorType, PointDetail.ChangeType.REMOVE));
        } else if (this.pointType == PointType.IPPON3) {
            int p;
            if (this.competitorType == CompetitorType.COMPETITOR1) {
                int p4 = this.fightPoints.getIppon1_3_3p() - 1;
                if (p4 >= 0) {
                    this.fightPoints.setIppon1_3_3p(p4);
                }
            } else if (this.competitorType == CompetitorType.COMPETITOR2 && (p = this.fightPoints.getIppon2_3_3p() - 1) >= 0) {
                this.fightPoints.setIppon2_3_3p(p);
            }
            if (competitionRules instanceof CompetitionRules2023) {
                this.fightPoints.addPointDetail(new PointDetail(Integer.valueOf((int)(this.matchData.getTimeFromStart() / 1000L)), PointType.IPPON3_3P, this.competitorType, PointDetail.ChangeType.REMOVE));
            } else {
                this.fightPoints.addPointDetail(new PointDetail(Integer.valueOf((int)(this.matchData.getTimeFromStart() / 1000L)), PointType.IPPON3POINTS, this.competitorType, PointDetail.ChangeType.REMOVE));
            }
        }
        this.tablaManager.recalculatePoints();
    }

    public void redrawElements() {
        CompetitionRules competitionRules = this.tablaManager.getCurrentCompetitionRules();
        if (this.pointType == PointType.WAZARI) {
            if (this.competitorType == CompetitorType.COMPETITOR1) {
                this.pointValue1Label.setText(String.valueOf(this.fightPoints.getWazari1()));
            } else if (this.competitorType == CompetitorType.COMPETITOR2) {
                this.pointValue1Label.setText(String.valueOf(this.fightPoints.getWazari2()));
            }
        } else if (this.pointType == PointType.IPPON1) {
            if (this.competitorType == CompetitorType.COMPETITOR1) {
                this.pointValue1Label.setText(String.valueOf(this.fightPoints.getIppon1_1()));
                this.pointValue2Label.setText(String.valueOf(this.fightPoints.getIppon1_1_3p()));
                if (this.fightPoints.getIppon1_1() > 0 || this.fightPoints.getIppon1_1_3p() > 0) {
                    this.setBgColor(Constants.COMPETITOR_1_BG_COLOR_IPPON);
                } else {
                    this.setBgColor(this.backgroundColor);
                }
            } else if (this.competitorType == CompetitorType.COMPETITOR2) {
                this.pointValue1Label.setText(String.valueOf(this.fightPoints.getIppon2_1()));
                this.pointValue2Label.setText(String.valueOf(this.fightPoints.getIppon2_1_3p()));
                if (this.fightPoints.getIppon2_1() > 0 || this.fightPoints.getIppon2_1_3p() > 0) {
                    this.setBgColor(Constants.COMPETITOR_2_BG_COLOR_IPPON);
                } else {
                    this.setBgColor(this.backgroundColor);
                }
            }
            this.remove(this.emptyLabel);
            this.remove(this.pointValue2Label);
            if (competitionRules instanceof CompetitionRules2023) {
                this.add(this.pointValue2Label);
            } else {
                this.add(this.emptyLabel);
            }
        } else if (this.pointType == PointType.IPPON2) {
            if (this.competitorType == CompetitorType.COMPETITOR1) {
                this.pointValue1Label.setText(String.valueOf(this.fightPoints.getIppon1_2()));
                this.pointValue2Label.setText(String.valueOf(this.fightPoints.getIppon1_2_3p()));
                if (this.fightPoints.getIppon1_2() > 0 || this.fightPoints.getIppon1_2_3p() > 0) {
                    this.setBgColor(Constants.COMPETITOR_1_BG_COLOR_IPPON);
                } else {
                    this.setBgColor(this.backgroundColor);
                }
            } else if (this.competitorType == CompetitorType.COMPETITOR2) {
                this.pointValue1Label.setText(String.valueOf(this.fightPoints.getIppon2_2()));
                this.pointValue2Label.setText(String.valueOf(this.fightPoints.getIppon2_2_3p()));
                if (this.fightPoints.getIppon2_2() > 0 || this.fightPoints.getIppon2_2_3p() > 0) {
                    this.setBgColor(Constants.COMPETITOR_2_BG_COLOR_IPPON);
                } else {
                    this.setBgColor(this.backgroundColor);
                }
            }
            this.remove(this.emptyLabel);
            this.remove(this.pointValue2Label);
            if (competitionRules instanceof CompetitionRules2023) {
                this.add(this.pointValue2Label);
            } else {
                this.add(this.emptyLabel);
            }
        } else if (this.pointType == PointType.IPPON3) {
            if (this.competitorType == CompetitorType.COMPETITOR1) {
                this.pointValue1Label.setText(String.valueOf(this.fightPoints.getIppon1_3()));
                this.pointValue2Label.setText(String.valueOf(this.fightPoints.getIppon1_3_3p()));
                if (this.fightPoints.getIppon1_3() > 0 || this.fightPoints.getIppon1_3_3p() > 0) {
                    this.setBgColor(Constants.COMPETITOR_1_BG_COLOR_IPPON);
                } else {
                    this.setBgColor(this.backgroundColor);
                }
            } else if (this.competitorType == CompetitorType.COMPETITOR2) {
                this.pointValue1Label.setText(String.valueOf(this.fightPoints.getIppon2_3()));
                this.pointValue2Label.setText(String.valueOf(this.fightPoints.getIppon2_3_3p()));
                if (this.fightPoints.getIppon2_3() > 0 || this.fightPoints.getIppon2_3_3p() > 0) {
                    this.setBgColor(Constants.COMPETITOR_2_BG_COLOR_IPPON);
                } else {
                    this.setBgColor(this.backgroundColor);
                }
            }
        } else if (this.pointType == PointType.SHIDO) {
            if (this.competitorType == CompetitorType.COMPETITOR1) {
                this.pointValue1Label.setText(String.valueOf(this.fightPoints.getShido1()));
            } else if (this.competitorType == CompetitorType.COMPETITOR2) {
                this.pointValue1Label.setText(String.valueOf(this.fightPoints.getShido2()));
            }
        } else if (this.pointType == PointType.CHUI) {
            if (this.competitorType == CompetitorType.COMPETITOR1) {
                this.pointValue1Label.setText(String.valueOf(this.fightPoints.getChui1()));
            } else if (this.competitorType == CompetitorType.COMPETITOR2) {
                this.pointValue1Label.setText(String.valueOf(this.fightPoints.getChui2()));
            }
        } else if (this.pointType == PointType.HANSOKUMAKE) {
            if (this.competitorType == CompetitorType.COMPETITOR1) {
                this.pointValue1Label.setText(String.valueOf(this.fightPoints.getHansokumake1()));
            } else if (this.competitorType == CompetitorType.COMPETITOR2) {
                this.pointValue1Label.setText(String.valueOf(this.fightPoints.getHansokumake2()));
            }
        }
        FontSizeUtil.refitFontSize(Constants.FONT, this.pointNameLabel, "I3");
        FontSizeUtil.refitFontSize(Constants.FONT, this.pointValue1Label, "99");
        FontSizeUtil.refitFontSize(Constants.FONT, this.pointValue2Label, "99");
        this.repaint();
    }

    private void setBgColor(Color bg) {
        super.setBackground(bg);
        if (this.pointNameLabel != null) {
            this.pointNameLabel.setBackground(bg);
        }
        if (this.pointValue1Label != null) {
            this.pointValue1Label.setBackground(bg);
        }
        if (this.pointValue2Label != null) {
            this.pointValue2Label.setBackground(bg);
        }
    }

    @Override
    public void setBackground(Color bg) {
        this.backgroundColor = bg;
        this.setBgColor(bg);
    }

    @Override
    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.pointNameLabel != null) {
            this.pointNameLabel.setForeground(fg);
        }
        if (this.pointValue1Label != null) {
            this.pointValue1Label.setForeground(fg);
        }
        if (this.pointValue2Label != null) {
            this.pointValue2Label.setForeground(fg);
        }
    }

    private MatchPoint generateMatchPoint(PointType pointType, float points, CompetitorType competitorType) {
        MatchPoint matchPoint = new MatchPoint();
        matchPoint.setPointType(pointType);
        matchPoint.setPoints(Float.valueOf(points));
        matchPoint.setCompetitor(competitorType);
        return matchPoint;
    }
}

