/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.jtekma.tabla.gui;

import java.awt.Dialog;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import si.nevensrok.jtekma.tabla.common.Constants;
import si.nevensrok.jtekma.tabla.common.MatchData;
import si.nevensrok.jtekma.tabla.gui.InjuryTimeCounter;
import si.nevensrok.jtekma.tabla.gui.TablaWindow;

public class InjuryTimeDialog
extends JDialog
implements InitializingBean,
DisposableBean,
ApplicationContextAware {
    private static final long serialVersionUID = 6797451306849846168L;
    private TablaWindow tablaWindow;
    private MatchData matchData;
    private ApplicationContext applicationContext;
    private InjuryTimeCounter competitor1counter;
    private InjuryTimeCounter competitor2counter;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setMatchData(MatchData matchData) {
        this.matchData = matchData;
    }

    public void afterPropertiesSet() throws Exception {
        this.competitor1counter = new InjuryTimeCounter(this, this.matchData, this.applicationContext);
        this.competitor2counter = new InjuryTimeCounter(this, this.matchData, this.applicationContext);
        this.competitor1counter.setBackground(Constants.COMPETITOR_1_BG_COLOR);
        this.competitor1counter.setForeground(Constants.COMPETITOR_1_FG_COLOR);
        this.competitor2counter.setBackground(Constants.COMPETITOR_2_BG_COLOR);
        this.competitor2counter.setForeground(Constants.COMPETITOR_2_FG_COLOR);
        this.add(this.competitor1counter);
        this.add(this.competitor2counter);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                InjuryTimeDialog.this.competitor1counter.redrawElements();
                InjuryTimeDialog.this.competitor2counter.redrawElements();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                InjuryTimeDialog.this.competitor1counter.stopTime();
                InjuryTimeDialog.this.competitor2counter.stopTime();
            }
        });
    }

    public void destroy() throws Exception {
        if (this.competitor1counter != null) {
            this.competitor1counter.destroy();
        }
        if (this.competitor2counter != null) {
            this.competitor2counter.destroy();
        }
    }

    public InjuryTimeDialog(TablaWindow tablaWindow) {
        super((Window)tablaWindow, Dialog.ModalityType.APPLICATION_MODAL);
        this.tablaWindow = tablaWindow;
        this.setDefaultCloseOperation(1);
        this.setLayout(new GridLayout(2, 1));
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            int width = (int)((float)this.tablaWindow.getWidth() * 0.8f);
            int height = (int)((float)this.tablaWindow.getHeight() * 0.6f);
            this.setSize(width, height);
            this.setLocationRelativeTo(this.tablaWindow);
        }
        super.setVisible(b);
        if (b) {
            if (this.competitor1counter != null) {
                this.competitor1counter.redrawElements();
            }
            if (this.competitor2counter != null) {
                this.competitor2counter.redrawElements();
            }
            this.revalidate();
            this.repaint();
        }
    }

    public void resetTime() {
        this.competitor1counter.stopTime();
        this.competitor1counter.setTime(0);
        this.competitor2counter.stopTime();
        this.competitor2counter.setTime(0);
    }

    public Integer getInjuryTime1() {
        return this.competitor1counter.getTime();
    }

    public void setInjuryTime1(Integer injuryTime) {
        this.competitor1counter.setTime(injuryTime);
    }

    public Integer getInjuryTime2() {
        return this.competitor2counter.getTime();
    }

    public void setInjuryTime2(Integer injuryTime) {
        this.competitor2counter.setTime(injuryTime);
    }
}

