/*
 * Decompiled with CFR 0.152.
 */
package si.nevensrok.common.x509cert;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import si.nevensrok.common.utils.ByteUtil;
import si.nevensrok.common.utils.HashUtil;
import si.nevensrok.common.x509cert.CertificateInformation;
import si.nevensrok.common.x509cert.SigningAlgorithm;
import sun.security.x509.AlgorithmId;
import sun.security.x509.BasicConstraintsExtension;
import sun.security.x509.CertificateAlgorithmId;
import sun.security.x509.CertificateExtensions;
import sun.security.x509.CertificateIssuerName;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateSubjectName;
import sun.security.x509.CertificateValidity;
import sun.security.x509.CertificateVersion;
import sun.security.x509.CertificateX509Key;
import sun.security.x509.DNSName;
import sun.security.x509.GeneralName;
import sun.security.x509.GeneralNameInterface;
import sun.security.x509.GeneralNames;
import sun.security.x509.IPAddressName;
import sun.security.x509.KeyUsageExtension;
import sun.security.x509.OIDName;
import sun.security.x509.RFC822Name;
import sun.security.x509.SubjectAlternativeNameExtension;
import sun.security.x509.URIName;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

public final class CertificateUtil {
    private CertificateUtil() {
    }

    public static CertificateInformation getCertificateInfo(X509CertImpl certificate) {
        try {
            X500Name issuerName;
            X500Name name;
            CertificateInformation certificateInfo = new CertificateInformation();
            X509CertInfo certInfo = (X509CertInfo)certificate.get("x509.info");
            Object subjectObj = certInfo.get("subject");
            if (subjectObj instanceof X500Name) {
                name = (X500Name)subjectObj;
            } else if (subjectObj instanceof CertificateSubjectName) {
                CertificateSubjectName subjectName = (CertificateSubjectName)subjectObj;
                name = (X500Name)subjectName.get("dname");
            } else {
                throw new RuntimeException("Unsupported subject class: " + subjectObj.getClass().getName());
            }
            CertificateX509Key certificateKey = (CertificateX509Key)certInfo.get("key");
            PublicKey publicKey = certificateKey.get("value");
            int keySize = 0;
            if (publicKey instanceof RSAPublicKey) {
                keySize = ((RSAPublicKey)publicKey).getModulus().bitLength();
            } else if (publicKey instanceof DSAPublicKey) {
                keySize = ((DSAPublicKey)publicKey).getParams().getP().bitLength();
            } else if (publicKey instanceof ECPublicKey) {
                keySize = ((ECPublicKey)publicKey).getParams().getOrder().bitLength();
            }
            CertificateAlgorithmId certificateAlgorithmId = (CertificateAlgorithmId)certInfo.get("algorithmID");
            AlgorithmId algorithmId = certificateAlgorithmId.get("algorithm");
            CertificateValidity certificateValidity = (CertificateValidity)certInfo.get("validity");
            Date validFrom = certificateValidity.get("notBefore");
            Date validUntil = certificateValidity.get("notAfter");
            boolean signing = false;
            boolean ca = false;
            int certificationPathLength = -1;
            LinkedList<String> alternativeNames = new LinkedList<String>();
            try {
                CertificateExtensions someExtensions = (CertificateExtensions)certInfo.get("extensions");
                if (someExtensions != null) {
                    GeneralNames generalNames;
                    SubjectAlternativeNameExtension subjectAlternativeNameExtension;
                    BasicConstraintsExtension basicConstraintsExtension;
                    Boolean signingObj;
                    KeyUsageExtension keyUsageExtension = (KeyUsageExtension)someExtensions.get("KeyUsage");
                    if (keyUsageExtension != null && (signingObj = keyUsageExtension.get("key_certsign")) != null) {
                        signing = signingObj;
                    }
                    if ((basicConstraintsExtension = (BasicConstraintsExtension)someExtensions.get("BasicConstraints")) != null) {
                        Object pathLength;
                        Object isCa = basicConstraintsExtension.get("is_ca");
                        if (isCa != null) {
                            ca = (Boolean)isCa;
                        }
                        if ((pathLength = basicConstraintsExtension.get("path_len")) != null) {
                            certificationPathLength = (Integer)pathLength;
                        }
                    }
                    if ((subjectAlternativeNameExtension = (SubjectAlternativeNameExtension)someExtensions.get("SubjectAlternativeName")) != null && (generalNames = subjectAlternativeNameExtension.get("subject_name")) != null) {
                        for (GeneralName generalName : generalNames.names()) {
                            GeneralNameInterface generalNameInterface = generalName.getName();
                            if (generalNameInterface instanceof RFC822Name) {
                                alternativeNames.add(((RFC822Name)generalNameInterface).getName());
                                continue;
                            }
                            if (generalNameInterface instanceof DNSName) {
                                alternativeNames.add(((DNSName)generalNameInterface).getName());
                                continue;
                            }
                            if (generalNameInterface instanceof X500Name) {
                                alternativeNames.add(((X500Name)generalNameInterface).getRFC2253Name());
                                continue;
                            }
                            if (generalNameInterface instanceof URIName) {
                                alternativeNames.add(((URIName)generalNameInterface).getName());
                                continue;
                            }
                            if (generalNameInterface instanceof IPAddressName) {
                                alternativeNames.add(((IPAddressName)generalNameInterface).getName());
                                continue;
                            }
                            if (generalNameInterface instanceof OIDName) {
                                alternativeNames.add(((OIDName)generalNameInterface).getOID().toString());
                                continue;
                            }
                            throw new RuntimeException("Unsupported general name interface: " + generalNameInterface.getClass().getName());
                        }
                    }
                }
            }
            catch (Exception someExtensions) {
                // empty catch block
            }
            Object isserObj = certInfo.get("issuer");
            if (isserObj instanceof X500Name) {
                issuerName = (X500Name)isserObj;
            } else if (isserObj instanceof CertificateIssuerName) {
                CertificateIssuerName issuer = (CertificateIssuerName)isserObj;
                issuerName = (X500Name)issuer.get("dname");
            } else {
                throw new RuntimeException("Unsupported issuer class: " + isserObj.getClass().getName());
            }
            certificateInfo.setSerialNumber(certificate.getSerialNumber());
            certificateInfo.setVersion(certificate.getVersion());
            certificateInfo.setValidFrom(validFrom);
            certificateInfo.setValidUntil(validUntil);
            certificateInfo.setCountry(name.getCountry());
            certificateInfo.setState(name.getState());
            certificateInfo.setCity(name.getLocality());
            certificateInfo.setOrganization(name.getOrganization());
            certificateInfo.setOrganizationUnit(name.getOrganizationalUnit());
            certificateInfo.setCommonName(name.getCommonName());
            certificateInfo.setDomain(name.getDomain());
            certificateInfo.setIp(name.getIP());
            certificateInfo.setAlternativeNames(alternativeNames);
            certificateInfo.setSignatureAlgorithm(algorithmId.getName());
            certificateInfo.setIsUsedForSigning(signing);
            certificateInfo.setIsCa(ca);
            certificateInfo.setCertificationPathLength(certificationPathLength);
            certificateInfo.setMd5fingerprint(ByteUtil.toHexString((byte[])CertificateUtil.getMD5Fingerprint(certificate)));
            certificateInfo.setSha1fingerprint(ByteUtil.toHexString((byte[])CertificateUtil.getSHA1Fingerprint(certificate)));
            certificateInfo.setSha256fingerprint(ByteUtil.toHexString((byte[])CertificateUtil.getSHA256Fingerprint(certificate)));
            certificateInfo.setKeySize(keySize);
            certificateInfo.setKeyAlgorithm(publicKey.getAlgorithm());
            certificateInfo.setIssuerCountry(issuerName.getCountry());
            certificateInfo.setIssuerState(issuerName.getState());
            certificateInfo.setIssuerCity(issuerName.getLocality());
            certificateInfo.setIssuerOrganization(issuerName.getOrganization());
            certificateInfo.setIssuerOrganizationUnit(issuerName.getOrganizationalUnit());
            certificateInfo.setIssuerCommonName(issuerName.getCommonName());
            return certificateInfo;
        }
        catch (Exception e) {
            throw new RuntimeException("Error extracting certificate information", e);
        }
    }

    public static byte[] getMD5Fingerprint(X509Certificate certificate) {
        try {
            return HashUtil.generateHash((byte[])certificate.getEncoded(), (HashUtil.HashType)HashUtil.HashType.MD5);
        }
        catch (Exception e) {
            throw new RuntimeException("Error calculating certificate MD5 fingerprint", e);
        }
    }

    public static byte[] getSHA1Fingerprint(X509Certificate certificate) {
        try {
            return HashUtil.generateHash((byte[])certificate.getEncoded(), (HashUtil.HashType)HashUtil.HashType.SHA1);
        }
        catch (Exception e) {
            throw new RuntimeException("Error calculating certificate SHA1 fingerprint", e);
        }
    }

    public static byte[] getSHA256Fingerprint(X509Certificate certificate) {
        try {
            return HashUtil.generateHash((byte[])certificate.getEncoded(), (HashUtil.HashType)HashUtil.HashType.SHA256);
        }
        catch (Exception e) {
            throw new RuntimeException("Error calculating certificate SHA256 fingerprint", e);
        }
    }

    public static X509CertImpl loadCertificate(InputStream inputStream) {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            return (X509CertImpl)certificateFactory.generateCertificate(inputStream);
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading certificate", e);
        }
    }

    public static void saveCertificate(X509CertImpl certificate, OutputStream outputStream) {
        try {
            outputStream.write(certificate.getEncoded());
        }
        catch (Exception e) {
            throw new RuntimeException("Error saving certificate", e);
        }
    }

    public static void saveCertificateAsBase64(Certificate certificate, OutputStream outputStream) {
        try {
            String base64 = ByteUtil.toBase64String((byte[])certificate.getEncoded());
            outputStream.write("-----BEGIN CERTIFICATE-----\n".getBytes("ASCII"));
            outputStream.write(base64.getBytes("ASCII"));
            outputStream.write("\n-----END CERTIFICATE-----\n".getBytes("ASCII"));
        }
        catch (Exception e) {
            throw new RuntimeException("Error saving certificate", e);
        }
    }

    public static X509CertImpl signCertificate(X509CertImpl certificate, Date validFrom, Date validUntil, SigningAlgorithm signingAlgorithm, X509CertImpl signerCertificate, KeyPair signerKeyPair) {
        try {
            X500Name signerName;
            X500Name existingName;
            X509CertInfo existingCertInfo = (X509CertInfo)certificate.get("x509.info");
            Object subjectObj = existingCertInfo.get("subject");
            if (subjectObj instanceof CertificateSubjectName) {
                CertificateSubjectName existingSubjectName = (CertificateSubjectName)subjectObj;
                existingName = (X500Name)existingSubjectName.get("dname");
            } else {
                existingName = (X500Name)subjectObj;
            }
            CertificateVersion existingCertificateVersion = (CertificateVersion)existingCertInfo.get("version");
            CertificateX509Key existingCertificateKey = (CertificateX509Key)existingCertInfo.get("key");
            PublicKey existingPublicKey = existingCertificateKey.get("value");
            CertificateValidity existingCertificateValidity = (CertificateValidity)existingCertInfo.get("validity");
            if (validFrom == null) {
                validFrom = existingCertificateValidity.get("notBefore");
            }
            if (validUntil == null) {
                validUntil = existingCertificateValidity.get("notAfter");
            }
            CertificateValidity validity = new CertificateValidity(validFrom, validUntil);
            CertificateExtensions existingSomeExtensions = (CertificateExtensions)existingCertInfo.get("extensions");
            X509CertInfo signerCertInfo = (X509CertInfo)signerCertificate.get("x509.info");
            Object signerSubjectObj = signerCertInfo.get("subject");
            if (signerSubjectObj instanceof CertificateSubjectName) {
                CertificateSubjectName existingSubjectName = (CertificateSubjectName)signerSubjectObj;
                signerName = (X500Name)existingSubjectName.get("dname");
            } else {
                signerName = (X500Name)signerSubjectObj;
            }
            X509CertInfo certInfo = new X509CertInfo();
            certInfo.set("version", existingCertificateVersion);
            certInfo.set("serialNumber", new CertificateSerialNumber(certificate.getSerialNumber()));
            certInfo.set("algorithmID", new CertificateAlgorithmId(AlgorithmId.get(signingAlgorithm.name())));
            certInfo.set("subject", existingName);
            certInfo.set("key", new CertificateX509Key(existingPublicKey));
            certInfo.set("validity", validity);
            certInfo.set("issuer", signerName);
            certInfo.set("extensions", existingSomeExtensions);
            X509CertImpl newCertificate = new X509CertImpl(certInfo);
            newCertificate.sign(signerKeyPair.getPrivate(), signingAlgorithm.name());
            newCertificate.verify(signerKeyPair.getPublic());
            return newCertificate;
        }
        catch (Exception e) {
            throw new RuntimeException("Error signing certificate", e);
        }
    }

    public static boolean isUsedForSigning(X509Certificate certificate) throws CertificateException, IOException {
        Boolean signingObj;
        KeyUsageExtension keyUsageExtension;
        X509CertImpl certImpl = (X509CertImpl)certificate;
        X509CertInfo certInfo = (X509CertInfo)certImpl.get("x509.info");
        CertificateExtensions someExtensions = (CertificateExtensions)certInfo.get("extensions");
        if (someExtensions != null && (keyUsageExtension = (KeyUsageExtension)someExtensions.get("KeyUsage")) != null && (signingObj = keyUsageExtension.get("key_certsign")) != null) {
            return signingObj;
        }
        return false;
    }

    public static boolean isCa(X509Certificate certificate) throws CertificateException, IOException {
        Object isCa;
        BasicConstraintsExtension basicConstraintsExtension;
        KeyUsageExtension keyUsageExtension;
        X509CertImpl certImpl = (X509CertImpl)certificate;
        X509CertInfo certInfo = (X509CertInfo)certImpl.get("x509.info");
        CertificateExtensions someExtensions = (CertificateExtensions)certInfo.get("extensions");
        if (someExtensions != null && (keyUsageExtension = (KeyUsageExtension)someExtensions.get("KeyUsage")) != null && (basicConstraintsExtension = (BasicConstraintsExtension)someExtensions.get("BasicConstraints")) != null && (isCa = basicConstraintsExtension.get("is_ca")) != null) {
            return (Boolean)isCa;
        }
        return false;
    }

    public static int getCertificationPathLength(X509Certificate certificate) throws CertificateException, IOException {
        Object certificationPathLength;
        BasicConstraintsExtension basicConstraintsExtension;
        KeyUsageExtension keyUsageExtension;
        X509CertImpl certImpl = (X509CertImpl)certificate;
        X509CertInfo certInfo = (X509CertInfo)certImpl.get("x509.info");
        CertificateExtensions someExtensions = (CertificateExtensions)certInfo.get("extensions");
        if (someExtensions != null && (keyUsageExtension = (KeyUsageExtension)someExtensions.get("KeyUsage")) != null && (basicConstraintsExtension = (BasicConstraintsExtension)someExtensions.get("BasicConstraints")) != null && (certificationPathLength = basicConstraintsExtension.get("path_len")) != null) {
            return (Integer)certificationPathLength;
        }
        return -1;
    }

    public static List<String> getAlternativeNames(X509Certificate certificate) throws CertificateException, IOException {
        LinkedList<String> alternativeNames = new LinkedList<String>();
        X509CertImpl certImpl = (X509CertImpl)certificate;
        X509CertInfo certInfo = (X509CertInfo)certImpl.get("x509.info");
        CertificateExtensions someExtensions = (CertificateExtensions)certInfo.get("extensions");
        if (someExtensions != null) {
            try {
                GeneralNames generalNames;
                SubjectAlternativeNameExtension subjectAlternativeNameExtension = (SubjectAlternativeNameExtension)someExtensions.get("SubjectAlternativeName");
                if (subjectAlternativeNameExtension != null && (generalNames = subjectAlternativeNameExtension.get("subject_name")) != null) {
                    for (GeneralName generalName : generalNames.names()) {
                        GeneralNameInterface generalNameInterface = generalName.getName();
                        if (generalNameInterface instanceof RFC822Name) {
                            alternativeNames.add(((RFC822Name)generalNameInterface).getName());
                            continue;
                        }
                        if (generalNameInterface instanceof DNSName) {
                            alternativeNames.add(((DNSName)generalNameInterface).getName());
                            continue;
                        }
                        if (generalNameInterface instanceof X500Name) {
                            alternativeNames.add(((X500Name)generalNameInterface).getRFC2253Name());
                            continue;
                        }
                        if (generalNameInterface instanceof URIName) {
                            alternativeNames.add(((URIName)generalNameInterface).getName());
                            continue;
                        }
                        if (generalNameInterface instanceof IPAddressName) {
                            alternativeNames.add(((IPAddressName)generalNameInterface).getName());
                            continue;
                        }
                        if (generalNameInterface instanceof OIDName) {
                            alternativeNames.add(((OIDName)generalNameInterface).getOID().toString());
                            continue;
                        }
                        throw new RuntimeException("Unsupported general name interface: " + generalNameInterface.getClass().getName());
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return alternativeNames;
    }

    public static X500Name getName(X509CertImpl certificate) throws Exception {
        X500Name name;
        X509CertInfo certInfo = (X509CertInfo)certificate.get("x509.info");
        Object subjectObj = certInfo.get("subject");
        if (subjectObj instanceof X500Name) {
            name = (X500Name)subjectObj;
        } else if (subjectObj instanceof CertificateSubjectName) {
            CertificateSubjectName subjectName = (CertificateSubjectName)subjectObj;
            name = (X500Name)subjectName.get("dname");
        } else {
            throw new RuntimeException("Unsupported subject class: " + subjectObj.getClass().getName());
        }
        return name;
    }

    public static boolean isNameEqual(X500Name name1, X500Name name2) throws Exception {
        if (!CertificateUtil.areStringsEqual(name1.getCountry(), name2.getCountry())) {
            return false;
        }
        if (!CertificateUtil.areStringsEqual(name1.getState(), name2.getState())) {
            return false;
        }
        if (!CertificateUtil.areStringsEqual(name1.getLocality(), name2.getLocality())) {
            return false;
        }
        if (!CertificateUtil.areStringsEqual(name1.getOrganization(), name2.getOrganization())) {
            return false;
        }
        if (!CertificateUtil.areStringsEqual(name1.getOrganizationalUnit(), name2.getOrganizationalUnit())) {
            return false;
        }
        return CertificateUtil.areStringsEqual(name1.getCommonName(), name2.getCommonName());
    }

    public static boolean isIssuedBy(X509CertImpl certificate, X509CertImpl isser) {
        return CertificateUtil.isIssuedBy(certificate, isser, false);
    }

    public static boolean isIssuedBy(X509CertImpl certificate, X509CertImpl isser, boolean notSelfSigned) {
        try {
            X500Name issuerName;
            X500Name certificateIssuerName;
            X500Name certificateName;
            X509CertInfo certInfo = (X509CertInfo)certificate.get("x509.info");
            if (certInfo.get("subject") instanceof X500Name) {
                certificateName = (X500Name)certInfo.get("subject");
            } else {
                CertificateSubjectName certificateSubjectName = (CertificateSubjectName)certInfo.get("subject");
                certificateName = (X500Name)certificateSubjectName.get("dname");
            }
            if (certInfo.get("issuer") instanceof X500Name) {
                certificateIssuerName = (X500Name)certInfo.get("issuer");
            } else {
                CertificateIssuerName issuer = (CertificateIssuerName)certInfo.get("issuer");
                certificateIssuerName = (X500Name)issuer.get("dname");
            }
            X509CertInfo isserCertInfo = (X509CertInfo)isser.get("x509.info");
            if (isserCertInfo.get("subject") instanceof X500Name) {
                issuerName = (X500Name)isserCertInfo.get("subject");
            } else {
                CertificateSubjectName candidateSubjectName = (CertificateSubjectName)isserCertInfo.get("subject");
                issuerName = (X500Name)candidateSubjectName.get("dname");
            }
            if (notSelfSigned && CertificateUtil.isNameEqual(certificateName, issuerName)) {
                return false;
            }
            return CertificateUtil.isNameEqual(certificateIssuerName, issuerName);
        }
        catch (Exception e) {
            throw new RuntimeException("Error checking if certificate is issed by isser", e);
        }
    }

    public static boolean isSelfSigned(X509CertImpl certificate) {
        try {
            X500Name certificateIssuerName;
            X500Name certificateName;
            X509CertInfo certInfo = (X509CertInfo)certificate.get("x509.info");
            if (certInfo.get("subject") instanceof X500Name) {
                certificateName = (X500Name)certInfo.get("subject");
            } else {
                CertificateSubjectName certificateSubjectName = (CertificateSubjectName)certInfo.get("subject");
                certificateName = (X500Name)certificateSubjectName.get("dname");
            }
            if (certInfo.get("issuer") instanceof X500Name) {
                certificateIssuerName = (X500Name)certInfo.get("issuer");
            } else {
                CertificateIssuerName issuer = (CertificateIssuerName)certInfo.get("issuer");
                certificateIssuerName = (X500Name)issuer.get("dname");
            }
            return CertificateUtil.isNameEqual(certificateName, certificateIssuerName);
        }
        catch (Exception e) {
            throw new RuntimeException("Error checking if certificate is selfsigned", e);
        }
    }

    private static boolean areStringsEqual(String s1, String s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }
}

